/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.handlers;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.widgets.Event;

import com.ca.fmp.ims.view.editor.CharFormatMode;
import com.ca.fmp.ims.view.editor.FormatMode;

/**
 * 2014/09/05 carel06
 * - copied TraverseListenerBase class from MVS codebase 
 * - removed references to FileMasterRecord and FileMasterRecordField
 * - TODO: need to look into how we can determine if we are on the last table
 * 
 * @author carel06
 */
public class TraverseListenerTable extends TraverseListenerBase {
	
	protected TableViewer tableViewer;
	private FormatMode formatMode;
	private Logger log = Logger.getLogger(TraverseListenerTable.class.getName());
	
	public TraverseListenerTable(TextCellEditor textCellEditor, TableViewer tableViewer, FormatMode formatMode) {
		super(textCellEditor);
		this.tableViewer = tableViewer;
		this.formatMode = formatMode;
	}
	
	protected void moveToNext(TraverseEvent traverseEvent) {
		int selectedElement = tableViewer.getTable().getSelectionIndex();
		int nextPosition = selectedElement;
		
		// carel06: Defect 2790
		// Class Cast Exception
		// galpe02: Defect 2770
		// Go to next record only if the next record is within the edited file. This condition is true when user does not edit last record.
		// When last record is edited it stays on the same record.
        // 2014/09/02 carel06
		// TODO: need to figure out what to do this since it is model independent
//		Object data = tableViewer.getTable().getItem(selectedElement).getData();
//		if(data instanceof FileMasterRecord) {
//			FileMasterRecord fileMasterRecord = (FileMasterRecord) data;
//			if(fileMasterRecord.isLastRecord() == false) {
//				nextPosition++;
//			}
//		} else {
//			// do nothing
//			// in SRM, it just goes to the next record field.
//			nextPosition++;
//		}
        nextPosition++;
        
		log.log(Level.INFO, "next record: " + nextPosition);
		
		textCellEditor.deactivate();		
		if(!tableViewer.getTable().isDisposed()) {		
			Event e = new Event();
			if (formatMode !=null){
				if (formatMode instanceof CharFormatMode){
					if (nextPosition >= ((CharFormatMode)formatMode).getVisibleItemCount(tableViewer.getTable()) -1){
						((CharFormatMode)formatMode).doScrollSegmentDown();
						nextPosition--;
					} 
				}
			}
			
			tableViewer.getTable().setSelection(nextPosition);
			if (tableViewer.getTable().getSelectionIndex() < 0){
				nextPosition--;
				tableViewer.getTable().setSelection(nextPosition);
			}
			
			e.item = tableViewer.getTable().getItem(nextPosition);
			tableViewer.getTable().notifyListeners(SWT.Selection, e);
		}
	}

	protected void moveToPrevious(TraverseEvent traverseEvent) {
		int selectedElement = tableViewer.getTable().getSelectionIndex();
		int previousPosition = selectedElement - 1;
		log.log(Level.INFO, "previous record: " + previousPosition);

		textCellEditor.deactivate();		
		Event e = new Event();
		if (formatMode !=null){
			if (formatMode instanceof CharFormatMode){
				if (previousPosition < 0){
					((CharFormatMode)formatMode).doScrollSegmentUp();
					previousPosition++;
				} 
			}
		}
		tableViewer.getTable().setSelection(previousPosition);
		e.item = tableViewer.getTable().getItem(previousPosition);
		tableViewer.getTable().notifyListeners(SWT.Selection, e);
	}
}