/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.handlers;

/**
 * 
 * @author navri01
 */
import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

import com.ca.fmp.ims.view.databaselist.DatabaseListView;
import com.ca.fmp.ims.view.serverwizards.AddServerWizard;
import com.ca.fmp.ims.view.wizards.OpenDatabaseWizard;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class AddServerHandler extends AbstractHandler implements
		IElementUpdater {
	static final String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$

	/**
	 * @param event
	 * @throws ExecutionException
	 */
	public Object execute(ExecutionEvent event) throws ExecutionException {
		AddServerWizard wizard = new AddServerWizard(null);
		IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
		IWorkbench workbench = window.getWorkbench();
		ISelection selection = HandlerUtil.getCurrentSelection(event);
		if (!(selection instanceof IStructuredSelection))
			selection = null;
		wizard.init(workbench, (IStructuredSelection) selection);
		wizard.setNewItem(true);
		Shell shell = window.getShell();
		TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(shell, wizard);
		dialog.create();
		dialog.open();
		try {
			// force directorylist view into focus
			final IWorkbenchPage page = window.getActivePage();
			IViewPart view = page.showView(DatabaseListView.ID);
			view.setFocus();
		}
		catch (final PartInitException e) {
			
		}
		return null;
		
	}

	/**
	 * @param element
	 * @param parameters
	 */
	public void updateElement(UIElement element,
			@SuppressWarnings("rawtypes") Map parameters) {
		return;
	}

}
