/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.editor;

import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

import com.ca.fmp.ims.model.IMSSegment;
import com.ca.fmp.ims.model.generated.SecondaryIXType;

public class SegmentLabelProvider extends StyledCellLabelProvider {
	
	int pixelSizeOfCharacter;
	int lineHeight;
	TextLayout layout;
	Shell shell;
	
	public SegmentLabelProvider(int pixelSizeOfCharacter, int lineHeight, TextLayout layout, Shell shell){
		this.pixelSizeOfCharacter = pixelSizeOfCharacter;
		this.lineHeight = lineHeight;
		this.layout = layout;
		this.shell = shell;
	}

	@Override
	protected void paint(Event event, Object element) {
		Bundle bundle = Platform.getBundle("com.ca.fmp.ims.view");
		
		IMSSegment segment = (IMSSegment) element;
		
	    int level = segment.getSegLevel();

		if(segment.isParent()){
			URL urlCol;
			URL urlExp;
			if(pixelSizeOfCharacter < 16){
				urlCol = FileLocator.find(bundle, new Path("icons/tree-collapse-9.png"), null);
				urlExp = FileLocator.find(bundle, new Path("icons/tree-expand-9.png"), null);	
			} else {
				urlCol = FileLocator.find(bundle, new Path("icons/tree-collapse-16.png"), null);
				urlExp = FileLocator.find(bundle, new Path("icons/tree-expand-16.png"), null);
			}
			
			Image iconCol = ImageDescriptor.createFromURL(urlCol).createImage();
			Image iconExp = ImageDescriptor.createFromURL(urlExp).createImage();
			
			Rectangle imageBounds = iconCol.getBounds();
			if(imageBounds.width < pixelSizeOfCharacter){
				iconCol = ImageDescriptor.createFromImageData(
						iconCol.getImageData().scaledTo(pixelSizeOfCharacter, pixelSizeOfCharacter)).createImage();
				iconExp = ImageDescriptor.createFromImageData(
						iconExp.getImageData().scaledTo(pixelSizeOfCharacter, pixelSizeOfCharacter)).createImage();
				imageBounds = iconCol.getBounds();
			}
			
			Rectangle bounds = event.getBounds();
			
			if(segment.isExpanded()){
				event.gc.drawImage(iconCol,
						bounds.x + ((level - 1) * pixelSizeOfCharacter) + ((pixelSizeOfCharacter - imageBounds.width) / 2) + 1,
						bounds.y + ((lineHeight - imageBounds.height) / 2));	
			} else {
				event.gc.drawImage(iconExp,
						bounds.x + ((level - 1) * pixelSizeOfCharacter) + ((pixelSizeOfCharacter - imageBounds.width) / 2) + 1,
						bounds.y + ((lineHeight - imageBounds.height) / 2));
			}
			
			iconCol.dispose();
			iconExp.dispose();
		}

		layout.setFont(JFaceResources.getTextFont());
		layout.setText(segment.getSegName());
		
		if( ! ((IMSSegment)element).segmentType.getSecondaryIX().name().equals(SecondaryIXType.NO.toString())){
			TextStyle keyField = new TextStyle(JFaceResources.getTextFont(),
					shell.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND),
					shell.getDisplay().getSystemColor(SWT.COLOR_CYAN));
			
			layout.setStyle(keyField, 0, layout.getText().length() - 1);
		}

		layout.draw(event.gc, event.x + ((1 + level) * pixelSizeOfCharacter), event.y);
	}
}
