/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.editor;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.TableItem;

import com.ca.fmp.ims.model.generated.KeyInfoType;
import com.ca.fmp.ims.model.generated.RangeListType;
import com.ca.fmp.ims.model.generated.SegmentFieldType;
import com.ca.fmp.ims.model.generated.YorNType;

public class SRFValueLabelProvider extends StyledCellLabelProvider {
	private TextLayout layout;
	private Shell shell;
	private Slider slider;
	
	private int startSubString = 0;
	private int endSubString = 0;
	
	private int keyLength;
	private YorNType previouseKeyPart = YorNType.N;
    
	public SRFValueLabelProvider(TextLayout layout, Shell shell, Slider slider){
		this.layout = layout;
		this.shell = shell;
		this.slider = slider;
	}
	
	@Override
	protected void measure(Event event, Object element) {
		if (element == null) {
			return; // do nothing
		}

		if (!(element instanceof SegmentFieldType)) {
			return; // do nothing
		}

		if (event == null) {
			return; // do nothing
		}

		event.gc.setFont(JFaceResources.getTextFont());
		Point size = event.gc.textExtent("H");
		event.height = size.y;
	}

	@Override
	protected void paint(Event event, Object element) {
		
		startSubString = slider.getSelection();
		endSubString = startSubString + slider.getThumb() - 1;
		
//        	layout.setText(((TableItem)event.item).getText(3));
        if(element instanceof SegmentFieldType) {
            SegmentFieldType segmentFieldType = (SegmentFieldType) element;
            // @carel06 20141104
            // Kip reported some issues where after updating the SegmentFieldType (2x),
            // and then scrolling left or right using the horizontal bar, the value 
            // reverted back to original value.
            // Instead of using tableItem value we are using the value from the response
            // and then stripping it based on subStringBeginIndex and subStringEndIndex
            // copied the code from MVS code base.
            //@polra04: #3184
            String xValue = "";
            if(segmentFieldType.getCharData() == null ) {
            	xValue = "";
            } else if(startSubString>=0 && endSubString >0 && startSubString<segmentFieldType.getCharData().length() && startSubString <= endSubString){
            	// carel06 - 2014/11/21
            	// added the clause "endSubString + 1".
            	// the reason why I added it was that when you use the String.substring(),
            	// the last parameter is exclusive.  It doesn't count.
            	// Since the subStringBeginIndex and subStringEndIndex had an offset of 0, it was missing a character.
    			xValue = segmentFieldType.getCharData().substring(Math.min(startSubString,segmentFieldType.getCharData().length()),Math.min(endSubString + 1,segmentFieldType.getCharData().length()));
    		} 
            
    		if(startSubString<0) {
    			xValue = segmentFieldType.getCharData();
    		}
            
        	layout.setText(xValue);
        } else {
        	layout.setText("");
        }
        
		layout.setFont(JFaceResources.getTextFont());
		
		SegmentFieldType segmentFieldType = (SegmentFieldType)element;
		YorNType keyPart = segmentFieldType.getKeyPart();
		
		KeyInfoType keyInfo = (KeyInfoType) ((TableItem)event.item).getData("KeyInfoType");
		
		if (previouseKeyPart == YorNType.N & keyPart == YorNType.Y){
			keyLength = (int) keyInfo.getLength();
		}		
		previouseKeyPart = keyPart; 
		
		if(keyPart != null && keyPart == YorNType.Y){
			TextStyle keyField;
			
			if(keyInfo.getProtect() == YorNType.Y){
				keyField = new TextStyle(JFaceResources.getTextFont(),
						shell.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND),
						shell.getDisplay().getSystemColor(SWT.COLOR_YELLOW));
			} else {
				//TODO use different color for unprotected key
				keyField = new TextStyle(JFaceResources.getTextFont(),
						shell.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND),
						shell.getDisplay().getSystemColor(SWT.COLOR_YELLOW));
			}
			
			int keyStart = (keyInfo.getStart() - segmentFieldType.getPosition() < 0 ? 0 : (int) keyInfo.getStart() - segmentFieldType.getPosition());
			int keyFieldLength = 0;
			long MaxLengthMinusKeyStart = segmentFieldType.getMaxLengthD() - (keyStart);
			
			if (keyLength >= (int) MaxLengthMinusKeyStart){
				keyFieldLength = (int) MaxLengthMinusKeyStart;
			} else {
				keyFieldLength = keyLength; 
			}
			keyLength = keyLength - keyFieldLength;
			if (segmentFieldType.getCharDataHex() == YorNType.N){
				layout.setStyle(keyField, keyStart, keyFieldLength - 1 + keyStart);
			} else {
				if ((2*keyFieldLength+3) >= segmentFieldType.getCharData().length()-1){
					layout.setStyle(keyField, keyStart, 2*(keyFieldLength + keyStart) + 2);
				} else {
					layout.setStyle(keyField, keyStart, 2*(keyFieldLength + keyStart) + 2 -1);
				}
				
			}
		}
        
		RangeListType protectedList = segmentFieldType.getProtectedList();		
		if(protectedList != null){
			int start, end;
			
			TextStyle protectedField = new TextStyle(JFaceResources.getTextFont(),
					shell.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND),
					shell.getDisplay().getSystemColor(SWT.COLOR_GRAY));
			
			for(int countProtectedFields = 0; countProtectedFields < protectedList.getRange().size(); countProtectedFields++){
				start = (int)protectedList.getRange().get(countProtectedFields).getStart() - 1;
				end = (int)protectedList.getRange().get(countProtectedFields).getEnd() - 1;
				
				doColumnHighlight(protectedField, start, end, false);
			}
		}
		
		if(segmentFieldType.getColorData() == YorNType.Y){
			TextStyle colorData = new TextStyle(JFaceResources.getTextFont(),
					shell.getDisplay().getSystemColor(SWT.COLOR_RED), null);
			
			layout.setStyle(colorData, 0, layout.getText().length() - 1);
		}
		
		if(segmentFieldType.getCursor() != null){
			Color myGreen = new Color(Display.getCurrent(), 0, 180, 0);
			int start;
			TextStyle findField;
			
			findField = new TextStyle(JFaceResources.getTextFont(),
			shell.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND),
			myGreen);

			start = segmentFieldType.getCursor() - 1;
			
			doColumnHighlight(findField, start, start, false);
		}
		
		layout.draw(event.gc, event.x + 2, event.y);
	}
	
	private void doColumnHighlight(TextStyle highlightStyle, int start, int end, boolean hex){

		if(!(start > endSubString || end < startSubString)){
			int layoutStart = (start - startSubString) < 0 ? 0 : (start - startSubString);
			int layoutEnd   = (end   - startSubString) < 0 ? 0 : (end   - startSubString);
			
			layout.setStyle(highlightStyle, layoutStart, layoutEnd);

			if(hex){
				//assume same length for char and hex data
				layout.setStyle(highlightStyle,
						layout.getText().length() + layoutStart + 1,
						layout.getText().length() + layoutEnd + 1);
				layout.setStyle(highlightStyle,
						layout.getText().length() + layoutStart + 2,
						layout.getText().length() + layoutEnd + 2);
			}
		}
	}
}

