/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.editor;

import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.FileMasterSession;
import com.ca.fmp.ims.common.ModelessWizardDialog;
import com.ca.fmp.ims.model.CancelRequest;
import com.ca.fmp.ims.model.CommitRequest;
import com.ca.fmp.ims.model.EndRequest;
import com.ca.fmp.ims.model.IMSSegment;
import com.ca.fmp.ims.model.RollbackRequest;
import com.ca.fmp.ims.model.generated.CursorType;
import com.ca.fmp.ims.model.generated.DisplayModeType;
import com.ca.fmp.ims.model.generated.EditGetDirectionType;
import com.ca.fmp.ims.model.generated.EditModeType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.SegmentCmdInfoType;
import com.ca.fmp.ims.model.generated.SegmentCmdStateType;
import com.ca.fmp.ims.model.generated.SegmentInfoListType;
import com.ca.fmp.ims.model.generated.SegmentInfoType;
import com.ca.fmp.ims.model.generated.YorNType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.Common;
import com.ca.fmp.ims.view.ckey.ConcatenatedKeyView;
import com.ca.fmp.ims.view.wizards.FindCommandWizard;
import com.ca.fmp.ims.view.wizards.LocateKeyCommandWizard;
import com.ca.fmp.ims.view.wizards.SegmentCommandWizard;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class EditorView extends ViewPart implements ISaveablePart,ISaveablePart2{
	public static String ID = "com.ca.fmp.ims.view.editor.EditorView";
	private static String CONTEXT_HELP_ID = "com.ca.fmp.ims.help.EditorView";
	
	private static final String COMMIT_BUTTON_ID = "com.ca.filemaster.editor.commands.commit";
	private static final String ROLLBACK_BUTTON_ID = "com.ca.filemaster.editor.commands.rollback";	
	public static final String HEX_BUTTON_ID="com.ca.fmp.ims.view.commands.hex";
	public static final String CHAR_BUTTON_ID = "com.ca.fmp.ims.view.commands.charFormat";
	private static final String SF_BUTTON_ID = "com.ca.fmp.ims.view.commands.sfFormat";
	private static final String FIND_BUTTON_ID = "com.ca.fmp.ims.view.commands.find";
	private static final String SEGMENT_BUTTON_ID = "com.ca.fmp.ims.view.commands.segment";
	private static final String LOCATEKEY_BUTTON_ID = "com.ca.fmp.ims.view.commands.locateKey";
	
	protected FileMasterServer server;
	protected SegmentInfoListType segmentInfo;
	protected YorNType isHexToggled = YorNType.N;
	protected long findLimit;
	
	private Composite container;
	private Composite charContainer;
	private Composite sfContainer;
	private FormatMode mode;
	
	private IToolBarManager toolbarManager;
	private IMenuManager menuManager;
	private MenuManager popupMenuMgr;	
	private Action commitAction;
	private Action rollbackAction;
	private Action hexAction;
	private Action charFormatAction;
	private Action sfFormatAction;
	private Action findAction;
	private Action segmentAction;
	private Action locatekeyAction;
	private boolean setEditEndForCommit = false;
	private boolean isDirty = false;
	private boolean performClosingCommand = true;
	private boolean clearMessage = true;
	
	private StackLayout layout;
	private DisplayModeType displayMode;
	private EditModeType editMode;
	public  IMSSegment currentSegment;
	protected long maxSegLen;
	
	public FindCommandWizard wizard;
	public SegmentCommandWizard segmentWizard;
	public LocateKeyCommandWizard wizardLK;
	
	private CursorType fmiCursor;
	private boolean findSliderActive = false;
	protected ArrayList<SegmentCmdInfoType> segmentState;
	public boolean isSegmentCmdActive = false;
	public HashMap<Short, SegmentInfoType> segmentInfoMap;
	
	@Override
	public void createPartControl(Composite parent) {
		if(((StatusLineContributionItem) ((IViewSite) this.getViewSite()).getActionBars()
				.getStatusLineManager().find("messages")) == null){
			 ((IViewSite) this.getViewSite()).getActionBars().getStatusLineManager().add(new StatusLineContributionItem("messages",40));
		}
   		((StatusLineContributionItem) ((IViewSite) this.getViewSite()).getActionBars()
   				.getStatusLineManager().find("messages")).setText(" ");
		if(((StatusLineContributionItem) ((IViewSite) this.getViewSite()).getActionBars()
				.getStatusLineManager().find("insertOrOvertype")) == null){
			 ((IViewSite) this.getViewSite()).getActionBars().getStatusLineManager().add(new StatusLineContributionItem("insertOrOvertype",10));
		}
   		((StatusLineContributionItem) ((IViewSite) this.getViewSite()).getActionBars()
				.getStatusLineManager().find("insertOrOvertype")).setText(" ");
   		if(((StatusLineContributionItem) ((IViewSite) this.getViewSite()).getActionBars()
				.getStatusLineManager().find("segmentCommand")) == null){
			 ((IViewSite) this.getViewSite()).getActionBars().getStatusLineManager().add(new StatusLineContributionItem("segmentCommand",5));
		}
   		((StatusLineContributionItem) ((IViewSite) this.getViewSite()).getActionBars()
				.getStatusLineManager().find("segmentCommand")).setText(" ");
   		if(((StatusLineContributionItem) ((IViewSite) this.getViewSite()).getActionBars()
				.getStatusLineManager().find("columnrange")) == null){
			 ((IViewSite) this.getViewSite()).getActionBars().getStatusLineManager().add(new StatusLineContributionItem("columnrange",24));
		}
   		((StatusLineContributionItem) ((IViewSite) this.getViewSite()).getActionBars()
				.getStatusLineManager().find("columnrange")).setText(" ");
   		
   		
		
		commitAction = new Action("Save/Commit") {
			@Override
			public void run() {
				if(loseFocusBecauseActionIsInvoked()){
                commit(YorNType.N);
				if (mode instanceof CharFormatMode) {
					((CharFormatMode) mode).putCursor();
				} else if (mode instanceof SingleRecordFormatMode){
					((SingleRecordFormatMode) mode).putCursor();
				} 
				}
			}

			@Override
			public void setEnabled(boolean enabled) {
				super.setEnabled(enabled);
			}
		};		
		commitAction.setId(COMMIT_BUTTON_ID);
		commitAction.setActionDefinitionId(COMMIT_BUTTON_ID);
		commitAction.setEnabled(isDirty());
		getViewSite().getActionBars().setGlobalActionHandler(COMMIT_BUTTON_ID, commitAction);		
		
		rollbackAction = new Action("Rollback") {
			@Override
			public void run() {
				if(loseFocusBecauseActionIsInvoked()){
				rollback();
				if (mode instanceof CharFormatMode) {
					((CharFormatMode) mode).putCursor();
				} else if (mode instanceof SingleRecordFormatMode){
					((SingleRecordFormatMode) mode).putCursor();
				} 
				}
			}
		};	
		rollbackAction.setId(ROLLBACK_BUTTON_ID);
		rollbackAction.setActionDefinitionId(ROLLBACK_BUTTON_ID);
		rollbackAction.setEnabled(isDirty());
		getViewSite().getActionBars().setGlobalActionHandler(ROLLBACK_BUTTON_ID, rollbackAction);		
		
		hexAction = new Action("Hexadecimal") {
			@Override
			public void run() {
				if(loseFocusBecauseActionIsInvoked()){
				isHexToggled = isHexToggled.value().equalsIgnoreCase("Y") ? YorNType.N: YorNType.Y;
				hex(isHexToggled);
				if(getToolBarAction(HEX_BUTTON_ID)!=null){
					if(isHexToggled.value().equalsIgnoreCase("Y")){
						getToolBarAction(HEX_BUTTON_ID).setChecked(true);
					}
					else{
						getToolBarAction(HEX_BUTTON_ID).setChecked(false);
					}
				}
			}
			}
		};	
		hexAction.setId(HEX_BUTTON_ID);
		hexAction.setActionDefinitionId(HEX_BUTTON_ID);
		hexAction.setEnabled(isDirty());
		getViewSite().getActionBars().setGlobalActionHandler(HEX_BUTTON_ID, hexAction);		
		
		Bundle bundle = Platform.getBundle("com.ca.fmp.ims.view");
		ImageDescriptor charImage = ImageDescriptor.createFromURL(FileLocator.find(bundle, new Path("icons/editor-open-character-16.png"), null));
		ImageDescriptor singleImage = ImageDescriptor.createFromURL(FileLocator.find(bundle, new Path("icons/editor-open-single-16.png"), null));
		ImageDescriptor findImage = ImageDescriptor.createFromURL(FileLocator.find(bundle, new Path("icons/find-16.png"), null));
		ImageDescriptor locateKeyImage = ImageDescriptor.createFromURL(FileLocator.find(bundle, new Path("icons/lkey-view-16.png"), null));
		
		charFormatAction = new Action("Character Format") {
			@Override
			public void run() {
				if(loseFocusBecauseActionIsInvoked()){
				setToCharFMode();
				}
			}
		};
		charFormatAction.setImageDescriptor(charImage);
		charFormatAction.setId(CHAR_BUTTON_ID);
		charFormatAction.setActionDefinitionId(CHAR_BUTTON_ID);
		getViewSite().getActionBars().setGlobalActionHandler(CHAR_BUTTON_ID, charFormatAction);		
	
		
		sfFormatAction = new Action("Single Record Format") {
			@Override
			public void run() {
				if(loseFocusBecauseActionIsInvoked()){
				setToSFFMode();
				}
			}
		};
		sfFormatAction.setImageDescriptor(singleImage);
		sfFormatAction.setId(SF_BUTTON_ID);
		sfFormatAction.setActionDefinitionId(SF_BUTTON_ID);
		getViewSite().getActionBars().setGlobalActionHandler(SF_BUTTON_ID, sfFormatAction);	
		
		segmentAction = new Action("Filter Segments...") {
			@Override
			public void run() {
				if(loseFocusBecauseActionIsInvoked()){
				segment();
				}
			}
		};
		segmentAction.setId(SEGMENT_BUTTON_ID);
		segmentAction.setActionDefinitionId(SEGMENT_BUTTON_ID);
		getViewSite().getActionBars().setGlobalActionHandler(SEGMENT_BUTTON_ID, segmentAction);
		
		findAction = new Action("Find...") {
			@Override
			public void run() {
				if(loseFocusBecauseActionIsInvoked()){
				find();
				}
			}
		};
		findAction.setImageDescriptor(findImage);
		findAction.setId(FIND_BUTTON_ID);
		findAction.setActionDefinitionId(FIND_BUTTON_ID);
		getViewSite().getActionBars().setGlobalActionHandler(FIND_BUTTON_ID, findAction);	
		
		locatekeyAction = new Action("Locate Key...") {
			@Override
			public void run() {
				if(loseFocusBecauseActionIsInvoked()){
				locateKey();
				}
			}
		};
		locatekeyAction.setImageDescriptor(locateKeyImage);
		locatekeyAction.setId(LOCATEKEY_BUTTON_ID);
		locatekeyAction.setActionDefinitionId(LOCATEKEY_BUTTON_ID);
		getViewSite().getActionBars().setGlobalActionHandler(LOCATEKEY_BUTTON_ID, locatekeyAction);	
		
		menuManager = (MenuManager) getViewSite().getActionBars().getMenuManager();	
		menuManager.setRemoveAllWhenShown(true);
		menuManager.addMenuListener(new IMenuListener() {
			@Override
			public void menuAboutToShow(IMenuManager m) {
                // carel06 2014/11/19
				// Defect 3208
				// Why are we setting the action to be enabled/disabled 
				// at this part of the code, this should have already been done 
				// already.
				refreshCommitAndRollbackCommandAvailability();
//				commitAction.setEnabled(isDirty());
//				rollbackAction.setEnabled(isDirty());
//				hexAction.setEnabled(true);
				
				menuManager.add(charFormatAction);
				menuManager.add(sfFormatAction);
				menuManager.add(hexAction);
				menuManager.add(new Separator());
				menuManager.add(commitAction);
				menuManager.add(rollbackAction);
				menuManager.add(new Separator());
				menuManager.add(segmentAction);
				menuManager.add(new Separator());
				menuManager.add(findAction);
				menuManager.add(locatekeyAction);
			}					
	    });		
				
		popupMenuMgr = new MenuManager("#PopupMenu");
		popupMenuMgr.setRemoveAllWhenShown(true);
		popupMenuMgr.addMenuListener(new IMenuListener() {
			@Override
			public void menuAboutToShow(IMenuManager m) {
                // carel06 2014/11/19
				// Defect 3208
				// Why are we setting the action to be enabled/disabled 
				// at this part of the code, this should have already been done 
				// already.
				refreshCommitAndRollbackCommandAvailability();
//				commitAction.setEnabled(isDirty());
//				rollbackAction.setEnabled(isDirty());
//				hexAction.setEnabled(true);
				
				popupMenuMgr.add(charFormatAction);
				popupMenuMgr.add(sfFormatAction);	
				popupMenuMgr.add(hexAction);
				popupMenuMgr.add(new Separator());
				popupMenuMgr.add(commitAction);
				popupMenuMgr.add(rollbackAction);
				popupMenuMgr.add(new Separator());
				popupMenuMgr.add(segmentAction);
				popupMenuMgr.add(new Separator());
				popupMenuMgr.add(findAction);
				popupMenuMgr.add(locatekeyAction);
			}					
	    });
		
		toolbarManager = getViewSite().getActionBars().getToolBarManager();
		toolbarManager.add(charFormatAction);
		toolbarManager.add(sfFormatAction);
//		Bundle bundle = Platform.getBundle("com.ca.fmp.ims.view");
		ImageDescriptor hexImage = ImageDescriptor.createFromURL(FileLocator.find(bundle, new Path("icons/hex-mode-16.png"), null));
		hexAction.setImageDescriptor(hexImage);
		hexAction.setToolTipText("Hexadecimal");
		hexAction.setId(HEX_BUTTON_ID);
		toolbarManager.add(hexAction);
		hexAction.setEnabled(true);
		if(isHexToggled.value().equalsIgnoreCase("Y")){
			hexAction.setChecked(true);
		}
		else{
			hexAction.setChecked(false);
		}
		container = parent;
		layout = new StackLayout();
		container.setLayout(layout);
		
		//createCharFormatMode();
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, CONTEXT_HELP_ID);
		
//		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener(new IPartListener(){
//
//			@Override
//			public void partActivated(IWorkbenchPart part) {
//				if(part instanceof EditorView && mode != null){
//					((StatusLineContributionItem) ((IViewSite) part.getSite()).getActionBars()
//							.getStatusLineManager().find("columnrange")).setText(mode.columnRangeString);
//				}
//			}
//
//			@Override
//			public void partDeactivated(IWorkbenchPart part) {
//				if(part instanceof EditorView){						
//					((StatusLineContributionItem) ((IViewSite) part.getSite()).getActionBars()
//							.getStatusLineManager().find("columnrange")).setText("");
//					((StatusLineContributionItem) ((IViewSite) part.getSite()).getActionBars()
//							.getStatusLineManager().find("messages")).setText("");
//				}
//			}
//			
//			@Override
//			public void partBroughtToTop(IWorkbenchPart part) {}
//
//			@Override
//			public void partClosed(IWorkbenchPart part) {}
//
//			@Override
//			public void partOpened(IWorkbenchPart part) {}
//
//		});
		refreshCommitAndRollbackCommandAvailability();
		
		// Create cursor
		CursorType fmiCursor = new CursorType();
		setCursor(fmiCursor);
	}

	@Override
	public void setFocus() {
		// TODO Auto-generated method stub	
	}
	IAction getToolBarAction(String actionId) {
	if(((ActionContributionItem) toolbarManager.find(actionId))!=null)
		return ((ActionContributionItem) toolbarManager.find(actionId)).getAction();
	else
		return null;
		
	}
   	@Override
	public void dispose(){	
   		
   		((StatusLineContributionItem) ((IViewSite) this.getViewSite()).getActionBars()
				.getStatusLineManager().find("insertOrOvertype")).setText("");
   		((StatusLineContributionItem) ((IViewSite) this.getViewSite()).getActionBars()
				.getStatusLineManager().find("columnrange")).setText("");
   		((StatusLineContributionItem) ((IViewSite) this.getViewSite()).getActionBars()
				.getStatusLineManager().find("segmentCommand")).setText("");
   		if(clearMessage){
   			((StatusLineContributionItem) ((IViewSite) this.getViewSite()).getActionBars()
   					.getStatusLineManager().find("messages")).setText("");
   		}
   		
   		IViewPart cKeyView = getSite().getWorkbenchWindow().getActivePage().findView("com.ca.fmp.ims.view.ckey");
		if(cKeyView != null){
			((ConcatenatedKeyView)cKeyView).updateCKey(null);
			((ConcatenatedKeyView)cKeyView).disableView();
		}
		
		super.dispose();
		//navri01- i added the isUserLogedOn condition to fix defect incase editor is open and 
		// user updates the server, the sessions are supposed to be canceled on old server
		// so we dont want to send cancel editor request since session is allready canceled.
		if (server !=null){
			if(server.isUserLoggedon()){					
				if (performClosingCommand){														
					XMLDocument xmlDocument = null;
					try {
						if (isDirty){
							xmlDocument = new XMLDocument(new EndRequest(server,((IViewSite) this.getSite()).getSecondaryId()).createXml());
						}
						else{
							xmlDocument = new XMLDocument(new CancelRequest(server,((IViewSite) this.getSite()).getSecondaryId()).createXml());
						}
					} catch (TTException e1) {
						// 	TODO Auto-generated catch block
						e1.printStackTrace();
					}
					final HashMap<String, Object> map = new HashMap<String, Object>();
					SendRequestToMainframe req=new SendRequestToMainframe(server, map, "opendb", true, xmlDocument);
					if(req.getResult()==Status.CANCEL_STATUS){
						return;
					}
				}
		
				// @parra12: The following cancel request needs to be sent in order for the fmi address spaces to be cleaned up.
				FileMasterSession.cancelOneSession(server,((IViewSite) this.getSite()).getSecondaryId());
				// @parra12: The following code removes the session element from the fmservertreemodel.
				FileMasterSession.removeOneSessionFromList(server,((IViewSite) this.getSite()).getSecondaryId());
			}
   	    }
		
		// Close find dialog 
		Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
		if(activeShell!=null){
			final Shell[] shells = activeShell.getShells();
			for (Shell shell : shells) {
				Object object = shell.getData();
				if (object instanceof ModelessWizardDialog) {
					ModelessWizardDialog mwd = (ModelessWizardDialog) object;	
					mwd.close(); 
				}
			}
		}
   	}
	
	public void createCharFormatMode(int maxSegmentLength) {
		setDisplayMode(DisplayModeType.C);
		mode = new CharFormatMode(container, this, segmentInfo, maxSegmentLength).createCharFormat();
		
		charContainer = ((CharFormatMode) mode).getComposite();	
		layout.topControl = charContainer;
			
		Menu charPopupMenu = popupMenuMgr.createContextMenu(mode.tableViewer.getControl());
		mode.tableViewer.getControl().setMenu(charPopupMenu);
		getSite().registerContextMenu(popupMenuMgr, mode.tableViewer);
		
		((CharFormatMode) mode).setMenuManager(popupMenuMgr);
		
		container.layout();
		updateToolBar();
	}
	
	public void createSingleRecordFormatMode(int maxSegmentLength) {
		setDisplayMode(DisplayModeType.S);
		mode = new SingleRecordFormatMode(container, this, segmentInfo, maxSegmentLength).createSingleRecordFormat();
		
		sfContainer = ((SingleRecordFormatMode) mode).getComposite();	
		layout.topControl = sfContainer;

		Menu singlePopupMenu = popupMenuMgr.createContextMenu(mode.tableViewer.getControl());
		mode.tableViewer.getControl().setMenu(singlePopupMenu);
		getSite().registerContextMenu(popupMenuMgr, mode.tableViewer);		
		
		((SingleRecordFormatMode) mode).setMenuManager(popupMenuMgr);
		
		container.layout();
		updateToolBar();
	}	
		
	public void setServer(FileMasterServer server){
		this.server = server; 
	}
	
	@Override
	public void setPartName(String partName) {
		super.setPartName(partName);
	}
	
	public FormatMode getFormatMode(){
		return mode;
	}
	
	public void setSegmentInfo(SegmentInfoListType segmentInfo){
		this.segmentInfo = segmentInfo;
		
		this.segmentState = new ArrayList<SegmentCmdInfoType>();
		SegmentCmdInfoType segmentCmdInfo;
		segmentInfoMap = new HashMap<Short, SegmentInfoType>();
		for (SegmentInfoType segmentInfoValue : segmentInfo.getSegmentInfo()){
			segmentCmdInfo = new SegmentCmdInfoType();
			segmentCmdInfo.setSegNum(segmentInfoValue.getSegNum());

			SegmentCmdStateType state = segmentInfoValue.getState();
			if(!isSegmentCmdActive && state == SegmentCmdStateType.X){
				isSegmentCmdActive = true;

				((StatusLineContributionItem) ((IViewSite) this.getViewSite()).getActionBars()
						.getStatusLineManager().find("segmentCommand")).setText("SEG");
			}
			segmentCmdInfo.setState(state);

			segmentState.add(segmentCmdInfo);
			segmentInfoMap.put(segmentInfoValue.getSegNum(), segmentInfoValue);
		}
	}	
	
	public void setFindLimit(long findLimit){
		this.findLimit = findLimit;
	}	
	
	public long getFindLimit(){
		return findLimit;
	}
	
	public FileMasterServer getServer(){
		return server;
	}
	
	public void closeView() {
		this.getSite().getPage().hideView(this);
	}
	
	public void hex(YorNType hexModeOn){
		if (mode instanceof CharFormatMode){					
			String reference = ((CharFormatMode)mode).getSegmentIDforReference();
			if(hexModeOn.equals(YorNType.Y)){
				((CharFormatMode)mode).requestAndDisplaySegments(reference, 0, EditGetDirectionType. DOWN);
				((CharFormatMode)mode).putCursor();
			}
			else{
				int maxSegmentLength = mode.maxSegmentLength;
				int hSliderSel = ((CharFormatMode)mode).slider.getSelection();
				((CharFormatMode)mode).disposeContainer();
				mode = new CharFormatMode(container, this, segmentInfo, maxSegmentLength).createCharFormat();
				((CharFormatMode)mode).requestAndDisplaySegments(reference, 0, EditGetDirectionType. DOWN);
				
				IViewPart cKeyView = getSite().getWorkbenchWindow().getActivePage().findView("com.ca.fmp.ims.view.ckey");
				if(cKeyView != null){
					mode.setCKeyHex(((ConcatenatedKeyView)cKeyView).getCKeyHex());
				}
				
				((CharFormatMode)mode).slider.setSelection(hSliderSel);   	  
				charContainer = ((CharFormatMode) mode).getComposite();	  	// Get the character composite and
				layout.topControl = charContainer;							// put it at the top of composites. 
				//@parra12: necessary to refresh the creation of the new mode.				
				
				Menu charPopupMenu = popupMenuMgr.createContextMenu(mode.tableViewer.getControl());
				mode.tableViewer.getControl().setMenu(charPopupMenu);
				getSite().registerContextMenu(popupMenuMgr, mode.tableViewer);
				
				((CharFormatMode) mode).setMenuManager(popupMenuMgr); // Set pop-up menu for EditingSupportFileMasterIMS class
				
				container.layout();				
			}
		}							
		else if (mode instanceof SingleRecordFormatMode){					
			String reference = ((SingleRecordFormatMode)mode).getSegmentIDforReference();
			if(hexModeOn.equals(YorNType.Y)){
				((SingleRecordFormatMode)mode).requestAndDisplaySegment(reference, 0, EditGetDirectionType. DOWN);
				((SingleRecordFormatMode)mode).putCursor();
			}
			else{
				int maxSegmentLength = mode.maxSegmentLength;
				int hSliderSel = ((SingleRecordFormatMode)mode).slider.getSelection();
				((SingleRecordFormatMode)mode).disposeContainer();												           			
				mode = new SingleRecordFormatMode(container, this, segmentInfo, maxSegmentLength).createSingleRecordFormat();
				((SingleRecordFormatMode)mode).requestAndDisplaySegment(reference, 0, EditGetDirectionType. DOWN);
				
				IViewPart cKeyView = getSite().getWorkbenchWindow().getActivePage().findView("com.ca.fmp.ims.view.ckey");
				if(cKeyView != null){
					mode.setCKeyHex(((ConcatenatedKeyView)cKeyView).getCKeyHex());
				}
				
				((SingleRecordFormatMode)mode).slider.setSelection(hSliderSel);   	  
				sfContainer = ((SingleRecordFormatMode) mode).getComposite();	  	// Get the SRF composite and
				layout.topControl = sfContainer;							        // put it at the top of composites. 
				
				Menu srfPopupMenu = popupMenuMgr.createContextMenu(mode.tableViewer.getControl());
				mode.tableViewer.getControl().setMenu(srfPopupMenu);
				getSite().registerContextMenu(popupMenuMgr, mode.tableViewer);
				
				((SingleRecordFormatMode) mode).setMenuManager(popupMenuMgr); // Set pop-up menu for EditingSupportFileMasterIMS class
				
				//@parra12: necessary to refresh the creation of the new mode.				
				container.layout();
			}
		}											
	}
	public void commit (YorNType endEdit){
	    XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument (new CommitRequest(server, ((IViewSite) this.getSite()).getSecondaryId(), endEdit).createXml());	
		} catch (TTException e1) {
			e1.printStackTrace();
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req = new SendRequestToMainframe(server, map, "opendb", true, xmlDocument);

		do{					
		}while(req.getResult() != Status.OK_STATUS);
		
		if (endEdit == YorNType.N){
			if (mode instanceof CharFormatMode){
				GUIResponseType response = req.getGuiResponseType();					
				((CharFormatMode)mode).updateDisplay(response, true);	
			}		
			else if (mode instanceof SingleRecordFormatMode){
				GUIResponseType response = req.getGuiResponseType();					
				((SingleRecordFormatMode)mode).updateDisplay(response);			
			}	
	    } else {
	    	//commit and close
	    	Common.displayMessageforEditorView(req.getGuiResponseType(), this.getViewSite(), true);
	    	if(((StatusLineContributionItem) ((IViewSite) this.getViewSite()).getActionBars()
	    			.getStatusLineManager().find("messages")).getText().length() != 0){
	    		clearMessage = false;
	    	}
	    }
		
		isDirty = false;
		firePropertyChange(PROP_DIRTY);
		refreshCommitAndRollbackCommandAvailability();
	}
	
	public void rollback(){
		XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument (new RollbackRequest(server, ((IViewSite) this.getSite()).getSecondaryId()).createXml());	
		} catch (TTException e1) {
			e1.printStackTrace();
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req = new SendRequestToMainframe(server, map, "opendb", true, xmlDocument);

		do{					
		}while(req.getResult() != Status.OK_STATUS);
		
		if (mode instanceof CharFormatMode){
			GUIResponseType response = req.getGuiResponseType();					
			((CharFormatMode)mode).updateDisplay(response, true);	
		}		
		else if (mode instanceof SingleRecordFormatMode){
			GUIResponseType response = req.getGuiResponseType();					
			((SingleRecordFormatMode)mode).updateDisplay(response);			
		}
		
		isDirty = false;
		firePropertyChange(PROP_DIRTY);
		refreshCommitAndRollbackCommandAvailability();
	}
	
	public void refreshCommitAndRollbackCommandAvailability(){
		// carel06 2014/11/19
		// Defect 3208
		// If we are in SF Mode, we have to check if there are error messages.
		// If there are can't enable the commit or rollback action.
		if(mode instanceof SingleRecordFormatMode) {
			SingleRecordFormatMode sfMode = (SingleRecordFormatMode) mode;
			String text = sfMode.getErrorMessageText().getText();
            if(text == null || text.length() == 0) {
            	// no errors
            	commitAction.setEnabled(isDirty());
            	rollbackAction.setEnabled(isDirty());            	
            } else {
            	// have some errors
            	commitAction.setEnabled(false);
            	rollbackAction.setEnabled(false);
            }
		} else {
			commitAction.setEnabled(isDirty());
			rollbackAction.setEnabled(isDirty()); 
		}
	}

	public void setDirty(){
		if (getEditMode() != EditModeType.B) {
			isDirty = true;
			firePropertyChange(PROP_DIRTY);	
		}
	}
	
	/**
	 * carel06 - 20141023
	 * When working on overtyping in SF mode,
	 * if error conditions exist in the SegmentFieldType,
	 * we disallow the user from saving.
	 *
	 * @param dirtyFlag
	 */
	public void setDirty(boolean dirtyFlag) {
		isDirty = dirtyFlag;
		firePropertyChange(PROP_DIRTY);
	}

	@Override
	public void doSave(IProgressMonitor monitor) {
		if(setEditEndForCommit){
			commit(YorNType.Y);
		}
		else{
		loseFocusBecauseActionIsInvoked();
		commit(YorNType.N);
		}
		performClosingCommand=false;
	}

	@Override
	public void doSaveAs() {}

	@Override
	public boolean isDirty() {
		return isDirty;
	}

	@Override
	public boolean isSaveAsAllowed() {
		return false;
	}

	@Override
	public boolean isSaveOnCloseNeeded() {
		
		//TODO only in edit mode
		return isDirty();
	}
	
	protected void setToCharFMode() {
		if (mode instanceof SingleRecordFormatMode){
			sfContainer.dispose();
		}
		CursorType fmiCursor = getCursor();
		fmiCursor.setCursorPosition(0);
		setCursor(fmiCursor);
		createCharFormatMode(mode.maxSegmentLength);	
		
	}
	
	protected void setToSFFMode() {
		if (mode instanceof CharFormatMode){
			charContainer.dispose();
		}
		CursorType fmiCursor = getCursor();
		fmiCursor.setCursorPosition(0);
		fmiCursor.setFieldId(0);
		setCursor(fmiCursor);
		createSingleRecordFormatMode(mode.maxSegmentLength);		
	}
	
	public void setMaxSegLen(long maxSegLen){
		this.maxSegLen = maxSegLen;
	}
	
	public void setDisplayMode(DisplayModeType displayMode){
		this.displayMode = displayMode;
	}
	
	public DisplayModeType getDisplayMode(){
		return displayMode;	
	}
	
	public void setEditMode(EditModeType editMode){
		this.editMode = editMode;
	}
	
	public EditModeType getEditMode(){
		return editMode;	
	}
	
	private void updateToolBar() {
		if (getDisplayMode() == DisplayModeType.C){
			charFormatAction.setEnabled(false);
		} else 
			charFormatAction.setEnabled(true);
		
		if (getDisplayMode() == DisplayModeType.S){
			sfFormatAction.setEnabled(false);
		} else
			sfFormatAction.setEnabled(true);			
	}
	
	public IMSSegment getCurrentSegment(){
		 return currentSegment;
	}
	
	/**
	 * Be able to send an updateSegment request before sending 
	 * other requests (COMMIT)
	 * 
	 * TODO: needs to be done in SRF mode as well.
	 */
	private boolean loseFocusBecauseActionIsInvoked() {
		container.getShell().setFocus();
		if(mode instanceof CharFormatMode) {
			//@parra12: taken this line of code and made it common for both char and sf mode.
			//	container.getShell().setFocus();
			if (((CharFormatMode) mode).getEditingSupportFileMasterIMS() != null){
				if (((CharFormatMode) mode).getEditingSupportFileMasterIMS().getSegmentUpdateRequest() != null) {
					if (((CharFormatMode) mode).getEditingSupportFileMasterIMS().getSegmentUpdateRequest().getFunctionRC() !=0 ||
						((CharFormatMode) mode).getEditingSupportFileMasterIMS().getSegmentUpdateRequest().getReturnCode() !=0) {
						((CharFormatMode) mode).getEditingSupportFileMasterIMS().setSegmentUpdateRequest(null);
						return false;					
					}
				}
			}			
			charContainer.setFocus();
		}
		return true;
	}
	
	public YorNType getHexToggled(){
		return isHexToggled;
	}
	
	public void segment(){
		if(SegmentCommandWizard.getSegmentCommandWizardCount() > 0)
			return;
		
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
		ISelection selection = window.getSelectionService().getSelection();
		
		segmentWizard = new SegmentCommandWizard(this, mode);
		segmentWizard.init(workbench, (IStructuredSelection) selection);  
	 
	    Shell shell = window.getShell();
	    TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(shell, segmentWizard);
		dialog.create();
		dialog.open();
	}
	
	public void find(){
		if(FindCommandWizard.getFindCommandWizardCount() > 0)
			return;
		
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
		ISelection selection = window.getSelectionService().getSelection();
		
		wizard = new FindCommandWizard(mode);
	    wizard.init(workbench, (IStructuredSelection) selection);  
	 
	    Shell shell = window.getShell();
		ModelessWizardDialog dialog = new ModelessWizardDialog(shell, wizard);
		dialog.create();
		setfindSliderActive(true);
		dialog.open();
	}

	public void setCursor(CursorType fmiCursor) {
		this.fmiCursor = fmiCursor;
	}
	
	public CursorType getCursor(){
		return fmiCursor;
	}
	
	public void updateTableBasedOnFindResult(GUIResponseType response) {
		if (mode instanceof CharFormatMode){
			((CharFormatMode) mode).updateDisplay(response, true);
		} else {
			if (mode instanceof SingleRecordFormatMode){
				((SingleRecordFormatMode) mode).updateDisplay(response);
			}
		}
	}
	
	public void updateTableBasedOnLocateKeyResult(GUIResponseType response) {
		if (mode instanceof CharFormatMode){
			((CharFormatMode) mode).editSelection = false;
			((CharFormatMode) mode).updateDisplay(response, true);
		} else {
			if (mode instanceof SingleRecordFormatMode){
				((SingleRecordFormatMode) mode).updateDisplay(response);
			}
		}
	}
	
	public void setfindSliderActive(boolean findSliderActive){
		this.findSliderActive = findSliderActive;
	}
	
	public boolean getfindSliderActive(){
		return findSliderActive;
	}
	
	public ArrayList<SegmentCmdInfoType> getSegmentState(){
		return segmentState;
	}
	
	public void setSegmentState(ArrayList<SegmentCmdInfoType> segmentState){
		this.segmentState = segmentState;
	}

	@Override
	public int promptToSaveOnClose() {
	
		boolean result = true;
		if (mode instanceof SingleRecordFormatMode){
			if(((SingleRecordFormatMode)getFormatMode()).getErrorMessageText().getText().length()>0){
				result = MessageDialog.openConfirm(null, "Error", "Save is disabled because there is an error in the edit session." +
						"\n"+"Click cancel to correct the error or OK to exit without saving the changes.");
				if(result){
					return ISaveablePart2.NO;
				}
				// 
				return ISaveablePart2.CANCEL;
			} else {
				return copyOrigSaveDialog();
			}
		} else {
			return copyOrigSaveDialog();
		}
	}

	private int copyOrigSaveDialog() {
		
		// TODO Auto-generated method stub
		MessageDialog dg = new MessageDialog(
				null,
				"Save Resource",
				null,
				"\'" + this.getPartName() + "\'" + " has been modified. Save changes?",
				MessageDialog.QUESTION_WITH_CANCEL, 
				new String[]{
					IDialogConstants.YES_LABEL, 
					IDialogConstants.NO_LABEL, 
					IDialogConstants.CANCEL_LABEL},
				0
				);
		switch(dg.open()) {
		case 0: 
			//yes
			setEditEndForCommit = true;
			System.out.println("yes");
			return ISaveablePart2.YES;
		case 1:
			//no
			System.out.println("no");
			return ISaveablePart2.NO;
		case 2:
			//cancel
			System.out.println("cancel");
			return ISaveablePart2.CANCEL;
			default:
				return ISaveablePart2.CANCEL;
		} 
	}
	
	public void locateKey(){
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
		ISelection selection = window.getSelectionService().getSelection();
	 
		if (!(selection instanceof IStructuredSelection)){
			selection = null;
		}
		wizardLK = new LocateKeyCommandWizard(mode);
		wizardLK.init(workbench, (IStructuredSelection) selection);
		Shell shell = window.getShell();
		TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(shell, wizardLK);
		dialog.create();
		dialog.open();	
	}

	protected Action getCommitAction() {
		return commitAction;
	}

	protected Action getRollbackAction() {
		return rollbackAction;
	}

	protected Action getHexAction() {
		return hexAction;
	}

	protected Action getCharFormatAction() {
		return charFormatAction;
	}

	protected Action getSfFormatAction() {
		return sfFormatAction;
	}

	protected Action getFindAction() {
		return findAction;
	}

	protected Action getSegmentAction() {
		return segmentAction;
	}

	protected Action getLocatekeyAction() {
		return locatekeyAction;
	}
}
