/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.ACC;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.common.Constants;
import com.ca.fmp.ims.model.GetSegmentsRequest;
import com.ca.fmp.ims.model.IMSSegment;
import com.ca.fmp.ims.model.generated.CKeyInfoType;
import com.ca.fmp.ims.model.generated.CursorType;
import com.ca.fmp.ims.model.generated.DisplayModeType;
import com.ca.fmp.ims.model.generated.EditGetDirectionType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.SegmentInfoListType;
import com.ca.fmp.ims.model.generated.YorNType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.Common;
import com.ca.fmp.ims.view.ckey.ConcatenatedKeyView;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;

public class CharFormatMode extends FormatMode {
	public List<IMSSegment> inputData = new ArrayList<IMSSegment>();
	
//	private Event selectionEvent;
	private int loadBufferSize;
	private CKeyInfoType ckeyInfo = CKeyInfoType.N;
	private IMSSegment selectedSegment;
//	private final int LINENUM_LEN = 10;
//	private Logger log = Logger.getLogger(CharFormatMode.class.getName());
	private int xPosMouse = -1;
	private int dataColumnBegin;
	ArrayList<String> shortText = new ArrayList<String>();
	ArrayList<String> messageID = new ArrayList<String>();
	List<String> messageText = new ArrayList<String>();
	String messageIDFinal="";
	String messageTextFinal= "";
	String title = "";
	private MenuManager menuMgr;
	private boolean show=true;
	private EditingSupportFileMasterIMS editingSupportFileMasterIMS;
	//@parra12: making this global so that we can dispose it when hex mode is off.
	private Composite editorComposite;
	private Composite navButtonsComposite;
	private Composite charContainer;
	
	private int selectionIndex = -1;
	public boolean editSelection;
	
	// cursor flags
	private boolean setCusrsorFlag = true;
	private boolean putCusrsorFlag = true;
	
	public CharFormatMode(Composite parent, EditorView eView, SegmentInfoListType sInfo, int maxSegmentLength) {
		super(parent, eView, sInfo, maxSegmentLength);
	}
	
    public FormatMode createCharFormat(){
    	charContainer = new Composite(parent, SWT.NONE);
    	charContainer.setLayout(new GridLayout(2, false));
		
		editorComposite = new Composite(charContainer, SWT.NONE);
		editorComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		GridLayout gl_editorComposite = new GridLayout(1, false);
		gl_editorComposite.marginWidth = 0;
		gl_editorComposite.marginHeight = 0;
		gl_editorComposite.verticalSpacing = 0;
		editorComposite.setLayout(gl_editorComposite);
		
		editorComposite.setFocus();
		
		tableViewer = new TableViewer(editorComposite, SWT.BORDER | SWT.FULL_SELECTION);
		TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(
				tableViewer, new FocusCellOwnerDrawHighlighter(tableViewer));
		ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy(
				tableViewer) {
			protected boolean isEditorActivationEvent(
					ColumnViewerEditorActivationEvent event) {
				return event.eventType == ColumnViewerEditorActivationEvent.TRAVERSAL || event.eventType == ColumnViewerEditorActivationEvent.MOUSE_DOUBLE_CLICK_SELECTION|| event.eventType==ColumnViewerEditorActivationEvent.KEY_PRESSED ||  
                        (event.eventType == ColumnViewerEditorActivationEvent.MOUSE_CLICK_SELECTION && ((MouseEvent)event.sourceEvent).button == 1) 
                        || event.eventType == ColumnViewerEditorActivationEvent.PROGRAMMATIC;
			}
		};
		
		
		TableViewerEditor.create(tableViewer, focusCellManager, actSupport, ColumnViewerEditor.TABBING_HORIZONTAL
                | ColumnViewerEditor.TABBING_MOVE_TO_ROW_NEIGHBOR | ColumnViewerEditor.TABBING_VERTICAL | ColumnViewerEditor.KEYBOARD_ACTIVATION);
		final Table table = tableViewer.getTable();
		//@parra12: Disable the tooltip text.
		table.setToolTipText("");
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		table.getVerticalBar().dispose();
		table.getHorizontalBar().dispose();

		tableViewer.getTable().setFont(JFaceResources.getTextFont());
		int pixelSizeOfCharacter = getPixelSizeOfCharacter();

		//navri01- added menuManager code to activate right click in editor char mode.
		menuMgr = new MenuManager();
		menuMgr.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
		if (show) {
			menuMgr.addMenuListener(new IMenuListener() {

				@Override
				public void menuAboutToShow(IMenuManager manager) {
					// TODO Auto-generated method stub
					show = false;
					menuMgr.removeAll();

				}
			});
		}
		((IViewSite) PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite()).registerContextMenu(menuMgr, tableViewer);
		Control control = tableViewer.getControl();
		Menu menu = menuMgr.createContextMenu(control);
		control.setMenu(menu);
		((IViewSite) PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite()).setSelectionProvider(tableViewer);
		
		TableViewerColumn colLevel = new TableViewerColumn(tableViewer, SWT.NONE);
		colLevel.getColumn().setWidth((pixelSizeOfCharacter * 5) + 16);
		colLevel.getColumn().setText("Level");
		colLevel.getColumn().setResizable(false); 
		
		Shell shell = new Shell();
		TextLayout levelLayout = new TextLayout(shell.getDisplay());
		colLevel.setLabelProvider(new LevelLabelProvider(pixelSizeOfCharacter, levelLayout));

		
		TableViewerColumn colName = new TableViewerColumn(tableViewer, SWT.NONE);
		colName.getColumn().setText("Segment");
		colName.getColumn().setResizable(false);
		colName.setEditingSupport(new EditingSupportFileMasterIMS(editorView,tableViewer,2, colName, this));
		
		TextLayout nameLayout = new TextLayout(shell.getDisplay());
		colName.setLabelProvider(new SegmentLabelProvider( pixelSizeOfCharacter, table.getItemHeight(), nameLayout, shell));


		TableViewerColumn colData = new TableViewerColumn(tableViewer, SWT.NONE);
		colData.getColumn().setText("Data");
		colData.getColumn().setResizable(false);
		editingSupportFileMasterIMS = new EditingSupportFileMasterIMS(editorView, tableViewer,3, colData, this);
		colData.setEditingSupport(editingSupportFileMasterIMS);
		
		TextLayout charDataLayout = new TextLayout(shell.getDisplay());
		
	    loadBufferSize = 0;	
		
		slider = new Slider(editorComposite, SWT.NONE);
		slider.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		slider.setMaximum(maxSegmentLength);		
		slider.addSelectionListener(new SelectionListener(){

			@Override
			public void widgetSelected(SelectionEvent e) {
				TextCellEditor textCellEditor = editingSupportFileMasterIMS.getTextCellEditor();
                if(textCellEditor != null && textCellEditor.isActivated()) {
                	textCellEditor.deactivate();
                }
                
				int dataColumnWidth = table.getColumn(2).getWidth();
				int pixelSizeOfCharacter = getPixelSizeOfCharacter();
					
				int columnStart = slider.getSelection();
				//@parra12: subtracting 1 to match the number of characters displayed on the page. Defect 3108.
				int columnEnd = (dataColumnWidth / pixelSizeOfCharacter) + columnStart - 1;
				columnRangeString = "Columns " + (columnStart + 1) + " - " + columnEnd;
				
				if(dataColumnWidth < pixelSizeOfCharacter){
					columnEnd = columnStart;
					columnRangeString = "";
				}
				((StatusLineContributionItem) ((IViewSite) editorView.getViewSite()).getActionBars()
						.getStatusLineManager().find("columnrange")).setText(columnRangeString);
				
				String charData;
				String hexData1;
				int start, end;
				for(int i = 0; i < table.getItemCount(); i++){
					start = columnStart;
					end = columnEnd;
					
					charData = inputData.get(i).segmentType.getSegmentFields().getSegmentField().get(0).getCharData();
					hexData1 = inputData.get(i).segmentType.getSegmentFields().getSegmentField().get(0).getHexData1();
					if(start > charData.length()){
						start = 0;
						end = 0;
					} else if(end > charData.length()){
						end = charData.length();
					}
					//@parra12: If hex is on than we need to preserve the hex data when user scrolls horizontally.
					if(hexData1!=null){
						displayHexData(inputData,table.getItem(i),charData,start,end,i);
					}
					else{
						table.getItem(i).setText(2, charData.substring(start, end));
					}
				}
				table.redraw();
				slider.setFocus();					
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {}
		});

		colData.setLabelProvider(new CharDataLabelProvider(charDataLayout, shell, slider, editorView));
		createNavButtons();
		
		
		table.getAccessible().addAccessibleListener(new AccessibleListener(){

			@Override
			public void getName(AccessibleEvent e) {
				if (e.childID == ACC.CHILDID_SELF) {
					e.result = "Level, Segment, Data";
				}
			}

			@Override
			public void getHelp(AccessibleEvent e) {}

			@Override
			public void getKeyboardShortcut(AccessibleEvent e) {}

			@Override
			public void getDescription(AccessibleEvent e) {}
			
		});

		tableViewer.getTable().addControlListener(new ControlListener() {

			@Override
			public void controlResized(ControlEvent e) {
			    int newLoadBufferSize = calculateNewLoadBufferSize(false);
//              System.out.println(" >>>> controlResized newLoadBufferSize: "+ newLoadBufferSize + "| loadBufferSize: " + loadBufferSize  + "|getVisibleItemCount(viewer.getTable()): " + getVisibleItemCount(viewer.getTable()));								
			    
				if (newLoadBufferSize > loadBufferSize){
//                  System.out.println(">>>> controlResized | Data request issued");
					
					loadBufferSize = newLoadBufferSize;
					
					if (inputData.size()!=0){					
					   requestAndDisplaySegments(inputData.get(0).segmentType.getSegid(), 0, EditGetDirectionType. UP);
					}   
					else{
						if (editorView.getCurrentSegment() != null){
							requestAndDisplaySegments((editorView.getCurrentSegment()).segmentType.getSegid(), 0, EditGetDirectionType. UP);
						} else
							requestAndDisplaySegments("TOP", 0, EditGetDirectionType. UP);	
					}
					putCursor();
					return;
				}	
				
				updateDisplay(null, true);
				putCursor();
			}
			
			@Override
			public void controlMoved(ControlEvent e) {}
		});
				
		tableViewer.getTable().addSelectionListener(new SelectionListener(){

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {}

			@Override
			public void widgetSelected(SelectionEvent e) {
				setCurrentSegment();
				TableItem selection = (TableItem)e.item;
				if (selection != null) {
					Object data = selection.getData();
					if (data instanceof IMSSegment) {
						selectedSegment = (IMSSegment)selection.getData();                  

						IViewPart cKeyView = editorView.getSite().getWorkbenchWindow().getActivePage().findView("com.ca.fmp.ims.view.ckey");
						if(cKeyView != null){
							((ConcatenatedKeyView)cKeyView).updateCKey(selectedSegment.segmentType.getCKey().getCKeyEntry());
							((ConcatenatedKeyView)cKeyView).setSegid(editorView.currentSegment.segmentType.getSegid());
						}
						
						//Segment was selected, get cursor
						if (setCusrsorFlag){
							CursorType fmiCursor = editorView.getCursor();
							fmiCursor.setSegid(selectedSegment.segmentType.getSegid());
							editorView.setCursor(fmiCursor);
						} else {
							setCusrsorFlag = true;
						}
					}
				}
				editSelection = true;
				
				CursorType fmiCursor = editorView.getCursor();
				if(fmiCursor.getCursorPosition() > -1 & putCusrsorFlag) {
					tableViewer.editElement(tableViewer.getTable().getSelection()[0].getData(), 2);
					if (getSubstringBeginIndex() > fmiCursor.getCursorPosition()){
						fmiCursor.setCursorPosition(getSubstringBeginIndex());
					}
					
					if (getSubstringEndIndex() < fmiCursor.getCursorPosition()){
						fmiCursor.setCursorPosition(getSubstringEndIndex());
					}
					((Text)selection.getParent().getChildren()[0]).setSelection(fmiCursor.getCursorPosition()-getSubstringBeginIndex());
				} else {
					putCusrsorFlag = true;
				}
			}

		});
		
		table.addMouseListener(new MouseListener(){

			@Override
			public void mouseDoubleClick(MouseEvent e) {}

			@Override
			public void mouseDown(MouseEvent e) {
				dataColumnBegin = tableViewer.getTable().getColumn(0).getWidth()+tableViewer.getTable().getColumn(1).getWidth();
				xPosMouse = e.x;
				
				if (e.button != 1){
					putCusrsorFlag = false;
				} else {
					int caretPos = (int) Math.floor((xPosMouse - dataColumnBegin)/getPixelSizeOfCharacter());
					//Get absolute position of the carter(from beginning of the column)
					if (caretPos > -1){
						caretPos = caretPos + getSubstringBeginIndex();
					}
					CursorType fmiCursor = editorView.getCursor();
					fmiCursor.setCursorPosition(caretPos);
					editorView.setCursor(fmiCursor);
					putCusrsorFlag = true;
				}
			}

			@Override
			public void mouseUp(MouseEvent e) {

				TableItem clickedItem = ((Table) e.widget).getItem(new Point(e.x, e.y));

				int clickedItemIndex = -1;
				TableItem allItems[] = tableViewer.getTable().getItems();
				for(int i = 0; i < allItems.length; i++){
					if(allItems[i].equals(clickedItem)){
						clickedItemIndex = i;
					}
				}

				if(clickedItemIndex > -1){
					//TODO
//					IMSSegment clickedSegment = testData.get(clickedItemIndex);
				}

			}

		});
		
		table.addMouseWheelListener(new MouseWheelListener(){
			@Override
			public void mouseScrolled(MouseEvent e) {
				slider.setSelection(slider.getSelection() - e.count);
				slider.notifyListeners(SWT.Selection, new Event());
			}
		});
		
		table.addKeyListener(new KeyListener(){

			@Override
			public void keyPressed(KeyEvent e) {
				if(e.keyCode == SWT.ARROW_UP){
					if (tableViewer.getTable().getSelectionIndex()==0){
					  doScrollSegmentUp();
					  tableViewer.getTable().setSelection(0);					  
					// e.doit = false;  
					}					
					else if (tableViewer.getTable().getSelectionIndex()==-1 && selectedSegment != null){
						doScrollSegmentUp(selectedSegment.segmentType.getSegid());
						tableViewer.getTable().setSelection(0);							
					//	e.doit = false;						
					}										
				}
				
				if(e.keyCode == SWT.PAGE_UP){					
					if (tableViewer.getTable().getSelectionIndex()==0){
					  doScrollPageUp();
					  tableViewer.getTable().setSelection(0);					  
					  e.doit = false;  
					}
					else if (tableViewer.getTable().getSelectionIndex()==-1 && selectedSegment != null){
						doScrollPageUp(selectedSegment.segmentType.getSegid());
						tableViewer.getTable().setSelection(0);							
						e.doit = false;						
					}					
				}

				else if(e.keyCode == SWT.ARROW_DOWN){
					int selectedIndex = tableViewer.getTable().getSelectionIndex();
					if(selectedIndex >= getVisibleItemCount(table) - 2){
						doScrollSegmentDown();
						tableViewer.getTable().setSelection(selectedIndex - 1);
					}
					else if (selectedIndex == -1 && selectedSegment != null){
							doScrollSegmentDown(selectedSegment.segmentType.getSegid());
							tableViewer.getTable().setSelection(0);
							e.doit = false;
					}
				}

				else if(e.keyCode == SWT.PAGE_DOWN){
					int selectedIndex = tableViewer.getTable().getSelectionIndex();
					if(selectedIndex == getVisibleItemCount(tableViewer.getTable()) - 2){
						doScrollPageDown();
						tableViewer.getTable().setSelection(selectedIndex - 1);
					}
					else if (selectedIndex == -1 && selectedSegment != null){
						doScrollPageDown(selectedSegment.segmentType.getSegid());
						tableViewer.getTable().setSelection(0);
						e.doit = false;
					}
				}
				
				if(e.keyCode == SWT.ARROW_RIGHT){
					slider.setSelection(slider.getSelection() + 1);
					slider.notifyListeners(SWT.Selection, new Event());
					
					e.doit = false;
				}
				
				else if(e.keyCode == SWT.ARROW_LEFT){
					slider.setSelection(slider.getSelection() - 1);
					slider.notifyListeners(SWT.Selection, new Event());
					
					e.doit = false;					
				}
			}

			@Override
			public void keyReleased(KeyEvent e) {}
		});
		
		return this;
	}
	
	private void createNavButtons(){
		navButtonsComposite = new Composite(charContainer, SWT.NONE);
		navButtonsComposite.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, true, 1, 1));
		GridLayout gl_navButtonsComposite = new GridLayout(1, false);
		gl_navButtonsComposite.marginWidth = 0;
		gl_navButtonsComposite.marginHeight = 0;
		navButtonsComposite.setLayout(gl_navButtonsComposite);
		
		

		Button btnTop = new Button(navButtonsComposite, SWT.NONE);
		btnTop.setImage(getImage("jump-top-24.png"));
		btnTop.setToolTipText("Go To Beginning");
		btnTop.getAccessible().addAccessibleListener(new AccessibleListener(){

			@Override
			public void getName(AccessibleEvent e) {
				e.result = "Go To Beginning";
			}

			@Override
			public void getHelp(AccessibleEvent e) {}

			@Override
			public void getKeyboardShortcut(AccessibleEvent e) {}

			@Override
			public void getDescription(AccessibleEvent e) {}
			
		});
		btnTop.addSelectionListener(new SelectionListener(){

			@Override
			public void widgetSelected(SelectionEvent e) {
				doScrollTop();
				putCursor();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {}
		});

		Button btnPageUp = new Button(navButtonsComposite, SWT.NONE);
		btnPageUp.setImage(getImage("jump-page-up-24.png"));
		btnPageUp.setToolTipText("Scroll Up One Page");
		btnPageUp.getAccessible().addAccessibleListener(new AccessibleListener(){

			@Override
			public void getName(AccessibleEvent e) {
				e.result = "Scroll Up One Page";
			}

			@Override
			public void getHelp(AccessibleEvent e) {}

			@Override
			public void getKeyboardShortcut(AccessibleEvent e) {}

			@Override
			public void getDescription(AccessibleEvent e) {}

		});
		btnPageUp.addSelectionListener(new SelectionListener(){

			@Override
			public void widgetSelected(SelectionEvent e) {
				doScrollPageUp();
				putCursor();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {}
		});

		Button btnUp = new Button(navButtonsComposite, SWT.NONE);
		btnUp.setImage(getImage("jump-segment-up-24.png"));
		btnUp.setToolTipText("Scroll Up One Segment");
		btnUp.getAccessible().addAccessibleListener(new AccessibleListener(){

			@Override
			public void getName(AccessibleEvent e) {
				e.result = "Scroll Up One Segment";
			}

			@Override
			public void getHelp(AccessibleEvent e) {}

			@Override
			public void getKeyboardShortcut(AccessibleEvent e) {}

			@Override
			public void getDescription(AccessibleEvent e) {}

		});
		btnUp.addSelectionListener(new SelectionListener(){

			@Override
			public void widgetSelected(SelectionEvent e) {
				doScrollSegmentUp();
				putCursor();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {}
		});

		Button btnGoTo = new Button(navButtonsComposite, SWT.NONE);
		btnGoTo.setImage(getImage("jump-segment-24.png"));
		btnGoTo.setToolTipText("Go To Segment");
		btnGoTo.getAccessible().addAccessibleListener(new AccessibleListener(){

			@Override
			public void getName(AccessibleEvent e) {
				e.result = "Go To Segment";
			}

			@Override
			public void getHelp(AccessibleEvent e) {}

			@Override
			public void getKeyboardShortcut(AccessibleEvent e) {}

			@Override
			public void getDescription(AccessibleEvent e) {}

		});
		btnGoTo.addSelectionListener(new SelectionListener(){

			@Override
			public void widgetSelected(SelectionEvent e) {
				//TODO
				System.out.println("Go To Segment");
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {}
		});

		Button btnDown = new Button(navButtonsComposite, SWT.NONE);
		btnDown.setImage(getImage("jump-segment-down-24.png"));
		btnDown.setToolTipText("Scroll Down One Segment");
		btnDown.getAccessible().addAccessibleListener(new AccessibleListener(){

			@Override
			public void getName(AccessibleEvent e) {
				e.result = "Scroll Down One Segment";
			}

			@Override
			public void getHelp(AccessibleEvent e) {}

			@Override
			public void getKeyboardShortcut(AccessibleEvent e) {}

			@Override
			public void getDescription(AccessibleEvent e) {}

		});
		btnDown.addSelectionListener(new SelectionListener(){

			@Override
			public void widgetSelected(SelectionEvent e) {
				doScrollSegmentDown();
				putCursor();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {}
		});

		Button btnPageDown = new Button(navButtonsComposite, SWT.NONE);
		btnPageDown.setImage(getImage("jump-page-down-24.png"));
		btnPageDown.setToolTipText("Scroll Down One Page");
		btnPageDown.getAccessible().addAccessibleListener(new AccessibleListener(){

			@Override
			public void getName(AccessibleEvent e) {
				e.result = "Scroll Down One Page";
			}

			@Override
			public void getHelp(AccessibleEvent e) {}

			@Override
			public void getKeyboardShortcut(AccessibleEvent e) {}

			@Override
			public void getDescription(AccessibleEvent e) {}

		});
		btnPageDown.addSelectionListener(new SelectionListener(){

			@Override
			public void widgetSelected(SelectionEvent e) {
				doScrollPageDown();
				putCursor();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {}
		});

		Button btnBottom = new Button(navButtonsComposite, SWT.NONE);
		btnBottom.setImage(getImage("jump-bottom-24.png"));
		btnBottom.setToolTipText("Go To End");
		btnBottom.getAccessible().addAccessibleListener(new AccessibleListener(){

			@Override
			public void getName(AccessibleEvent e) {
				e.result = "Go To End";
			}

			@Override
			public void getHelp(AccessibleEvent e) {}

			@Override
			public void getKeyboardShortcut(AccessibleEvent e) {}

			@Override
			public void getDescription(AccessibleEvent e) {}

		});
		btnBottom.addSelectionListener(new SelectionListener(){

			@Override
			public void widgetSelected(SelectionEvent e) {
				doScrollBottom();
				putCursor();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {}
		});
	}
	
	public Composite getComposite() {
		return this.charContainer;
	}
	
	private int calculateNewLoadBufferSize(boolean isCalculationForBottomBuffer){	
		if (isCalculationForBottomBuffer)			
			return Math.max(getFullyVisibleItemCount(tableViewer.getTable()), 2);  // There is a bug on a mainframe. Requesting last single segment abends. Using 2 intead is approach we have been recommended by Guy.
				
		return Math.max(getVisibleItemCount(tableViewer.getTable()), 1);
	}
	
	public void updateDisplay(GUIResponseType response, boolean doRemoveAll){
		//Check error messages and display
		Common.displayMessageforEditorView(response, editorView.getViewSite());
		if(response!=null&&response.getReturnCode()!=0){	
			editorView.closeView();
			return;
		}
		
		if(response != null){
			inputData = processInput(response.getEditResponse().getSegmentList().getSegment(),
					response.getEditResponse().getSegmentList().getDisplayMode());	
		}
		
		Table table = tableViewer.getTable();
		
		int visibleItemCount = getVisibleItemCount(table);
		if(visibleItemCount > inputData.size()){
			visibleItemCount = inputData.size();
			doRemoveAll = true;
		}
		
		int pixelSizeOfCharacter = getPixelSizeOfCharacter();
		
		int indentedSegmentNameWidth = 0;
		for(int i = 0; i < visibleItemCount; i++){
			if(inputData.get(i).getSegLevel() + inputData.get(i).getSegName().length() > indentedSegmentNameWidth){
				indentedSegmentNameWidth = inputData.get(i).getSegLevel() + inputData.get(i).getSegName().length();
			}
		}
		
		if((indentedSegmentNameWidth + 2) * pixelSizeOfCharacter > (7 * pixelSizeOfCharacter) + 16){
			table.getColumn(1).setWidth((indentedSegmentNameWidth + 2) * pixelSizeOfCharacter);	
		} else {
			table.getColumn(1).setWidth((7 * pixelSizeOfCharacter) + 16); //min width for column label
		}
		
		Rectangle rect = table.getClientArea();
		int newDataColumnWidth = rect.width	- table.getColumn(0).getWidth() - table.getColumn(1).getWidth();
		
		table.getColumn(2).setWidth(newDataColumnWidth);
		
		int thumbSize = (newDataColumnWidth / pixelSizeOfCharacter) - 1;
		slider.setThumb(thumbSize);
		slider.setPageIncrement(thumbSize);
								
		// galpe02: related to the "processing" message in status bar - message was not displayed - it should be fixed or this block removed
		/*
		((StatusLineContributionItem) ((IViewSite) editorView.getViewSite()).getActionBars()
				.getStatusLineManager().find("processingmessage")).setText(processingMessageString);
		*/		
				
		int columnStart = slider.getSelection();
        // TODO: carel06 should we just call getSubStringEndIndex method here.
		//@parra12: subtracting 1 to match the number of characters displayed on the page. Defect 3108.
		int columnEnd = ((table.getColumn(2).getWidth() / pixelSizeOfCharacter) + columnStart)-1;
		columnRangeString = "Columns " + (columnStart + 1) + " - " + columnEnd;
		
		if(table.getColumn(2).getWidth() < pixelSizeOfCharacter){
			columnEnd = columnStart;
			columnRangeString = "";
		}
		((StatusLineContributionItem) ((IViewSite) editorView.getViewSite()).getActionBars()
				.getStatusLineManager().find("columnrange")).setText(columnRangeString);

		if(doRemoveAll){
			table.removeAll();			
		}
		
		int start, end;
		String charData;
		String hexData1;
		TableItem item;
		int sliderPosition = -1;
		
		for(int i = 0; i < visibleItemCount; i++){
			if(doRemoveAll){
				item = new TableItem (table, SWT.NONE);
			} else {
				item = table.getItems()[i];	
			}
			
			start = columnStart;
			end = columnEnd;
			
			charData = inputData.get(i).segmentType.getSegmentFields().getSegmentField().get(0).getCharData();
			hexData1 = inputData.get(i).segmentType.getSegmentFields().getSegmentField().get(0).getHexData1();
			if(start > charData.length()){
				start = 0;
				end = 0;
			} else if(end > charData.length()){
				end = charData.length();
			}
			//navri01- added method for hexData. it will used for display hexstore, work in progress.
			if(hexData1!=null){
				displayHexData(inputData, item, charData, start, end,i);
			}
			else{
			item.setText(0, String.valueOf(inputData.get(i).getSegLevel()));
			item.setText(1, inputData.get(i).getSegName());
			item.setText(2, charData.substring(start, end));
			item.setData(inputData.get(i));
			}
			
			//Set first position of the cursor - fist segment
			/*if (i == 0){
				CursorType fmiCursor = editorView.getCursor();
				fmiCursor.setCursorPosition(0);
				fmiCursor.setSegid(inputData.get(i).segmentType.getSegid());
				editorView.setCursor(fmiCursor);
			}*/
			
			if(response != null){
				if (response.getEditResponse().getSegmentList().getFindCount() != null){
					editSelection = false;
				}
			}
			
			//Set cursor for Find
			if (inputData.get(i).segmentType.getSegmentFields().getSegmentField().get(0).getCursor() != null) {
				CursorType fmiCursor = editorView.getCursor();			
				fmiCursor.setCursorPosition(inputData.get(i).segmentType.getSegmentFields().getSegmentField().get(0).getCursor()-1);
				fmiCursor.setSegid(inputData.get(i).segmentType.getSegid());
				fmiCursor.setFieldId(0);
				editorView.setCursor(fmiCursor);	
				int cursorOffset = inputData.get(i).segmentType.getSegmentFields().getSegmentField().get(0).getCursor();
				if (cursorOffset + editorView.wizard.page.getfindValueLength() > columnEnd) {
					sliderPosition = inputData.get(i).segmentType.getSegmentFields().getSegmentField().get(0).getCursor()-1;
				}
				
				if (cursorOffset < columnStart + 1) {
					sliderPosition = inputData.get(i).segmentType.getSegmentFields().getSegmentField().get(0).getCursor()-1;
				}
			}
		}
		
		// if cursor is out of current display, set slider
		if ((sliderPosition > -1)  & editorView.getfindSliderActive()){
			setSilderOffset(sliderPosition);	
			editorView.wizard.page.getShell().setActive();
		}
		
		if(editSelection
				&& selectionIndex > -1
				&& selectionIndex < tableViewer.getTable().getItemCount() - 1){
			table.setFocus();
			table.setSelection(selectionIndex);

			Event e = new Event();
			e.item = tableViewer.getTable().getItem(selectionIndex);
			tableViewer.getTable().notifyListeners(SWT.Selection, e);

			tableViewer.editElement(table.getItem(selectionIndex).getData(), 2);
		}
	}
	
	public void displayHexData(List<IMSSegment> inputData2,TableItem item,String charData, int start, int end,int i){
		String CharHexData1 = "";
		String CharHexData2 = "";

		if (inputData2.get(i).segmentType.getSegmentFields().getSegmentField().get(0).getHexData1()!= null) {
			CharHexData1 = inputData2.get(i).segmentType.getSegmentFields().getSegmentField().get(0).getHexData1();
			CharHexData2 = inputData2.get(i).segmentType.getSegmentFields().getSegmentField().get(0).getHexData2();
			item.setText(0, String.valueOf(inputData2.get(i).getSegLevel()));
			item.setText(1, inputData2.get(i).getSegName());
			item.setText(2, charData.substring(start, end)
					+ Constants.LINE_SEPARATOR +  CharHexData1.substring(start, end)
					+ Constants.LINE_SEPARATOR +  CharHexData2.substring(start, end));
			item.setData(inputData2.get(i));
		} 
	}

	public void doScrollTop(){
		selectionIndex = -1;
		editSelection = false;
		requestAndDisplaySegments("TOP", 0, EditGetDirectionType.UP);
	}
	
	public void doScrollPageUp(){
		selectionIndex = -1;
		editSelection = false;
		doScrollPageUp(inputData.get(0).segmentType.getSegid());
	}
	
	public void doScrollPageUp(String reference){
		selectionIndex = -1;
		editSelection = false;
		requestAndDisplaySegments(reference, getFullyVisibleItemCount(tableViewer.getTable()), EditGetDirectionType.UP);
	}
	
	public void doScrollSegmentUp(){
		selectionIndex = -1;
		editSelection = false;
		doScrollSegmentUp(inputData.get(0).segmentType.getSegid());
	}
	
	public void doScrollSegmentUp(String reference){
		selectionIndex = -1;
		editSelection = false;
		requestAndDisplaySegments(reference, 1, EditGetDirectionType.UP);
	}	
		
	public void doScrollSegmentDown(){
		selectionIndex = -1;
		editSelection = false;
		doScrollSegmentDown(inputData.get(0).segmentType.getSegid());		
	}

	public void doScrollSegmentDown(String reference){
		selectionIndex = -1;
		editSelection = false;
		requestAndDisplaySegments(reference, 1, EditGetDirectionType.DOWN);		
	}	
				
	public void doScrollPageDown(){
		selectionIndex = -1;
		editSelection = false;
		doScrollPageDown(inputData.get(0).segmentType.getSegid());
	}
	
	public void doScrollPageDown(String reference){
		selectionIndex = -1;
		editSelection = false;
		requestAndDisplaySegments(reference, getFullyVisibleItemCount(tableViewer.getTable()), EditGetDirectionType.DOWN);
	}	
	
	public void doScrollBottom(){
		selectionIndex = -1;
		editSelection = false;
		requestAndDisplaySegments("BOT", 0, EditGetDirectionType.DOWN);						
	}
	
	@Override
	public void loadCurrentSegmentsWithCKEYInfo (DisplayModeType ckeyDisplay, YorNType ckeyHex){
	    selectionIndex = tableViewer.getTable().getSelectionIndex();
	    
		if (inputData.size()>0){
			requestAndDisplaySegments(inputData.get(0).segmentType.getSegid(), 0, EditGetDirectionType.UP, ckeyDisplay, ckeyHex);
		}

		IViewPart cKeyView = editorView.getSite().getWorkbenchWindow().getActivePage().findView("com.ca.fmp.ims.view.ckey");
		if (cKeyView != null && editorView.currentSegment.segmentType != null){
			
			if( ! editorView.currentSegment.segmentType.getSegid().equals(((ConcatenatedKeyView)cKeyView).getSegid())){
				((StatusLineContributionItem) ((IViewSite) editorView.getViewSite()).getActionBars()
						.getStatusLineManager().find("messages")).setText("Note: Concatenated key change");
			} else {
				((StatusLineContributionItem) ((IViewSite) editorView.getViewSite()).getActionBars()
						.getStatusLineManager().find("messages")).setText(" ");
			}
			
			((ConcatenatedKeyView)cKeyView).updateCKey(editorView.currentSegment.segmentType.getCKey().getCKeyEntry());
			((ConcatenatedKeyView)cKeyView).setSegid(editorView.currentSegment.segmentType.getSegid());
		}
		
		editSelection = true;
	}
	
	public void requestAndDisplaySegments(String reference, int scrollCount, EditGetDirectionType direction){
		IViewPart cKeyView = editorView.getSite().getWorkbenchWindow().getActivePage().findView("com.ca.fmp.ims.view.ckey");
		ckeyInfo = CKeyInfoType.Y;
     	if(cKeyView == null){
     		ckeyInfo = CKeyInfoType.N;
     	}		
		YorNType hexMode =editorView.isHexToggled;
	    loadBufferSize = calculateNewLoadBufferSize(reference=="BOT" ? true:false);  							    																																														
	    XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument(new GetSegmentsRequest(editorView.server,((IViewSite) editorView.getSite()).getSecondaryId(), loadBufferSize, reference, 
					scrollCount, direction, ckeyInfo, ckeyDisplay,hexMode, ckeyHex, editorView.getDisplayMode()).createXml());	
		} catch (TTException e1) {
			e1.printStackTrace();
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req = new SendRequestToMainframe(editorView.server, map, "opendb", true, xmlDocument);
		do{				
		}while(req.getResult() != Status.OK_STATUS && req.getResult()!= Status.CANCEL_STATUS);	
		if(req.getResult() == Status.CANCEL_STATUS){
			editorView.closeView();
			return;
		}
		
		GUIResponseType response = req.getGuiResponseType();					
		updateDisplay(response, true);
		setCurrentSegment();
		
		if(cKeyView != null
				&& ((ConcatenatedKeyView)cKeyView).isEmpty()
				&& editorView.currentSegment != null
				&& editorView.currentSegment.segmentType!=null
				&& editorView.currentSegment.segmentType.getCKey()!=null){
			((ConcatenatedKeyView)cKeyView).updateCKey(editorView.currentSegment.segmentType.getCKey().getCKeyEntry());
			if(((ConcatenatedKeyView)cKeyView).getSegid() == null){
				((ConcatenatedKeyView)cKeyView).setSegid(editorView.currentSegment.segmentType.getSegid());
			}
		}
	}
	
	public void requestAndDisplaySegments(String reference, int scrollCount, EditGetDirectionType direction, DisplayModeType ckeyDisplay, YorNType ckeyHex){
		this.ckeyDisplay = ckeyDisplay;
		this.ckeyHex = ckeyHex;
		
		requestAndDisplaySegments(reference, scrollCount, direction);
	}
	

	
	/**
	 * Return the index value for the last character in the segment.
	 * Note that this is index based 0.
	 * 
	 * @return last possible index value in the viewable segment.
	 */
//	@polra04 going back to original for now
//	public int getSubstringEndIndex() {
//		int dataColumnWidth = tableViewer.getTable().getColumn(2).getWidth();
//		int pixelSizeOfCharacter = getPixelSizeOfCharacter();
//		//@parra12: subtracting 1 to match the number of characters displayed on the page. Defect 3108.
//		int numberOfCharactersThatCanBeDisplayed = (dataColumnWidth / pixelSizeOfCharacter) + getSubstringBeginIndex() - 1;
//        int subStringEndIndex = numberOfCharactersThatCanBeDisplayed - 1; // returning index based 0, so we need to subtract 1.
//        return subStringEndIndex;
//	}
	//@parra12: getter for segment id.
	protected String getSegmentIDforReference(){
		return inputData.get(0).segmentType.getSegid();
	}
	
	//@parra12: need to dispose the two composites when toggling hex mode off. 
	protected void disposeContainer(){
		editorComposite.dispose();
		navButtonsComposite.dispose();
	}

	public void setCurrentSegment() {
		TableItem[] selectedItems = tableViewer.getTable().getSelection();

		if (selectedItems.length > 0) {
			Object data = selectedItems[0].getData();
			if (data instanceof IMSSegment) {
				editorView.currentSegment = (IMSSegment)selectedItems[0].getData();                  
			}
		} else {
			if (inputData.size() !=0)
				editorView.currentSegment = inputData.get(0);
		}						
	}
	
	public void setEditingSupportFileMasterIMS(EditingSupportFileMasterIMS editingSupportFileMasterIMS){
		this.editingSupportFileMasterIMS = editingSupportFileMasterIMS;
	}
	
	public EditingSupportFileMasterIMS getEditingSupportFileMasterIMS(){
		return editingSupportFileMasterIMS;
	}
	
	public void setSilderOffset(int offset) {
		slider.setSelection(offset);
		slider.notifyListeners(SWT.Selection, new Event());
	}
	
	public void putCursor(){
		final Table table = tableViewer.getTable();		
		
		if (!table.isDisposed()) {			
			Event e = new Event();			
			CursorType fmiCursor = editorView.getCursor();		
			boolean currentCursorVisible = false;
			
			for(int i = 0; i < inputData.size(); i++){
				if (inputData.get(i).segmentType.getSegid().equals(fmiCursor.getSegid())) {
					setCusrsorFlag = false;
					table.setFocus();
					table.setSelection(i);
					if (table.getSelectionIndex() < 0 | i >= getVisibleItemCount(table)-1){
						break;
					}
					e.item = tableViewer.getTable().getItem(i);
					table.notifyListeners(SWT.Selection, e);
					currentCursorVisible = true;
					setCusrsorFlag = true;
				}
				e.doit = false;
			}				
			
			if (!currentCursorVisible) {
				int i = 0;	
				fmiCursor.setCursorPosition(0);
				fmiCursor.setSegid(inputData.get(i).segmentType.getSegid());
				editorView.setCursor(fmiCursor);
				table.setFocus();
				table.setSelection(i);
				e.item = tableViewer.getTable().getItem(i);
				table.notifyListeners(SWT.Selection, e);
				currentCursorVisible = true;
			}
		}
	}
}
