/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.common.FMHistory;
import com.ca.fmp.ims.common.validator.Validator;
import com.ca.fmp.ims.model.FindRequest;
import com.ca.fmp.ims.model.generated.CursorType;
import com.ca.fmp.ims.model.generated.DisplayModeType;
import com.ca.fmp.ims.model.generated.FindParametersType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.LocationType;
import com.ca.fmp.ims.model.generated.OccurrenceType;
import com.ca.fmp.ims.model.generated.RangeType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.editor.EditorView;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.ui.verifyDigit;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class FindCommandWizardPage extends WizardPage {

	private static final int FIND_LENGTH_MAX = 16;

	private static final String TITLE = "Find";
	private static final String COMMAND_TYPE_FIND = "Find";
	private static String CONTEXT_HELP_ID = "com.ca.fmp.ims.help.Find";

	private static final String ERROR_START_COLUMN_GREATER_THEN_END_COLUMN = "End column range should be greater than start column range.";
	private static final String ERROR_FIND_STRING_LONGER_THEN_MAX = "The FIND string length exceeds the maximum length of nn characters.";
	private static final String ERROR_COLUMN_NUMBER_HIGHER_THEN_MAX_LENGTH = "Colum numbers must not be higher than the maximum segment length.";
	private static final String ERROR_SMALL_COLUMN_RANGE = "The string will not fit between the specified columns.";
	private static final String ERROR_MISSING_START_COLUMN_VALUE = "Missing start column value";
	private static final String FIND_TYPE[] = new String[] { "Character",
			"Case-sensitive", "Hexadecimal", "Packed decimal" };

	private Composite container;
	private Composite parentComposite;

	private Label startCol;
	private Label endCol;
	private Label totalMatch;

	private Combo txtFindString;
	private Spinner txtFindLim;
	private Combo txtstartCol;
	private Combo txtendCol;

	private Button nextBtn;
	private Button prevBtn;
	private Button firstBtn;
	private Button lastBtn;

	private Button charBtn;
	private Button wordBtn;
	private Button prefixBtn;
	private Button suffixBtn;

	private ModifyListener mLTxtFind = null;
	private ModifyListener modLisTxtstartCol = null;
	private ModifyListener modLisTxtendCol = null;

	private Composite btnComposite;
	private Button findBtn;
	private Button findAllBtn;
	private Combo cmbFindType;
	private Text txtFindLength;

	private Logger log = Logger
			.getLogger(FindCommandWizardPage.class.getName());
	// private EditorView editorView = getEditorView();

	private String typeofCommand;
	private String findValue = "";
	private int findValueLength = 0;
	private String previousFindValue = "";
	private String findType = FIND_TYPE[0];
	private int findLength = 0;
	private String columnRangeStart = "";
	private String columnRangeEnd = "";

	// tracking Find by Find button or Find By change
	private String previousCommandType = "";

	// the default value for occurrence is NEXT
	private OccurrenceType occurrence = OccurrenceType.NEXT; // next,previous,first,last
	// what is the current selection
	// i have to add this variable since when we do a find_all/change_all, i
	// change the occurrence
	// value to OCCURRENCE_ALL. But if we go from find_all to find, we need to
	// know the current selection
	private OccurrenceType occurrence_current = OccurrenceType.NEXT;

	// the default value for location is character
	// character,word,prefix,suffix,field
	private LocationType location = LocationType.CHAR;

	// the default value is to search all lines
	private int findLimit = 5000;

	private boolean isFindCmdChanges;
	private int loadBufferSize;
	
	private EditorView editorView;

	public FindCommandWizardPage() {
		super(TITLE);
		setTitle(TITLE);
	}

	@Override
	public void createControl(Composite parent) {
		container = new Composite(parent, SWT.NULL);
		container.setLayout(new GridLayout(1, false));
		PlatformUI.getWorkbench().getHelpSystem()
				.setHelp(parent, CONTEXT_HELP_ID);

		parentComposite = new Composite(container, SWT.NONE);
		GridLayout gl_parentComposite = new GridLayout(1, false);
		gl_parentComposite.marginWidth = 0;
		gl_parentComposite.marginWidth = 0;
		parentComposite.setLayout(gl_parentComposite);
		parentComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true,
				false, 1, 1));

		isFindCmdChanges = true;
		
		editorView = getEditorView();
		
		createControlFindGroup();
		createControlColumnRangeGroup();
		createControlOccurenceGroup();
		createControlLocationGroup();
		createControlSearchGroup();
		createControlSubmissionButtons();
		
		totalMatch = new Label(btnComposite, SWT.WRAP);
		totalMatch.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true,
				false, 4, 1));
		totalMatch.setText("  ");
		
		Point size1 = getShell().computeSize(SWT.DEFAULT, SWT.DEFAULT);
		getShell().setSize(size1);
		setControl(btnComposite);
			
		Point size = getShell().computeSize(SWT.DEFAULT, SWT.DEFAULT);
		getShell().setSize(size);
		setControl(container);

		
		((TestingToolsWizardDialog) getWizard().getContainer()).getButton(
				IDialogConstants.FINISH_ID).setEnabled(false);
		((TestingToolsWizardDialog) getWizard().getContainer()).getButton(
				IDialogConstants.FINISH_ID).setVisible(false);
		((TestingToolsWizardDialog) getWizard().getContainer()).getButton(
				IDialogConstants.CANCEL_ID).setText("Close");

		FMHistory.intializeComboBoxes(txtFindString, "excludeExcString");
		FMHistory.intializeComboBoxes(txtstartCol, "excludestartCol");
		FMHistory.intializeComboBoxes(txtendCol, "excludeendCol");

	}

	private void createControlFindGroup() {
		Composite composite1 = new Composite(parentComposite, SWT.NONE);
		GridLayout gl_comp = new GridLayout(3, false);
		gl_comp.marginHeight = 0;
		gl_comp.marginWidth = 0;
		composite1.setLayout(gl_comp);
		composite1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false,
				1, 1));

		// /////First Column: Find
		Composite firstColumnFind = new Composite(composite1, SWT.NONE);
		GridLayout gl_firstColumnFind = new GridLayout(1, false);
		gl_firstColumnFind.marginHeight = 0;
		gl_firstColumnFind.marginWidth = 0;
		firstColumnFind.setLayout(gl_firstColumnFind);
		firstColumnFind.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true,
				false, 1, 1));

		Label lblFind = new Label(firstColumnFind, SWT.NONE);
		lblFind.setText("F&ind:");

		txtFindString = new Combo(firstColumnFind, SWT.BORDER);
		txtFindString.setFocus();
		txtFindString.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true,
				false, 1, 1));

		mLTxtFind = new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent arg0) {
				log.log(Level.INFO, "txtFindString modifyText");
				findValue = txtFindString.getText();
				setfindValueLength(findValue.length());
				controlModifiedAny();
			}
		};
		txtFindString.addModifyListener(mLTxtFind);

		// ////////Second Column: Find
		Composite SecondColumnFind = new Composite(composite1, SWT.NULL);
		GridLayout gl_SecondColumnFind = new GridLayout(1, false);
		gl_SecondColumnFind.marginHeight = 0;
		gl_SecondColumnFind.marginWidth = 0;
		SecondColumnFind.setLayout(gl_SecondColumnFind);
		SecondColumnFind.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false,
				false, 1, 1));

		Label lblFindType = new Label(SecondColumnFind, SWT.NONE);
		lblFindType.setText("T&ype:");

		cmbFindType = new Combo(SecondColumnFind, SWT.NONE | SWT.READ_ONLY);
		cmbFindType.setItems(FIND_TYPE);
		cmbFindType.setText(FIND_TYPE[0]);
		cmbFindType.addSelectionListener(new SelectionListener() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				log.log(Level.INFO, "cmbFindType widgetSelected");
				if (cmbFindType.getSelectionIndex() == 3) {
					txtFindLength.setEnabled(true);
				} else {
					txtFindLength.setEnabled(false);
				}
				findType = cmbFindType.getText();
				setfindValueLength(findValue.length());
				controlModifiedAny();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				widgetSelected(e);
			}
		});
		cmbFindType.addKeyListener(new KeyListener() {
			@Override
			public void keyReleased(KeyEvent arg0) {
				log.log(Level.INFO, "cmbFindType keyReleased");
				if (cmbFindType.getSelectionIndex() == 3) {
					txtFindLength.setEnabled(true);
				} else {
					txtFindLength.setEnabled(false);
				}
				findType = cmbFindType.getText();
				setfindValueLength(findValue.length());
				controlModifiedAny();
			}

			@Override
			public void keyPressed(KeyEvent arg0) {
				// do nothing
			}
		});

		// ////////////Third Column: Find
		Composite ThirdColumnFind = new Composite(composite1, SWT.NULL);
		GridLayout gl_ThirdColumnFind = new GridLayout(1, true);
		gl_ThirdColumnFind.marginHeight = 0;
		gl_ThirdColumnFind.marginWidth = 0;
		ThirdColumnFind.setLayout(gl_ThirdColumnFind);

		Label lblLength = new Label(ThirdColumnFind, SWT.NONE);
		lblLength.setText("Len&gth:");

		txtFindLength = new Text(ThirdColumnFind, SWT.BORDER);
		txtFindLength.setEnabled(false);
		txtFindLength.addVerifyListener(new verifyDigit(true));
		txtFindLength.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent arg0) {
				log.log(Level.INFO, "txtFindLength modifyText");
				String txtFindLengthValue = txtFindLength.getText();
				if (txtFindLengthValue == null
						|| txtFindLengthValue.length() == 0) {
					txtFindLengthValue = "0";
				}
				findLength = Integer.parseInt(txtFindLengthValue);
				controlModifiedAny();
			}
		});

	}

	private void createControlColumnRangeGroup() {
		Composite composite = new Composite(container, SWT.NONE);
		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		composite.setLayout(gl_composite);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false,
				1, 1));

		Group colRange = new Group(composite, SWT.NONE);
		colRange.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false,
				1, 1));
		colRange.setLayout(new GridLayout(3, false));
		colRange.setText("Column range");

		startCol = new Label(colRange, SWT.NONE);
		startCol.setText("&Start:");

		txtstartCol = new Combo(colRange, SWT.BORDER);
		txtstartCol.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true,
				false, 2, 1));
		modLisTxtstartCol = new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent arg0) {
				log.log(Level.INFO, "txtstartCol modifyText");
				columnRangeStart = txtstartCol.getText();
				controlModifiedAny();
			}
		};
		txtstartCol.addModifyListener(modLisTxtstartCol);
		txtstartCol.addVerifyListener(new verifyDigit(true));

		endCol = new Label(colRange, SWT.NONE);
		endCol.setText("&End:");

		txtendCol = new Combo(colRange, SWT.BORDER);
		txtendCol.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false,
				2, 1));
		modLisTxtendCol = new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent arg0) {
				log.log(Level.INFO, "txtendCol modifyText");
				columnRangeEnd = txtendCol.getText();
				controlModifiedAny();
			}
		};
		txtendCol.addModifyListener(modLisTxtendCol);
		txtendCol.addVerifyListener(new verifyDigit(true));
	}

	private void createControlOccurenceGroup() {
		Group occurenceGrp = new Group(container, SWT.NONE);
		occurenceGrp.setLayout(new GridLayout(5, false));
		occurenceGrp
				.setSize(occurenceGrp.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		occurenceGrp.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1));
		occurenceGrp.setText("Occurrences");
		setControl(container);

		nextBtn = new Button(occurenceGrp, SWT.RADIO);
		nextBtn.setText("&Next");
		// the default value
		nextBtn.setSelection(true);
		nextBtn.addSelectionListener(new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent arg0) {
				log.log(Level.INFO, "nextBtn widget selected");
				occurrence = OccurrenceType.NEXT;
				occurrence_current = OccurrenceType.NEXT;
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent arg0) {
				widgetSelected(arg0);
			}
		});

		prevBtn = new Button(occurenceGrp, SWT.RADIO);
		prevBtn.setText("Pre&vious");
		prevBtn.addSelectionListener(new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent arg0) {
				log.log(Level.INFO, "prevBtn widget selected");
				occurrence = OccurrenceType.PREV;
				occurrence_current = OccurrenceType.PREV;
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent arg0) {
				widgetSelected(arg0);
			}
		});

		firstBtn = new Button(occurenceGrp, SWT.RADIO);
		firstBtn.setText("Firs&t");
		firstBtn.addSelectionListener(new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent arg0) {
				log.log(Level.INFO, "firstBtn widget selected");
				occurrence = OccurrenceType.FIRST;
				occurrence_current = OccurrenceType.FIRST;
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent arg0) {
				widgetSelected(arg0);
			}
		});

		lastBtn = new Button(occurenceGrp, SWT.RADIO);
		lastBtn.setText("&Last");
		lastBtn.addSelectionListener(new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent arg0) {
				log.log(Level.INFO, "lastBtn widget selected");
				occurrence = OccurrenceType.LAST;
				occurrence_current = OccurrenceType.LAST;
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent arg0) {
				widgetSelected(arg0);
			}
		});
	}

	private void createControlLocationGroup() {
		Group locatnGrp = new Group(container, SWT.NONE);
		locatnGrp.setLayout(new GridLayout(5, false));
		locatnGrp.setSize(locatnGrp.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		locatnGrp.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1));
		locatnGrp.setText("Location");

		charBtn = new Button(locatnGrp, SWT.RADIO);
		charBtn.setText("Characte&r");
		// the default value for location is char
		charBtn.setSelection(true);
		charBtn.addSelectionListener(new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent arg0) {
				log.log(Level.INFO, "charBtn widget selected");
				location = LocationType.CHAR;
				controlModifiedAny();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent arg0) {
				widgetSelected(arg0);
			}
		});

		wordBtn = new Button(locatnGrp, SWT.RADIO);
		wordBtn.setText("&Word");
		wordBtn.addSelectionListener(new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent arg0) {
				log.log(Level.INFO, "wordBtn widget selected");
				location = LocationType.WORD;
				controlModifiedAny();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent arg0) {
				widgetSelected(arg0);
			}
		});

		prefixBtn = new Button(locatnGrp, SWT.RADIO);
		prefixBtn.setText("Prefi&x");
		prefixBtn.addSelectionListener(new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent arg0) {
				log.log(Level.INFO, "prefixBtn widget selected");
				location = LocationType.PREFIX;
				controlModifiedAny();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent arg0) {
				widgetSelected(arg0);
			}
		});

		suffixBtn = new Button(locatnGrp, SWT.RADIO);
		suffixBtn.setText("S&uffix");
		suffixBtn.addSelectionListener(new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent arg0) {
				log.log(Level.INFO, "suffixBtn widget selected");
				location = LocationType.SUFFIX;
				controlModifiedAny();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent arg0) {
				widgetSelected(arg0);
			}
		});

	}

	private void createControlSearchGroup() {
		Composite composite1 = new Composite(container, SWT.NONE);
		composite1.setLayout(new GridLayout(2, false));

		Label findLim = new Label(composite1, SWT.NONE);

		findLim.setText("Find li&mit:");
		txtFindLim = new Spinner(composite1, SWT.BORDER);
		txtFindLim.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false,
				false, 1, 1));

		// get the findLimit value from the FMEditorProfile value
		findLimit = (int) editorView.getFindLimit();
		txtFindLim.setValues(findLimit, 0, 99999999, 0, 1, 1);
		txtFindLim.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent arg0) {
				log.log(Level.INFO, "txtFindLimit modified");
				findLimit = txtFindLim.getSelection();
			}
		});
		txtFindLim.addKeyListener(new KeyListener() {
			@Override
			public void keyReleased(KeyEvent arg0) {
				log.log(Level.INFO, "txtFindLimit keyReleased");
				findLimit = txtFindLim.getSelection();
			}

			@Override
			public void keyPressed(KeyEvent arg0) {
				// do nothing
			}
		});
	}

	/*
	 * I naming the "Find", "Find All", "Change", and "Change All" buttons as
	 * the "Submission" buttons. When you click any of these buttons. You are
	 * submitting a request to the mainframe.. That's what I mean by
	 * "submitting".
	 */ 
	
	private void createControlSubmissionButtons() {
		btnComposite = new Composite(container, SWT.NONE);
		GridLayout gl_btnComposite = new GridLayout(2, true);
		gl_btnComposite.marginWidth = 0;
		btnComposite.setLayout(gl_btnComposite);
		btnComposite.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, true, true,
				1, 1));
		initializeDialogUnits(container);

		findBtn = new Button(btnComposite, SWT.NONE);
		findBtn.addSelectionListener(new SelectionListener() {
			@Override
			public void widgetSelected(SelectionEvent arg0) {
				// we need to set the occurrence to occurrence_current
				// b/c if we came from FIND_ALL, the occurrence was set to all.
				// we need to find the original value.
				occurrence = occurrence_current;
				typeofCommand = COMMAND_TYPE_FIND;
				if (!previousCommandType.equalsIgnoreCase(typeofCommand)) {
					previousCommandType = typeofCommand;
				}
				if (!previousFindValue.equalsIgnoreCase(findValue)) {
					previousFindValue = findValue;
				}
				actionsWhenClickingOnAnyOfTheSubmissionButtons();
				sendRequestToMainframeAndUpdateEditorViewIfNeeded();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent arg0) {
				// do nothing
				widgetSelected(arg0);
			}
		});
		findBtn.setText("&Find");
		setButtonLayoutData(findBtn);

		findAllBtn = new Button(btnComposite, SWT.NONE);
		findAllBtn.addSelectionListener(new SelectionListener() {
			@Override
			public void widgetSelected(SelectionEvent arg0) {
				occurrence = OccurrenceType.ALL;
				typeofCommand = COMMAND_TYPE_FIND;

				// #2670 find all + find next
				previousFindValue = findValue;
				previousCommandType = typeofCommand;
				isFindCmdChanges = true;
				actionsWhenClickingOnAnyOfTheSubmissionButtons();
				sendRequestToMainframeAndUpdateEditorViewIfNeeded();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent arg0) {
				widgetSelected(arg0);
			}
		});
		findAllBtn.setText("Find &All");
		setButtonLayoutData(findAllBtn);
	}

	private void controlModifiedAny() {
		// isFindLIMExceedLimitation=false; // Mahma04# 2998 :send find instead
		// of RFind

		determineIfFindButtonsShouldBeEnabledOrDisabled();
		determineIfThereAreErrorsWithTheQuery();
	}

	/**
	 * The ones still commented out are the ones I still haven't
	 * verified/translated. Need to continue doing that.
	 * 
	 */
	private void determineIfThereAreErrorsWithTheQuery() {
		// let's initialize this by setting the error message to null
		setErrorMessage(null);

		// these are the rules for packed decimal
		if (cmbFindType.getSelectionIndex() == 3) {
			// this is in bytes
			// The length of the from and to strings can go up to 31 positions
			// each.

			// Length value can only go up to 16 because this is a number of
			// bytes.
			if (findLength > FIND_LENGTH_MAX) {
				disableSubmissionButtonsBecauseOfErrorInQuery("Find Length cannot be more than "
						+ FIND_LENGTH_MAX);
				return;
			}

		}

		// when user choose packed decimal and Find value is empty user need to
		// specify find value or length value
		if (txtFindString.getText().isEmpty()
				&& (cmbFindType.getSelectionIndex() == 3)
				&& (txtFindLength.getText().trim().isEmpty())) {
			disableSubmissionButtonsBecauseOfErrorInQuery("Specify Find value or Length value in packed decimal type.");
			return;
		}

		if (!txtFindString.getText().isEmpty()) {
			String maxFindLength = "80";
			String adjustedFindString = adjustFindString();
			int findStringLength;

			if (findType.equals(FIND_TYPE[3])) {
				findStringLength = findValue.length();
			} else {
				findStringLength = adjustedFindString.length();
			}

			if (findType.equals(FIND_TYPE[3])) {
				if (txtFindString.getText().contains("+")
						|| txtFindString.getText().contains("-")) {
					maxFindLength = "32";
				} else {
					maxFindLength = "31";
				}
			} else {
				if (findType.equals(FIND_TYPE[2])) {
					maxFindLength = "76";
				} else {
				maxFindLength = "77";
				}			}
			if (findStringLength > Integer.parseInt(maxFindLength)) {
				disableSubmissionButtonsBecauseOfErrorInQuery(ERROR_FIND_STRING_LONGER_THEN_MAX
						.replace("nn", maxFindLength));
				return;
			}
		}

		if (!txtFindString.getText().isEmpty()) {
			if (cmbFindType.getSelectionIndex() == 2) {
				String errorMessage = Validator.errorMsg[Validator
						.HexadecimalLength(txtFindString.getText(), false)];
				if (errorMessage != null && errorMessage.length() > 0) {
					disableSubmissionButtonsBecauseOfErrorInQuery(errorMessage);
					return;
				}
			} else if (cmbFindType.getSelectionIndex() == 3) {
				// TODO try to figure out why this would be an error.
				String errorMessage = Validator.errorMsg[Validator
						.PackedDecimalLength(txtFindString.getText(), false)];
				if (errorMessage != null && errorMessage.length() > 0) {
					disableSubmissionButtonsBecauseOfErrorInQuery(errorMessage);
					return;
				}
			}
			if (txtFindLength.isEnabled() && !txtFindLength.getText().isEmpty()) {
				try {
					findLength = Integer.parseInt(txtFindLength.getText());
				} catch (NumberFormatException e) {
				}
			}
		}

		if (txtFindString.getText().isEmpty()
				&& !(txtFindLength.isEnabled()
						&& txtFindLength.getText().trim().length() > 0 && Validator
						.length(txtFindLength.getText(), false) == Validator.NO_ERROR)) {
			disableSubmissionButtonsBecauseOfErrorInQuery(null);
			return;
		}

		if (!columnRangeStart.isEmpty()) {
			try {
				int start = Integer.parseInt(columnRangeStart);
				if (start > editorView.getFormatMode()
						.getmaxSegmentLength()) {
					disableSubmissionButtonsBecauseOfErrorInQuery(ERROR_COLUMN_NUMBER_HIGHER_THEN_MAX_LENGTH);
					return;
				}
			} catch (NumberFormatException e) {
				disableSubmissionButtonsBecauseOfErrorInQuery(ERROR_COLUMN_NUMBER_HIGHER_THEN_MAX_LENGTH);
				return;
			}
		}

		if (!columnRangeEnd.isEmpty()) {
			try {
				int end = Integer.parseInt(columnRangeEnd);
				if (end > editorView.getFormatMode().getmaxSegmentLength()) {
					disableSubmissionButtonsBecauseOfErrorInQuery(ERROR_COLUMN_NUMBER_HIGHER_THEN_MAX_LENGTH);
					return;
				}
			} catch (NumberFormatException e) {
				disableSubmissionButtonsBecauseOfErrorInQuery(ERROR_COLUMN_NUMBER_HIGHER_THEN_MAX_LENGTH);
				return;
			}
		}

		if (!columnRangeStart.isEmpty() && !columnRangeEnd.isEmpty()) {
			int start = Integer.parseInt(columnRangeStart);
			int end = Integer.parseInt(columnRangeEnd);
			if (start > end) {
				disableSubmissionButtonsBecauseOfErrorInQuery(ERROR_START_COLUMN_GREATER_THEN_END_COLUMN);
				return;
			}
		}

		if (columnRangeStart.isEmpty() && !columnRangeEnd.isEmpty()) {
			disableSubmissionButtonsBecauseOfErrorInQuery(ERROR_MISSING_START_COLUMN_VALUE);
			return;
		}

		if (!txtFindString.getText().isEmpty() & !columnRangeStart.isEmpty()) {
			if (!columnRangeEnd.isEmpty()) {
				if (txtFindString.getText().length() > (Integer
						.parseInt(columnRangeEnd) - Integer
						.parseInt(columnRangeStart))) {
					disableSubmissionButtonsBecauseOfErrorInQuery(ERROR_SMALL_COLUMN_RANGE);
				}
			} else {
				if (txtFindString.getText().length() > (editorView
						.getFormatMode().getmaxSegmentLength() - Integer
						.parseInt(columnRangeStart))) {
					disableSubmissionButtonsBecauseOfErrorInQuery(ERROR_SMALL_COLUMN_RANGE);
				}

			}
		}

		if (txtFindLength.isEnabled() && !txtFindLength.getText().isEmpty()) {
			String errorMessage = Validator.errorMsg[Validator.length(
					txtFindLength.getText(), false)];
			if (errorMessage != null && errorMessage.length() > 0) {
				disableSubmissionButtonsBecauseOfErrorInQuery(errorMessage);
				return;
			}
		}
		// change made in Find request, need to send Find request (no rfind)
		isFindCmdChanges = true;
	}

	private void disableSubmissionButtonsBecauseOfErrorInQuery(
			String errorMessage) {
		if (errorMessage != null && errorMessage.length() > 0) {
			setErrorMessage(errorMessage);
			findBtn.setEnabled(false);
			findAllBtn.setEnabled(false);

		} else {
			setErrorMessage(null);
		}
	}

	public void determineIfFindButtonsShouldBeEnabledOrDisabled() {
		// what is the only condition that will make this false?
		if (findType.equals(FIND_TYPE[3])
				&& (findValue.isEmpty() || findValue == null)
				&& txtFindLength.getText().isEmpty()) {
			findBtn.setEnabled(false);
			findAllBtn.setEnabled(false);
			return;
		}

		if (findValue == null || findValue.length() == 0
				&& (!findType.equals(FIND_TYPE[3]))) {
			findBtn.setEnabled(false);
			findAllBtn.setEnabled(false);
			return;
		}

		findBtn.setEnabled(true);
		findAllBtn.setEnabled(true);
	}

	private void actionsWhenClickingOnAnyOfTheSubmissionButtons() {
		FMHistory.insertHistory(txtFindString, "excludeExcString");
		FMHistory.insertHistory(txtstartCol, "excludestartCol");
		FMHistory.insertHistory(txtendCol, "excludeendCol");

		txtFindString.removeModifyListener(mLTxtFind);
		String text = txtFindString.getText();
		FMHistory.intializeComboBoxes(txtFindString, "excludeExcString");
		txtFindString.setText(text);
		txtFindString.addModifyListener(mLTxtFind);

		txtstartCol.removeModifyListener(modLisTxtstartCol);
		text = txtstartCol.getText();
		FMHistory.intializeComboBoxes(txtstartCol, "excludestartCol");
		txtstartCol.setText(text);
		txtstartCol.addModifyListener(modLisTxtstartCol);

		txtendCol.removeModifyListener(modLisTxtendCol);
		text = txtendCol.getText();
		FMHistory.intializeComboBoxes(txtendCol, "excludeendCol");
		txtendCol.setText(text);
		txtendCol.addModifyListener(modLisTxtendCol);
	}

	private void sendRequestToMainframeAndUpdateEditorViewIfNeeded() {

		FindParametersType findParameters = new FindParametersType();
		RangeType colsRange = new RangeType();
		String adjustedFindString = null;
		// CursorType adjustedCursorPosition = new CursorType();

		// Set Find limit
		findParameters.setFindlim((long) findLimit);

		// Set Occurrence
		findParameters.setOccurrence(occurrence);

		// Adjust cursor
		if ((occurrence == OccurrenceType.NEXT)
				|| (occurrence == OccurrenceType.PREV)) {
			CursorType adjustedCursorPosition = adjustCursorPosition();
			if (adjustedCursorPosition.getSegid() != null) {
				findParameters.setCursor(adjustedCursorPosition);
			}
		}

		if (occurrence == OccurrenceType.LAST
				| occurrence == OccurrenceType.FIRST) {
			isFindCmdChanges = true;
		}
			
		if (isFindCmdChanges) {
			// Adjust Find String
			adjustedFindString = adjustFindString();
			// Set Columns range
			if (!columnRangeStart.isEmpty()) {
				colsRange.setStart(Long.parseLong(columnRangeStart));
			}
			if (!columnRangeEnd.isEmpty()) {
				colsRange.setEnd(Long.parseLong(columnRangeEnd));
			}
			if (!columnRangeStart.isEmpty() || !columnRangeEnd.isEmpty()) {
				findParameters.setColsRange(colsRange);
			}
			// Set Location
			findParameters.setLocation(location);
			// Set Find limit
			// !!! findParameters.setFindlim((long)findLimit);
		}

//		EditorView editorView = getEditorView();
		if (editorView == null) {
			return;
		}
		// calculate size of response
		if (editorView.getDisplayMode() == DisplayModeType.S){
			loadBufferSize = 1;
		} else {			
			loadBufferSize = calculateNewLoadBufferSize();
		}
		
		XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument(new FindRequest(
					editorView.getServer(),
					((IViewSite) editorView.getSite()).getSecondaryId(),
					adjustedFindString, findParameters, loadBufferSize).createXml());
		} catch (TTException e1) {
			e1.printStackTrace();
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req = new SendRequestToMainframe(
				editorView.getServer(), map, "opendb", true, xmlDocument);

		do {
		} while (req.getResult() != Status.OK_STATUS);

		GUIResponseType response = req.getGuiResponseType();

		boolean messageOccured = false;
		if (response.getFunctionRC() != 0) {
			for (int i = 0; i < response.getMessages().getMessage().size(); i++) {
				if (response.getMessages().getMessage().get(i).getMessageId()
						.contains("CAWK445I")) {
					totalMatch.setText("String not found");
					messageOccured = true;
				}
				if (response.getMessages().getMessage().get(i).getMessageId()
						.contains("CAWK441I")) {
					totalMatch.setText("String found");
					messageOccured = true;
				}
				if (response.getMessages().getMessage().get(i).getMessageId()
						.contains("CAWK442I")) {
					if (response.getEditResponse().getSegmentList()
							.getFindCount() != null) {
						totalMatch.setText("Found "
								+ response.getEditResponse().getSegmentList()
										.getFindCount().toString() + " times");
						messageOccured = true;
					}
				}
				if (response.getMessages().getMessage().get(i).getMessageId()
						.contains("CAWK446I")
						|| response.getMessages().getMessage().get(i)
								.getMessageId().contains("CAWK447I")) {
					totalMatch.setText("No more matches found");
					messageOccured = true;
				}

				if (response.getMessages().getMessage().get(i).getMessageId()
						.contains("CAWL005W")) {
					totalMatch.setText("Find limit exceeded");
					messageOccured = true;
				}
			}
			if (messageOccured) {
				response.setFunctionRC(0);
				messageOccured = false;
			}
		}
		isFindCmdChanges = false;
		editorView.updateTableBasedOnFindResult(response);
	}

	/**
	 * This can return null so need to catch for null.
	 * 
	 * @return
	 */
	private EditorView getEditorView() {
		IWorkbenchPart workbenchPart = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage().getActivePart();
		EditorView editorView;
		if (!(workbenchPart instanceof EditorView)) {
			/*
			 * log.log(Level.WARNING,
			 * "workbenchPart is not instance of EditorView");
			 */
			totalMatch
					.setText("Click on the editor to perform the Find action.");
			editorView = null;
		} else {
			editorView = (EditorView) workbenchPart;
		}

		return editorView;
	}

	private CursorType adjustCursorPosition() {
		CursorType originalCursorPosition;
		//EditorView editorView = getEditorView();
		if (editorView == null) {
			originalCursorPosition = new CursorType();
		} else {
			originalCursorPosition = editorView.getCursor();
		}

		CursorType adjustedCursorPosition = new CursorType();
		adjustedCursorPosition.setSegid(originalCursorPosition.getSegid());
		adjustedCursorPosition.setFieldId(originalCursorPosition.getFieldId());
		adjustedCursorPosition.setCursorPosition(originalCursorPosition.getCursorPosition() < 0 ? 0 : originalCursorPosition.getCursorPosition()+1);

		return adjustedCursorPosition;
	}

	/**
	 * 
	 * @return
	 */
	private String adjustFindString() {
		String adjustedFindString = findValue;

		if (findType.equals(FIND_TYPE[0])) {
			adjustedFindString = "T'" + findValue + "'";
		} else if (findType.equals(FIND_TYPE[1])) {
			adjustedFindString = "C'" + findValue + "'";
		} else if (findType.equals(FIND_TYPE[2])) {
			adjustedFindString = "X'" + findValue + "'";
		} else {
			if (findValue.isEmpty() && txtFindLength.getText().length() > 0) {
				adjustedFindString = "PL" + txtFindLength.getText();
			} else if (!findValue.isEmpty()
					&& txtFindLength.getText().length() > 0) {
				adjustedFindString = "PL" + txtFindLength.getText() + "'"
						+ findValue + "'";
			} else {
				adjustedFindString = "P'" + findValue + "'";
			}
		}
		return adjustedFindString;
	}

	public void setfindValueLength(int findValueLength) {
		if(cmbFindType.getSelectionIndex() == 2){
			this.findValueLength = findValueLength / 2;
		} else {
			this.findValueLength = findValueLength;
		}
	}

	public int getfindValueLength() {
		return findValueLength;

	}
	
	private int calculateNewLoadBufferSize(){			
		return Math.max(editorView.getFormatMode().getVisibleItemCount(editorView.getFormatMode().getTableViewer().getTable()), 1);
	}
}