/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.editor;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Event;
import com.ca.fmp.ims.model.generated.SegmentFieldType;

public class SRFFormatLabelProvider extends StyledCellLabelProvider{
	private SegmentFieldType segmentFieldType;
	private TextLayout layout;
	private TableViewer tableViewer;
	
	public SRFFormatLabelProvider(TextLayout layout, TableViewer tableViewer){
		this.layout = layout;
		this.tableViewer = tableViewer;
	}
	
	@Override
	protected void measure(Event event, Object element) {
		if (element == null) {
			return; // do nothing
		}

		if (!(element instanceof SegmentFieldType)) {
			return; // do nothing
		}

		if (event == null) {
			return; // do nothing
		}

		event.gc.setFont(JFaceResources.getTextFont());
		Point size = event.gc.textExtent("H");
		event.height = size.y;
	}
	
	@Override
	protected void paint(Event event, Object element) {	
		if (element != null) {
			if (element instanceof SegmentFieldType) {
				segmentFieldType = (SegmentFieldType) element;
				TextStyle plain = new TextStyle(JFaceResources.getTextFont(),
						null, null);
				layout.setText(String.valueOf(segmentFieldType.getFormatChar()));
				layout.setStyle(plain, 0, layout.getText().length());
				int colWidth = tableViewer.getTable().getColumn(2).getWidth();
				if(colWidth != 0){
					layout.setWidth(colWidth);					
				} else {
					layout.setWidth(-1);
				}		
				layout.setAlignment(SWT.CENTER);
				layout.setSpacing(event.height);	
				layout.draw(event.gc, event.x, event.y);					
			}
		}	
	}
}