/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.databaselist;

import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.PatternFilter;

public class DatabaseListViewPatternFilter extends PatternFilter {
	 protected boolean isChildMatch(Viewer viewer, Object element) {
		 Object parent = ((ITreeContentProvider) ((AbstractTreeViewer) viewer).getContentProvider()).getParent(element);
	
		 if(parent!=null){
			 return (isLeafMatch(viewer, parent) ? true : isChildMatch(viewer,parent));
		 }
		 return false;		 
	 }
	
	 @Override
	 protected boolean isLeafMatch(Viewer viewer, Object element) {
		 String labelText = ((ILabelProvider) ((StructuredViewer) viewer).getLabelProvider()).getText(element);
		  
		 if(labelText == null) {
			 return false;
		 }
		  
		 return (wordMatches(labelText) ? true : isChildMatch(viewer, element));
	 }
}
