/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.editor;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.TableItem;

import com.ca.fmp.ims.model.IMSSegment;
import com.ca.fmp.ims.model.generated.KeyInfoType;
import com.ca.fmp.ims.model.generated.RangeListType;
import com.ca.fmp.ims.model.generated.SecondaryIXType;
import com.ca.fmp.ims.model.generated.SegmentFieldType;
import com.ca.fmp.ims.model.generated.YorNType;

public class CharDataLabelProvider extends StyledCellLabelProvider {
	private TextLayout layout;
	private Shell shell;
	private Slider slider;
	private EditorView eView;
	
	private int startSubString = 0;
	private int endSubString = 0;
	
	public CharDataLabelProvider(TextLayout layout, Shell shell, Slider slider, EditorView eView){
		this.layout = layout;
		this.shell = shell;
		this.slider = slider;
		this.eView = eView;
	}

	@Override
	protected void paint(Event event, Object element) {
		startSubString = slider.getSelection();
		endSubString = startSubString + slider.getThumb() - 1;
		layout = new TextLayout(shell.getDisplay());
		String textInput = ((TableItem)event.item).getText(2);
		layout.setText(textInput);
		layout.setFont(JFaceResources.getTextFont());
		layout.setStyle(null, 0, textInput.length() - 1);
		
		RangeListType protectedList = ((IMSSegment)element).segmentType.getSegmentFields().getSegmentField().get(0).getProtectedList();		
		if(protectedList != null){
			int start, end;
			
			TextStyle protectedField = new TextStyle(JFaceResources.getTextFont(),
					shell.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND),
					shell.getDisplay().getSystemColor(SWT.COLOR_GRAY));
			
			for(int countProtectedFields = 0; countProtectedFields < protectedList.getRange().size(); countProtectedFields++){
				start = (int)protectedList.getRange().get(countProtectedFields).getStart() - 1;
				end = (int)protectedList.getRange().get(countProtectedFields).getEnd() - 1;
				
				doColumnHighlight(protectedField, start, end, YorNType.N);
			}
		}
		
		KeyInfoType keyInfo = ((IMSSegment)element).segmentType.getKeyInfo();
		if(keyInfo != null){
			int start = (int)keyInfo.getStart() - 1;
			int end = start + (int)keyInfo.getLength() - 1;
			
			TextStyle keyField;
			if(((IMSSegment)element).segmentType.getSecondaryIX().name().equals(SecondaryIXType.NO.toString())){
				keyField = new TextStyle(JFaceResources.getTextFont(),
						shell.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND),
						shell.getDisplay().getSystemColor(SWT.COLOR_YELLOW));				
			} else {
				keyField = new TextStyle(JFaceResources.getTextFont(),
						shell.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND),
						shell.getDisplay().getSystemColor(SWT.COLOR_CYAN));
			}
			
			doColumnHighlight(keyField, start, end, YorNType.N);
		}
		
		//Highlight Find result
		RangeListType rangeFindList = ((IMSSegment)element).segmentType.getSegmentFields().getSegmentField().get(0).getFindList();
		Color myGreen = new Color(Display.getCurrent(), 0, 180, 0);
		
		if(rangeFindList != null){
			int start, end;
			TextStyle findField;
			
			for(int countfindFields = 0; countfindFields < rangeFindList.getRange().size(); countfindFields++){	
				findField = new TextStyle(JFaceResources.getTextFont(),
				shell.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND),
				shell.getDisplay().getSystemColor(SWT.COLOR_GREEN));
				
				start = (int) rangeFindList.getRange().get(countfindFields).getStart() -1;
				end = (int) rangeFindList.getRange().get(countfindFields).getEnd() -1;
				
				doColumnHighlight(findField, start, end, eView.getHexToggled());
				
				if (((IMSSegment)element).segmentType.getSegmentFields().getSegmentField().get(0).getCursor() != null) {												
					findField = new TextStyle(JFaceResources.getTextFont(),
					shell.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND),
					myGreen);
								
					start = (int) ((IMSSegment)element).segmentType.getSegmentFields().getSegmentField().get(0).getCursor() -1;
					end = start + eView.wizard.page.getfindValueLength() - 1; 
								
					doColumnHighlight(findField, start, end, eView.getHexToggled());
				}
			}
				
			// Old source code			
			/*for(int countfindFields = 0; countfindFields < rangeFindList.getRange().size(); countfindFields++){				
				if (((IMSSegment)element).segmentType.getSegmentFields().getSegmentField().get(0).getCursor() != null){
					if (((IMSSegment)element).segmentType.getSegmentFields().getSegmentField().get(0).getCursor() ==
						rangeFindList.getRange().get(countfindFields).getStart()) {													
							findField = new TextStyle(JFaceResources.getTextFont(),
							shell.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND),
							shell.getDisplay().getSystemColor(SWT.COLOR_DARK_GREEN));
					} else 
						findField = new TextStyle(JFaceResources.getTextFont(),
						shell.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND),
						shell.getDisplay().getSystemColor(SWT.COLOR_GREEN));
				} else 
					findField = new TextStyle(JFaceResources.getTextFont(),
					shell.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND),
					shell.getDisplay().getSystemColor(SWT.COLOR_GREEN));
				
				start = (int) rangeFindList.getRange().get(countfindFields).getStart() -1;
				end = (int) rangeFindList.getRange().get(countfindFields).getEnd() -1;
				
				doColumnHighlight(findField, start, end, eView.getHexToggled());
			}	*/	
		}
		
		//@parra12: using an offset of 2 with event.x to prevent shifiting of data when enabling edit mode: Defect 3091
		layout.draw(event.gc, event.x+2, event.y);
		myGreen.dispose();
		layout.dispose();
	}
	
	private void doColumnHighlight(TextStyle highlightStyle, int start, int end, YorNType hex){

		if(!(start > endSubString || end < startSubString)){
			int layoutStart = (start - startSubString) < 0 ? 0 : (start - startSubString);
			int layoutEnd = (end - startSubString) > (endSubString - startSubString) ? (endSubString - startSubString) : (end - startSubString); 

			layout.setStyle(highlightStyle, layoutStart, layoutEnd);
			
			if(hex == YorNType.Y){
				int hexOffset = (layout.getText().length() / 3) + 1;
				layout.setStyle(highlightStyle, layoutStart + hexOffset,		layoutEnd + hexOffset);
				layout.setStyle(highlightStyle, layoutStart + (2 * hexOffset),	layoutEnd + (2 * hexOffset));
			}
		}
	}

	@Override
	protected void measure(Event event, Object element) {
		if(element == null) {
//			log.log(Level.WARNING, "element is null");
			return; // do nothing
		}


		if(event == null) {
//			log.log(Level.WARNING, "event is null");
			return; // do nothing
		}

		Point size = event.gc.textExtent("");
		IMSSegment imsSegment = (IMSSegment) element;
		if (imsSegment.segmentType.getSegmentFields() != null && imsSegment.segmentType.getSegmentFields().getSegmentField().size() > 0) {
			SegmentFieldType imsSegmentField = imsSegment.segmentType.getSegmentFields() .getSegmentField().get(0);
			// check if we are displaying one line or three
			// is hex mode "on"
			size = event.gc.textExtent("H");
			if(imsSegmentField.getHexData1() != null){
				event.height = (int) Math.ceil(size.y * 3.125);
			} else {
				event.height = size.y;
			}
		} 
		
	}
	
	@Override
	public void update(ViewerCell cell) {
		// The line below is part of fix for defect #2637 and #2657 - this causes the error message not to be displayed.
		// As for now there is no official Eclipse fix. For more please see: https://bugs.eclipse.org/bugs/show_bug.cgi?id=363764 
		cell.setText(" ");
		super.update(cell);
	}	
}

