/**
 * Copyright (c) 2017 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.ui.IViewSite;

import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.MessagesType;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;

public class Common {

	public static final String EMPTY_SPACE_IN_CHAR = " ";
	public static String LINE_SEPARATOR = "\r\n";
	public static final int EMPTY_SPACE_TO_INSERT = 0x20;
	/**
	 * @param args
	 */
	static ArrayList<String> shortText = new ArrayList<String>();
	static ArrayList<String> messageID = new ArrayList<String>();
	static List<String> messageText = new ArrayList<String>();
	static String messageIDFinal="";
	static String messageTextFinal= "";
	static String title = "";
	
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

	public static void displayErrorDialogs(MessagesType messages) {

		for (int i = 0; i < messages.getMessage().size(); i++) {
			String shortText = "";
			if(messages.getMessage().get(i).getShortText() != null) {
				shortText = messages.getMessage().get(i).getShortText();							
			}
			String messageID = "";
			if(messages.getMessage().get(i).getMessageId() != null) {
				messageID = messages.getMessage().get(i).getMessageId();
			}
			List<String> messageText = messages.getMessage().get(i).getMessageText();			
            try {
            	TT_ErrorDialog.openError(null, "Error", messageID + ": " + shortText, new Throwable(messageText.get(i)));            	
            } catch(Exception e) {
            	// do nothing
            	// we need to throw an Exception when the TT_ErrorDialog pops up
            	// so that is part of the details section.
            	// but we don't want it in the problem log view
            }
		}
	}
	
	public static void displayMessageforEditorView(GUIResponseType response, IViewSite viewSite) {
		displayMessageforEditorView(response, viewSite, false);
	}
	
	public static void displayMessageforEditorView(GUIResponseType response, IViewSite viewSite, boolean displayFRCZero) {
		
		// clear status bar
		if (viewSite!= null) {
			if(((StatusLineContributionItem) ((IViewSite) viewSite).getActionBars()
					.getStatusLineManager().find("messages")) == null){
				 ((IViewSite) viewSite).getActionBars().getStatusLineManager().add(new StatusLineContributionItem("messages"));
			}
			((StatusLineContributionItem) ((IViewSite) viewSite).getActionBars()
					.getStatusLineManager().find("messages")).setText(" ");
		}
		
		if(response!=null){
			// message to display
			String messageText;
			
			if(response.getReturnCode()!=0){
				// Critical error, invoke pop-up error window
				displayErrorMessage(response.getMessages());
			} else if (response.getFunctionRC() !=0){
				if(response.getMessages().getMessage().get(0).getMessageId().equalsIgnoreCase("CAWL108E")){
					displayErrorMessage(response.getMessages());
				}
				else if (response.getMessages().getMessage().size() > 1) {
					// more than one message, display pop-up window	
					displayErrorMessage(response.getMessages());
				} else {
					// display message on status bar
					if (viewSite!= null) {
						messageText = response.getMessages().getMessage().get(0).getShortText();
						((StatusLineContributionItem) ((IViewSite) viewSite).getActionBars()
								.getStatusLineManager().find("messages")).setText(messageText);
					}   
				}
			} else if(displayFRCZero){
				if (viewSite != null) {
					try{
						//display short text from first message on status bar
						messageText = response.getMessages().getMessage().get(0).getShortText();
						((StatusLineContributionItem) ((IViewSite) viewSite).getActionBars()
								.getStatusLineManager().find("messages")).setText(messageText);
					} catch (NullPointerException npe) {}
				}
			}
		}
	}
	
	private static void displayErrorMessage(MessagesType messages){
		shortText = new ArrayList<String>();
		messageID = new ArrayList<String>();
		messageText = new ArrayList<String>();
		messageIDFinal = new String();
		messageTextFinal = new String();

		for(int i=0;i<messages.getMessage().size();i++){
			shortText.add(messages.getMessage().get(i).getShortText());
			messageID.add(messages.getMessage().get(i).getMessageId());
			if(messages.getMessage().get(i).getMessageText()!=null)
					messageText.add(messages.getMessage().get(i).getMessageText()+ "\n");
			else 
				messageText.add("");
		}
		for(int i=0;i<messageID.size();i++){
			messageIDFinal+= messageID.get(i)+" : " + shortText.get(i) + "\n" ;
			title = "Error";
			messageTextFinal+= messageText.get(i).substring(1, messageText.get(i).length()-2) + "\n";
		
		}
		TT_ErrorDialog.openError(null, title, messageIDFinal, new Throwable(messageTextFinal));
	}
}
