/*
 * Decompiled with CFR 0.152.
 */
package com.ca.fmp.ims.operation;

import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.FileMasterSession;
import com.ca.fmp.ims.model.UnmarshalGUIResponse;
import com.ca.fmp.ims.model.UnmarshalMFRequest;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.MFRequestType;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;

public class SendRequestToMainframe {
    private IStatus result = Status.OK_STATUS;
    private HashMap<String, Object> map;
    private String operation;
    private boolean doSignon;
    private FileMasterServer fileMasterServer;
    private static final String SERVICE = "filemaster/fmp";
    private static final int GUISESSIONLEN = 36;
    private XMLRequest response = null;
    private Logger log = Logger.getLogger(this.getClass().getName());
    private XMLDocument xmlDocument = null;
    private GUIResponseType guiResponseType;
    private MFRequestType mfRequestType;
    private String uuid;

    public SendRequestToMainframe(FileMasterServer fileMasterServer, HashMap<String, Object> map, String operation, boolean doSignon, XMLDocument xmlDocument) {
        this.fileMasterServer = fileMasterServer;
        this.map = map;
        this.xmlDocument = xmlDocument;
        this.operation = operation;
        this.doSignon = false;
        this.schedule();
    }

    public GUIResponseType getGuiResponseType() {
        return this.guiResponseType;
    }

    public MFRequestType getMFRequestType() {
        return this.mfRequestType;
    }

    public IStatus getResult() {
        return this.result;
    }

    private void schedule() {
        ServerConnect sc = new ServerConnect((TTServer)this.fileMasterServer, SERVICE);
        try {
            if (this.xmlDocument == null) {
                this.response = sc.connect(this.operation, this.map, this.doSignon);
            } else {
                int begOfGUISession = this.xmlDocument.toString().indexOf("GUIsession=\"") + 12;
                this.uuid = this.xmlDocument.toString().substring(begOfGUISession, begOfGUISession + 36);
                this.map.put("uuid", this.uuid);
                this.map.put("product", "IMS");
                this.response = sc.connect(this.operation, this.map, this.doSignon, this.xmlDocument);
            }
            Element reqElement = this.response.getRoot();
            if (reqElement != null) {
                if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                    ArrayList<String> extraText = new ArrayList<String>();
                    extraText.add("Session information: " + this.uuid);
                    String message = "Return Code: 32";
                    String message2 = "The connection with the server has been interrupted.";
                    TT_ErrorDialog.openError(null, (String)"Communications Error", (String)message, (Throwable)new Throwable(message2), extraText);
                    FileMasterSession.removeSession((FileMasterServer)this.fileMasterServer, (String)this.uuid);
                    this.result = Status.CANCEL_STATUS;
                    return;
                }
                if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("16")) {
                    FileMasterSession.removeSession((FileMasterServer)this.fileMasterServer, (String)this.uuid);
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
            this.log.log(Level.WARNING, "received TTException");
            this.result = Status.CANCEL_STATUS;
            return;
        }
        UnmarshalGUIResponse u = new UnmarshalGUIResponse();
        File f = this.response.getAttachedFile();
        if (f == null) {
            this.log.log(Level.WARNING, "Attached file not found");
            this.log.log(Level.WARNING, this.response.toString());
            this.result = Status.CANCEL_STATUS;
            return;
        }
        u.readAndUnmarshal(f);
        this.guiResponseType = u.getResponse();
        if (this.guiResponseType == null) {
            UnmarshalMFRequest umf = new UnmarshalMFRequest();
            umf.readAndUnmarshal(f);
            this.mfRequestType = umf.getResponse();
        }
    }
}

