/*
 * Decompiled with CFR 0.152.
 */
package com.ca.fmp.ims.model;

import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.FileMasterSession;
import com.ca.fmp.ims.model.GetSegmentsRequest;
import com.ca.fmp.ims.model.ManagePrefsRequest;
import com.ca.fmp.ims.model.OpenDatabaseRequestType;
import com.ca.fmp.ims.model.RestoreDataSetRequestType;
import com.ca.fmp.ims.model.UpdateSegmentFieldTypeRequest;
import com.ca.fmp.ims.model.UpdateSegmentRequestType;
import com.ca.fmp.ims.model.generated.GUIRequestType;
import com.ca.fmp.ims.model.generated.ObjectFactory;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class RequestType {
    protected ObjectFactory of;
    protected GUIRequestType guiRequestType;
    protected static final String FILE_PREFIX = "com.ca.testingtools.";
    protected String uuid;
    private FileMasterServer server;

    public RequestType(FileMasterServer server) {
        this.server = server;
        this.of = new ObjectFactory();
        this.guiRequestType = this.of.createGUIRequestType();
        this.guiRequestType.setGUIsession(this.getSession());
    }

    public File marshal() {
        try {
            File xFile = File.createTempFile(FILE_PREFIX, ".xml");
            xFile.deleteOnExit();
            JAXBElement<GUIRequestType> element = this.of.createGUIRequest(this.guiRequestType);
            JAXBContext jc = JAXBContext.newInstance((String)"com.ca.fmp.ims.model.generated");
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("jaxb.encoding", (Object)"ISO-8859-1");
            m.marshal(element, xFile);
            return xFile;
        }
        catch (JAXBException jaxbException) {
            jaxbException.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String getSession() {
        try {
            boolean isTransactional;
            boolean createNew = this instanceof RestoreDataSetRequestType;
            boolean bl = isTransactional = !(this instanceof OpenDatabaseRequestType);
            if (this instanceof OpenDatabaseRequestType || this instanceof GetSegmentsRequest || this instanceof UpdateSegmentRequestType || this instanceof UpdateSegmentFieldTypeRequest || this instanceof ManagePrefsRequest) {
                isTransactional = false;
            }
            this.uuid = FileMasterSession.getUUID((FileMasterServer)this.server, (boolean)isTransactional, (boolean)createNew);
            if (this.uuid != null && this.uuid.isEmpty()) {
                return "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.uuid;
    }

    public String getUUID() {
        return this.uuid;
    }
}

