/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.print;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FMPreferences;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.utility.print.PrintGenericWizard;
import com.ca.filemaster.utility.print.PrintUtilityWizardPageOne;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PrintGenericWizardPage
extends FileMasterWizard {
    private Combo dsNameText;
    private Combo volumeText;
    private FileMasterServer server;
    private Map<String, String> map;
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.printOne";
    private FileMasterDataset dataSet;

    protected PrintGenericWizardPage(FileMasterServer server) {
        super("Select Data set", "", server);
        this.setTitle("Print Utility");
        this.server = server;
    }

    protected PrintGenericWizardPage(FileMasterServer server, Map<String, String> map) {
        super("Select Data set", "", server);
        this.setTitle("Print Utility");
        this.server = server;
        this.map = map;
    }

    @Override
    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.printOne");
        super.createControl(parent);
        super.createDataSet();
        FMHistory.intializeComboBoxes(this.dataSetCombo, "DatasetListPrintGeneric");
        Label lblvolumeSerial = new Label(this.dataSetComposite, 0);
        lblvolumeSerial.setText("&Volume serial:");
        this.volumeText = new Combo(this.dataSetComposite, 2048);
        this.volumeText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Combo)this.volumeText, (int)37);
        this.volumeText.setTextLimit(6);
        this.volumeText.addModifyListener((ModifyListener)this);
        this.volumeText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes(this.volumeText, "VolumeListPrintGeneric");
    }

    @Override
    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.canFlipToNextPage());
    }

    public boolean canFlipToNextPage() {
        this.error = "";
        if (this.volumeText != null) {
            switch (Validator.volume(this.volumeText.getText(), false)) {
                case 9: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.volume(this.volumeText.getText(), false)] + "\n ";
                }
            }
        }
        return super.isPageComplete();
    }

    public IWizardPage getNextPage() {
        FMHistory.insertHistory(this.dataSetCombo, "DatasetListPrintGeneric");
        FMHistory.insertHistory(this.volumeText, "VolumeListPrintGeneric");
        String typeOfDSN = "";
        String subTypeOfDSN = "";
        this.dsNameText = this.dataSetCombo;
        FileMasterDataset FMDataSet = new FileMasterDataset(null);
        FMDataSet.setName(this.dataSetCombo.getText());
        if (this.fmdataset != null && this.fmdataset.getName().equalsIgnoreCase(this.dsNameText.getText().trim())) {
            typeOfDSN = this.fmdataset.getDsOrg();
            subTypeOfDSN = this.fmdataset.getDsType();
        } else {
            FMDataSet = CommonMFCalls.getFQDSN(this.dsNameText.getText(), this.volumeText.getText(), this.server);
            if (CommonMFCalls.RETURN_CODE.equals("0")) {
                if (FMDataSet.getDsOrg().equalsIgnoreCase("VSAM")) {
                    FMDataSet.setName(((FMPVSAMDataset)FMDataSet).getCluster());
                }
                if (FMDataSet.getDsOrg().equalsIgnoreCase("HFS") || FMDataSet.getDsOrg().equalsIgnoreCase("VSAM") && FMDataSet.getDsType().equalsIgnoreCase("N") || FMDataSet.getDsOrg().equalsIgnoreCase("GDG")) {
                    MessageDialog.openError(null, (String)"Data Set Not Supported", (String)(String.valueOf(FMDataSet.getName()) + " not supported."));
                    return null;
                }
                typeOfDSN = FMDataSet.getDsOrg();
                subTypeOfDSN = FMDataSet.getDsType();
            }
        }
        if (typeOfDSN.isEmpty()) {
            return null;
        }
        this.dataSet = new FileMasterDataset(null);
        this.dataSet.setName(FMDataSet.getName());
        Text dataSetComboPageOne = ((PrintUtilityWizardPageOne)((PrintGenericWizard)this.getWizard()).getPage("Print")).getDataSetText();
        if (dataSetComboPageOne != null && !dataSetComboPageOne.getText().trim().equalsIgnoreCase(this.dataSet.getName())) {
            ((PrintUtilityWizardPageOne)((PrintGenericWizard)this.getWizard()).getPage("Print")).clearTable();
            ((PrintUtilityWizardPageOne)((PrintGenericWizard)this.getWizard()).getPage("Print")).setDatasetCombo(this.dataSet.getName());
        }
        ((PrintUtilityWizardPageOne)((PrintGenericWizard)this.getWizard()).getPage("Print")).setFileType(typeOfDSN);
        ((PrintUtilityWizardPageOne)((PrintGenericWizard)this.getWizard()).getPage("Print")).setSubTypeOfDSN(subTypeOfDSN);
        ((PrintUtilityWizardPageOne)((PrintGenericWizard)this.getWizard()).getPage("Print")).setVolumeSerial(this.volumeText.getText());
        return ((PrintGenericWizard)this.getWizard()).getPage("Print");
    }

    @Override
    public boolean isPageComplete() {
        if (((PrintGenericWizard)this.getWizard()).getPage("Print") != null) {
            return ((PrintUtilityWizardPageOne)((PrintGenericWizard)this.getWizard()).getPage("Print")).isPageComplete();
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.map.put("Action", "Finish");
            if (!FMPreferences.disabledPreview()) {
                ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&Preview");
            }
        }
        this.dataSetCombo.setFocus();
    }

    public boolean doFinish() {
        if (((PrintGenericWizard)this.getWizard()).getPage("Print") != null) {
            return ((PrintUtilityWizardPageOne)((PrintGenericWizard)this.getWizard()).getPage("Print")).doFinish();
        }
        return false;
    }
}

