/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.compare;

import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.utility.compare.Position;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifyDigit;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class InsertPositionWizardPage
extends WizardPage
implements ModifyListener {
    private Combo oldPositionCombo;
    private Combo newPositionCombo;
    private Combo lengthCombo;
    private String error;
    private Position position;

    protected InsertPositionWizardPage() {
        super("");
        this.setTitle("Position");
        this.setDescription("Insert the position of the record to be compared ");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label oldPositonLabel = new Label(container, 0);
        oldPositonLabel.setText("&Old position:");
        this.oldPositionCombo = new Combo(container, 2048);
        this.oldPositionCombo.setTextLimit(5);
        GridData gd_odlDataSetNameCombo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_odlDataSetNameCombo.widthHint = 320;
        gd_odlDataSetNameCombo.horizontalIndent = 2;
        this.oldPositionCombo.setLayoutData((Object)gd_odlDataSetNameCombo);
        TextUtil.setWidth((Combo)this.oldPositionCombo, (int)37);
        this.oldPositionCombo.addModifyListener((ModifyListener)this);
        this.oldPositionCombo.addVerifyListener((VerifyListener)new verifyDigit(true));
        Label lengthLabel = new Label(container, 0);
        lengthLabel.setText("&Length:");
        this.lengthCombo = new Combo(container, 0);
        this.lengthCombo.setEnabled(false);
        this.lengthCombo.setTextLimit(5);
        GridData gd_lengthCombo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_lengthCombo.widthHint = 320;
        gd_lengthCombo.horizontalIndent = 2;
        this.lengthCombo.setLayoutData((Object)gd_lengthCombo);
        TextUtil.setWidth((Combo)this.lengthCombo, (int)37);
        Label newPositionLabel = new Label(container, 0);
        newPositionLabel.setText("&New position:");
        this.newPositionCombo = new Combo(container, 2048);
        this.newPositionCombo.setEnabled(false);
        GridData gd_newPositionCombo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_newPositionCombo.widthHint = 320;
        gd_newPositionCombo.horizontalIndent = 2;
        this.newPositionCombo.setLayoutData((Object)gd_newPositionCombo);
        this.newPositionCombo.setTextLimit(5);
        TextUtil.setWidth((Combo)this.newPositionCombo, (int)37);
        this.lengthCombo.addModifyListener((ModifyListener)this);
        this.lengthCombo.addVerifyListener((VerifyListener)new verifyDigit(true));
        this.newPositionCombo.addModifyListener((ModifyListener)this);
        this.newPositionCombo.addVerifyListener((VerifyListener)new verifyDigit(true));
        FMHistory.intializeComboBoxes(this.oldPositionCombo, "OldPositionCombo");
        FMHistory.intializeComboBoxes(this.lengthCombo, "LengthCombo");
        FMHistory.intializeComboBoxes(this.newPositionCombo, "NewPositionCombo");
        this.getShell().getDefaultButton().setText("OK");
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        this.error = "";
        switch (Validator.oldPosition(this.oldPositionCombo.getText(), true)) {
            case 13: {
                this.error = String.valueOf(this.error) + Validator.errorMsg[13] + "\n";
                this.lengthCombo.setEnabled(false);
                this.newPositionCombo.setEnabled(false);
                break;
            }
            case 12: {
                this.error = String.valueOf(this.error) + Validator.errorMsg[12] + "\n ";
                break;
            }
            case 0: {
                this.lengthCombo.setEnabled(true);
            }
        }
        if (this.lengthCombo.getEnabled()) {
            switch (Validator.length(this.lengthCombo.getText(), true)) {
                case 15: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[15] + "\n";
                    this.newPositionCombo.setEnabled(false);
                    break;
                }
                case 14: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[14] + "\n";
                    this.newPositionCombo.setEnabled(false);
                    break;
                }
                case 0: {
                    this.newPositionCombo.setEnabled(true);
                }
            }
        }
        switch (Validator.newPosition(this.newPositionCombo.getText(), false)) {
            case 17: {
                this.error = String.valueOf(this.error) + Validator.errorMsg[17] + "\n";
                break;
            }
            case 16: {
                this.error = String.valueOf(this.error) + Validator.errorMsg[16] + "\n";
                break;
            }
        }
        if (this.error.length() > 0) {
            this.setErrorMessage(this.error);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean doFinish() {
        FMHistory.insertHistory(this.oldPositionCombo, "OldPositionCombo");
        FMHistory.insertHistory(this.lengthCombo, "LengthCombo");
        FMHistory.insertHistory(this.newPositionCombo, "NewPositionCombo");
        this.position = new Position();
        this.position.setOldPosition(Integer.parseInt(this.oldPositionCombo.getText()));
        this.position.setLength(Integer.parseInt(this.lengthCombo.getText()));
        if (this.newPositionCombo.getText().isEmpty()) {
            this.position.setNewPosition(Integer.parseInt(this.oldPositionCombo.getText()));
        } else {
            this.position.setNewPosition(Integer.parseInt(this.newPositionCombo.getText()));
        }
        return true;
    }

    public Position getPosition() {
        return this.position;
    }
}

