/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utilities;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.utilities.CopyGenericWizard;
import com.ca.filemaster.utility.copy.CopyPDSFromWizardPage;
import com.ca.filemaster.utility.copy.CopyPDSSummaryPage;
import com.ca.filemaster.utility.copy.CopySeqFromWizardPage;
import com.ca.filemaster.utility.copy.CopySequentialSummaryPage;
import com.ca.filemaster.utility.copy.CopyVSAMFromWizardPage;
import com.ca.filemaster.utility.copy.CopyVSAMSummaryPage;
import com.ca.filemaster.utility.copy.PDSSelectionCrtLayoutWizardPage;
import com.ca.filemaster.utility.copy.SeqSelectionCrtLayoutWizardPage;
import com.ca.filemaster.utility.copy.VSAMSelectionCrtLayoutWizardPage;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class CopyGenericWizardPage1
extends FileMasterWizard {
    private Combo dsNameText;
    private Combo volumeText;
    private String serverName;
    private FileMasterDataset dataSet;
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    private FileMasterServer server;
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.copyUtilityDatasetWizardPage";

    protected CopyGenericWizardPage1(String serverName) {
        super("Select Data set", "", FMServerTreeModel.getInstance().getServer(serverName));
        this.setTitle("Copy Data Set");
        this.setDescription("Select data set to copy from");
        this.serverName = serverName;
    }

    @Override
    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.copyUtilityDatasetWizardPage");
        super.createControl(parent);
        super.createDataSet();
        FMHistory.intializeComboBoxes(this.dataSetCombo, "DatasetListCopyGeneric");
        Label lblvolumeSerial = new Label(this.dataSetComposite, 0);
        lblvolumeSerial.setText("&Volume serial:");
        this.volumeText = new Combo(this.dataSetComposite, 2048);
        this.volumeText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Combo)this.volumeText, (int)37);
        this.volumeText.setTextLimit(6);
        this.volumeText.addModifyListener((ModifyListener)this);
        this.volumeText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes(this.volumeText, "VolumeListCopyGeneric");
    }

    @Override
    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.canFlipToNextPage());
    }

    public boolean canFlipToNextPage() {
        this.error = "";
        if (this.volumeText != null) {
            switch (Validator.volume(this.volumeText.getText(), false)) {
                case 9: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.volume(this.volumeText.getText(), false)] + "\n ";
                }
            }
        }
        return super.isPageComplete();
    }

    public IWizardPage getNextPage() {
        FMHistory.insertHistory(this.dataSetCombo, "DatasetListCopyGeneric");
        FMHistory.insertHistory(this.volumeText, "VolumeListCopyGeneric");
        String typeOfDSN = "";
        this.dataSet = new FileMasterDataset(null);
        this.dsNameText = this.dataSetCombo;
        this.server = this.model.getServer(this.serverName);
        this.dataSet.setName(this.dsNameText.getText());
        this.fmdataset = CommonMFCalls.getFQDSN(this.dsNameText.getText(), this.volumeText.getText(), this.server, true);
        if (CommonMFCalls.RETURN_CODE.equals("0")) {
            if (this.fmdataset.getVolume().equalsIgnoreCase("ARCIVE")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)"Invalid data set", (Throwable)new Throwable("Data set is archived. "));
                return null;
            }
            if (this.fmdataset.getDsOrg().equalsIgnoreCase("VSAM")) {
                this.dataSet.setName(((FMPVSAMDataset)this.fmdataset).getCluster());
            }
            if (this.fmdataset.getDsOrg().equalsIgnoreCase("HFS") || this.fmdataset.getDsOrg().equalsIgnoreCase("VSAM") && this.fmdataset.getDsType().equalsIgnoreCase("N") || this.fmdataset.getDsOrg().equalsIgnoreCase("GDG")) {
                MessageDialog.openError(null, (String)"Data Set Not Supported", (String)(String.valueOf(this.fmdataset.getName()) + " not supported."));
                return null;
            }
            typeOfDSN = this.fmdataset.getDsOrg();
            if (typeOfDSN.trim().isEmpty()) {
                typeOfDSN = this.fmdataset.getFileType();
            }
        } else {
            return null;
        }
        if (typeOfDSN.equalsIgnoreCase("PDS") || typeOfDSN.equalsIgnoreCase("PDSE")) {
            typeOfDSN = "PDS";
            if (this.getWizard().getPage("Copy PDS From") == null) {
                ((CopyGenericWizard)this.getWizard()).addPage((IWizardPage)new CopyPDSFromWizardPage("Copy PDS From", this.server, this.fmdataset, null, this.volumeText.getText(), false));
                ((CopyGenericWizard)this.getWizard()).addPage((IWizardPage)new PDSSelectionCrtLayoutWizardPage("Options", this.server.getName(), this.dataSet.getName(), "", "", ""));
                ((CopyGenericWizard)this.getWizard()).addPage((IWizardPage)new CopyPDSSummaryPage("Copy PDS Summary"));
            } else {
                ((CopyPDSFromWizardPage)((CopyGenericWizard)this.getWizard()).getPage("Copy PDS From")).setFromDataSetCombo(this.fmdataset);
            }
        } else if (typeOfDSN.equalsIgnoreCase("PS") || typeOfDSN.equalsIgnoreCase("PSL") || typeOfDSN.equalsIgnoreCase("Sequential")) {
            typeOfDSN = "Sequential";
            if (this.getWizard().getPage("Copy Sequential From") == null) {
                ((CopyGenericWizard)this.getWizard()).addPage((IWizardPage)new CopySeqFromWizardPage("Copy Sequential From", this.server, this.fmdataset, this.volumeText.getText(), false));
                ((CopyGenericWizard)this.getWizard()).addPage((IWizardPage)new SeqSelectionCrtLayoutWizardPage("Options", this.server.getName(), this.dataSet.getName(), "", "", ""));
                ((CopyGenericWizard)this.getWizard()).addPage((IWizardPage)new CopySequentialSummaryPage("Copy SEQ Summary"));
            } else {
                ((CopySeqFromWizardPage)((CopyGenericWizard)this.getWizard()).getPage("Copy Sequential From")).setFromDataSetCombo(this.fmdataset);
            }
        } else if (typeOfDSN.equalsIgnoreCase("CLUSTER") || typeOfDSN.equalsIgnoreCase("VSAM") || typeOfDSN.equalsIgnoreCase("Linear")) {
            typeOfDSN = "VSAM";
            if (this.getWizard().getPage("Copy VSAM From") == null) {
                ((CopyGenericWizard)this.getWizard()).addPage((IWizardPage)new CopyVSAMFromWizardPage("Copy VSAM From", this.server, this.fmdataset, false));
                ((CopyGenericWizard)this.getWizard()).addPage((IWizardPage)new VSAMSelectionCrtLayoutWizardPage("Options", this.server.getName(), this.dataSet.getName(), "", "", ""));
                ((CopyGenericWizard)this.getWizard()).addPage((IWizardPage)new CopyVSAMSummaryPage("Copy VSAM Summary"));
            } else {
                ((CopyVSAMFromWizardPage)((CopyGenericWizard)this.getWizard()).getPage("Copy VSAM From")).setFromDataSetCombo(this.fmdataset);
            }
        }
        return ((CopyGenericWizard)this.getWizard()).getPage("Copy " + typeOfDSN + " From");
    }

    @Override
    public boolean isPageComplete() {
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.dataSetCombo.setFocus();
    }
}

