/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utilities;

import com.ca.filemaster.ConfigureSettingsWizardPageOne;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.runners.RunGetCreateFile;
import com.ca.filemaster.ui.wizards.AllocateDatasetWizardPage1;
import com.ca.filemaster.utilities.AllocateNewVSAMDataSetWizardPage1;
import com.ca.filemaster.utilities.DataLabelProvider;
import com.ca.filemaster.utilities.IndexLabelProvider;
import com.ca.filemaster.utilities.ParameterLabelProvider;
import com.ca.filemaster.utility.copy.CopyPDSToWizardPage;
import com.ca.filemaster.utility.copy.CopySeqToWizardPage;
import com.ca.filemaster.utility.copy.CopyVSAMFromWizardPage;
import com.ca.filemaster.utility.copy.CopyVSAMToWizardPage;
import com.ca.filemaster.utility.print.PrintUtilityWizardPageThree;
import com.ca.filemaster.views.report.ReportView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifyDigit;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AllocateNewVSAMDataSetWizardPage2
extends WizardPage
implements ModifyListener,
SelectionListener {
    static final String cacopyright = "Copyright \ufffd 2011 CA";
    TableViewer viewer;
    private Composite container;
    private static final int PARAMETER = 0;
    private static final int DATA = 1;
    private static final int INDEX = 2;
    TableEditor[] dataEditor = new TableEditor[13];
    TableEditor[] indexEditor = new TableEditor[13];
    Object[] dataText = new Object[13];
    Object[] indexText = new Object[13];
    private Button noneRadio;
    private Button permRadio;
    private Button expirationRadio;
    private DateTime dateTime;
    private Text ClusterLabelData;
    public static final int CISIZE = 0;
    public static final int UNIT = 1;
    public static final int PRIMARY = 2;
    public static final int SECONDARY = 3;
    public static final int KEYPOSITION = 4;
    public static final int KEYLENGTH = 5;
    public static final int AVGRECORDSIZE = 6;
    public static final int MAXRECORDSIZE = 7;
    public static final int OWNERID = 8;
    public static final int PERCENTFREECICA = 9;
    public static final int SHAREOPTIONSCR = 10;
    public static final int SHAREOPTIONSCS = 11;
    public static final int BUFFERSPACE = 12;
    private String DatasetName = "";
    private boolean indexNeeded = true;
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.allocateNewVSAMDataSetWizardPageTwo";
    ArrayList<String> parameters = new ArrayList();
    FMPVSAMDataset vsamDSN = new FMPVSAMDataset(null);
    private FileMasterServer server;
    private String programReturnCode;

    public AllocateNewVSAMDataSetWizardPage2(FileMasterServer server, String datasetName) {
        super("allocateNewVSAMDataSetWizardPage2");
        this.setTitle("Allocate VSAM Data Set (Page 2 of 2)");
        this.setDescription("New data set allocation parameters");
        this.DatasetName = datasetName;
        this.server = server;
    }

    public void createControl(Composite parent) {
        IWizardPage page;
        this.container = new Composite(parent, 0);
        GridLayout container_layout = new GridLayout(1, false);
        this.container.setLayout((Layout)container_layout);
        Composite cluster_composite = new Composite(this.container, 0);
        cluster_composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout cluster_layout = new GridLayout(2, false);
        cluster_composite.setLayout((Layout)cluster_layout);
        Label ClusterLabel = new Label(cluster_composite, 0);
        GridData gd_clusterLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        ClusterLabel.setLayoutData((Object)gd_clusterLabel);
        ClusterLabel.setText("  Cluster:                   ");
        this.ClusterLabelData = new Text(cluster_composite, 8);
        GridData gd_clusterLabelData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.ClusterLabelData.setLayoutData((Object)gd_clusterLabelData);
        this.ClusterLabelData.setText(this.DatasetName);
        Composite allocation_composite = new Composite(this.container, 0);
        allocation_composite.setLayout((Layout)new GridLayout(1, false));
        Group allocationGroup = new Group(this.container, 0);
        allocationGroup.setLayout((Layout)new GridLayout(1, false));
        allocationGroup.setSize(allocationGroup.computeSize(-1, -1));
        allocationGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        allocationGroup.setText("Allocation");
        allocationGroup.setSize(allocationGroup.computeSize(-1, -1));
        this.createViewer((Composite)allocationGroup);
        this.setControl((Control)this.container);
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.allocateNewVSAMDataSetWizardPageTwo");
        if (this.getShell().getParent().getData() instanceof TestingToolsWizardDialog && (page = ((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage().getPreviousPage()) instanceof CopyVSAMFromWizardPage) {
            ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).setModelParameters(((CopyVSAMFromWizardPage)page).getFromDataSet());
        }
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        GridData gd_table = new GridData(4, 4, true, false, 2, 1);
        gd_table.heightHint = 320;
        gd_table.widthHint = 534;
        this.viewer.getTable().setLayoutData((Object)gd_table);
        this.createColumns(parent, this.viewer);
        this.parameters.add("CI size");
        this.parameters.add("Unit");
        this.parameters.add("Primary");
        this.parameters.add("Secondary");
        this.parameters.add("Key position");
        this.parameters.add("Key length");
        this.parameters.add("Avg record size");
        this.parameters.add("Max record size");
        this.parameters.add("Owner ID");
        this.parameters.add("Percent free CI and CA");
        this.parameters.add("Share options crossregion");
        this.parameters.add("Share options crosssystem");
        this.parameters.add("Buffer space");
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)this.parameters.toArray());
        this.getCellEditData();
    }

    private void createColumns(Composite parent, TableViewer viewer2) {
        String[] titles = new String[]{"Parameter", "Data", "Index"};
        int[] bounds = new int[]{300, 100, 100, 50};
        Table table = this.viewer.getTable();
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableColumn = new TableViewerColumn(this.viewer, bounds[i]);
            switch (i) {
                case 0: {
                    tableColumn.setLabelProvider((CellLabelProvider)new ParameterLabelProvider());
                    break;
                }
                case 1: {
                    tableColumn.setLabelProvider((CellLabelProvider)new DataLabelProvider());
                    break;
                }
                case 2: {
                    tableColumn.setLabelProvider((CellLabelProvider)new IndexLabelProvider());
                }
            }
            tableColumn.getColumn().setText(titles[i]);
            tableColumn.getColumn().setWidth(bounds[i]);
            table.setSortDirection(1024);
            ++i;
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public boolean isPageComplete() {
        int count = 0;
        while (count < this.dataText.length) {
            switch (count) {
                case 0: {
                    if (this.dataText[count] == null) {
                        return false;
                    }
                    if (((Text)this.dataText[count]).getText().isEmpty()) {
                        this.setErrorMessage("Data CI Size is empty");
                        return false;
                    }
                    if (this.indexText == null) {
                        return false;
                    }
                    if (this.indexText.length == 0) {
                        return false;
                    }
                    if (((Text)this.indexText[count]).getText().isEmpty() && ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("K")) {
                        this.setErrorMessage("Index CI Size is empty");
                        return false;
                    }
                    this.setErrorMessage(null);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (((Text)this.dataText[count]).getText().isEmpty() && (((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("K") || ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("E") || ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("R") || ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("L"))) {
                        this.setErrorMessage("Primary Data is empty");
                        return false;
                    }
                    this.setErrorMessage(null);
                    if (((Text)this.indexText[count]).getText().isEmpty() && ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("K")) {
                        this.setErrorMessage("Primary Index is empty");
                        return false;
                    }
                    if (this.indexText == null) {
                        return false;
                    }
                    if (this.indexText.length == 0) {
                        return false;
                    }
                    this.setErrorMessage(null);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    if (((Text)this.dataText[count]).getText().isEmpty() && ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("K")) {
                        this.setErrorMessage("Key Position is missing");
                        return false;
                    }
                    this.setErrorMessage(null);
                    break;
                }
                case 5: {
                    if (this.VerifyKeyLength()) break;
                    return false;
                }
                case 6: {
                    if (((Text)this.dataText[count]).getText().isEmpty() && (((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("K") || ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("E") || ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("R"))) {
                        this.setErrorMessage("Average Record Size Data is missing");
                        return false;
                    }
                    if (((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equalsIgnoreCase("R")) {
                        if (!((Text)this.dataText[count]).getText().equalsIgnoreCase(((Text)this.dataText[7]).getText())) {
                            ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).indexEnabled(true);
                        } else {
                            ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).indexEnabled(false);
                        }
                    }
                    this.setErrorMessage(null);
                    break;
                }
                case 7: {
                    if (((Text)this.dataText[count]).getText().isEmpty() && (((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("K") || ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("E") || ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("R"))) {
                        this.setErrorMessage("Max Record Size Data is missing");
                        return false;
                    }
                    if (((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equalsIgnoreCase("R")) {
                        if (!((Text)this.dataText[count]).getText().equalsIgnoreCase(((Text)this.dataText[6]).getText())) {
                            ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).indexEnabled(true);
                        } else {
                            ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).indexEnabled(false);
                        }
                    }
                    this.setErrorMessage(null);
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    if (!((Text)this.dataText[count]).getText().isEmpty() && Integer.valueOf(((Text)this.dataText[count]).getText()) >= 100) {
                        this.setErrorMessage("Percent Free CI And CA data should be less than 100");
                        return false;
                    }
                    if (!((Text)this.indexText[count]).getText().isEmpty() && this.indexNeeded && Integer.valueOf(((Text)this.indexText[count]).getText()) >= 100) {
                        this.setErrorMessage("Percent Free CI And CA index should be less than 100");
                        return false;
                    }
                    this.setErrorMessage(null);
                    break;
                }
                case 10: {
                    if (((Text)this.dataText[count]).getText().isEmpty() && (((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("K") || ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("E") || ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("R") || ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("L"))) {
                        this.setErrorMessage("Share options crossregion is missing");
                        return false;
                    }
                    this.setErrorMessage(null);
                    break;
                }
                case 11: {
                    if (((Text)this.dataText[count]).getText().isEmpty() && (((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("K") || ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("E") || ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("R") || ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("L"))) {
                        this.setErrorMessage("Share options crosssystem is missing");
                        return false;
                    }
                    this.setErrorMessage(null);
                    break;
                }
            }
            ++count;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void getCellEditData() {
        int i = 0;
        while (i < 13) {
            TableItem item = this.viewer.getTable().getItem(i);
            this.dataEditor[i] = new TableEditor(this.viewer.getTable());
            this.indexEditor[i] = new TableEditor(this.viewer.getTable());
            this.dataText[i] = new Text((Composite)this.viewer.getTable(), 2048);
            this.indexText[i] = new Text((Composite)this.viewer.getTable(), 2048);
            switch (i) {
                case 0: {
                    ((Text)this.dataText[0]).addVerifyListener((VerifyListener)new verifyDigit(true));
                    ((Text)this.indexText[0]).addVerifyListener((VerifyListener)new verifyDigit(true));
                    this.verifyCISIZE();
                    break;
                }
                case 1: {
                    this.dataText[i] = new Combo((Composite)this.viewer.getTable(), 2056);
                    this.indexText[i] = new Combo((Composite)this.viewer.getTable(), 2056);
                    ((Combo)this.dataText[i]).setItems(new String[]{"Tracks", "Cylinders", "Records", "Kilobytes", "Megabytes"});
                    ((Combo)this.dataText[i]).select(0);
                    ((Combo)this.dataText[i]).addModifyListener((ModifyListener)this);
                    ((Combo)this.indexText[i]).setItems(new String[]{"Tracks", "Cylinders", "Records", "Kilobytes", "Megabytes"});
                    ((Combo)this.indexText[i]).select(0);
                    ((Combo)this.indexText[i]).addModifyListener((ModifyListener)this);
                    break;
                }
                case 9: {
                    this.verifyPercentFreeCIandCA();
                    break;
                }
                case 4: {
                    this.verifyKeyPosition();
                    break;
                }
                case 2: {
                    this.verifyPrimaryAlloc();
                    break;
                }
                case 3: {
                    this.verifySecondaryAlloc();
                    break;
                }
                case 5: {
                    ((Text)this.dataText[5]).addVerifyListener((VerifyListener)new verifyDigit(false));
                    ((Text)this.dataText[5]).setTextLimit(5);
                    ((Text)this.dataText[5]).setText("");
                    ((Text)this.dataText[i]).addModifyListener((ModifyListener)this);
                    ((Text)this.indexText[i]).setEnabled(false);
                    break;
                }
                case 6: {
                    this.verifyAvgRecordSize();
                    break;
                }
                case 7: {
                    this.verifyMaxRecordSize();
                    break;
                }
                case 10: {
                    ((Text)this.indexText[10]).setEnabled(false);
                    this.verifyShareOptionsRegion(10);
                    break;
                }
                case 11: {
                    ((Text)this.indexText[11]).setEnabled(false);
                    this.verifyShareOptionsSystem(11);
                    break;
                }
                case 8: {
                    this.verifyOwnerID();
                    break;
                }
                case 12: {
                    this.verifyBufferSpace();
                    break;
                }
                default: {
                    ((Text)this.dataText[i]).addModifyListener((ModifyListener)this);
                    ((Text)this.indexText[i]).addModifyListener((ModifyListener)this);
                }
            }
            this.dataEditor[i].grabHorizontal = true;
            this.dataEditor[i].minimumHeight = ((Control)this.dataText[i]).getSize().y;
            this.dataEditor[i].minimumWidth = ((Control)this.dataText[i]).getSize().x;
            this.indexEditor[i].grabHorizontal = true;
            this.indexEditor[i].minimumHeight = ((Control)this.indexText[i]).getSize().y;
            this.indexEditor[i].minimumWidth = ((Control)this.indexText[i]).getSize().x;
            this.dataEditor[i].setEditor((Control)this.dataText[i], item, 1);
            this.indexEditor[i].setEditor((Control)this.indexText[i], item, 2);
            ++i;
        }
    }

    private void verifyOwnerID() {
        ((Text)this.indexText[8]).setEnabled(false);
        ((Text)this.dataText[8]).setTextLimit(8);
        ((Text)this.indexText[8]).setEnabled(false);
        ((Text)this.dataText[8]).setText("");
        ((Text)this.dataText[8]).addModifyListener((ModifyListener)this);
        ((Text)this.dataText[8]).addVerifyListener((VerifyListener)new verifytoUpperCase());
    }

    private void verifyShareOptionsRegion(int i) {
        ((Text)this.dataText[i]).setText("");
        ((Text)this.dataText[i]).setTextLimit(1);
        ((Text)this.dataText[i]).addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.doit) {
                    return;
                }
                if (e.text.length() == 0) {
                    return;
                }
                Pattern p = Pattern.compile("[1-4]{0,1}");
                Matcher m = p.matcher(e.text);
                e.doit = m.matches();
            }
        });
        ((Text)this.dataText[i]).addModifyListener((ModifyListener)this);
    }

    private void verifyShareOptionsSystem(int i) {
        ((Text)this.dataText[i]).setText("");
        ((Text)this.dataText[i]).setTextLimit(1);
        ((Text)this.dataText[i]).addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.doit) {
                    return;
                }
                if (e.text.length() == 0) {
                    return;
                }
                Pattern p = Pattern.compile("[3-4]{0,1}");
                Matcher m = p.matcher(e.text);
                e.doit = m.matches();
            }
        });
        ((Text)this.dataText[i]).addModifyListener((ModifyListener)this);
    }

    private void verifyBufferSpace() {
        ((Text)this.dataText[12]).setTextLimit(7);
        ((Text)this.indexText[12]).setEnabled(false);
        ((Text)this.dataText[12]).setText("");
        ((Text)this.dataText[12]).addVerifyListener((VerifyListener)new verifyDigit(false));
        ((Text)this.dataText[12]).addModifyListener((ModifyListener)this);
    }

    private void verifyMaxRecordSize() {
        ((Text)this.dataText[7]).setTextLimit(6);
        ((Text)this.indexText[7]).setEnabled(false);
        ((Text)this.dataText[7]).setText("");
        ((Text)this.dataText[7]).addVerifyListener((VerifyListener)new verifyDigit(false));
        ((Text)this.dataText[7]).addModifyListener((ModifyListener)this);
    }

    private void verifyAvgRecordSize() {
        ((Text)this.dataText[6]).setTextLimit(6);
        ((Text)this.indexText[6]).setEnabled(false);
        ((Text)this.dataText[6]).setText("");
        ((Text)this.dataText[6]).addVerifyListener((VerifyListener)new verifyDigit(false));
        ((Text)this.dataText[6]).addModifyListener((ModifyListener)this);
    }

    private void verifySecondaryAlloc() {
        if (((Text)this.dataText[3]).getTextLimit() == Text.LIMIT - 1) {
            ((Text)this.dataText[3]).setTextLimit(6);
            ((Text)this.dataText[3]).addVerifyListener((VerifyListener)new verifyDigit(false));
            ((Text)this.indexText[3]).setTextLimit(6);
            ((Text)this.indexText[3]).addVerifyListener((VerifyListener)new verifyDigit(false));
        }
        if (!this.indexNeeded) {
            ((Text)this.indexText[3]).setEnabled(false);
        } else {
            ((Text)this.indexText[3]).setEnabled(true);
        }
        ((Text)this.dataText[3]).addModifyListener((ModifyListener)this);
        ((Text)this.indexText[3]).addModifyListener((ModifyListener)this);
    }

    private void verifyPrimaryAlloc() {
        if (((Text)this.dataText[2]).getTextLimit() == Text.LIMIT - 1) {
            ((Text)this.dataText[2]).setTextLimit(6);
            ((Text)this.dataText[2]).addVerifyListener((VerifyListener)new verifyDigit(false));
            ((Text)this.indexText[2]).setTextLimit(6);
            ((Text)this.indexText[2]).addVerifyListener((VerifyListener)new verifyDigit(false));
        }
        if (!this.indexNeeded) {
            ((Text)this.indexText[2]).setEnabled(false);
        } else {
            ((Text)this.indexText[2]).setEnabled(true);
        }
        ((Text)this.dataText[2]).addModifyListener((ModifyListener)this);
        ((Text)this.indexText[2]).addModifyListener((ModifyListener)this);
    }

    private void verifyKeyPosition() {
        ((Text)this.dataText[4]).setTextLimit(5);
        ((Text)this.indexText[4]).setEnabled(false);
        ((Text)this.dataText[4]).setText("");
        ((Text)this.dataText[4]).addVerifyListener((VerifyListener)new verifyDigit(false));
        ((Text)this.dataText[4]).addModifyListener((ModifyListener)this);
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    private void verifyCISIZE() {
        if ((Text)this.dataText[0] == null) {
            this.dataText[0] = new Text((Composite)this.viewer.getTable(), 2048);
            ((Text)this.dataText[0]).setTextLimit(5);
            ((Text)this.dataText[0]).addVerifyListener((VerifyListener)new verifyDigit(false));
        }
        if ((Text)this.indexText[0] == null) {
            this.indexText[0] = new Text((Composite)this.viewer.getTable(), 2048);
            ((Text)this.indexText[0]).setTextLimit(5);
            ((Text)this.indexText[0]).addVerifyListener((VerifyListener)new verifyDigit(false));
        }
        if (!this.indexNeeded) {
            ((Text)this.indexText[0]).setEnabled(false);
        } else {
            ((Text)this.indexText[0]).setEnabled(true);
        }
        ((Text)this.dataText[0]).addModifyListener((ModifyListener)this);
        ((Text)this.indexText[0]).addModifyListener((ModifyListener)this);
    }

    private void verifyPercentFreeCIandCA() {
        ((Text)this.dataText[9]).setTextLimit(3);
        ((Text)this.dataText[9]).addVerifyListener((VerifyListener)new verifyDigit(false));
        ((Text)this.indexText[9]).setTextLimit(3);
        ((Text)this.indexText[9]).addVerifyListener((VerifyListener)new verifyDigit(false));
        ((Text)this.dataText[9]).addModifyListener((ModifyListener)this);
        ((Text)this.indexText[9]).addModifyListener((ModifyListener)this);
    }

    private boolean VerifyKeyLength() {
        if (!((Text)this.dataText[5]).getText().isEmpty()) {
            int keylengthValD = Integer.valueOf(((Text)this.dataText[5]).getText());
            if (!((Text)this.dataText[6]).getText().isEmpty() && keylengthValD > Integer.valueOf(((Text)this.dataText[6]).getText())) {
                this.setErrorMessage("Key Length cannot be greater than the Avg record size");
                return false;
            }
            if (keylengthValD == 0 && ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("K")) {
                this.setErrorMessage("Key Length cannot be 0");
                return false;
            }
        }
        if (((Text)this.dataText[5]).getText().isEmpty() && ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType().equals("K")) {
            this.setErrorMessage("Invalid Key Length");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public HashMap<String, Object> allocParms() {
        HashMap<String, Object> allocParms = new HashMap<String, Object>();
        allocParms.put("CISizeData", ((Text)this.dataText[0]).getText());
        allocParms.put("CISizeIndex", ((Text)this.indexText[0]).getText());
        allocParms.put("UnitData", ((Combo)this.dataText[1]).getText());
        allocParms.put("UnitIndex", ((Combo)this.indexText[1]).getText());
        allocParms.put("PrimaryData", ((Text)this.dataText[2]).getText());
        allocParms.put("PrimaryIndex", ((Text)this.indexText[2]).getText());
        allocParms.put("SecondaryData", ((Text)this.dataText[3]).getText());
        allocParms.put("SecondaryIndex", ((Text)this.indexText[3]).getText());
        allocParms.put("KeyPositionData", ((Text)this.dataText[4]).getText());
        allocParms.put("KeyLengthData", ((Text)this.dataText[5]).getText());
        allocParms.put("AvgRecordSizeData", ((Text)this.dataText[6]).getText());
        allocParms.put("MaxRecordSizeData", ((Text)this.dataText[7]).getText());
        allocParms.put("OwnerIDData", ((Text)this.dataText[8]).getText());
        allocParms.put("PercentFreeData", ((Text)this.dataText[9]).getText());
        allocParms.put("PercentFreeIndex", ((Text)this.indexText[9]).getText());
        allocParms.put("ShareOptionsData", ((Text)this.dataText[10]).getText());
        allocParms.put("ShareOptionsIndex", ((Text)this.dataText[11]).getText());
        allocParms.put("BufferSpaceData", ((Text)this.dataText[12]).getText());
        return allocParms;
    }

    public boolean doFinish() {
        if ((AllocateDatasetWizardPage1)this.getWizard().getPage("Allocate Data Set") != null) {
            ((AllocateDatasetWizardPage1)this.getWizard().getPage("Allocate Data Set")).doFinish();
        }
        this.vsamDSN.setCluster(((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getCluster());
        this.vsamDSN.setData(((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getComponentDSNData());
        this.vsamDSN.setIndex(((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getComponentDSNIndex());
        if (((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).isSMSClass()) {
            ArrayList<String> indexSerials = new ArrayList<String>();
            indexSerials.clear();
            this.vsamDSN.setIndexVolumes(indexSerials);
            ArrayList<String> dataSerials = new ArrayList<String>();
            dataSerials.clear();
            this.vsamDSN.setDataVolumes(dataSerials);
        } else {
            if (this.vsamDSN.getIndexVolumes().size() > 0) {
                this.vsamDSN.getIndexVolumes().set(0, ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVolumeIndex());
            } else {
                this.vsamDSN.getIndexVolumes().add(((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVolumeIndex());
            }
            if (this.vsamDSN.getDataVolumes().size() > 0) {
                this.vsamDSN.getDataVolumes().set(0, ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVolumeData());
            } else {
                this.vsamDSN.getDataVolumes().add(((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVolumeData());
            }
        }
        this.vsamDSN.setSmsData(((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getSMSData());
        this.vsamDSN.setSmsManagement(((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getSMSManagement());
        this.vsamDSN.setSmsStorage(((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getSMSStorage());
        this.vsamDSN.setVSAMFileType(((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).getVSAMFileType());
        this.vsamDSN.setVsamOptions(((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).OptionValues());
        this.vsamDSN.setAllocParms(this.allocParms());
        boolean isSMSClass = ((AllocateNewVSAMDataSetWizardPage1)this.getPreviousPage()).isSMSClass();
        RunGetCreateFile runner = new RunGetCreateFile(this.server, this.vsamDSN, isSMSClass);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element element = xml.getRoot();
            NodeList command = element.getElementsByTagName("CreateFileResponse");
            Element createFileResponse = (Element)command.item(0);
            NodeList retCode = element.getElementsByTagName("ReturnCode");
            Node rcNode = retCode.item(0);
            Element rcElement = (Element)rcNode;
            NodeList rcList = rcElement.getChildNodes();
            Node rcValue = rcList.item(0);
            String returnCode = rcValue.getNodeValue();
            this.programReturnCode = createFileResponse.getAttribute("programReturnCode");
            if (returnCode.equals("0")) {
                if (this.programReturnCode.equals("0")) {
                    MessageDialog.openInformation(null, (String)"Allocate Data Set", (String)("Data set named '" + this.DatasetName + "' has been allocated"));
                } else {
                    ArrayList<String> contentAL = new ArrayList<String>();
                    NodeList nodes = element.getElementsByTagName("Line");
                    NodeList messages = element.getElementsByTagName("Message");
                    String message = "";
                    if (nodes.getLength() == 0) {
                        int i = 0;
                        while (i < messages.getLength()) {
                            Node msgNode = messages.item(i);
                            Element msgElement = (Element)msgNode;
                            message = String.valueOf(message) + AllocateNewVSAMDataSetWizardPage2.getTagValue("Message", msgElement);
                            ++i;
                        }
                        TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                    } else {
                        Node msgNode = messages.item(0);
                        Element msgElement = (Element)msgNode;
                        message = AllocateNewVSAMDataSetWizardPage2.getTagValue("Message", msgElement);
                        MessageDialog.openError(null, (String)"Allocate Data Set", (String)message);
                        int i = 0;
                        while (i < nodes.getLength()) {
                            Element lineElement = (Element)nodes.item(i);
                            String line = new String();
                            line = AllocateNewVSAMDataSetWizardPage2.getTagValue("Line", lineElement);
                            contentAL.add(line);
                            ++i;
                        }
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IWorkbenchPage page = window.getActivePage();
                        try {
                            IViewPart view;
                            if (!contentAL.toArray(new String[contentAL.size()]).toString().isEmpty() && (view = page.showView("com.ca.filemaster.views.reportsview", contentAL.toArray(new String[contentAL.size()]).toString(), 1)) instanceof ReportView) {
                                ((ReportView)view).updateReportViewer(contentAL.toArray(new String[contentAL.size()]));
                            }
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                String message = "";
                NodeList messages = element.getElementsByTagName("Message");
                int i = 0;
                while (i < messages.getLength()) {
                    Node msgNode = messages.item(i);
                    Element msgElement = (Element)msgNode;
                    NodeList msgList = msgElement.getChildNodes();
                    Node msgValue = msgList.item(0);
                    message = String.valueOf(message) + msgValue.getNodeValue() + "\n";
                    ++i;
                }
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                return false;
            }
        }
        if (this.getShell().getParent().getData() instanceof TestingToolsWizardDialog) {
            if (((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage() instanceof CopyPDSToWizardPage) {
                ((CopyPDSToWizardPage)((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage()).setDisp("SHR");
            } else if (((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage() instanceof CopySeqToWizardPage) {
                ((CopySeqToWizardPage)((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage()).setDisp("SHR");
            } else if (((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage() instanceof CopyVSAMToWizardPage) {
                ((CopyVSAMToWizardPage)((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage()).setDisp("SHR");
            } else if (((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage() instanceof PrintUtilityWizardPageThree) {
                ((PrintUtilityWizardPageThree)((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage()).setDisp("SHR");
            } else if (((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage() instanceof ConfigureSettingsWizardPageOne) {
                ((ConfigureSettingsWizardPageOne)((TestingToolsWizardDialog)this.getShell().getParent().getData()).getCurrentPage()).setPrintTabDisp("SHR");
            }
        }
        return true;
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue != null) {
            return nValue.getNodeValue();
        }
        return "";
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.noneRadio || e.getSource() == this.permRadio) {
            this.dateTime.setEnabled(false);
        } else if (e.getSource() == this.expirationRadio) {
            this.dateTime.setEnabled(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.container.setFocus();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void setIndexNeeded(boolean indexNeeded) {
        this.indexNeeded = indexNeeded;
        ((Text)this.dataText[0]).removeModifyListener((ModifyListener)this);
        ((Text)this.indexText[0]).removeModifyListener((ModifyListener)this);
        ((Text)this.dataText[2]).removeModifyListener((ModifyListener)this);
        ((Text)this.indexText[2]).removeModifyListener((ModifyListener)this);
        ((Text)this.dataText[3]).removeModifyListener((ModifyListener)this);
        ((Text)this.indexText[3]).removeModifyListener((ModifyListener)this);
        this.verifyCISIZE();
        if (this.indexText[1] != null) {
            ((Combo)this.indexText[1]).removeModifyListener((ModifyListener)this);
            if (indexNeeded) {
                ((Combo)this.indexText[1]).setEnabled(true);
            } else {
                ((Combo)this.indexText[1]).setEnabled(false);
            }
            ((Combo)this.indexText[1]).addModifyListener((ModifyListener)this);
        }
        this.verifyPrimaryAlloc();
        this.verifySecondaryAlloc();
    }

    public void setIndexSerials(ArrayList<String> serials) {
        this.vsamDSN.setIndexVolumes(serials);
    }

    public void setDataSerials(ArrayList<String> serials) {
        this.vsamDSN.setDataVolumes(serials);
    }

    public ArrayList<String> getIndexSerials() {
        return this.vsamDSN.getIndexVolumes();
    }

    public ArrayList<String> getDataSerials() {
        return this.vsamDSN.getDataVolumes();
    }

    public void setDataVolumesCount(String dataVolumesCount) {
        this.vsamDSN.setDataVolumesCount(dataVolumesCount);
    }

    public void setIndexVolumesCount(String indexVolumesCount) {
        this.vsamDSN.setIndexVolumesCount(indexVolumesCount);
    }

    public String getDataVolumesCount() {
        return this.vsamDSN.getDataVolumesCount();
    }

    public String getIndexVolumesCount() {
        return this.vsamDSN.getIndexVolumesCount();
    }

    public void updateDataSet(String dataSet) {
        this.DatasetName = dataSet;
        if (this.ClusterLabelData != null) {
            this.ClusterLabelData.setText(this.DatasetName);
        }
    }

    public void setModelParameters(FileMasterDataset modelDataset) {
        ((Text)this.dataText[0]).setText(((FMPVSAMDataset)modelDataset).getDataControlIntervalSize());
        if (((FMPVSAMDataset)modelDataset).getDataUnits().equalsIgnoreCase("TRKS")) {
            ((Combo)this.dataText[1]).setText("Tracks");
        } else if (((FMPVSAMDataset)modelDataset).getDataUnits().equalsIgnoreCase("CYLS")) {
            ((Combo)this.dataText[1]).setText("Cylinders");
        } else if (((FMPVSAMDataset)modelDataset).getDataUnits().equalsIgnoreCase("BLK")) {
            ((Combo)this.dataText[1]).setText("Blocks");
        }
        ((Text)this.dataText[2]).setText(((FMPVSAMDataset)modelDataset).getDataPrimary());
        ((Text)this.dataText[3]).setText(((FMPVSAMDataset)modelDataset).getDataSecondary());
        ((Text)this.dataText[4]).setText(((FMPVSAMDataset)modelDataset).getOffset());
        ((Text)this.dataText[5]).setText(((FMPVSAMDataset)modelDataset).getLength());
        ((Text)this.dataText[6]).setText(((FMPVSAMDataset)modelDataset).getAverage());
        ((Text)this.dataText[7]).setText(((FMPVSAMDataset)modelDataset).getMaximum());
        if (modelDataset.getDsType().equalsIgnoreCase("R")) {
            ((Text)this.dataText[7]).setText(((FMPVSAMDataset)modelDataset).getAverage());
        }
        ((Text)this.dataText[8]).setText(((FMPVSAMDataset)modelDataset).getOwner());
        ((Text)this.dataText[9]).setText(((FMPVSAMDataset)modelDataset).getDataCApercent());
        ((Text)this.dataText[10]).setText(((FMPVSAMDataset)modelDataset).getCrossregion());
        ((Text)this.dataText[12]).setText(((FMPVSAMDataset)modelDataset).getBufferSpace());
        ((Text)this.indexText[0]).setText(((FMPVSAMDataset)modelDataset).getIndexControlIntervalSize());
        if (((FMPVSAMDataset)modelDataset).getIndexUnits().equalsIgnoreCase("TRKS")) {
            ((Combo)this.indexText[1]).setText("Tracks");
        } else if (((FMPVSAMDataset)modelDataset).getIndexUnits().equalsIgnoreCase("CYLS")) {
            ((Combo)this.indexText[1]).setText("Cylinders");
        } else if (((FMPVSAMDataset)modelDataset).getIndexUnits().equalsIgnoreCase("BLK")) {
            ((Combo)this.indexText[1]).setText("Blocks");
        }
        ((Text)this.indexText[2]).setText(((FMPVSAMDataset)modelDataset).getIndexPrimary());
        ((Text)this.indexText[3]).setText(((FMPVSAMDataset)modelDataset).getIndexSecondary());
        ((Text)this.indexText[9]).setText(((FMPVSAMDataset)modelDataset).getDataCIpercent());
        ((Text)this.dataText[11]).setText(((FMPVSAMDataset)modelDataset).getCrosssystem());
    }

    public String getProgramReturnCode() {
        return this.programReturnCode;
    }
}

