/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.ui.wizards;

import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DSNListWizardPage
extends WizardPage
implements ModifyListener {
    static String cacopyright = "Copyright \ufffd 2016 CA";
    private static final String sourceClass = DSNListWizardPage.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.datasetWizard";
    private Text dataSetCombo;
    private Combo dsnListCombo;
    private Button select;
    private FileMasterServer server;
    private Table table;

    protected DSNListWizardPage(String pageName, FileMasterServer server, String dsnListPDS, String dsnListName) {
        super(pageName);
        this.setTitle("Select DSN List");
        this.setDescription("");
        this.server = server;
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.datasetWizard");
        Composite subParent = new Composite(parent, 0);
        subParent.setSize(subParent.computeSize(-1, -1));
        subParent.setLayout((Layout)new GridLayout(1, true));
        this.setControl((Control)parent);
        Group dataSetGroup = new Group(subParent, 0);
        GridData gd_dataSetGroup = new GridData(16384, 0x1000000, false, true, 1, 1);
        dataSetGroup.setSize(dataSetGroup.computeSize(-1, -1));
        dataSetGroup.setLayoutData((Object)gd_dataSetGroup);
        dataSetGroup.setLayout((Layout)new GridLayout(7, true));
        Label dataSetLabel = new Label((Composite)dataSetGroup, 16384);
        dataSetLabel.setText("&Data set:");
        this.dataSetCombo = new Text((Composite)dataSetGroup, 16392);
        GridData gd_dataSetCombo = new GridData(4, 4, false, false, 5, 1);
        gd_dataSetCombo.widthHint = 307;
        this.dataSetCombo.setLayoutData((Object)gd_dataSetCombo);
        this.dataSetCombo.setText(this.getDSNListPDS());
        new Label((Composite)dataSetGroup, 0);
        Label dsnListLabel = new Label((Composite)dataSetGroup, 0);
        dsnListLabel.setText("DSN &list:");
        this.dsnListCombo = new Combo((Composite)dataSetGroup, 16384);
        this.dsnListCombo.setLayoutData((Object)new GridData(4, 4, false, false, 5, 1));
        this.dsnListCombo.addModifyListener((ModifyListener)this);
        this.select = new Button((Composite)dataSetGroup, 8);
        GridData gd_select = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_select.widthHint = 63;
        this.select.setLayoutData((Object)gd_select);
        this.select.setText("&Select");
        this.select.setEnabled(false);
        new Label((Composite)dataSetGroup, 0);
        new Label((Composite)dataSetGroup, 0);
        new Label((Composite)dataSetGroup, 0);
        new Label((Composite)dataSetGroup, 0);
        new Label((Composite)dataSetGroup, 0);
        new Label((Composite)dataSetGroup, 0);
        new Label((Composite)dataSetGroup, 0);
        this.table = new Table((Composite)dataSetGroup, 67584);
        GridData gd_table = new GridData(4, 4, false, true, 6, 1);
        gd_table.heightHint = 130;
        gd_table.widthHint = 380;
        this.table.setLayoutData((Object)gd_table);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn tblclmnName = new TableColumn(this.table, 0);
        tblclmnName.setWidth(90);
        tblclmnName.setText("Name");
        TableColumn tblclmnDescription = new TableColumn(this.table, 0);
        tblclmnDescription.setWidth(286);
        tblclmnDescription.setText("Description");
        new Label((Composite)dataSetGroup, 0);
        this.getShell().getDefaultButton().setText("OK");
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
    }

    public boolean isPageComplete() {
        if (Validator.dataset(this.dsnListCombo.getText(), false) == 3 || this.dsnListCombo.getText().equals("")) {
            this.select.setEnabled(true);
        }
        return this.table.getSelection().length > 0;
    }

    public boolean doFinish() {
        return true;
    }

    private String getDSNListPDS() {
        String DSNListPDS = this.server.getFmpPreferences().getFmParmFilePrefs().getDSNLists();
        return DSNListPDS != null ? DSNListPDS : "";
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }
}

