/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.handlers;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.ui.wizards.RenameDatasetWizard;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class RenameDatasetHandler
extends AbstractHandler
implements IElementUpdater {
    private FileMasterDataset dataSet;
    private FileMasterServer server;
    private FMPVSAMDataset vsamDSN = new FMPVSAMDataset(null);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        TT_TreeItem TT_Treeserver = ((TT_TreeItem)((IStructuredSelection)selection).getFirstElement()).getParent();
        TT_TreeItem datasetName = (TT_TreeItem)((IStructuredSelection)selection).getFirstElement();
        if (datasetName.getValue() instanceof FileMasterDataset) {
            this.dataSet = (FileMasterDataset)datasetName.getValue();
            this.server = (FileMasterServer)datasetName.getServer();
            this.dataSet = CommonMFCalls.getFQDSN(this.dataSet.getName(), "", this.server);
            String message = CommonMFCalls.MESSAGE;
            if (!message.startsWith("CAWA014E")) {
                if (message.length() == 0) {
                    RenameDatasetWizard wizard;
                    if (this.dataSet.getDsOrg().equalsIgnoreCase("VSAM") && !this.dataSet.getDsType().equalsIgnoreCase("T")) {
                        this.vsamDSN = (FMPVSAMDataset)this.dataSet;
                        wizard = new RenameDatasetWizard(datasetName, this.server, this.dataSet.getName(), this.vsamDSN.getCluster(), this.vsamDSN.getData(), this.vsamDSN.getIndex());
                    } else {
                        wizard = new RenameDatasetWizard(datasetName, this.server);
                    }
                    if (!(selection instanceof IStructuredSelection)) {
                        selection = null;
                    }
                    Shell shell = window.getShell();
                    TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(shell, (IWizard)wizard);
                    dialog.create();
                    dialog.open();
                    try {
                        IWorkbenchPage page = window.getActivePage();
                        IViewPart view = page.showView("com.ca.filemaster.views.directorylist");
                        view.setFocus();
                    }
                    catch (PartInitException partInitException) {}
                } else {
                    MessageDialog.openError(null, (String)"Rename error", (String)message);
                }
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
    }
}

