/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import com.ca.filemaster.Activator;
import com.ca.filemaster.common.FMNodeChild;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FMXMLProfile;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.filemaster.preferences.FMChangeLogPrefs;
import com.ca.filemaster.preferences.FMDefaultPrefs;
import com.ca.filemaster.preferences.FMParmFilePrefs;
import com.ca.filemaster.preferences.FMPrintPrefs;
import com.ca.filemaster.preferences.FileMasterPreferences;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.core.ITreeWrappedItem;
import com.ca.testingtools.core.NodeChild;
import com.ca.testingtools.core.Profile;
import com.ca.testingtools.core.ProfileNode;
import com.ca.testingtools.core.PropertyChangeManager;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FMServerTreeModel
extends PropertyChangeManager
implements IPropertyChangeListener {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected static final String NAME = "name";
    protected static final String TREE_FILE = "com.ca.testingtools.TREE_FILE";
    private static FMServerTreeModel model = null;
    private ArrayList<String> order = new ArrayList();
    private HashMap<String, IConfigurationElement> elementlist;
    private final ArrayList<TT_TreeItem> servers = new ArrayList();
    protected FMXMLProfile profiles;
    protected String XMLPathName;
    private static final int MOVEUP = 0;
    private static final int MOVEDOWN = 1;
    public HashMap<Integer, TT_TreeItem> dlistMap = new HashMap();

    public FMServerTreeModel() {
        this.loadPlugins();
        ScopedPreferenceStore store = (ScopedPreferenceStore)Activator.plugin.getPreferenceStore();
        String filename = store.getString(TREE_FILE);
        if (filename == null || filename.isEmpty()) {
            filename = FMServerTreeModel.setFileName();
        }
        IPath propertyPath = Platform.getStateLocation((Bundle)Activator.plugin.getBundle());
        this.XMLPathName = propertyPath.append(filename).toOSString();
        File pFile = new File(this.XMLPathName);
        if (pFile.exists()) {
            try {
                this.profiles = new FMXMLProfile(pFile);
                Element[] elementArray = this.profiles.getServers();
                int n = elementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Element server = elementArray[n2];
                    try {
                        this.insertServer(server);
                    }
                    catch (IOException e) {
                        this.log.log(Level.WARNING, e.getClass().getSimpleName(), e);
                    }
                    ++n2;
                }
            }
            catch (TTException e) {
                String newFileName = String.valueOf(filename) + ".bad";
                String newXMLPathName = propertyPath.append(newFileName).toOSString();
                File newFile = new File(newXMLPathName);
                pFile.renameTo(newFile);
                this.log.log(Level.WARNING, e.getErrorMessage());
                this.profiles = new FMXMLProfile();
            }
        } else {
            this.profiles = new FMXMLProfile();
        }
    }

    public static String setFileName() {
        ScopedPreferenceStore store = (ScopedPreferenceStore)Activator.plugin.getPreferenceStore();
        String filename = store.getDefaultString("DEFAULT_FM_FILE_NAME");
        SimpleDateFormat dflocaltime = new SimpleDateFormat("yyyyMMddHHmmss");
        String ts = dflocaltime.format(new Date());
        filename = filename.replace(".", "." + ts + ".");
        store.setValue(TREE_FILE, filename);
        try {
            store.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return filename;
    }

    protected void loadPlugins() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("com.ca.testingtools.profile");
        this.elementlist = new HashMap(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = element.getName();
            if (name.equals("seperator")) {
                this.locate(element);
            } else {
                this.elementlist.put(element.getAttribute("id"), element);
            }
            ++n2;
        }
        for (IConfigurationElement element : this.elementlist.values()) {
            this.locate(element);
        }
        Iterator<String> iterator = this.order.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (this.elementlist.containsKey(key)) continue;
            iterator.remove();
        }
    }

    public void save() {
        File backUppFile = null;
        try {
            backUppFile = new File(this.XMLPathName);
            this.profiles.toFile(this.XMLPathName);
            new File(this.XMLPathName);
        }
        catch (TTException e) {
            try {
                this.profiles = new FMXMLProfile(backUppFile);
                this.profiles.toFile(this.XMLPathName);
            }
            catch (TTException e1) {
                e1.printStackTrace();
            }
            this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
    }

    public void dispose() {
        for (TT_TreeItem item : this.servers) {
            item.removeListener((IPropertyChangeListener)this);
        }
        this.save();
        model = null;
    }

    public TT_TreeItem insertServer(Element serverElement) throws IOException {
        FileMasterServer server = new FileMasterServer(serverElement);
        server.addPropertyChangeListener(this);
        TT_TreeItem serverItem = new TT_TreeItem(serverElement, (ITreeWrappedItem)server, server.getName());
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "com.ca.testingtools.server", null, (Object)serverItem);
        this.updateModelPrefs(serverElement, server);
        this.servers.add(serverItem);
        this.dlistMap.put(server.getUUIDString().hashCode(), serverItem);
        this.firePropertyChange(event);
        this.insertDatasets(serverElement, serverItem);
        return serverItem;
    }

    protected void insertProfiles(Element serverElement, TT_TreeItem parent) {
        Element[] profileList;
        Element[] elementArray = profileList = this.profiles.getProfiles(serverElement);
        int n = profileList.length;
        int n2 = 0;
        while (n2 < n) {
            Element profile = elementArray[n2];
            this.insertProfile(parent, profile);
            ++n2;
        }
    }

    protected void insertDatasets(Element serverElement, TT_TreeItem parent) {
        Element[] datasetList;
        Element[] elementArray = datasetList = this.profiles.getDatasets(serverElement);
        int n = datasetList.length;
        int n2 = 0;
        while (n2 < n) {
            Element dataset = elementArray[n2];
            this.insertDataset(parent, dataset);
            ++n2;
        }
    }

    protected void insertMembers(Element datasetElement, TT_TreeItem parent) {
        Element[] memberList;
        Element[] elementArray = memberList = this.profiles.getMembers(datasetElement);
        int n = memberList.length;
        int n2 = 0;
        while (n2 < n) {
            Element member = elementArray[n2];
            this.insertMember(parent, member);
            ++n2;
        }
    }

    public TT_TreeItem insertProfile(TT_TreeItem parent, Element profile) {
        FileMasterServer server = (FileMasterServer)parent.getValue();
        String name = profile.getAttribute(NAME);
        Profile profileObject = new Profile();
        TT_TreeItem profileItem = new TT_TreeItem(profile, (ITreeWrappedItem)profileObject, name);
        parent.addChild(profileItem);
        for (String key : this.order) {
            IConfigurationElement nodeConfig = this.elementlist.get(key);
            ProfileNode node = null;
            try {
                node = (ProfileNode)nodeConfig.createExecutableExtension("class");
                node.setInitializationData(nodeConfig, "config", (Object)node);
                node.setInitializationData(nodeConfig, "server", (Object)server);
                String id = nodeConfig.getAttribute("id");
                Element profileNodeElement = this.profiles.getProfileNode(profile, id);
                if (profileNodeElement == null) {
                    profileNodeElement = this.createElement("profilenode");
                    profile.appendChild(profileNodeElement);
                }
                node.setInitializationData(nodeConfig, "settings", (Object)profileNodeElement);
                TT_TreeItem nodeItem = new TT_TreeItem(profileNodeElement, (ITreeWrappedItem)node, node.getName());
                node.setParent(nodeItem);
                profileItem.addChild(nodeItem);
                NodeList nodeChildren = profileNodeElement.getElementsByTagName("nodechild");
                int ix = 0;
                while (ix < nodeChildren.getLength()) {
                    this.insertNodeChild(nodeItem, (Element)nodeChildren.item(ix));
                    ++ix;
                }
            }
            catch (CoreException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
        }
        return profileItem;
    }

    public TT_TreeItem updateModel(TT_TreeItem parent, Element dataset) {
        String name = dataset.getAttribute(NAME);
        name = name.replace("%23", "#");
        name = name.replace("%24", "$");
        name = name.replace("%40", "@");
        String DSLength = dataset.getAttribute("DSLENGTH");
        String DSorg = dataset.getAttribute("DSORG");
        String FileType = dataset.getAttribute("FILETYPE");
        String Volume = dataset.getAttribute("VOLUME");
        String blkSize = dataset.getAttribute("BLKSIZE");
        FileMasterDataset datasetObject = null;
        FMPVSAMDataset vsamDatasetObject = null;
        TT_TreeItem datasetItem = null;
        if (DSorg.equals("VSAM") || FileType.startsWith("VSAM")) {
            vsamDatasetObject = new FMPVSAMDataset(parent);
            datasetItem = new TT_TreeItem(dataset, (ITreeWrappedItem)vsamDatasetObject);
            datasetItem = this.findObjectInTree((Object)((FMPVSAMDataset)datasetItem.getValue()), parent);
        } else {
            datasetObject = new FileMasterDataset(parent);
            datasetItem = new TT_TreeItem(dataset, (ITreeWrappedItem)datasetObject);
            datasetItem = this.findObjectInTree((Object)((FileMasterDataset)datasetItem.getValue()), parent);
        }
        FileMasterDataset fmDataSet = (FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class));
        fmDataSet.setName(name);
        fmDataSet.setFileType(FileType);
        fmDataSet.setVolume(Volume);
        fmDataSet.setDsOrg(DSorg);
        fmDataSet.setDsType(dataset.getAttribute("DSTYPE"));
        fmDataSet.setDSLength(DSLength);
        fmDataSet.setBlksize(blkSize);
        fmDataSet.setLrecl(dataset.getAttribute("LRECL"));
        fmDataSet.setExtents(dataset.getAttribute("EXTENTS"));
        fmDataSet.setDateCreated(dataset.getAttribute("DATECREATED"));
        fmDataSet.setDateReferenced(dataset.getAttribute("DATEREFERENCED"));
        fmDataSet.setExpirationDate(dataset.getAttribute("EXPDTDATE"));
        fmDataSet.setDSLength(dataset.getAttribute("DSLENGTH"));
        fmDataSet.setRecfm(dataset.getAttribute("RECFM"));
        fmDataSet.setTracks(dataset.getAttribute("TRACKS"));
        fmDataSet.setUnits(dataset.getAttribute("SPCUNITS"));
        fmDataSet.setPrimaryAlloc(dataset.getAttribute("SPCPRI"));
        fmDataSet.setSecondaryAlloc(dataset.getAttribute("SPCSEC"));
        fmDataSet.setUnitType(dataset.getAttribute("UNITTYPE"));
        fmDataSet.setUsedAllocUnit(dataset.getAttribute("USEDALLOCUnit"));
        fmDataSet.setUsedAllocValue(dataset.getAttribute("USEDALLOCValue"));
        fmDataSet.setAllocatedallocUnit(dataset.getAttribute("ALLOCATEDALOCUnit"));
        fmDataSet.setAllocatedallocValue(dataset.getAttribute("ALLOCATEDALOCValue"));
        fmDataSet.setExtentsAllocated(dataset.getAttribute("EXTENTSAllocated"));
        fmDataSet.setExtentsUsed(dataset.getAttribute("EXTENTSUsed"));
        fmDataSet.setDircMax(dataset.getAttribute("DIRCMax"));
        fmDataSet.setDircUsed(dataset.getAttribute("DIRCUsed"));
        fmDataSet.setNumMembers(dataset.getAttribute("NUMMembers"));
        if (DSorg.equals("VSAM")) {
            FMPVSAMDataset vsamFMDataSet = (FMPVSAMDataset)((Object)datasetItem.getAdapter(FMPVSAMDataset.class));
            vsamFMDataSet.setLength(dataset.getAttribute("KEY_LENGTH"));
            vsamFMDataSet.setOffset(dataset.getAttribute("KEY_POSITION"));
            vsamFMDataSet.setAverage(dataset.getAttribute("AVERAGE_RECORD_SIZE"));
            vsamFMDataSet.setMaximum(dataset.getAttribute("MAXIMUM_RECORD_SIZE"));
            vsamFMDataSet.setBufferSpace(dataset.getAttribute("BUFFER_SPACE"));
        }
        this.dlistMap.remove((String.valueOf(parent.getServer().getUUIDString()) + name).hashCode());
        this.dlistMap.put((String.valueOf(parent.getServer().getUUIDString()) + name).hashCode(), datasetItem);
        return datasetItem;
    }

    public TT_TreeItem insertDataset(TT_TreeItem parent, Element dataset) {
        String name = dataset.getAttribute(NAME);
        name = name.replace("%23", "#");
        name = name.replace("%24", "$");
        name = name.replace("%40", "@");
        String DSLength = dataset.getAttribute("DSLENGTH");
        String DSorg = dataset.getAttribute("DSORG");
        String FileType = dataset.getAttribute("FILETYPE");
        String Volume = dataset.getAttribute("VOLUME");
        String blkSize = dataset.getAttribute("BLKSIZE");
        FileMasterDataset datasetObject = null;
        FMPVSAMDataset vsamDatasetObject = null;
        TT_TreeItem datasetItem = null;
        if (DSorg.equals("VSAM") || FileType.startsWith("VSAM")) {
            vsamDatasetObject = new FMPVSAMDataset(parent);
            datasetItem = new TT_TreeItem(dataset, (ITreeWrappedItem)vsamDatasetObject);
        } else {
            datasetObject = new FileMasterDataset(parent);
            datasetItem = new TT_TreeItem(dataset, (ITreeWrappedItem)datasetObject);
        }
        FileMasterDataset fmDataSet = (FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class));
        fmDataSet.setName(name);
        fmDataSet.setFileType(FileType);
        fmDataSet.setVolume(Volume);
        fmDataSet.setDsOrg(DSorg);
        fmDataSet.setDsType(dataset.getAttribute("DSTYPE"));
        fmDataSet.setDSLength(DSLength);
        fmDataSet.setBlksize(blkSize);
        fmDataSet.setLrecl(dataset.getAttribute("LRECL"));
        fmDataSet.setExtents(dataset.getAttribute("EXTENTS"));
        fmDataSet.setDateCreated(dataset.getAttribute("DATECREATED"));
        fmDataSet.setDateReferenced(dataset.getAttribute("DATEREFERENCED"));
        fmDataSet.setExpirationDate(dataset.getAttribute("EXPDTDATE"));
        fmDataSet.setDSLength(dataset.getAttribute("DSLENGTH"));
        fmDataSet.setRecfm(dataset.getAttribute("RECFM"));
        fmDataSet.setTracks(dataset.getAttribute("TRACKS"));
        fmDataSet.setUnits(dataset.getAttribute("SPCUNITS"));
        fmDataSet.setPrimaryAlloc(dataset.getAttribute("SPCPRI"));
        fmDataSet.setSecondaryAlloc(dataset.getAttribute("SPCSEC"));
        fmDataSet.setUnitType(dataset.getAttribute("UNITTYPE"));
        fmDataSet.setUsedAllocUnit(dataset.getAttribute("USEDALLOCUnit"));
        fmDataSet.setUsedAllocValue(dataset.getAttribute("USEDALLOCValue"));
        fmDataSet.setAllocatedallocUnit(dataset.getAttribute("ALLOCATEDALOCUnit"));
        fmDataSet.setAllocatedallocValue(dataset.getAttribute("ALLOCATEDALOCValue"));
        fmDataSet.setExtentsAllocated(dataset.getAttribute("EXTENTSAllocated"));
        fmDataSet.setExtentsUsed(dataset.getAttribute("EXTENTSUsed"));
        fmDataSet.setDircMax(dataset.getAttribute("DIRCMax"));
        fmDataSet.setDircUsed(dataset.getAttribute("DIRCUsed"));
        fmDataSet.setNumMembers(dataset.getAttribute("NUMMembers"));
        if (DSorg.equals("VSAM")) {
            FMPVSAMDataset vsamFMDataSet = (FMPVSAMDataset)((Object)datasetItem.getAdapter(FMPVSAMDataset.class));
            vsamFMDataSet.setLength(dataset.getAttribute("KEY_LENGTH"));
            vsamFMDataSet.setOffset(dataset.getAttribute("KEY_POSITION"));
            vsamFMDataSet.setAverage(dataset.getAttribute("AVERAGE_RECORD_SIZE"));
            vsamFMDataSet.setMaximum(dataset.getAttribute("MAXIMUM_RECORD_SIZE"));
            vsamFMDataSet.setBufferSpace(dataset.getAttribute("BUFFER_SPACE"));
        }
        parent.addChild(datasetItem);
        this.dlistMap.put((String.valueOf(parent.getServer().getUUIDString()) + name).hashCode(), datasetItem);
        this.insertMembers(dataset, datasetItem);
        return datasetItem;
    }

    public TT_TreeItem insertMember(TT_TreeItem parent, Element member) {
        String name = member.getAttribute(NAME);
        String type = member.getAttribute("TYPE");
        FileMasterMember memberObject = new FileMasterMember(parent);
        TT_TreeItem memberItem = new TT_TreeItem(member, (ITreeWrappedItem)memberObject, name);
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setType(type);
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setSize(member.getAttribute("SIZE"));
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setAmode(member.getAttribute("AMODE"));
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setRmode(member.getAttribute("RMODE"));
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setLinkDate(member.getAttribute("LINK_DATE"));
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setLinkTime(member.getAttribute("LINK_TIME"));
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setReentrant(member.getAttribute("REENTRANT"));
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setReusable(member.getAttribute("REUSABLE"));
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setRefreshable(member.getAttribute("REFRESHABLE"));
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setAuthCode(member.getAttribute("AUTH_CODE"));
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setRecordCount(member.getAttribute("RECORD_COUNT"));
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setDateCreated(member.getAttribute("CREATED"));
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setDateChanged(member.getAttribute("CHANGED"));
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setTimeChanged(member.getAttribute("TIME_CHANGED"));
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setID(member.getAttribute("ID"));
        parent.addChild(memberItem);
        this.dlistMap.put((String.valueOf(parent.getServer().getUUIDString()) + parent.getName() + name).hashCode(), memberItem);
        return memberItem;
    }

    public TT_TreeItem insertNodeChild(TT_TreeItem parent, Element nodechild) {
        ProfileNode profileNode = (ProfileNode)parent.getValue();
        String name = nodechild.getAttribute(NAME);
        NodeChild nodechildObject = profileNode.buildChild();
        TT_TreeItem nodechildItem = new TT_TreeItem(nodechild, (ITreeWrappedItem)nodechildObject, name);
        parent.addChild(nodechildItem);
        return nodechildItem;
    }

    public TT_TreeItem findObject(Object object) {
        TT_TreeItem result = null;
        for (TT_TreeItem node : this.servers) {
            result = node.findValue(object);
            if (result != null) break;
        }
        return result;
    }

    public TT_TreeItem findObjectInTree(Object object, TT_TreeItem treeItem) {
        TT_TreeItem result = null;
        result = this.findObject(treeItem).findValue(object);
        return result;
    }

    public Element addServer(String name, String hostname, int port, String uuidString, String PreferenceIsSet, String protocol) throws Exception {
        Element top = this.profiles.getTop();
        Element serverElement = FMServerTreeModel.BuildElement(name, hostname, port, uuidString, PreferenceIsSet, protocol);
        top.appendChild(serverElement);
        return serverElement;
    }

    public Element addProfile(Element serverElement, String name) {
        Element profile = this.createElement("profile");
        profile.setAttribute(NAME, name);
        profile.setAttribute("UUID", UUID.randomUUID().toString());
        serverElement.appendChild(profile);
        return profile;
    }

    public Element addNodeChild(Element profileNodeElement, String name) {
        Element nodechild = this.createElement("nodechild");
        nodechild.setAttribute(NAME, name);
        nodechild.setAttribute("UUID", UUID.randomUUID().toString());
        profileNodeElement.appendChild(nodechild);
        return nodechild;
    }

    public Element addSession(Element profileNodeElement, String uuid, String type, String user) {
        Element nodechild = this.createElement("session");
        nodechild.setAttribute("uuid", uuid);
        nodechild.setAttribute("type", type);
        nodechild.setAttribute("user", user);
        profileNodeElement.appendChild(nodechild);
        return nodechild;
    }

    public Element updateAttributeS(Element datasetNodeElement, FileMasterDataset dataSet) {
        datasetNodeElement.setAttribute(NAME, dataSet.getName());
        datasetNodeElement.setAttribute("UUID", UUID.randomUUID().toString());
        datasetNodeElement.setAttribute("VOLUME", dataSet.getVolume());
        datasetNodeElement.setAttribute("FILETYPE", dataSet.getFileType());
        datasetNodeElement.setAttribute("DSLENGTH", dataSet.getDSLength());
        datasetNodeElement.setAttribute("DSORG", dataSet.getDsOrg());
        datasetNodeElement.setAttribute("DSLENGTH", dataSet.getDSLength());
        datasetNodeElement.setAttribute("DSTYPE", dataSet.getDsType());
        datasetNodeElement.setAttribute("BLKSIZE", dataSet.getBlksize());
        datasetNodeElement.setAttribute("DATECREATED", dataSet.getDateCreated());
        datasetNodeElement.setAttribute("DATEREFERENCED", dataSet.getDateReferenced());
        datasetNodeElement.setAttribute("EXPDTDATE", dataSet.getExpirationDate());
        datasetNodeElement.setAttribute("EXTENTS", dataSet.getExtents());
        datasetNodeElement.setAttribute("LRECL", dataSet.getLrecl());
        datasetNodeElement.setAttribute("RECFM", dataSet.getRecfm());
        datasetNodeElement.setAttribute("TRACKS", dataSet.getTracks());
        datasetNodeElement.setAttribute("SPCUNITS", dataSet.getUnits());
        datasetNodeElement.setAttribute("SPCPRI", dataSet.getPrimaryAlloc());
        datasetNodeElement.setAttribute("SPCSEC", dataSet.getSecondaryAlloc());
        datasetNodeElement.setAttribute("UNITTYPE", dataSet.getUnitType());
        datasetNodeElement.setAttribute("USEDALLOCUnit", dataSet.getUsedAllocUnit());
        datasetNodeElement.setAttribute("USEDALLOCValue", dataSet.getUsedAllocValue());
        datasetNodeElement.setAttribute("ALLOCATEDALOCUnit", dataSet.getAllocatedallocUnit());
        datasetNodeElement.setAttribute("ALLOCATEDALOCValue", dataSet.getAllocatedallocValue());
        datasetNodeElement.setAttribute("EXTENTSAllocated", dataSet.getExtentsAllocated());
        datasetNodeElement.setAttribute("EXTENTSUsed", dataSet.getExtentsUsed());
        datasetNodeElement.setAttribute("DIRCMax", dataSet.getDircMax());
        datasetNodeElement.setAttribute("DIRCUsed", dataSet.getDircUsed());
        datasetNodeElement.setAttribute("NUMMembers", dataSet.getNumMembers());
        if (dataSet instanceof FMPVSAMDataset) {
            datasetNodeElement.setAttribute("KEY_POSITION", ((FMPVSAMDataset)dataSet).getOffset());
            datasetNodeElement.setAttribute("KEY_LENGTH", ((FMPVSAMDataset)dataSet).getLength());
            datasetNodeElement.setAttribute("AVERAGE_RECORD_SIZE", ((FMPVSAMDataset)dataSet).getAverage());
            datasetNodeElement.setAttribute("MAXIMUM_RECORD_SIZE", ((FMPVSAMDataset)dataSet).getMaximum());
            datasetNodeElement.setAttribute("BUFFER_SPACE", ((FMPVSAMDataset)dataSet).getBufferSpace());
        }
        return datasetNodeElement;
    }

    public Element addDataset(Element datasetNodeElement, FileMasterDataset dataSet) {
        Element nodechild = this.createElement("datasetnode");
        nodechild.setAttribute(NAME, dataSet.getName());
        nodechild.setAttribute("UUID", UUID.randomUUID().toString());
        nodechild.setAttribute("VOLUME", dataSet.getVolume());
        nodechild.setAttribute("FILETYPE", dataSet.getFileType());
        nodechild.setAttribute("DSLENGTH", dataSet.getDSLength());
        nodechild.setAttribute("DSORG", dataSet.getDsOrg());
        nodechild.setAttribute("DSLENGTH", dataSet.getDSLength());
        nodechild.setAttribute("DSTYPE", dataSet.getDsType());
        nodechild.setAttribute("BLKSIZE", dataSet.getBlksize());
        nodechild.setAttribute("DATECREATED", dataSet.getDateCreated());
        nodechild.setAttribute("DATEREFERENCED", dataSet.getDateReferenced());
        nodechild.setAttribute("EXPDTDATE", dataSet.getExpirationDate());
        nodechild.setAttribute("EXTENTS", dataSet.getExtents());
        nodechild.setAttribute("LRECL", dataSet.getLrecl());
        nodechild.setAttribute("RECFM", dataSet.getRecfm());
        nodechild.setAttribute("TRACKS", dataSet.getTracks());
        nodechild.setAttribute("SPCUNITS", dataSet.getUnits());
        nodechild.setAttribute("SPCPRI", dataSet.getPrimaryAlloc());
        nodechild.setAttribute("SPCSEC", dataSet.getSecondaryAlloc());
        nodechild.setAttribute("UNITTYPE", dataSet.getUnitType());
        nodechild.setAttribute("USEDALLOCUnit", dataSet.getUsedAllocUnit());
        nodechild.setAttribute("USEDALLOCValue", dataSet.getUsedAllocValue());
        nodechild.setAttribute("ALLOCATEDALOCUnit", dataSet.getAllocatedallocUnit());
        nodechild.setAttribute("ALLOCATEDALOCValue", dataSet.getAllocatedallocValue());
        nodechild.setAttribute("EXTENTSAllocated", dataSet.getExtentsAllocated());
        nodechild.setAttribute("EXTENTSUsed", dataSet.getExtentsUsed());
        nodechild.setAttribute("DIRCMax", dataSet.getDircMax());
        nodechild.setAttribute("DIRCUsed", dataSet.getDircUsed());
        nodechild.setAttribute("NUMMembers", dataSet.getNumMembers());
        if (dataSet instanceof FMPVSAMDataset) {
            nodechild.setAttribute("KEY_POSITION", ((FMPVSAMDataset)dataSet).getOffset());
            nodechild.setAttribute("KEY_LENGTH", ((FMPVSAMDataset)dataSet).getLength());
            nodechild.setAttribute("AVERAGE_RECORD_SIZE", ((FMPVSAMDataset)dataSet).getAverage());
            nodechild.setAttribute("MAXIMUM_RECORD_SIZE", ((FMPVSAMDataset)dataSet).getMaximum());
            nodechild.setAttribute("BUFFER_SPACE", ((FMPVSAMDataset)dataSet).getBufferSpace());
        }
        datasetNodeElement.appendChild(nodechild);
        return nodechild;
    }

    public Element addDataset(Element datasetNodeElement, String name, String volume, String fileType, String DSLength, String DSOrg) {
        Element nodechild = this.createElement("datasetnode");
        nodechild.setAttribute(NAME, name);
        nodechild.setAttribute("UUID", UUID.randomUUID().toString());
        nodechild.setAttribute("VOLUME", volume);
        nodechild.setAttribute("FILETYPE", fileType);
        nodechild.setAttribute("DSLENGTH", String.valueOf(DSLength));
        nodechild.setAttribute("DSORG", DSOrg);
        datasetNodeElement.appendChild(nodechild);
        return nodechild;
    }

    public Element addMember(Element memberNodeElement, FileMasterMember fileMasterMember) {
        Element nodechild = this.createElement("membernode");
        nodechild.setAttribute(NAME, fileMasterMember.getName());
        nodechild.setAttribute("TYPE", fileMasterMember.getType());
        nodechild.setAttribute("UUID", UUID.randomUUID().toString());
        nodechild.setAttribute("SIZE", fileMasterMember.getSize());
        nodechild.setAttribute("AMODE", fileMasterMember.getAmode());
        nodechild.setAttribute("RMODE", fileMasterMember.getRmode());
        nodechild.setAttribute("LINK_DATE", fileMasterMember.getLinkDate());
        nodechild.setAttribute("LINK_TIME", fileMasterMember.getLinkTime());
        nodechild.setAttribute("REENTRANT", fileMasterMember.getReentrant());
        nodechild.setAttribute("REUSABLE", fileMasterMember.getReusable());
        nodechild.setAttribute("REFRESHABLE", fileMasterMember.getRefreshable());
        nodechild.setAttribute("RECORD_COUNT", fileMasterMember.getRecordCount());
        nodechild.setAttribute("CREATED", fileMasterMember.getDateCreated());
        nodechild.setAttribute("CHANGED", fileMasterMember.getDateChanged());
        nodechild.setAttribute("TIME_CHANGED", fileMasterMember.getTimeChanged());
        nodechild.setAttribute("ID", fileMasterMember.getID());
        memberNodeElement.appendChild(nodechild);
        return nodechild;
    }

    public Element addMember(Element memberNodeElement, String name, String type) {
        Element nodechild = this.createElement("membernode");
        nodechild.setAttribute(NAME, name);
        nodechild.setAttribute("type", type);
        nodechild.setAttribute("UUID", UUID.randomUUID().toString());
        memberNodeElement.appendChild(nodechild);
        return nodechild;
    }

    public TT_TreeItem updateModelPrefs(Element serverElement, FileMasterServer server) {
        boolean confirmDeleteDataset;
        boolean confirmDeleteMember = serverElement.getAttribute("ConfirmDeleteMember").equalsIgnoreCase("true");
        boolean bl = confirmDeleteDataset = serverElement.getAttribute("ConfirmDeleteDataset").equalsIgnoreCase("true");
        boolean useDasdUnit = serverElement.getAttribute("UseDasdUnit").isEmpty() ? true : serverElement.getAttribute("UseDasdUnit").equalsIgnoreCase("true");
        String dASD_UNIT = "DASD_UNIT".isEmpty() ? "SYSDA" : serverElement.getAttribute("DASD_UNIT");
        String sMS_Storage = serverElement.getAttribute("SMS_Storage");
        String sizeInCYL = serverElement.getAttribute("SizeInCYL").isEmpty() ? "0" : serverElement.getAttribute("SizeInCYL");
        FMDefaultPrefs fmDefaultPrefs = new FMDefaultPrefs(confirmDeleteMember, confirmDeleteDataset, useDasdUnit, dASD_UNIT, sMS_Storage, sizeInCYL);
        String dSNLists = serverElement.getAttribute("DSNLists");
        String selectionCriteria = serverElement.getAttribute("SelectionCriteria");
        String reformatControl = serverElement.getAttribute("ReformatControl");
        String customerRecordLayout = serverElement.getAttribute("CustomerRecordLayout");
        FMParmFilePrefs fmParmFilesPrefs = new FMParmFilePrefs(dSNLists, selectionCriteria, reformatControl, customerRecordLayout);
        String changeLog_DSN = serverElement.getAttribute("ChangeLog_DSN");
        boolean useVolSer = serverElement.getAttribute("UseVolSer").equalsIgnoreCase("true");
        String volume_Serial = serverElement.getAttribute("Volume_Serial");
        String generic_Unit = serverElement.getAttribute("Generic_Unit");
        boolean changeLog_Forced = serverElement.getAttribute("ChangeLog_Force").equalsIgnoreCase("true");
        int primaryAlloc = 0;
        int secondaryAlloc = 0;
        if (!serverElement.getAttribute("PrimaryAlloc").isEmpty()) {
            primaryAlloc = Integer.parseInt(serverElement.getAttribute("PrimaryAlloc"));
        }
        if (!serverElement.getAttribute("SecondaryAlloc").isEmpty()) {
            secondaryAlloc = Integer.parseInt(serverElement.getAttribute("SecondaryAlloc"));
        }
        FMChangeLogPrefs fmChangeLogPrefs = new FMChangeLogPrefs(changeLog_DSN, useVolSer, volume_Serial, generic_Unit, primaryAlloc, secondaryAlloc, changeLog_Forced);
        String sysoutClass = serverElement.getAttribute("SysoutClass");
        int noCopies = 0;
        boolean definePrintDef = serverElement.getAttribute("DefinePrintDest").equalsIgnoreCase("true");
        String printDSN = serverElement.getAttribute("PrintDSN");
        String printMember = serverElement.getAttribute("PrintMember");
        String destPrinter = serverElement.getAttribute("DestPrinter");
        String extJESNode = serverElement.getAttribute("ExtJESNode");
        String userJESNode = serverElement.getAttribute("UserJESNode");
        String sysoutWriter = serverElement.getAttribute("SysoutWriter");
        int printDestSel = 1;
        if (!serverElement.getAttribute("NoCopies").isEmpty()) {
            noCopies = Integer.parseInt(serverElement.getAttribute("NoCopies"));
        }
        if (!serverElement.getAttribute("PrintDestSel").isEmpty()) {
            printDestSel = Integer.parseInt(serverElement.getAttribute("PrintDestSel"));
        }
        String dataSetDisposition = "SHR";
        if (!serverElement.getAttribute("DataSetDisposition").isEmpty()) {
            dataSetDisposition = serverElement.getAttribute("DataSetDisposition");
        }
        String newAllocationType = serverElement.getAttribute("NewAllocationType");
        FMPrintPrefs fmPrintPrefs = new FMPrintPrefs(sysoutClass, noCopies, definePrintDef, printDSN, printMember, destPrinter, extJESNode, userJESNode, sysoutWriter, printDestSel, dataSetDisposition, newAllocationType);
        FileMasterPreferences fmPrefs = new FileMasterPreferences(fmDefaultPrefs, fmParmFilesPrefs, fmChangeLogPrefs, fmPrintPrefs);
        server.setFmpPreferences(fmPrefs);
        return this.findObject((Object)server);
    }

    public Element updatePrefs(Element serverElement, boolean ConfirmDeleteDataset, boolean ConfirmDeleteMember, boolean UseDasdUnit, String DASD_UNIT, String SMS_Storage, String SizeInCYL, String DSNLists, String SelectionCriteria, String ReformatControl, String CustomerRecordLayout, String ChangeLog_DSN, boolean UseVolSer, String Volume_Serial, String Generic_Unit, int PrimaryAlloc, int SecondaryAlloc, boolean ChangeLogForce, String PrintDSN, String PrintMember, String DestPrinter, String ExtJESNode, String UserJESNode, String SysoutWriter, int NoCopies, String SysoutClass, boolean DefinePrintDest, int printDestSel, String dataSetDisposition, String newAllocationType) {
        serverElement.setAttribute("ConfirmDeleteMember", ConfirmDeleteMember ? "true" : "false");
        serverElement.setAttribute("ConfirmDeleteDataset", ConfirmDeleteDataset ? "true" : "false");
        serverElement.setAttribute("UseDasdUnit", UseDasdUnit ? "true" : "false");
        serverElement.setAttribute("DASD_UNIT", DASD_UNIT);
        serverElement.setAttribute("SMS_Storage", SMS_Storage);
        serverElement.setAttribute("SizeInCYL", SizeInCYL);
        serverElement.setAttribute("DSNLists", DSNLists);
        serverElement.setAttribute("SelectionCriteria", SelectionCriteria);
        serverElement.setAttribute("ReformatControl", ReformatControl);
        serverElement.setAttribute("CustomerRecordLayout", CustomerRecordLayout);
        serverElement.setAttribute("ChangeLog_DSN", ChangeLog_DSN);
        serverElement.setAttribute("UseVolSer", UseVolSer ? "true" : "false");
        serverElement.setAttribute("Volume_Serial", Volume_Serial);
        serverElement.setAttribute("Generic_Unit", Generic_Unit);
        serverElement.setAttribute("PrimaryAlloc", Integer.toString(PrimaryAlloc));
        serverElement.setAttribute("SecondaryAlloc", Integer.toString(SecondaryAlloc));
        serverElement.setAttribute("ChangeLog_Force", ChangeLogForce ? "true" : "false");
        serverElement.setAttribute("PrintDSN", PrintDSN);
        serverElement.setAttribute("PrintMember", PrintMember);
        serverElement.setAttribute("DestPrinter", DestPrinter);
        serverElement.setAttribute("ExtJESNode", ExtJESNode);
        serverElement.setAttribute("UserJESNode", UserJESNode);
        serverElement.setAttribute("SysoutWriter", SysoutWriter);
        serverElement.setAttribute("NoCopies", Integer.toString(NoCopies));
        serverElement.setAttribute("SysoutClass", SysoutClass);
        serverElement.setAttribute("DefinePrintDest", DefinePrintDest ? "true" : "false");
        serverElement.setAttribute("PrintDestSel", Integer.toString(printDestSel));
        serverElement.setAttribute("DataSetDisposition", dataSetDisposition);
        serverElement.setAttribute("NewAllocationType", newAllocationType);
        return serverElement;
    }

    public void updateJCLPrefs(Element serverElement, String JCL) {
        if (serverElement.getElementsByTagName("JCL").getLength() == 0) {
            Element jclELement = this.createElement("JCL");
            jclELement.setTextContent(JCL);
            serverElement.appendChild(jclELement);
        } else {
            serverElement.getElementsByTagName("JCL").item(0).setTextContent(JCL);
        }
    }

    public Element updateChangelogInfo(Element serverElement, int changeLogNum, String changeLogOpt) {
        serverElement.setAttribute("clognum", String.valueOf(changeLogNum));
        serverElement.setAttribute("clogpopt", changeLogOpt);
        return serverElement;
    }

    public static Element BuildElement(String name, String hostname, int port, String uuidString, String PreferenceIsSet, String protocol) {
        Element element = FMServerTreeModel.getInstance().createElement("com.ca.testingtools.server");
        if (uuidString == null || uuidString.length() == 0) {
            uuidString = UUID.randomUUID().toString();
        }
        element.setAttribute("Name", name);
        element.setAttribute("Host", hostname);
        element.setAttribute("Port", String.valueOf(port));
        element.setAttribute("UUID", uuidString);
        element.setAttribute("PreferenceIsSet", PreferenceIsSet);
        element.setAttribute("Protocol", protocol);
        return element;
    }

    public TT_TreeItem removeItem(Object element) {
        int i;
        String eventkey;
        TT_TreeItem item = ((TT_TreeItem)element).getValue() instanceof FileMasterMember ? this.dlistMap.get((String.valueOf(((TT_TreeItem)element).getServer().getUUIDString()) + ((TT_TreeItem)element).getParent().getName() + ((TT_TreeItem)element).getName()).hashCode()) : (((TT_TreeItem)element).getValue() instanceof FileMasterDataset ? this.dlistMap.get((String.valueOf(((TT_TreeItem)element).getServer().getUUIDString()) + ((TT_TreeItem)element).getName()).hashCode()) : this.dlistMap.get(((TT_TreeItem)element).getServer().getUUIDString().hashCode()));
        if (item == null) {
            return null;
        }
        TT_TreeItem parent = item.getParent();
        ITreeWrappedItem value = item.getValue();
        String string = eventkey = value == null ? item.getClass().getSimpleName() : value.getClass().getSimpleName();
        if (((TT_TreeItem)element).getValue() instanceof FileMasterMember) {
            this.dlistMap.remove((String.valueOf(((TT_TreeItem)element).getServer().getUUIDString()) + ((TT_TreeItem)element).getParent().getName() + ((TT_TreeItem)element).getName()).hashCode());
        } else {
            int child;
            if (((TT_TreeItem)element).getValue() instanceof FileMasterServer) {
                child = 0;
                while (child < ((TT_TreeItem)element).getChildren().length) {
                    FileMasterDataset ds = (FileMasterDataset)((TT_TreeItem)((TT_TreeItem)element).getChildren()[child]).getValue();
                    int grandChild = 0;
                    while (grandChild < ((TT_TreeItem)((TT_TreeItem)element).getChildren()[child]).getChildren().length) {
                        FileMasterMember mem = (FileMasterMember)((TT_TreeItem)((TT_TreeItem)((TT_TreeItem)element).getChildren()[child]).getChildren()[grandChild]).getValue();
                        this.dlistMap.remove((String.valueOf(((TT_TreeItem)element).getServer().getUUIDString()) + ds.getName() + mem.getName()).hashCode());
                        ++grandChild;
                    }
                    this.dlistMap.remove((String.valueOf(((TT_TreeItem)element).getServer().getUUIDString()) + ds.getName()).hashCode());
                    ++child;
                }
            }
            if (((TT_TreeItem)element).getValue() instanceof FileMasterDataset) {
                child = 0;
                while (child < ((TT_TreeItem)element).getChildren().length) {
                    FileMasterMember mem = (FileMasterMember)((TT_TreeItem)((TT_TreeItem)element).getChildren()[child]).getValue();
                    this.dlistMap.remove((String.valueOf(((TT_TreeItem)element).getServer().getUUIDString()) + ((TT_TreeItem)element).getName() + mem.getName()).hashCode());
                    ++child;
                }
            }
            this.dlistMap.remove((String.valueOf(((TT_TreeItem)element).getServer().getUUIDString()) + ((TT_TreeItem)element).getName()).hashCode());
        }
        item.delete();
        if (parent == null) {
            i = this.indexOf(item);
            if (this.servers.size() > 0) {
                return this.servers.remove(i);
            }
        } else {
            i = this.indexOf(item) - 1;
            parent.removeChild(item);
            if (i < parent.getChildren().length && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i];
            }
            if (parent.getChildren().length > 0 && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i - 1];
            }
            return parent;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, eventkey, element, null);
        this.firePropertyChange(event);
        return null;
    }

    public TT_TreeItem removeItem(Object element, TT_TreeItem elementParent) {
        TT_TreeItem item = this.findObjectInTree(element, elementParent);
        if (item == null) {
            return null;
        }
        TT_TreeItem parent = item.getParent();
        ITreeWrappedItem value = item.getValue();
        String eventkey = value == null ? item.getClass().getSimpleName() : value.getClass().getSimpleName();
        item.delete();
        if (parent == null) {
            int i = this.indexOf(item);
            if (this.servers.size() > 0) {
                return this.servers.remove(i);
            }
        } else {
            int i = this.indexOf(item) - 1;
            parent.removeChild(item);
            if (i < parent.getChildren().length && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i];
            }
            if (parent.getChildren().length > 0 && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i - 1];
            }
            return parent;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, eventkey, element, null);
        this.firePropertyChange(event);
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.firePropertyChange(event);
    }

    public static synchronized FMServerTreeModel getInstance() {
        if (model == null) {
            model = new FMServerTreeModel();
        }
        return model;
    }

    public FileMasterServer getServer(String name) {
        for (TT_TreeItem item : this.servers) {
            FileMasterServer server = (FileMasterServer)item.getValue();
            if (server.getUUIDString().equals(name)) {
                return server;
            }
            if (!server.getName().equalsIgnoreCase(name)) continue;
            return server;
        }
        return null;
    }

    private void locate(IConfigurationElement element) {
        Position position;
        String name = element.getName();
        boolean seperator = "seperator".equals(name);
        String ID = element.getAttribute(seperator ? NAME : "id");
        String menuid = element.getAttribute("menuid");
        try {
            position = Position.valueOf(element.getAttribute("menulocation"));
        }
        catch (Exception e) {
            position = Position.last;
        }
        switch (position) {
            case first: {
                this.order.add(0, ID);
                break;
            }
            case last: {
                this.order.add(ID);
                break;
            }
            case before: {
                int ix = this.order.indexOf(menuid);
                if (ix == -1 || ix > this.order.size()) {
                    this.order.add(ID);
                    break;
                }
                this.order.add(ix, ID);
                break;
            }
            case after: {
                int ix = this.order.indexOf(menuid);
                if (ix == -1 || ix >= this.order.size()) {
                    this.order.add(ID);
                    break;
                }
                this.order.add(ix + 1, ID);
            }
        }
    }

    public FMXMLProfile getProfiles() {
        return this.profiles;
    }

    public Element createElement(String name) {
        return this.profiles.createElement(name);
    }

    public TT_TreeItem[] getServers() {
        return this.servers.toArray(new TT_TreeItem[this.servers.size()]);
    }

    public String getXMLPathName() {
        return this.XMLPathName;
    }

    public int indexOf(TT_TreeItem item) {
        TT_TreeItem parent = item.getParent();
        if (parent == null) {
            return this.servers.indexOf(item);
        }
        TT_TreeItem[] childs = (TT_TreeItem[])parent.getChildren();
        int i = 0;
        while (i < childs.length) {
            if (childs[i].equals((Object)item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public TT_TreeItem reposition(Object element, int direction) {
        FMNodeChild itemObject = null;
        TT_TreeItem item = this.findObject(element);
        boolean isdataset = item.getParent(FileMasterMember.class) == null;
        int totalItems = item.getParent().getChildren().length;
        int index = this.indexOf(item);
        if (direction == 0 && index > 0 || direction == 1 && index < totalItems - 1) {
            TT_TreeItem newItem;
            TT_TreeItem oldItem;
            TT_TreeItem parent = item.getParent();
            FileMasterServer server = (FileMasterServer)item.getServer();
            TT_TreeItem[] children = new TT_TreeItem[parent.getChildren().length];
            itemObject = isdataset ? new FileMasterDataset(parent) : new FileMasterMember(parent);
            int i = 0;
            while (i < parent.getChildren().length) {
                if (isdataset) {
                    children[i] = new TT_TreeItem(((TT_TreeItem)parent.getChildren()[i]).getElement(), (ITreeWrappedItem)itemObject);
                    ((FileMasterDataset)children[i].getValue()).setDsOrg(((FileMasterDataset)((TT_TreeItem)parent.getChildren()[i]).getValue()).getDsOrg());
                    int j = 0;
                    while (j < ((TT_TreeItem)parent.getChildren()[i]).getChildren().length) {
                        FileMasterMember memberObject = new FileMasterMember((TT_TreeItem)parent.getChildren()[i]);
                        children[i].addChild(new TT_TreeItem(((TT_TreeItem)((TT_TreeItem)parent.getChildren()[i]).getChildren()[j]).getElement(), (ITreeWrappedItem)memberObject));
                        ++j;
                    }
                } else {
                    children[i] = new TT_TreeItem(((TT_TreeItem)parent.getChildren()[i]).getElement(), (ITreeWrappedItem)((FileMasterMember)itemObject));
                }
                children[i].setName(((TT_TreeItem)parent.getChildren()[i]).getName());
                children[i].setValue(((TT_TreeItem)parent.getChildren()[i]).getValue());
                ++i;
            }
            if (direction == 0) {
                oldItem = children[index - 1];
                children[index - 1] = newItem = children[index];
                children[index] = oldItem;
            } else {
                oldItem = children[index + 1];
                children[index + 1] = newItem = children[index];
                children[index] = oldItem;
            }
            int dsnCount = 0;
            while (dsnCount < children.length) {
                this.removeItem(children[dsnCount].getValue(), parent);
                ++dsnCount;
            }
            try {
                Element datasetElement = null;
                Element memberElement = null;
                TT_TreeItem treeItem = this.findObject((Object)server);
                int dsnCount2 = 0;
                while (dsnCount2 < children.length) {
                    if (isdataset) {
                        datasetElement = this.addDataset(this.getServer(parent.getName()).getElement(), ((FileMasterDataset)((Object)children[dsnCount2].getAdapter(FileMasterDataset.class))).getName(), ((FileMasterDataset)((Object)children[dsnCount2].getAdapter(FileMasterDataset.class))).getVolume(), ((FileMasterDataset)((Object)children[dsnCount2].getAdapter(FileMasterDataset.class))).getFileType(), ((FileMasterDataset)((Object)children[dsnCount2].getAdapter(FileMasterDataset.class))).getDSLength(), ((FileMasterDataset)((Object)children[dsnCount2].getAdapter(FileMasterDataset.class))).getDsOrg());
                        int memCount = 0;
                        while (memCount < children[dsnCount2].getChildren().length) {
                            memberElement = this.addMember(datasetElement, ((FileMasterMember)((Object)((TT_TreeItem)children[dsnCount2].getChildren()[memCount]).getAdapter(FileMasterMember.class))).getName(), ((FileMasterMember)((Object)((TT_TreeItem)children[dsnCount2].getChildren()[memCount]).getAdapter(FileMasterMember.class))).getType());
                            ++memCount;
                        }
                        if (direction == 0) {
                            if (dsnCount2 == index - 1) {
                                item = this.insertDataset(treeItem, datasetElement);
                            } else {
                                this.insertDataset(treeItem, datasetElement);
                            }
                        } else if (dsnCount2 == index + 1) {
                            item = this.insertDataset(treeItem, datasetElement);
                        } else {
                            this.insertDataset(treeItem, datasetElement);
                        }
                    } else {
                        memberElement = this.addMember(parent.getElement(), ((FileMasterMember)((Object)children[dsnCount2].getAdapter(FileMasterMember.class))).getName(), ((FileMasterMember)((Object)children[dsnCount2].getAdapter(FileMasterMember.class))).getType());
                        if (direction == 0) {
                            if (dsnCount2 == index - 1) {
                                item = this.insertMember(parent, memberElement);
                            } else {
                                this.insertMember(parent, memberElement);
                            }
                        } else if (dsnCount2 == index + 1) {
                            item = this.insertMember(parent, memberElement);
                        } else {
                            this.insertMember(parent, memberElement);
                        }
                    }
                    ++dsnCount2;
                }
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, e.getClass().getSimpleName(), e);
            }
            this.save();
        }
        return item;
    }

    public boolean isActiveView(IWorkbenchPage activePage, IViewPart view) {
        IWorkbenchPart activeView = activePage.getActivePart();
        return activeView == null ? false : activeView.equals(view);
    }

    public ArrayList<FileMasterSession> getSessions(FileMasterServer server) {
        ArrayList<FileMasterSession> fmSessions = new ArrayList<FileMasterSession>();
        int count = 0;
        while (count < this.profiles.getSessions(server.getElement()).length) {
            FileMasterSession fmSession = new FileMasterSession(this.profiles.getSessions(server.getElement())[count].getAttribute("uuid"), this.profiles.getSessions(server.getElement())[count].getAttribute("type"), this.profiles.getSessions(server.getElement())[count].getAttribute("user"));
            fmSessions.add(fmSession);
            ++count;
        }
        return fmSessions;
    }

    public Element updateserver(Element serverElement, TTServer server, String PreferenceIsSet) {
        serverElement.setAttribute("PreferenceIsSet", PreferenceIsSet);
        return serverElement;
    }

    protected static enum Position {
        first,
        last,
        before,
        after;

    }
}

