/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.views.directorylist;

import com.ca.filemaster.common.ContextSwitch;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.views.directorylist.DirectoryListDoubleClickListener;
import com.ca.filemaster.views.directorylist.DirectoryListViewComparator;
import com.ca.filemaster.views.directorylist.DirectoryListViewContentProvider;
import com.ca.filemaster.views.directorylist.DirectoryListViewLabelProvider;
import com.ca.filemaster.views.directorylist.DirectoryListViewPatternFilter;
import com.ca.testingtools.core.ServerStatusJob;
import com.ca.testingtools.core.TT_TreeItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class DirectoryListView
extends ViewPart
implements IPropertyChangeListener {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    public static final String ID = "com.ca.filemaster.views.directorylist";
    public static final String CONTEXT_HELP_ID = "com.ca.filemaster.help.directorylistview";
    private static final boolean sortview = true;
    private TreeViewer viewer;
    private boolean show = true;
    private MenuManager menuMgr;
    private FMServerTreeModel model = FMServerTreeModel.getInstance();

    public void createPartControl(Composite parent) {
        DirectoryListViewPatternFilter filter = new DirectoryListViewPatternFilter();
        FilteredTree tree = new FilteredTree(parent, 68354, (PatternFilter)filter, false);
        this.viewer = tree.getViewer();
        DirectoryListViewContentProvider contentprovider = new DirectoryListViewContentProvider(this);
        DirectoryListViewLabelProvider labelProvider = new DirectoryListViewLabelProvider(tree);
        DirectoryListDoubleClickListener doubleClickListener = new DirectoryListDoubleClickListener();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
        this.viewer.setContentProvider((IContentProvider)contentprovider);
        this.viewer.setComparator((ViewerComparator)new DirectoryListViewComparator());
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.addDoubleClickListener((IDoubleClickListener)doubleClickListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.menuMgr = new MenuManager();
        this.menuMgr.add((IContributionItem)new GroupMarker("additions"));
        if (this.show) {
            this.menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    DirectoryListView.this.show = false;
                    DirectoryListView.this.menuMgr.removeAll();
                }
            });
        }
        this.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.viewer);
        Control control = this.viewer.getControl();
        Menu menu = this.menuMgr.createContextMenu(control);
        control.setMenu(menu);
        TT_TreeItem[] servers = this.model.getServers();
        this.viewer.setInput((Object)servers);
        this.viewer.collapseAll();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        TT_TreeItem[] tT_TreeItemArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            TT_TreeItem item = tT_TreeItemArray[n2];
            ServerStatusJob job = new ServerStatusJob(item);
            job.schedule();
            ++n2;
        }
        this.hookDoubleClickCommand();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void hookDoubleClickCommand() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IHandlerService handlerService = (IHandlerService)DirectoryListView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.ca.filemaster.commands.openfasteditor", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void setFocus() {
        ContextSwitch.activate("com.ca.filemaster");
        this.viewer.getControl().setFocus();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void propertyChange(PropertyChangeEvent event) {
        Display display;
        Object source = event.getSource();
        final TT_TreeItem item = this.model.findObject(source);
        Object newValue = event.getNewValue();
        TT_TreeItem[] tT_TreeItemArray = this.model.getServers();
        int n = tT_TreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TT_TreeItem itemRefresh = tT_TreeItemArray[n2];
            ServerStatusJob job = new ServerStatusJob(itemRefresh);
            job.schedule();
            ++n2;
        }
        if (source instanceof FileMasterServer) {
            if (((FileMasterServer)((Object)source)).getStatusText() == " Conection Refuse" && ((FileMasterServer)((Object)source)).getStatus() == 11) {
                ((FileMasterServer)((Object)source)).setStatusText(11, " Conection Refuse");
            }
            if (((FileMasterServer)((Object)source)).getStatusText() == " Unknown host" && ((FileMasterServer)((Object)source)).getStatus() == 12) {
                ((FileMasterServer)((Object)source)).setStatusText(12, "Unknown host");
            }
            if (((FileMasterServer)((Object)source)).getStatus() == 3) {
                ((FileMasterServer)((Object)source)).setStatusText(3, "Active");
            }
        }
        if (item != null && newValue != null && (display = Display.getDefault()) != null && !this.viewer.getControl().isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DirectoryListView.this.viewer.refresh((Object)item, true);
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        TT_TreeItem[] tT_TreeItemArray = this.model.getServers();
        int n = tT_TreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TT_TreeItem server = tT_TreeItemArray[n2];
            server.removeListener((IPropertyChangeListener)this);
            ++n2;
        }
    }
}

