/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import com.ca.filemaster.common.CRLClass;
import com.ca.filemaster.common.FMLayoutTreeModel;
import com.ca.filemaster.common.FieldNameContentProvider;
import com.ca.filemaster.common.FieldNameLabelProvider;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterLayout;
import com.ca.filemaster.common.FileMasterLayoutField;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.FormatLabelProvider;
import com.ca.filemaster.common.LengthLabelProvider;
import com.ca.filemaster.common.MessageLabelProvider;
import com.ca.filemaster.common.PosLabelProvider;
import com.ca.filemaster.common.TypeLabelProvider;
import com.ca.filemaster.runners.RunGetViewLayout;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericUpdatePage
extends FileMasterWizard
implements SelectionListener {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.viewLayoutPage";
    private Composite container;
    private Composite layCompsite;
    private Label RecordLayoutLabel;
    private Text RecordLayoutData;
    private Combo datasetComboPage1;
    private Combo memberComboPage1;
    private String datasetView;
    private String memberview;
    private TableViewer tableViewer;
    private boolean isDirectoryListCaller;
    private static final int FieldName = 0;
    private static final int Position = 1;
    private static final int Type = 2;
    private static final int Format = 3;
    private static final int Length = 4;
    private static final int Message = 5;
    private FMLayoutTreeModel model = FMLayoutTreeModel.getInstance();
    protected String fieldName;
    private FileMasterDataset dataset;
    private FileMasterMember member;
    private FileMasterServer server;
    private TreeViewer treeViewer;
    private Tree tree;
    private String pageName;
    private ArrayList<Object> fmLayoutList = new ArrayList();
    private String topLayoutName = "";
    private boolean occursField = true;
    CRLClass.LayoutField selectedLayoutField;

    public GenericUpdatePage(String pageName, FileMasterServer server, String datasetComboPage1, String memberComboPage1, String topLayoutName) {
        super(pageName);
        this.pageName = pageName;
        this.setTitle(pageName);
        this.datasetView = datasetComboPage1;
        this.memberview = memberComboPage1;
        this.topLayoutName = topLayoutName;
        this.server = server;
        this.selectedLayoutField = null;
    }

    public GenericUpdatePage(String pageName, FileMasterServer server, String datasetComboPage1, String memberComboPage1, String topLayoutName, boolean occursField) {
        super(pageName);
        this.pageName = pageName;
        this.setTitle(pageName);
        this.datasetView = datasetComboPage1;
        this.memberview = memberComboPage1;
        this.topLayoutName = topLayoutName;
        this.server = server;
        this.occursField = occursField;
        this.selectedLayoutField = null;
    }

    public GenericUpdatePage(String pageName, FileMasterServer server, String datasetComboPage1, String memberComboPage1, String topLayoutName, boolean occursField, CRLClass.LayoutField selectedLayoutField) {
        super(pageName);
        this.pageName = pageName;
        this.setTitle(pageName);
        this.datasetView = datasetComboPage1;
        this.memberview = memberComboPage1;
        this.topLayoutName = topLayoutName;
        this.server = server;
        this.occursField = occursField;
        this.selectedLayoutField = selectedLayoutField;
    }

    public GenericUpdatePage(String pageName, FileMasterServer server, String datasetComboPage1, String memberComboPage1, String topLayoutName, CRLClass.LayoutField selectedLayoutField) {
        super(pageName);
        this.pageName = pageName;
        this.setTitle(pageName);
        this.datasetView = datasetComboPage1;
        this.memberview = memberComboPage1;
        this.topLayoutName = topLayoutName;
        this.server = server;
        this.selectedLayoutField = selectedLayoutField;
    }

    @Override
    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.viewLayoutPage");
        this.layCompsite = new Composite(this.container, 0);
        this.layCompsite.setLayout((Layout)new GridLayout(2, false));
        this.RecordLayoutLabel = new Label(this.layCompsite, 0);
        this.RecordLayoutLabel.setText("&Record layout:");
        GridData gd_RecordLayoutLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.RecordLayoutLabel.setLayoutData((Object)gd_RecordLayoutLabel);
        this.RecordLayoutData = new Text(this.layCompsite, 8);
        if (this.datasetView != null) {
            this.RecordLayoutData.setText(String.valueOf(this.datasetView) + "(" + this.memberview + ")");
        } else {
            this.RecordLayoutData.setText(String.valueOf(this.datasetComboPage1.getText()) + "(" + this.memberComboPage1.getText() + ")");
        }
        GridData gd_RecordLayoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.RecordLayoutData.setLayoutData((Object)gd_RecordLayoutData);
        this.createViewer(this.container);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GenericUpdatePage.this.setPageComplete(GenericUpdatePage.this.isPageComplete());
            }
        });
        if (this.pageName.endsWith("Select Field Name")) {
            this.process("");
        }
        if (!this.pageName.equalsIgnoreCase("View Layout")) {
            this.getShell().getDefaultButton().setText("OK");
        }
        this.setControl((Control)this.container);
    }

    private void createViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 67586);
        this.tree = this.treeViewer.getTree();
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.tree.addSelectionListener((SelectionListener)this);
        GridData gd = new GridData(4, 4, true, true);
        this.tree.setLayoutData((Object)gd);
        this.treeViewer.setContentProvider((IContentProvider)new FieldNameContentProvider());
        this.createColumns(parent, this.treeViewer);
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    private void createColumns(Composite parent, TreeViewer viewer) {
        String[] titles = new String[]{"Field Name", "Position", "Type", "Format", "Length", "Message"};
        int[] bounds = new int[]{225, 55, 95, 50, 50, 150};
        int i = 0;
        while (i < titles.length) {
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(viewer, 0);
            TreeColumn treeColumn = treeViewerColumn.getColumn();
            treeColumn.setText(titles[i]);
            treeColumn.setWidth(bounds[i]);
            treeColumn.setResizable(true);
            switch (i) {
                case 0: {
                    treeViewerColumn.setLabelProvider((CellLabelProvider)new FieldNameLabelProvider());
                    break;
                }
                case 1: {
                    treeViewerColumn.setLabelProvider((CellLabelProvider)new PosLabelProvider());
                    treeViewerColumn.getColumn().setAlignment(131072);
                    break;
                }
                case 2: {
                    treeViewerColumn.setLabelProvider((CellLabelProvider)new TypeLabelProvider());
                    break;
                }
                case 3: {
                    treeViewerColumn.setLabelProvider((CellLabelProvider)new FormatLabelProvider());
                    treeViewerColumn.getColumn().setAlignment(131072);
                    break;
                }
                case 4: {
                    treeViewerColumn.setLabelProvider((CellLabelProvider)new LengthLabelProvider());
                    treeViewerColumn.getColumn().setAlignment(131072);
                    break;
                }
                case 5: {
                    treeViewerColumn.setLabelProvider((CellLabelProvider)new MessageLabelProvider());
                }
            }
            ++i;
        }
        this.treeViewer.setAutoExpandLevel(-1);
    }

    @Override
    public boolean isPageComplete() {
        if (this.getShell().getParent().getData() instanceof WorkbenchWindow) {
            return true;
        }
        if (this.tree.getSelectionCount() > 0) {
            int i = 0;
            while (i < this.tree.getSelectionCount()) {
                if (this.tree.getSelection()[i].getData() instanceof FileMasterLayout) {
                    this.setErrorMessage("01 level selected");
                    return false;
                }
                this.fieldName = ((FileMasterLayoutField)((Object)this.tree.getSelection()[i].getData())).getText();
                String error = "";
                String compareFieldName = this.selectedLayoutField.getField();
                FileMasterLayoutField fmlf = (FileMasterLayoutField)((Object)this.tree.getSelection()[i].getData());
                String formatLength = !fmlf.getFractionLength().equalsIgnoreCase("0") ? String.valueOf(fmlf.getIntegerLength()) + "." + fmlf.getFractionLength() : (!fmlf.getIntegerLength().equalsIgnoreCase("0") ? fmlf.getIntegerLength() : fmlf.getLength());
                if (!formatLength.equalsIgnoreCase(this.selectedLayoutField.getFormatLength())) {
                    error = String.valueOf(error) + "Length of " + this.fieldName + " field name does not match length of " + compareFieldName + " field name\n ";
                }
                String signed = "";
                String formatChar = this.selectedLayoutField.getFormatType().substring(0, 1);
                if (this.selectedLayoutField.getFormatType().length() == 2) {
                    if (this.selectedLayoutField.getFormatType().substring(1, 2).equalsIgnoreCase("S")) {
                        signed = "Y";
                    }
                } else {
                    signed = "N";
                }
                if (!((FileMasterLayoutField)((Object)this.tree.getSelection()[i].getData())).getFormatChar().equalsIgnoreCase(formatChar) || !((FileMasterLayoutField)((Object)this.tree.getSelection()[i].getData())).getSigned().equalsIgnoreCase(signed)) {
                    error = String.valueOf(error) + "Type of " + this.fieldName + "  field name does not match type of " + compareFieldName + " field name\n";
                }
                if (!error.equalsIgnoreCase("")) {
                    this.setErrorMessage(error);
                    return false;
                }
                ++i;
            }
            this.setErrorMessage(null);
            return true;
        }
        return false;
    }

    public void doGetFieldName(boolean isSelectionPage) {
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean process(String layoutParm) {
        if (this.fmLayoutList.isEmpty()) {
            this.dataset = new FileMasterDataset(null);
            this.member = new FileMasterMember(null);
            if (this.datasetView != null) {
                this.dataset.setName(this.datasetView);
                this.member.setName(this.memberview);
            } else {
                this.dataset.setName(this.datasetComboPage1.getText().trim());
                this.member.setName(this.memberComboPage1.getText().trim());
            }
            RunGetViewLayout runner = this.topLayoutName.isEmpty() ? new RunGetViewLayout(this.dataset.getText(), this.member.getText(), this.server, this.occursField) : new RunGetViewLayout(this.dataset.getText(), this.member.getText(), this.server, this.occursField, this.topLayoutName);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
            XMLRequest xml = runner.getXml();
            if (xml != null) {
                Element element = xml.getRoot();
                if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
                } else {
                    NodeList nodes = element.getElementsByTagName("Field");
                    NodeList messages = element.getElementsByTagName("Message");
                    NodeList retCode = element.getElementsByTagName("ReturnCode");
                    String message = "";
                    if (nodes.getLength() == 0) {
                        int i = 0;
                        while (i < messages.getLength()) {
                            Node msgNode = messages.item(i);
                            Element msgElement = (Element)msgNode;
                            message = String.valueOf(message) + GenericUpdatePage.getTagValue("Message", msgElement);
                            ++i;
                        }
                        Node rcNode = retCode.item(0);
                        Element rcElement = (Element)rcNode;
                        String returnCode = GenericUpdatePage.getTagValue("ReturnCode", rcElement);
                        TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                        return false;
                    }
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element layoutElement = (Element)nodes.item(i);
                        Element NameElement = (Element)layoutElement.getElementsByTagName("Name").item(0);
                        Element levelElement = (Element)layoutElement.getElementsByTagName("Level").item(0);
                        Element signedElement = (Element)layoutElement.getElementsByTagName("Signed").item(0);
                        Element integerLenElement = (Element)layoutElement.getElementsByTagName("IntegerLength").item(0);
                        Element fractionLenElement = (Element)layoutElement.getElementsByTagName("FractionLength").item(0);
                        Element occursElement = (Element)layoutElement.getElementsByTagName("Occurs").item(0);
                        Element lengthElement = (Element)layoutElement.getElementsByTagName("Length").item(0);
                        Element positionElement = (Element)layoutElement.getElementsByTagName("Position").item(0);
                        Element redefineInfoElement = (Element)layoutElement.getElementsByTagName("RedefineInfo").item(0);
                        if (GenericUpdatePage.getTagValue("Level", levelElement).equalsIgnoreCase("01")) {
                            FileMasterLayout layout = new FileMasterLayout(null);
                            layout.setName(GenericUpdatePage.getTagValue("Name", NameElement));
                            layout.setLevel(GenericUpdatePage.getTagValue("Level", levelElement));
                            if (signedElement != null) {
                                layout.setSigned(GenericUpdatePage.getTagValue("Signed", signedElement));
                            }
                            layout.setIntegerLength(GenericUpdatePage.getTagValue("IntegerLength", integerLenElement));
                            layout.setFractionLength(GenericUpdatePage.getTagValue("FractionLength", fractionLenElement));
                            if (!this.occursField) {
                                layout.setOccurs(GenericUpdatePage.getTagValue("Occurs", occursElement));
                            }
                            layout.setLength(GenericUpdatePage.getTagValue("Length", lengthElement));
                            layout.setPosition(GenericUpdatePage.getTagValue("Postion", positionElement));
                            if (redefineInfoElement != null) {
                                layout.setRedefineInfo(GenericUpdatePage.getTagValue("RedefineInfo", redefineInfoElement));
                            } else {
                                layout.setRedefineInfo("");
                            }
                            this.fmLayoutList.add((Object)layout);
                        } else {
                            Element formatCharElement = (Element)layoutElement.getElementsByTagName("FormatChar").item(0);
                            FileMasterLayoutField layout = new FileMasterLayoutField(null);
                            layout.setName(GenericUpdatePage.getTagValue("Name", NameElement));
                            layout.setLevel(GenericUpdatePage.getTagValue("Level", levelElement));
                            if (formatCharElement != null) {
                                layout.setFormatChar(GenericUpdatePage.getTagValue("FormatChar", formatCharElement));
                            }
                            if (signedElement != null) {
                                layout.setSigned(GenericUpdatePage.getTagValue("Signed", signedElement));
                            }
                            layout.setIntegerLength(GenericUpdatePage.getTagValue("IntegerLength", integerLenElement));
                            layout.setFractionLength(GenericUpdatePage.getTagValue("FractionLength", fractionLenElement));
                            if (!this.occursField) {
                                layout.setOccurs(GenericUpdatePage.getTagValue("Occurs", occursElement));
                            }
                            layout.setLength(GenericUpdatePage.getTagValue("Length", lengthElement));
                            layout.setPosition(GenericUpdatePage.getTagValue("Postion", positionElement));
                            if (redefineInfoElement != null) {
                                layout.setRedefineInfo(GenericUpdatePage.getTagValue("RedefineInfo", redefineInfoElement));
                            } else {
                                layout.setRedefineInfo("");
                            }
                            int j = this.fmLayoutList.size() - 1;
                            while (j >= 0) {
                                if (this.fmLayoutList.get(j) instanceof FileMasterLayout && Integer.parseInt(((FileMasterLayout)((Object)this.fmLayoutList.get(j))).getLevel()) < Integer.parseInt(layout.getLevel())) {
                                    ((FileMasterLayout)((Object)this.fmLayoutList.get(j))).addChildFields(layout);
                                    break;
                                }
                                if (this.fmLayoutList.get(j) instanceof FileMasterLayoutField && Integer.parseInt(((FileMasterLayoutField)((Object)this.fmLayoutList.get(j))).getLevel()) < Integer.parseInt(layout.getLevel())) {
                                    ((FileMasterLayoutField)((Object)this.fmLayoutList.get(j))).addChildFields(layout);
                                    break;
                                }
                                --j;
                            }
                            this.fmLayoutList.add((Object)layout);
                        }
                        ++i;
                    }
                    if (this.treeViewer != null) {
                        this.treeViewer.setInput((Object)this.fmLayoutList.toArray(new Object[this.fmLayoutList.size()]));
                        this.treeViewer.refresh();
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public boolean doviewFinish() {
        return true;
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        return nValue.getNodeValue();
    }

    public void setServer(FileMasterServer server) {
        this.server = server;
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.RecordLayoutData.setFocus();
    }

    public ArrayList<Object> getFmLayoutList() {
        return this.fmLayoutList;
    }

    public void setFmLayoutList(ArrayList<Object> fmLayoutList) {
        this.fmLayoutList = fmLayoutList;
    }
}

