/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.selection.wizards;

import com.ca.filemaster.common.FMSelectionTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.selection.wizards.AddSelCritWizardPage;
import com.ca.testingtools.core.TT_TreeItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AddSelCritWizard
extends Wizard
implements INewWizard {
    private AddSelCritWizardPage page1;
    private FMSelectionTreeModel selectionModel = FMSelectionTreeModel.getInstance();
    private boolean isSelectionTreeItem = false;
    private FileMasterServer server;
    private FileMasterDataset dataset;
    private FileMasterMember member;

    public AddSelCritWizard() {
        this.setWindowTitle("Add Selection Criteria");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        if (object != null) {
            TT_TreeItem treeItem = this.selectionModel.findObject(object);
            this.isSelectionTreeItem = true;
            if (treeItem != null) {
                if (this.isSelectionTreeItem) {
                    this.server = null;
                    if (treeItem.getParent() != null) {
                        this.member = (FileMasterMember)treeItem.getAdapter(FileMasterMember.class);
                        this.dataset = (FileMasterDataset)treeItem.getParent().getAdapter(FileMasterDataset.class);
                    } else {
                        this.member = null;
                        this.dataset = (FileMasterDataset)treeItem.getAdapter(FileMasterDataset.class);
                    }
                }
            } else {
                this.member = null;
                this.dataset = null;
                this.server = null;
            }
        }
    }

    public void addPages() {
        String datasetName = "";
        String memberName = "";
        if (this.dataset != null) {
            datasetName = this.dataset.getName();
        }
        if (this.member != null) {
            memberName = this.member.getName();
        }
        this.page1 = new AddSelCritWizardPage("Add Selection", this.server, datasetName, memberName, false);
        this.addPage((IWizardPage)this.page1);
    }

    public boolean performFinish() {
        return this.page1.doFinish();
    }

    public boolean canFinish() {
        return this.page1.canFinish();
    }
}

