/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.customlayout.wizards;

import com.ca.filemaster.common.CRLClass;
import com.ca.filemaster.common.FMLayoutTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterLayout;
import com.ca.filemaster.common.FileMasterLayoutField;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.customlayout.wizards.AddCRLPage;
import com.ca.filemaster.customlayout.wizards.CRLDummy;
import com.ca.filemaster.customlayout.wizards.CRLWizard;
import com.ca.filemaster.customlayout.wizards.InsertTopLayoutWizard;
import com.ca.filemaster.customlayout.wizards.LayoutDSNLabelProvider;
import com.ca.filemaster.customlayout.wizards.LayoutMemberLabelProvider;
import com.ca.filemaster.customlayout.wizards.SaveAsWizard;
import com.ca.filemaster.customlayout.wizards.TopFieldNameLabelProvider;
import com.ca.filemaster.views.layout.LayoutView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UpdateCRLPage
extends FileMasterWizard
implements SelectionListener {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.newCustomLayoutPage";
    private Text txtDataSet;
    private Text txtMember;
    private Text txtDescription;
    private Spinner spnRecOffset;
    private Button btnInsert;
    private Button btnRemove;
    private Button btnSaveAs;
    private Button selectAllClearButton;
    private Group topLevelGroup;
    private Table topLevelTable;
    private Combo cmbDefault;
    private CheckboxTableViewer checkboxTableViewer;
    private FMLayoutTreeModel fmltModel = FMLayoutTreeModel.getInstance();
    private boolean isDirectoryListCaller = false;
    private FileMasterServer server;
    private String datasetName = "";
    private String memberName = "";
    private boolean newCRL = false;
    private boolean isOffsetEmpty = false;
    private String error;
    private CRLClass crl;
    private ArrayList<Object> listOfLayouts = new ArrayList();

    public UpdateCRLPage(String pageName, String datasetName, FileMasterServer server) {
        super(pageName, datasetName, server);
        this.setTitle("Update Custom Layout");
    }

    public UpdateCRLPage(String pageName, CRLClass crl, boolean newCRL, FileMasterServer server, boolean isDirectoryListCaller) {
        super(pageName, crl.getDatasetName(), server);
        this.crl = crl;
        this.datasetName = crl.getDatasetName();
        this.isDirectoryListCaller = isDirectoryListCaller;
        this.newCRL = newCRL;
        this.server = server;
        if (newCRL) {
            this.setTitle("Create New Custom Layout");
        } else {
            this.setTitle("Update Custom Layout");
            this.memberName = crl.getMemberName();
        }
    }

    public UpdateCRLPage(String pageName, String datasetName, String memberName, boolean newCRL, FileMasterServer server, boolean isDirectoryListCaller) {
        super(pageName, datasetName, server);
        this.datasetName = datasetName;
        this.server = server;
        this.isDirectoryListCaller = isDirectoryListCaller;
        if (memberName != null) {
            this.memberName = memberName;
        }
        this.newCRL = newCRL;
        if (newCRL) {
            this.setTitle("Create New Custom Layout");
        } else {
            this.setTitle("Update Custom Layout");
        }
        this.crl = new CRLClass(datasetName, memberName, "", 0);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.newCustomLayoutPage");
        Composite compositeTop = new Composite(container, 0);
        GridData gd_compositeTop = new GridData(4, 128, false, true, 1, 1);
        gd_compositeTop.widthHint = 267;
        compositeTop.setLayoutData((Object)gd_compositeTop);
        compositeTop.setLayout((Layout)new GridLayout(2, false));
        Label lblDataSet = new Label(compositeTop, 0);
        lblDataSet.setText("&Data set:");
        this.txtDataSet = new Text(compositeTop, 2048);
        this.txtDataSet.setEditable(false);
        GridData gd_txtDataSet = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtDataSet.widthHint = 280;
        this.txtDataSet.setLayoutData((Object)gd_txtDataSet);
        this.txtDataSet.setText(this.datasetName);
        Label lblMember = new Label(compositeTop, 0);
        lblMember.setText("&Member:");
        this.txtMember = new Text(compositeTop, 2048);
        if (!this.newCRL) {
            this.txtMember.setEditable(false);
        }
        GridData gd_txtMember = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtMember.widthHint = 280;
        this.txtMember.setLayoutData((Object)gd_txtMember);
        this.txtMember.setText(this.memberName);
        this.txtMember.addModifyListener((ModifyListener)this);
        this.txtMember.setTextLimit(8);
        this.txtMember.addVerifyListener((VerifyListener)new verifytoUpperCase());
        Label lblDescription = new Label(compositeTop, 0);
        lblDescription.setText("Des&cription:");
        this.txtDescription = new Text(compositeTop, 2048);
        GridData gd_txtDescription = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtDescription.widthHint = 280;
        this.txtDescription.setLayoutData((Object)gd_txtDescription);
        this.txtDescription.setTextLimit(51);
        Label lblRecOffset = new Label(compositeTop, 0);
        lblRecOffset.setText("Record &offset:");
        this.spnRecOffset = new Spinner(compositeTop, 2048);
        this.spnRecOffset.setMaximum(99999);
        this.spnRecOffset.setMinimum(-99999);
        this.spnRecOffset.setTextLimit(5);
        GridData gd_spinner = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_spinner.widthHint = 80;
        this.spnRecOffset.setLayoutData((Object)gd_spinner);
        this.spnRecOffset.addModifyListener((ModifyListener)this);
        this.spnRecOffset.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (UpdateCRLPage.this.spnRecOffset.getText().equals("")) {
                    UpdateCRLPage.this.isOffsetEmpty = true;
                } else {
                    UpdateCRLPage.this.isOffsetEmpty = false;
                }
            }
        });
        this.spnRecOffset.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (UpdateCRLPage.this.isOffsetEmpty) {
                    UpdateCRLPage.this.spnRecOffset.setSelection(0);
                    UpdateCRLPage.this.isOffsetEmpty = false;
                }
            }
        });
        Composite compositeTable = new Composite(container, 0);
        GridData gd_compositeTable = new GridData(4, 4, true, true, 1, 1);
        gd_compositeTable.heightHint = 249;
        compositeTable.setLayoutData((Object)gd_compositeTable);
        compositeTable.setLayout((Layout)new GridLayout(1, false));
        this.topLevelGroup = new Group(compositeTable, 0);
        GridData gd_group = new GridData(4, 4, true, true, 1, 1);
        gd_group.widthHint = 605;
        this.topLevelGroup.setLayoutData((Object)gd_group);
        this.topLevelGroup.setLayout((Layout)new GridLayout(2, false));
        Composite composite_left = new Composite((Composite)this.topLevelGroup, 0);
        composite_left.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite_left.setLayout((Layout)new GridLayout(1, false));
        this.createViewer(composite_left);
        Composite composite_default = new Composite(composite_left, 0);
        composite_default.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        composite_default.setLayout((Layout)new GridLayout(3, false));
        this.selectAllClearButton = new Button(composite_default, 0);
        this.selectAllClearButton.setText("Select &All");
        GridData gd_selectAllClearButton = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_selectAllClearButton.widthHint = 120;
        this.selectAllClearButton.setLayoutData((Object)gd_selectAllClearButton);
        this.selectAllClearButton.addSelectionListener((SelectionListener)this);
        Label lblDefaultLayout = new Label(composite_default, 0);
        lblDefaultLayout.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        lblDefaultLayout.setSize(55, 15);
        lblDefaultLayout.setText("Default &layout:");
        this.cmbDefault = new Combo(composite_default, 8);
        GridData gd_cmbDefault = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_cmbDefault.widthHint = 252;
        this.cmbDefault.setLayoutData((Object)gd_cmbDefault);
        this.checkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.checkboxTableViewer.setInput(null);
        Composite composite_right = new Composite((Composite)this.topLevelGroup, 0);
        composite_right.setLayoutData((Object)new GridData(131072, 4, false, true, 1, 1));
        composite_right.setLayout((Layout)new GridLayout(1, false));
        this.btnInsert = new Button(composite_right, 0);
        this.btnInsert.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnInsert.setText("&Insert Layout...");
        this.btnRemove = new Button(composite_right, 0);
        this.btnRemove.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnRemove.setText("&Remove Layout");
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnRemove.setEnabled(false);
        this.btnInsert.addSelectionListener((SelectionListener)this);
        Composite compositeButtons = new Composite(container, 0);
        GridData gd_compositeButtons = new GridData(4, 1024, false, true, 1, 1);
        gd_compositeButtons.widthHint = 562;
        compositeButtons.setLayoutData((Object)gd_compositeButtons);
        compositeButtons.setLayout((Layout)new GridLayout(1, false));
        this.btnSaveAs = new Button(compositeButtons, 0);
        this.btnSaveAs.setText("&Save As...");
        this.btnSaveAs.addSelectionListener((SelectionListener)this);
        this.setPageComplete(this.isPageComplete());
    }

    private void createViewer(Composite parent) {
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68354);
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (UpdateCRLPage.this.checkboxTableViewer.getCheckedElements().length == UpdateCRLPage.this.checkboxTableViewer.getTable().getItemCount()) {
                    UpdateCRLPage.this.selectAllClearButton.setText("&Clear Selections");
                } else {
                    UpdateCRLPage.this.selectAllClearButton.setText("Select &All");
                }
                if (UpdateCRLPage.this.checkboxTableViewer.getCheckedElements().length == 0) {
                    UpdateCRLPage.this.selectAllClearButton.setText("Select &All");
                    UpdateCRLPage.this.btnRemove.setEnabled(false);
                } else {
                    UpdateCRLPage.this.btnRemove.setEnabled(true);
                }
                UpdateCRLPage.this.setPageComplete(UpdateCRLPage.this.canFlipToNextPage());
            }
        });
        this.topLevelTable = this.checkboxTableViewer.getTable();
        this.topLevelTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.topLevelTable.setLinesVisible(true);
        this.topLevelTable.setHeaderVisible(true);
        this.topLevelTable.setFocus();
        this.createColumns(parent, this.checkboxTableViewer);
    }

    private void createColumns(Composite parent, CheckboxTableViewer viewer) {
        String[] titles = new String[]{"Member", "Layout DSN", "Top Level Field Name"};
        int[] bounds = new int[]{100, 200, 150};
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)viewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(titles[i]);
            tableColumn.setWidth(bounds[i]);
            switch (i) {
                case 0: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new LayoutMemberLabelProvider());
                    break;
                }
                case 1: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new LayoutDSNLabelProvider());
                    break;
                }
                case 2: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new TopFieldNameLabelProvider());
                }
            }
            ++i;
        }
    }

    public void setCRL(CRLClass crl) {
        this.crl = crl;
        this.txtDataSet.setText(this.crl.getDatasetName());
        this.txtMember.setText(this.crl.getMemberName());
        this.txtDescription.setText(this.crl.getDescription());
        this.spnRecOffset.setSelection(this.crl.getOffset());
    }

    public IWizardPage getPreviousPage() {
        String memberCRLToUpdate = new String();
        String datasetCRLToUpdate = new String();
        datasetCRLToUpdate = this.txtDataSet.getText();
        memberCRLToUpdate = this.txtMember.getText();
        if (((CRLWizard)this.getWizard()).getPage("Add Custom Layout") == null) {
            AddCRLPage page1 = new AddCRLPage("Add Custom Layout", this.server, datasetCRLToUpdate, memberCRLToUpdate, this.isDirectoryListCaller);
            ((CRLWizard)this.getWizard()).addPage((IWizardPage)page1);
        }
        AddCRLPage cfr_ignored_0 = (AddCRLPage)((CRLWizard)this.getWizard()).getPage("Add Custom Layout");
        AddCRLPage.chkForDSChanged = false;
        ((AddCRLPage)((CRLWizard)this.getWizard()).getPage("Add Custom Layout")).setDatasetName(datasetCRLToUpdate);
        ((AddCRLPage)((CRLWizard)this.getWizard()).getPage("Add Custom Layout")).setMemberName(memberCRLToUpdate);
        return ((CRLWizard)this.getWizard()).getPage("Add Custom Layout");
    }

    private void tableUpdate() {
        this.checkboxTableViewer.setInput((Object)this.crl.getLayouts().toArray(new Object[this.crl.getLayouts().size()]));
        this.checkboxTableViewer.refresh();
        String[] tempDef = new String[this.crl.getLayouts().size()];
        int i = 0;
        while (i < tempDef.length) {
            tempDef[i] = String.valueOf(this.crl.getLayout(i).getLayoutMember()) + ": " + this.crl.getLayout(i).getTopLayoutField();
            ++i;
        }
        this.cmbDefault.setItems(tempDef);
        this.cmbDefault.add("");
        this.setPageComplete(this.canFlipToNextPage());
    }

    public void insertLayout(CRLDummy crl) {
        CRLClass.Layout tempcrl1 = this.crl.addLayout(crl.getDatasetName(), crl.getMemberName());
        tempcrl1.addField(crl.getTopLavelField(), true);
        this.listOfLayouts.add(crl.getTopLavelField());
        this.tableUpdate();
    }

    public void setDatasetName(String datasetName) {
        if (this.txtDataSet != null) {
            this.txtDataSet.setText(datasetName);
        }
    }

    public void setMemberName(String memberName) {
        if (this.txtMember != null) {
            this.txtMember.setText(memberName);
        }
    }

    public void setDescription(String description) {
        this.txtDescription.setText(description);
    }

    public void setRecOffset(int recOffset) {
        this.spnRecOffset.setSelection(recOffset);
    }

    public void setMemberFieldEnabled(boolean enabled) {
        if (this.txtMember != null) {
            this.txtMember.setEditable(enabled);
        }
    }

    public boolean isPageComplete() {
        return this.nextOrFinish();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    private boolean ValidateMember() {
        if (this.txtMember != null) {
            if (Validator.member((String)this.txtMember.getText(), (boolean)true) == 0) {
                return true;
            }
            switch (Validator.member((String)this.txtMember.getText(), (boolean)true)) {
                case 0: {
                    break;
                }
                case 7: {
                    this.error = String.valueOf(this.error) + "Member name has invalid format\n";
                    break;
                }
                case 6: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member((String)this.txtMember.getText(), (boolean)true)] + "\n ";
                    break;
                }
                case 5: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member((String)this.txtMember.getText(), (boolean)true)] + "\n ";
                }
            }
            if (this.error.length() > 0) {
                this.setErrorMessage(this.error);
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }
        return false;
    }

    private boolean nextOrFinish() {
        this.error = "";
        boolean returnVal = false;
        returnVal = super.isPageComplete();
        if (this.checkboxTableViewer.getTable().getItemCount() == 0) {
            this.error = String.valueOf(this.error) + "Insert at least one layout\n ";
            returnVal = false;
            this.selectAllClearButton.setEnabled(false);
        } else {
            if (this.checkboxTableViewer.getCheckedElements().length == this.checkboxTableViewer.getTable().getItemCount()) {
                this.selectAllClearButton.setText("&Clear Selections");
            } else {
                this.selectAllClearButton.setText("Select &All");
            }
            this.selectAllClearButton.setEnabled(true);
        }
        if (returnVal) {
            returnVal = this.ValidateMember();
        }
        if (this.txtMember != null) {
            this.memberName = this.txtMember.getText().trim();
            FileMasterDataset fmdataset = new FileMasterDataset(null);
            fmdataset.setName(this.dataSetName);
            fmdataset.setDsOrg("PDS");
            TT_TreeItem dsItem = null;
            dsItem = this.fmltModel.findObject((Object)fmdataset);
            if (dsItem != null) {
                FileMasterMember fmmember = new FileMasterMember(dsItem);
                fmmember.setName(this.memberName);
                if (this.fmltModel.findObjectInTree((Object)fmmember, dsItem) != null) {
                    this.error = String.valueOf(this.error) + "Duplicate member name\n ";
                }
            }
        }
        if (this.spnRecOffset.getText().startsWith("-")) {
            this.spnRecOffset.setTextLimit(6);
        } else {
            this.spnRecOffset.setTextLimit(5);
        }
        if (!this.spnRecOffset.getText().matches("-?[0-9]*")) {
            this.error = String.valueOf(this.error) + "Record offset has invalid format\n ";
            returnVal = false;
        }
        if (this.spnRecOffset.getSelection() > 32760 || this.spnRecOffset.getSelection() < -32760) {
            this.error = String.valueOf(this.error) + "Record offset is out of bounds\n ";
            returnVal = false;
        }
        if (this.error.length() > 0) {
            this.setErrorMessage(this.error);
        } else {
            this.setErrorMessage(null);
        }
        return returnVal;
    }

    public boolean doFinish() {
        Object[] checkedLayouts = new Object[this.listOfLayouts.size()];
        Object[] checkedLayoutMembers = this.checkboxTableViewer.getCheckedElements();
        TT_TreeItem dsItem = null;
        dsItem = this.fmltModel.findObject((Object)this.fmdataset);
        if (dsItem == null) {
            Element dsElement = this.fmltModel.addDataset(null, this.fmdataset);
            dsItem = this.fmltModel.insertDataset(dsElement);
        }
        FileMasterMember fmmember = new FileMasterMember(null);
        fmmember.setName(this.txtMember.getText());
        if (this.listOfLayouts.size() == 0) {
            fmmember.setName(this.txtMember.getText().trim());
            fmmember.setType("CRL");
            checkedLayoutMembers = new Object[]{fmmember};
            int count = 0;
            while (count < checkedLayoutMembers.length) {
                if (checkedLayoutMembers[count] instanceof FileMasterMember) {
                    fmmember.setName(((FileMasterMember)checkedLayoutMembers[count]).getName());
                    fmmember.setType(((FileMasterMember)checkedLayoutMembers[count]).getType());
                    Element memElement = this.fmltModel.addMember(dsItem.getElement(), fmmember.getName(), fmmember.getType());
                    this.fmltModel.insertMember(dsItem, memElement);
                    checkedLayouts[0] = this.process(((FileMasterMember)checkedLayoutMembers[count]).getName());
                }
                ++count;
            }
        } else {
            Element memElement = this.fmltModel.addMember(dsItem.getElement(), fmmember.getName(), fmmember.getType());
            TT_TreeItem memItem = this.fmltModel.insertMember(dsItem, memElement);
            if (this.listOfLayouts != null) {
                int i = 0;
                while (i < this.listOfLayouts.size()) {
                    checkedLayouts[i] = this.process(this.listOfLayouts.get(i).toString());
                    ++i;
                }
            } else {
                checkedLayouts[0] = this.process(this.txtMember.getText());
            }
            Element fmlayoutElement = null;
            TT_TreeItem fmlayoutItem = null;
            int outerCountLay = 0;
            while (outerCountLay < checkedLayouts.length) {
                int countLay = 0;
                while (countLay < ((Object[])checkedLayouts[outerCountLay]).length) {
                    Element fmlayoutfieldElement;
                    if (((Object[])checkedLayouts[outerCountLay])[countLay] instanceof FileMasterLayout) {
                        fmlayoutElement = this.fmltModel.addLayout(memElement, (FileMasterLayout)((Object[])checkedLayouts[outerCountLay])[countLay]);
                        fmlayoutItem = this.fmltModel.insertLayout(memItem, fmlayoutElement);
                    } else if (fmlayoutElement != null) {
                        fmlayoutfieldElement = this.fmltModel.addLayoutField(fmlayoutElement, (FileMasterLayoutField)((Object[])checkedLayouts[outerCountLay])[countLay]);
                        this.fmltModel.insertLayoutField(fmlayoutItem, fmlayoutfieldElement);
                    } else {
                        fmlayoutfieldElement = this.fmltModel.addLayoutField(memElement, (FileMasterLayoutField)((Object[])checkedLayouts[outerCountLay])[countLay]);
                        this.fmltModel.insertLayoutField(memItem, fmlayoutfieldElement);
                    }
                    ++countLay;
                }
                ++outerCountLay;
            }
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        try {
            TreeViewer viewer;
            IWorkbenchPage page = window.getActivePage();
            IViewPart view = page.showView("com.ca.filemaster.layout.views.layoutview");
            if (view instanceof LayoutView && (viewer = ((LayoutView)view).getViewer()) != null) {
                TT_TreeItem selection = this.fmltModel.findObjectInTree((Object)fmmember, this.fmltModel.findObject((Object)this.fmdataset));
                Object[] expandedElements = viewer.getExpandedElements();
                viewer.setInput((Object)this.fmltModel.getDatasets());
                viewer.refresh(true);
                viewer.setExpandedElements(expandedElements);
                if (this.isDirectoryListCaller && selection == null) {
                    view = page.showView("com.ca.filemaster.views.directorylist");
                } else {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                    view = page.showView("com.ca.filemaster.layout.views.layoutview");
                    page.activate((IWorkbenchPart)view);
                    page.bringToTop((IWorkbenchPart)view);
                }
                view.setFocus();
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        this.fmltModel.save();
        return true;
    }

    private Object[] process(String layoutParm) {
        XMLRequest xml = null;
        xml = layoutParm.equals("CUSTLAY") || layoutParm.equals("CUSTOMER-RECORD") ? this.getCRXML() : (layoutParm.equals("STUDLAY") || layoutParm.equals("STUDENT-RECORD") ? this.getSRXML() : this.getBothXML());
        if (xml != null) {
            Element element = xml.getCommand();
            NodeList nodes = element.getElementsByTagName("layoutnode");
            if (nodes.getLength() == 0) {
                TT_ErrorDialog.openError(null, (String)"Layout Error", (String)"Layout has no fields.", (Throwable)new Throwable("Layout name mispelled\nLayout not defined\nMainframe communication error"));
            } else {
                ArrayList<FileMasterLayout> fmLayoutList = new ArrayList<FileMasterLayout>();
                int i = 0;
                while (i < nodes.getLength()) {
                    FileMasterLayout layout;
                    Element layoutElement = (Element)nodes.item(i);
                    if (layoutElement.getAttribute("level").equalsIgnoreCase("01")) {
                        layout = new FileMasterLayout(null);
                        layout.setName(layoutElement.getAttribute("name"));
                        layout.setLevel(layoutElement.getAttribute("level"));
                        fmLayoutList.add(layout);
                    } else {
                        layout = new FileMasterLayoutField(null);
                        layout.setName(layoutElement.getAttribute("name"));
                        layout.setLevel(layoutElement.getAttribute("level"));
                        fmLayoutList.add(layout);
                    }
                    ++i;
                }
                return fmLayoutList.toArray(new Object[fmLayoutList.size()]);
            }
        }
        return null;
    }

    public XMLRequest getSRXML() {
        XMLRequest xml = new XMLRequest();
        xml.setCommand("AddLayout");
        Element element = xml.getCommand();
        Element layoutElement = xml.createElement("layoutnode");
        layoutElement.setAttribute("name", "STUDENT-RECORD");
        layoutElement.setAttribute("level", "01");
        Element layoutFieldNameElement = xml.createElement("layoutnode");
        layoutFieldNameElement.setAttribute("name", "NAME");
        layoutFieldNameElement.setAttribute("level", "03");
        Element layoutFieldIDElement = xml.createElement("layoutnode");
        layoutFieldIDElement.setAttribute("name", "ID");
        layoutFieldIDElement.setAttribute("level", "03");
        Element layoutFieldEthinicityElement = xml.createElement("layoutnode");
        layoutFieldEthinicityElement.setAttribute("name", "ETHINICITY");
        layoutFieldEthinicityElement.setAttribute("level", "03");
        layoutElement.appendChild(layoutFieldNameElement);
        layoutElement.appendChild(layoutFieldIDElement);
        layoutElement.appendChild(layoutFieldEthinicityElement);
        element.appendChild(layoutElement);
        return xml;
    }

    public XMLRequest getCRXML() {
        XMLRequest xml = new XMLRequest();
        xml.setCommand("AddLayout");
        Element element = xml.getCommand();
        Element layoutElement2 = xml.createElement("layoutnode");
        layoutElement2.setAttribute("name", "CUSTOMER-RECORD");
        layoutElement2.setAttribute("level", "01");
        Element layoutFieldFirstNameElement = xml.createElement("layoutnode");
        layoutFieldFirstNameElement.setAttribute("name", "FIRST-NAME");
        layoutFieldFirstNameElement.setAttribute("level", "03");
        Element layoutFieldLastNameElement = xml.createElement("layoutnode");
        layoutFieldLastNameElement.setAttribute("name", "LAST-NAME");
        layoutFieldLastNameElement.setAttribute("level", "03");
        Element layoutFieldAgeElement = xml.createElement("layoutnode");
        layoutFieldAgeElement.setAttribute("name", "AGE");
        layoutFieldAgeElement.setAttribute("level", "03");
        Element layoutFieldSSNElement = xml.createElement("layoutnode");
        layoutFieldSSNElement.setAttribute("name", "SSN");
        layoutFieldSSNElement.setAttribute("level", "03");
        layoutElement2.appendChild(layoutFieldFirstNameElement);
        layoutElement2.appendChild(layoutFieldLastNameElement);
        layoutElement2.appendChild(layoutFieldAgeElement);
        layoutElement2.appendChild(layoutFieldSSNElement);
        element.appendChild(layoutElement2);
        return xml;
    }

    public XMLRequest getBothXML() {
        XMLRequest xml = new XMLRequest();
        xml.setCommand("AddLayout");
        Element element = xml.getCommand();
        Element layoutElement = xml.createElement("layoutnode");
        layoutElement.setAttribute("name", "STUDENT-RECORD");
        layoutElement.setAttribute("level", "01");
        Element layoutFieldNameElement = xml.createElement("layoutnode");
        layoutFieldNameElement.setAttribute("name", "NAME");
        layoutFieldNameElement.setAttribute("level", "03");
        Element layoutFieldIDElement = xml.createElement("layoutnode");
        layoutFieldIDElement.setAttribute("name", "ID");
        layoutFieldIDElement.setAttribute("level", "03");
        Element layoutFieldEthinicityElement = xml.createElement("layoutnode");
        layoutFieldEthinicityElement.setAttribute("name", "ETHINICITY");
        layoutFieldEthinicityElement.setAttribute("level", "03");
        layoutElement.appendChild(layoutFieldNameElement);
        layoutElement.appendChild(layoutFieldIDElement);
        layoutElement.appendChild(layoutFieldEthinicityElement);
        element.appendChild(layoutElement);
        Element layoutElement2 = xml.createElement("layoutnode");
        layoutElement2.setAttribute("name", "CUSTOMER-RECORD");
        layoutElement2.setAttribute("level", "01");
        Element layoutFieldFirstNameElement = xml.createElement("layoutnode");
        layoutFieldFirstNameElement.setAttribute("name", "FIRST-NAME");
        layoutFieldFirstNameElement.setAttribute("level", "03");
        Element layoutFieldLastNameElement = xml.createElement("layoutnode");
        layoutFieldLastNameElement.setAttribute("name", "LAST-NAME");
        layoutFieldLastNameElement.setAttribute("level", "03");
        Element layoutFieldAgeElement = xml.createElement("layoutnode");
        layoutFieldAgeElement.setAttribute("name", "AGE");
        layoutFieldAgeElement.setAttribute("level", "03");
        Element layoutFieldSSNElement = xml.createElement("layoutnode");
        layoutFieldSSNElement.setAttribute("name", "SSN");
        layoutFieldSSNElement.setAttribute("level", "03");
        layoutElement2.appendChild(layoutFieldFirstNameElement);
        layoutElement2.appendChild(layoutFieldLastNameElement);
        layoutElement2.appendChild(layoutFieldAgeElement);
        layoutElement2.appendChild(layoutFieldSSNElement);
        element.appendChild(layoutElement2);
        return xml;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.btnInsert) {
            TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new InsertTopLayoutWizard());
            dialog.create();
            dialog.open();
            this.setPageComplete(this.isPageComplete());
        } else if (e.getSource() == this.btnRemove) {
            ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
            String key = "CLOSING_VALUE";
            boolean showDiag = !store.getBoolean(key);
            boolean remove = false;
            int itemsChecked = this.checkboxTableViewer.getCheckedElements().length;
            if (showDiag) {
                String question = itemsChecked == 1 ? "Do you want to remove selected layout from custom layout?" : "Do you want to remove selected layouts from custom layout?";
                String toggleMessage = "Always remove items without this prompt";
                MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Remove", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)store, (String)key);
                int returncode = result.getReturnCode();
                boolean bl = remove = returncode == 0 || returncode == 2;
                if (remove) {
                    store.setValue(key, result.getToggleState());
                }
            }
            if (showDiag && remove || !showDiag) {
                int i = this.checkboxTableViewer.getTable().getItemCount();
                while (i >= 0) {
                    if (this.checkboxTableViewer.getChecked(this.checkboxTableViewer.getElementAt(i))) {
                        this.crl.removeLayout(i);
                        if (this.cmbDefault.getSelectionIndex() == i) {
                            this.cmbDefault.select(-1);
                            this.cmbDefault.redraw();
                        }
                    }
                    --i;
                }
                this.btnRemove.setEnabled(false);
                this.checkboxTableViewer.setAllChecked(false);
                this.tableUpdate();
            }
            this.setPageComplete(this.isPageComplete());
        } else if (e.getSource() == this.btnSaveAs) {
            this.crl.setDatasetName(this.txtDataSet.getText());
            this.crl.setMemberName(this.txtMember.getText());
            this.crl.setDescription(this.txtDescription.getText());
            this.crl.setOffset(this.spnRecOffset.getSelection());
            TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new SaveAsWizard(this.server, this.crl));
            dialog.create();
            dialog.open();
        } else if (e.getSource() == this.selectAllClearButton) {
            if (this.selectAllClearButton.getText() == "Select &All") {
                this.checkboxTableViewer.setAllChecked(true);
                this.selectAllClearButton.setText("&Clear Selections");
                this.btnRemove.setEnabled(true);
            } else {
                this.selectAllClearButton.setText("Select &All");
                this.checkboxTableViewer.setAllChecked(false);
                this.btnRemove.setEnabled(false);
            }
            this.setPageComplete(this.isPageComplete());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

