/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.customlayout.wizards;

import com.ca.filemaster.common.CRLClass;
import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMLayoutTreeModel;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterLayout;
import com.ca.filemaster.common.FileMasterLayoutField;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.customlayout.wizards.CRLUpdate2;
import com.ca.filemaster.customlayout.wizards.InsertTopLayoutWizard;
import com.ca.filemaster.customlayout.wizards.LayoutDSNLabelProvider;
import com.ca.filemaster.customlayout.wizards.LayoutMemberLabelProvider;
import com.ca.filemaster.customlayout.wizards.TopFieldNameLabelProvider;
import com.ca.filemaster.runners.RunPutCrlMem;
import com.ca.filemaster.views.layout.LayoutView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CRLUpdate1Page
extends FileMasterWizard
implements SelectionListener {
    static final String cacopyright = "Copyright (c) 2017 CA";
    protected final String CONTEXT_HELP_NEW_ID = "com.ca.filemaster.help.newCustomLayoutPage";
    protected final String CONTEXT_HELP_PROPERTIES_ID = "com.ca.filemaster.help.customLayoutProperties";
    private Combo serverNameCombo;
    private Text txtMember;
    private Text txtDescription;
    private Text txtDefault;
    private Spinner spnRecOffset;
    private Button btnRules;
    private Button btnInsert;
    private Button btnDefault;
    private Button btnRemove;
    private Group topLevelGroup;
    private Table topLevelTable;
    private TableViewer checkboxTableViewer;
    private FMLayoutTreeModel fmltModel = FMLayoutTreeModel.getInstance();
    private FMServerTreeModel fmstModel = FMServerTreeModel.getInstance();
    private FileMasterServer server;
    private boolean isOffsetEmpty = false;
    private boolean newCRL;
    private CRLClass crl;
    private ArrayList<Object> listOfLayouts = new ArrayList();
    private String origDataSet;
    private String origMember;

    public CRLUpdate1Page(String pageName, CRLClass crl, boolean newCRL, FileMasterServer server) {
        super(pageName, crl.getDatasetName(), server);
        this.crl = crl;
        this.server = server;
        this.newCRL = newCRL;
        this.origDataSet = crl.getDatasetName();
        this.origMember = crl.getMemberName();
        if (!newCRL) {
            this.setTitle(String.valueOf(crl.getDatasetName()) + "(" + crl.getMemberName() + ")" + " " + "Update");
        } else {
            this.setTitle(pageName);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.newCRL) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.newCustomLayoutPage");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.customLayoutProperties");
        }
        Label serverNameLabel = new Label(this.dataSetComposite, 0);
        serverNameLabel.setText("Se&rver:");
        this.serverNameCombo = new Combo(this.dataSetComposite, 2056);
        GridData gd_serverNameCombo = new GridData(4, 4, false, false, 1, 1);
        this.serverNameCombo.setLayoutData((Object)gd_serverNameCombo);
        this.serverNameCombo.setItems(this.getServers());
        if (this.serverNameCombo.getItemCount() > 0) {
            boolean lastServerExists = false;
            String lastServerUsed = FMHistory.getServer((String)"ServerAddLayoutPage1");
            int count = 0;
            while (count < this.serverNameCombo.getItemCount()) {
                if (this.serverNameCombo.getItem(count).toString().equalsIgnoreCase(lastServerUsed)) {
                    lastServerExists = true;
                    this.serverNameCombo.setText(this.serverNameCombo.getItem(count).toString());
                    this.changeServer();
                    break;
                }
                ++count;
            }
            if (!lastServerExists) {
                this.serverNameCombo.setText(this.serverNameCombo.getItem(0));
            }
        }
        this.serverNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CRLUpdate1Page.this.changeServer();
                CRLUpdate1Page.this.setPageComplete(CRLUpdate1Page.this.canFlipToNextPage());
            }
        });
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        super.createDataSet();
        Label lblMember = new Label(this.dataSetComposite, 0);
        lblMember.setText("&Member name:");
        this.txtMember = new Text(this.dataSetComposite, 2048);
        GridData gd_txtMember = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtMember.widthHint = 280;
        this.txtMember.setLayoutData((Object)gd_txtMember);
        this.txtMember.addModifyListener((ModifyListener)this);
        this.txtMember.setTextLimit(8);
        this.txtMember.addVerifyListener((VerifyListener)new verifytoUpperCase());
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        Label lblDescription = new Label(this.dataSetComposite, 0);
        lblDescription.setText("Descri&ption:");
        this.txtDescription = new Text(this.dataSetComposite, 2048);
        GridData gd_txtDescription = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtDescription.widthHint = 280;
        this.txtDescription.setLayoutData((Object)gd_txtDescription);
        this.txtDescription.setTextLimit(51);
        this.txtDescription.addModifyListener((ModifyListener)this);
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        Label lblRecOffset = new Label(this.dataSetComposite, 0);
        lblRecOffset.setText("Record &offset:");
        this.spnRecOffset = new Spinner(this.dataSetComposite, 2048);
        this.spnRecOffset.setMaximum(99999);
        this.spnRecOffset.setMinimum(-99999);
        this.spnRecOffset.setTextLimit(5);
        GridData gd_spinner = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_spinner.widthHint = 80;
        this.spnRecOffset.setLayoutData((Object)gd_spinner);
        this.spnRecOffset.addModifyListener((ModifyListener)this);
        this.spnRecOffset.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (CRLUpdate1Page.this.spnRecOffset.getText().equals("")) {
                    CRLUpdate1Page.this.isOffsetEmpty = true;
                } else {
                    CRLUpdate1Page.this.isOffsetEmpty = false;
                }
            }
        });
        this.spnRecOffset.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (CRLUpdate1Page.this.isOffsetEmpty) {
                    CRLUpdate1Page.this.spnRecOffset.setSelection(0);
                    CRLUpdate1Page.this.isOffsetEmpty = false;
                }
            }
        });
        Composite compositeTable = new Composite(this.container, 0);
        GridData gd_compositeTable = new GridData(4, 4, true, true, 1, 1);
        gd_compositeTable.heightHint = 249;
        compositeTable.setLayoutData((Object)gd_compositeTable);
        compositeTable.setLayout((Layout)new GridLayout(1, false));
        this.topLevelGroup = new Group(compositeTable, 0);
        GridData gd_group = new GridData(4, 4, true, true, 1, 1);
        gd_group.widthHint = 605;
        this.topLevelGroup.setLayoutData((Object)gd_group);
        this.topLevelGroup.setLayout((Layout)new GridLayout(2, false));
        Composite composite_left = new Composite((Composite)this.topLevelGroup, 0);
        composite_left.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite_left.setLayout((Layout)new GridLayout(1, false));
        this.createViewer(composite_left);
        Composite composite_default = new Composite(composite_left, 0);
        composite_default.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_composite_default = new GridLayout(2, false);
        gl_composite_default.marginWidth = 0;
        composite_default.setLayout((Layout)gl_composite_default);
        Label lblDefaultLayout = new Label(composite_default, 0);
        lblDefaultLayout.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblDefaultLayout.setSize(55, 15);
        lblDefaultLayout.setText("Defaul&t layout:");
        this.txtDefault = new Text(composite_default, 2048);
        GridData gd_txtDefault = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtDefault.widthHint = 252;
        this.txtDefault.setLayoutData((Object)gd_txtDefault);
        this.txtDefault.setEditable(false);
        this.txtDefault.setText("No Default");
        this.checkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.checkboxTableViewer.setInput(null);
        Composite composite_right = new Composite((Composite)this.topLevelGroup, 0);
        composite_right.setLayoutData((Object)new GridData(131072, 4, false, true, 1, 1));
        composite_right.setLayout((Layout)new GridLayout(1, false));
        this.btnRules = new Button(composite_right, 0);
        this.btnRules.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnRules.setText("R&ules...");
        this.btnRules.addSelectionListener((SelectionListener)this);
        this.btnRules.setEnabled(false);
        this.btnInsert = new Button(composite_right, 0);
        this.btnInsert.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnInsert.setText("&Insert Layout...");
        this.btnInsert.addSelectionListener((SelectionListener)this);
        this.btnDefault = new Button(composite_right, 0);
        this.btnDefault.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDefault.setText("Set as D&efault");
        this.btnDefault.addSelectionListener((SelectionListener)this);
        this.btnDefault.setEnabled(false);
        this.btnRemove = new Button(composite_right, 0);
        this.btnRemove.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnRemove.setText("Remo&ve Layout");
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnRemove.setEnabled(false);
        if (this.newCRL) {
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("OK");
        }
        this.dataSetCombo.setFocus();
        FMHistory.intializeComboBoxes((Combo)this.dataSetCombo, (String)"DatasetListCRLUpdate1Page");
        if (this.crl.getDatasetName() != null) {
            this.dataSetCombo.setText(this.crl.getDatasetName());
            this.txtMember.setFocus();
        }
        if (!this.newCRL) {
            this.txtMember.setText(this.crl.getMemberName());
        }
        if (this.crl.getDatasetName() != null) {
            this.dataSetCombo.setText(this.crl.getDatasetName());
        }
        if (this.crl.getMemberName() != null) {
            this.txtMember.setText(this.crl.getMemberName());
        }
        if (this.crl.getDescription() != null) {
            this.txtDescription.setText(this.crl.getDescription());
        }
        this.spnRecOffset.setSelection(this.crl.getOffset());
        this.tableUpdate();
    }

    private void createViewer(Composite parent) {
        this.checkboxTableViewer = new TableViewer(parent, 68354);
        this.checkboxTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int selectionCount = CRLUpdate1Page.this.checkboxTableViewer.getTable().getSelectionCount();
                switch (selectionCount) {
                    case 0: {
                        CRLUpdate1Page.this.btnRules.setEnabled(false);
                        CRLUpdate1Page.this.btnDefault.setEnabled(false);
                        CRLUpdate1Page.this.btnRemove.setEnabled(false);
                        break;
                    }
                    case 1: {
                        if (CRLUpdate1Page.this.crl.getLayout(CRLUpdate1Page.this.checkboxTableViewer.getTable().getSelectionIndex()).isDefault()) {
                            CRLUpdate1Page.this.btnDefault.setText("Clear D&efault");
                        } else {
                            CRLUpdate1Page.this.btnDefault.setText("Set as D&efault");
                        }
                        CRLUpdate1Page.this.btnRules.setEnabled(true);
                        CRLUpdate1Page.this.btnDefault.setEnabled(true);
                        CRLUpdate1Page.this.btnRemove.setEnabled(true);
                        break;
                    }
                    default: {
                        CRLUpdate1Page.this.btnRules.setEnabled(false);
                        CRLUpdate1Page.this.btnDefault.setEnabled(false);
                        CRLUpdate1Page.this.btnRemove.setEnabled(true);
                    }
                }
            }
        });
        this.checkboxTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CRLUpdate1Page.this.openRules(CRLUpdate1Page.this.checkboxTableViewer.getTable().getSelectionIndex());
            }
        });
        this.topLevelTable = this.checkboxTableViewer.getTable();
        this.topLevelTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.topLevelTable.setLinesVisible(true);
        this.topLevelTable.setHeaderVisible(true);
        this.topLevelTable.setFocus();
        this.createColumns(parent, this.checkboxTableViewer);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        String[] titles = new String[]{"Member", "Layout DSN", "Top Level Field Name"};
        int[] bounds = new int[]{100, 200, 150};
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(viewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(titles[i]);
            tableColumn.setWidth(bounds[i]);
            switch (i) {
                case 0: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new LayoutMemberLabelProvider());
                    break;
                }
                case 1: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new LayoutDSNLabelProvider());
                    break;
                }
                case 2: {
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new TopFieldNameLabelProvider());
                }
            }
            ++i;
        }
    }

    private void openRules(int index) {
        TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new CRLUpdate2(this.crl, index, this.server));
        dialog.create();
        dialog.open();
    }

    private void tableUpdate() {
        this.checkboxTableViewer.setInput((Object)this.crl.getLayouts().toArray(new Object[this.crl.getLayouts().size()]));
        this.checkboxTableViewer.refresh();
        this.txtDefault.setText("No Default");
        int i = 0;
        while (i < this.crl.getLayouts().size()) {
            if (this.crl.getLayout(i).isDefault()) {
                this.txtDefault.setText(String.valueOf(this.crl.getLayout(i).getLayoutMember()) + ": " + this.crl.getLayout(i).getTopLayoutField());
                break;
            }
            ++i;
        }
        this.setPageComplete(this.isPageComplete());
    }

    public void insertLayouts(CRLClass crlLayout) {
        int i = 0;
        while (i < crlLayout.getLayouts().size()) {
            this.crl.addLayout(crlLayout.getLayout(i));
            this.listOfLayouts.add(crlLayout.getLayout(i).getTopLayoutField());
            ++i;
        }
        this.tableUpdate();
    }

    public boolean isPageComplete() {
        return this.nextOrFinish();
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    private boolean ValidateMember() {
        if (this.txtMember != null) {
            if (Validator.member((String)this.txtMember.getText(), (boolean)true) == 0) {
                return true;
            }
            switch (Validator.member((String)this.txtMember.getText(), (boolean)true)) {
                case 0: {
                    break;
                }
                case 7: {
                    this.error = String.valueOf(this.error) + "Member name has invalid format\n";
                    break;
                }
                case 6: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member((String)this.txtMember.getText(), (boolean)true)] + "\n ";
                    break;
                }
                case 5: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member((String)this.txtMember.getText(), (boolean)true)] + "\n ";
                }
            }
            if (this.error.length() > 0) {
                this.setErrorMessage(this.error);
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }
        return false;
    }

    private boolean nextOrFinish() {
        this.error = "";
        boolean returnVal = false;
        returnVal = super.isPageComplete();
        if (this.getErrorMessage() != null) {
            this.error = this.getErrorMessage();
        }
        if (this.checkboxTableViewer.getTable().getItemCount() == 0) {
            this.error = String.valueOf(this.error) + "Insert at least one layout\n ";
            returnVal = false;
        }
        if (returnVal) {
            returnVal = this.ValidateMember();
        }
        if (this.txtMember != null && this.newCRL || this.txtMember != null && !this.newCRL && !this.origMember.equalsIgnoreCase(this.txtMember.getText().trim())) {
            String memberName = this.txtMember.getText().trim();
            FileMasterDataset fmdataset = new FileMasterDataset(null);
            fmdataset.setName(this.dataSetCombo.getText());
            fmdataset.setDsOrg("PDS");
            TT_TreeItem dsItem = null;
            dsItem = this.fmltModel.findObject((Object)fmdataset);
            if (dsItem != null) {
                FileMasterMember fmmember = new FileMasterMember(dsItem);
                fmmember.setName(memberName);
                if (this.fmltModel.findObjectInTree((Object)fmmember, dsItem) != null) {
                    this.error = String.valueOf(this.error) + "Duplicate member name\n ";
                    returnVal = false;
                }
            }
        }
        if (this.spnRecOffset.getText().startsWith("-")) {
            this.spnRecOffset.setTextLimit(6);
        } else {
            this.spnRecOffset.setTextLimit(5);
        }
        if (!this.spnRecOffset.getText().matches("-?[0-9]*")) {
            this.error = String.valueOf(this.error) + "Record offset has invalid format\n ";
            returnVal = false;
        }
        if (this.spnRecOffset.getSelection() > 32760 || this.spnRecOffset.getSelection() < -32760) {
            this.error = String.valueOf(this.error) + "Record offset is out of bounds\n ";
            returnVal = false;
        }
        if (this.txtDescription.getText().trim().equalsIgnoreCase("")) {
            this.error = String.valueOf(this.error) + "Missing description\n ";
            returnVal = false;
        }
        int i = 0;
        while (i < this.crl.getLayouts().size()) {
            if (this.crl.getLayout(i).getLayoutFields().size() == 0) {
                this.error = String.valueOf(this.error) + "Invalid Custom Layout";
                returnVal = false;
                break;
            }
            ++i;
        }
        if (this.error.length() > 0) {
            this.setErrorMessage(this.error);
        } else {
            this.setErrorMessage(null);
        }
        return returnVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doFinish() {
        FMHistory.clearList((String)"ServerAddLayoutPage1");
        FMHistory.insertHistory((Combo)this.serverNameCombo, (String)"ServerAddLayoutPage1");
        FMHistory.insertHistory((Combo)this.dataSetCombo, (String)"DatasetListCRLUpdate1Page");
        this.changeServer();
        this.crl.setDatasetName(this.dataSetCombo.getText().trim());
        this.crl.setMemberName(this.txtMember.getText().trim());
        this.crl.setDescription(this.txtDescription.getText());
        this.crl.setOffset(this.spnRecOffset.getSelection());
        int i = 0;
        while (i < this.crl.getLayouts().size()) {
            if (this.crl.getLayout(i).getEntryVersion() == null) {
                this.crl.getLayout(i).setEntryVersion("8.5");
            }
            ++i;
        }
        this.fmdataset = new FileMasterDataset(null);
        this.fmdataset.setName(this.crl.getDatasetName());
        this.fmdataset.setDsOrg("PDS");
        FileMasterMember fmmember = new FileMasterMember(null);
        fmmember.setName(this.crl.getMemberName());
        fmmember.setType("CRL");
        FileMasterLayout fmlayout = null;
        Element fmlayoutElement = null;
        FileMasterLayoutField fmlayoutfield = null;
        Element fmlayoutfieldElement = null;
        TT_TreeItem dsItem = null;
        TT_TreeItem memItem = null;
        TT_TreeItem fmlayoutItem = null;
        RunPutCrlMem runner = this.newCRL || !this.newCRL && !this.origDataSet.equalsIgnoreCase(this.crl.getDatasetName()) || !this.newCRL && !this.origMember.equalsIgnoreCase(this.crl.getMemberName()) ? new RunPutCrlMem(this.server, this.crl, false) : new RunPutCrlMem(this.server, this.crl, true);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml == null) return false;
        Element element = xml.getRoot();
        if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
            TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
            return false;
        }
        NodeList nodes = element.getElementsByTagName("GUIResponse");
        NodeList messages = element.getElementsByTagName("Message");
        NodeList retCode = element.getElementsByTagName("ReturnCode");
        String message = "";
        if (nodes.getLength() != 0) return false;
        int i2 = 0;
        while (i2 < messages.getLength()) {
            Node msgNode = messages.item(i2);
            Element msgElement = (Element)msgNode;
            message = String.valueOf(message) + CRLUpdate1Page.getTagValue("Message", msgElement);
            ++i2;
        }
        Node rcNode = retCode.item(0);
        Element rcElement = (Element)rcNode;
        String returnCode = CRLUpdate1Page.getTagValue("ReturnCode", rcElement);
        if (!returnCode.equalsIgnoreCase("0")) {
            TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
            return false;
        }
        if (this.newCRL || !this.newCRL && !this.origDataSet.equalsIgnoreCase(this.crl.getDatasetName()) || !this.newCRL && !this.origMember.equalsIgnoreCase(this.crl.getMemberName())) {
            dsItem = this.fmltModel.findObject((Object)this.fmdataset);
            if (dsItem == null) {
                this.fmdataset = CommonMFCalls.getFQDSN((String)this.fmdataset.getName(), (String)"", (FileMasterServer)this.server);
                if (!CommonMFCalls.RETURN_CODE.equals("0")) {
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + CommonMFCalls.RETURN_CODE), (Throwable)new Throwable(CommonMFCalls.MESSAGE));
                    return false;
                }
                if (this.fmdataset.getDsOrg().equalsIgnoreCase("PDS") || this.fmdataset.getDsOrg().equalsIgnoreCase("PDSE")) {
                    Element dsElement = this.fmltModel.addDataset(null, this.fmdataset);
                    dsItem = this.fmltModel.insertDataset(dsElement);
                } else {
                    TT_ErrorDialog.openError(null, (String)"Error", (String)"FILE NOT A PDS", (Throwable)new Throwable("THE SPECIFIED DATASET '" + this.fmdataset.getName() + "' IS NOT A PARTITIONED DATASET"));
                    return false;
                }
            }
            Element memElement = this.fmltModel.addMember(dsItem.getElement(), fmmember.getName(), fmmember.getType(), this.crl.getDescription(), this.crl.getOffset());
            memItem = this.fmltModel.insertMember(dsItem, memElement);
        } else {
            dsItem = this.fmltModel.findObject((Object)this.fmdataset);
            int i3 = 0;
            while (i3 < dsItem.getChildren().length) {
                if (((TT_TreeItem)dsItem.getChildren()[i3]).getName().equalsIgnoreCase(this.crl.getMemberName())) {
                    memItem = (TT_TreeItem)dsItem.getChildren()[i3];
                    break;
                }
                ++i3;
            }
            memItem.getElement().setAttribute("description", this.crl.getDescription());
            memItem.getElement().setAttribute("offset", String.valueOf(this.crl.getOffset()));
            int numChildren = memItem.getChildren().length;
            int i4 = numChildren - 1;
            while (i4 >= 0) {
                this.fmltModel.removeItem((Object)((TT_TreeItem)memItem.getChildren()[i4]), memItem);
                --i4;
            }
        }
        int i5 = 0;
        while (i5 < this.crl.getLayouts().size()) {
            fmlayout = new FileMasterLayout(null);
            fmlayout.setName(String.valueOf(this.crl.getLayout(i5).getLayoutMember()) + ": " + this.crl.getLayout(i5).getTopLayoutField());
            fmlayout.setLevel(this.crl.getLayout(i5).getTopLayoutLevelString());
            fmlayoutElement = this.fmltModel.addLayout(memItem.getElement(), fmlayout.getName(), this.crl.getLayout(i5).getLayoutDataset(), this.crl.getLayout(i5).getLayoutMember(), this.crl.getLayout(i5).isDefault());
            fmlayoutItem = this.fmltModel.insertLayout(memItem, fmlayoutElement);
            int j = 0;
            while (j < this.crl.getLayout(i5).getLayoutFields().size()) {
                fmlayoutfield = new FileMasterLayoutField(null);
                fmlayoutfield.setName(this.crl.getLayout(i5).getLayoutField(j).getField());
                fmlayoutfield.setLevel(this.crl.getLayout(i5).getLayoutField(j).getLevelString());
                if (this.crl.getLayout(i5).getLayoutField(j).isSelected()) {
                    fmlayoutfieldElement = this.fmltModel.addLayoutField(fmlayoutElement, fmlayoutfield.getName(), fmlayoutfield.getLevel(), this.crl.getLayout(i5).getLayoutField(j).isTop(), this.crl.getLayout(i5).getLayoutField(j).isSelected(), this.crl.getLayout(i5).getLayoutField(j).getPosition(), this.crl.getLayout(i5).getLayoutField(j).getFormatType(), this.crl.getLayout(i5).getLayoutField(j).getFormatNum(), this.crl.getLayout(i5).getLayoutField(j).getFormatDec(), this.crl.getLayout(i5).getLayoutField(j).getLogOperator(), this.crl.getLayout(i5).getLayoutField(j).getOperator(), this.crl.getLayout(i5).getLayoutField(j).getValue());
                    this.fmltModel.insertLayoutField(fmlayoutItem, fmlayoutfieldElement);
                }
                ++j;
            }
            ++i5;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        try {
            TreeViewer viewer;
            IWorkbenchPage page = window.getActivePage();
            IViewPart view = page.showView("com.ca.filemaster.layout.views.layoutview");
            if (view instanceof LayoutView && (viewer = ((LayoutView)view).getViewer()) != null) {
                TT_TreeItem selection = this.fmltModel.findObjectInTree((Object)fmmember, this.fmltModel.findObject((Object)this.fmdataset));
                Object[] expandedElements = viewer.getExpandedElements();
                viewer.setInput((Object)this.fmltModel.getDatasets());
                viewer.refresh(true);
                viewer.setExpandedElements(expandedElements);
                viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                view = page.showView("com.ca.filemaster.layout.views.layoutview");
                page.activate((IWorkbenchPart)view);
                page.bringToTop((IWorkbenchPart)view);
                view.setFocus();
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        this.fmltModel.save();
        return true;
    }

    public XMLRequest getSRXML() {
        XMLRequest xml = new XMLRequest();
        xml.setCommand("AddLayout");
        Element element = xml.getCommand();
        Element layoutElement = xml.createElement("layoutnode");
        layoutElement.setAttribute("name", "STUDENT-RECORD");
        layoutElement.setAttribute("level", "01");
        Element layoutFieldNameElement = xml.createElement("layoutnode");
        layoutFieldNameElement.setAttribute("name", "NAME");
        layoutFieldNameElement.setAttribute("level", "03");
        Element layoutFieldIDElement = xml.createElement("layoutnode");
        layoutFieldIDElement.setAttribute("name", "ID");
        layoutFieldIDElement.setAttribute("level", "03");
        Element layoutFieldEthinicityElement = xml.createElement("layoutnode");
        layoutFieldEthinicityElement.setAttribute("name", "ETHINICITY");
        layoutFieldEthinicityElement.setAttribute("level", "03");
        layoutElement.appendChild(layoutFieldNameElement);
        layoutElement.appendChild(layoutFieldIDElement);
        layoutElement.appendChild(layoutFieldEthinicityElement);
        element.appendChild(layoutElement);
        return xml;
    }

    public XMLRequest getCRXML() {
        XMLRequest xml = new XMLRequest();
        xml.setCommand("AddLayout");
        Element element = xml.getCommand();
        Element layoutElement2 = xml.createElement("layoutnode");
        layoutElement2.setAttribute("name", "CUSTOMER-RECORD");
        layoutElement2.setAttribute("level", "01");
        Element layoutFieldFirstNameElement = xml.createElement("layoutnode");
        layoutFieldFirstNameElement.setAttribute("name", "FIRST-NAME");
        layoutFieldFirstNameElement.setAttribute("level", "03");
        Element layoutFieldLastNameElement = xml.createElement("layoutnode");
        layoutFieldLastNameElement.setAttribute("name", "LAST-NAME");
        layoutFieldLastNameElement.setAttribute("level", "03");
        Element layoutFieldAgeElement = xml.createElement("layoutnode");
        layoutFieldAgeElement.setAttribute("name", "AGE");
        layoutFieldAgeElement.setAttribute("level", "03");
        Element layoutFieldSSNElement = xml.createElement("layoutnode");
        layoutFieldSSNElement.setAttribute("name", "SSN");
        layoutFieldSSNElement.setAttribute("level", "03");
        layoutElement2.appendChild(layoutFieldFirstNameElement);
        layoutElement2.appendChild(layoutFieldLastNameElement);
        layoutElement2.appendChild(layoutFieldAgeElement);
        layoutElement2.appendChild(layoutFieldSSNElement);
        element.appendChild(layoutElement2);
        return xml;
    }

    public XMLRequest getBothXML() {
        XMLRequest xml = new XMLRequest();
        xml.setCommand("AddLayout");
        Element element = xml.getCommand();
        Element layoutElement = xml.createElement("layoutnode");
        layoutElement.setAttribute("name", "STUDENT-RECORD");
        layoutElement.setAttribute("level", "01");
        Element layoutFieldNameElement = xml.createElement("layoutnode");
        layoutFieldNameElement.setAttribute("name", "NAME");
        layoutFieldNameElement.setAttribute("level", "03");
        Element layoutFieldIDElement = xml.createElement("layoutnode");
        layoutFieldIDElement.setAttribute("name", "ID");
        layoutFieldIDElement.setAttribute("level", "03");
        Element layoutFieldEthinicityElement = xml.createElement("layoutnode");
        layoutFieldEthinicityElement.setAttribute("name", "ETHINICITY");
        layoutFieldEthinicityElement.setAttribute("level", "03");
        layoutElement.appendChild(layoutFieldNameElement);
        layoutElement.appendChild(layoutFieldIDElement);
        layoutElement.appendChild(layoutFieldEthinicityElement);
        element.appendChild(layoutElement);
        Element layoutElement2 = xml.createElement("layoutnode");
        layoutElement2.setAttribute("name", "CUSTOMER-RECORD");
        layoutElement2.setAttribute("level", "01");
        Element layoutFieldFirstNameElement = xml.createElement("layoutnode");
        layoutFieldFirstNameElement.setAttribute("name", "FIRST-NAME");
        layoutFieldFirstNameElement.setAttribute("level", "03");
        Element layoutFieldLastNameElement = xml.createElement("layoutnode");
        layoutFieldLastNameElement.setAttribute("name", "LAST-NAME");
        layoutFieldLastNameElement.setAttribute("level", "03");
        Element layoutFieldAgeElement = xml.createElement("layoutnode");
        layoutFieldAgeElement.setAttribute("name", "AGE");
        layoutFieldAgeElement.setAttribute("level", "03");
        Element layoutFieldSSNElement = xml.createElement("layoutnode");
        layoutFieldSSNElement.setAttribute("name", "SSN");
        layoutFieldSSNElement.setAttribute("level", "03");
        layoutElement2.appendChild(layoutFieldFirstNameElement);
        layoutElement2.appendChild(layoutFieldLastNameElement);
        layoutElement2.appendChild(layoutFieldAgeElement);
        layoutElement2.appendChild(layoutFieldSSNElement);
        element.appendChild(layoutElement2);
        return xml;
    }

    private String[] getServers() {
        String[] listOfServers = new String[this.fmstModel.getServers().length];
        int serverCount = 0;
        while (serverCount < this.fmstModel.getServers().length) {
            listOfServers[serverCount] = this.fmstModel.getServers()[serverCount].getServer().getText();
            ++serverCount;
        }
        if (this.server == null) {
            this.server = (FileMasterServer)this.fmstModel.getServers()[0].getServer();
            this.serverChanged(this.server);
        }
        return listOfServers;
    }

    private void changeServer() {
        String TestServer = "";
        int servers = 0;
        while (servers < this.fmstModel.getServers().length) {
            TestServer = this.fmstModel.getServers()[servers].getText();
            if (TestServer.equalsIgnoreCase(this.serverNameCombo.getText())) {
                this.server = (FileMasterServer)this.fmstModel.getServers()[servers].getAdapter(FileMasterServer.class);
                this.serverChanged(this.server);
                break;
            }
            ++servers;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.btnRules) {
            this.openRules(this.checkboxTableViewer.getTable().getSelectionIndex());
        } else if (e.getSource() == this.btnInsert) {
            TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new InsertTopLayoutWizard());
            dialog.create();
            dialog.open();
            this.setPageComplete(this.isPageComplete());
        } else if (e.getSource() == this.btnDefault) {
            int selectedIndex = this.checkboxTableViewer.getTable().getSelectionIndex();
            if (this.crl.getLayout(selectedIndex).isDefault()) {
                this.crl.getLayout(selectedIndex).setDefault(false);
                this.txtDefault.setText("No Default");
                this.btnDefault.setText("Set as D&efault");
            } else {
                int i = 0;
                while (i < this.crl.getLayouts().size()) {
                    if (i != selectedIndex) {
                        this.crl.getLayout(i).setDefault(false);
                    } else {
                        this.crl.getLayout(i).setDefault(true);
                        this.txtDefault.setText(String.valueOf(this.crl.getLayout(i).getLayoutMember()) + ": " + this.crl.getLayout(i).getTopLayoutField());
                        this.btnDefault.setText("Clear D&efault");
                    }
                    ++i;
                }
            }
            this.setPageComplete(this.isPageComplete());
        } else if (e.getSource() == this.btnRemove) {
            ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
            String key = "CLOSING_VALUE";
            boolean showDiag = !store.getBoolean(key);
            boolean remove = false;
            int[] itemsSelected = this.checkboxTableViewer.getTable().getSelectionIndices();
            if (showDiag) {
                String question = itemsSelected.length == 1 ? "Do you want to remove selected layout from custom layout?" : "Do you want to remove selected layouts from custom layout?";
                String toggleMessage = "Always remove items without this prompt";
                MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Remove", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)store, (String)key);
                int returncode = result.getReturnCode();
                boolean bl = remove = returncode == 0 || returncode == 2;
                if (remove) {
                    store.setValue(key, result.getToggleState());
                }
            }
            if (showDiag && remove || !showDiag) {
                int i = itemsSelected.length - 1;
                while (i >= 0) {
                    this.crl.removeLayout(itemsSelected[i]);
                    --i;
                }
                this.btnRemove.setEnabled(false);
                this.tableUpdate();
            }
            this.setPageComplete(this.isPageComplete());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        return nValue.getNodeValue();
    }
}

