/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.pricommands.wizards;

import com.ca.filemaster.common.FMPRange;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.editor.virtualtableviews.CharFormatMode;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.runners.RunGetReset;
import com.ca.testingtools.common.XMLRequest;
import java.util.ArrayList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class ResetprimaryCommandWizardPage
extends WizardPage
implements ModifyListener,
SelectionListener {
    private Composite container;
    private Group restOptionGroup;
    protected FileMasterServer server;
    protected String uuid;
    protected String displayMode;
    protected String hexMode;
    public static final String CONTEXT_HELP_ID = "com.ca.filemaster.help.reset";
    Button commandButton;
    Button excudeButton;
    Button errorButton;
    Button changeButton;
    Button findButton;
    private ArrayList<String> restOptions = new ArrayList();

    public ResetprimaryCommandWizardPage(String pageName, FileMasterServer server, String uuid, String displayMode, String hexMode) {
        super(pageName);
        this.setTitle("Reset");
        this.server = server;
        this.uuid = uuid;
        this.displayMode = displayMode;
        this.hexMode = hexMode;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_HELP_ID);
        this.restOptionGroup = new Group(this.container, 0);
        this.restOptionGroup.setLayout((Layout)new GridLayout(3, false));
        this.restOptionGroup.setSize(this.restOptionGroup.computeSize(-1, -1));
        this.restOptionGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.restOptionGroup.setText("Reset options");
        this.commandButton = new Button((Composite)this.restOptionGroup, 32);
        this.commandButton.setText("&Command");
        this.commandButton.addSelectionListener((SelectionListener)this);
        this.commandButton.setSelection(true);
        this.excudeButton = new Button((Composite)this.restOptionGroup, 32);
        this.excudeButton.setText("E&xclude");
        this.excudeButton.addSelectionListener((SelectionListener)this);
        this.excudeButton.setSelection(true);
        this.errorButton = new Button((Composite)this.restOptionGroup, 32);
        this.errorButton.setText("E&rror");
        this.errorButton.addSelectionListener((SelectionListener)this);
        this.errorButton.setSelection(true);
        this.changeButton = new Button((Composite)this.restOptionGroup, 32);
        this.changeButton.setText("Chan&ge");
        this.changeButton.addSelectionListener((SelectionListener)this);
        this.changeButton.setSelection(true);
        this.findButton = new Button((Composite)this.restOptionGroup, 32);
        this.findButton.setText("&Find");
        this.findButton.addSelectionListener((SelectionListener)this);
        this.findButton.setSelection(true);
        Point size = this.getShell().computeSize(350, 400);
        this.getShell().setSize(size);
        this.setControl((Control)this.container);
        this.getShell().getDefaultButton().setText("OK");
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        this.setErrorMessage(null);
        return this.commandButton.getSelection() || this.excudeButton.getSelection() || this.errorButton.getSelection() || this.changeButton.getSelection() || this.findButton.getSelection();
    }

    public boolean doFinish() {
        FMPRange labelPair = new FMPRange("", "");
        RunGetReset runner = new RunGetReset(this.server, this.uuid, this.displayMode, this.hexMode, labelPair, this.restOptions);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xmlRequest = runner.getXml();
        Element reqElement = xmlRequest.getRoot();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window.getActivePage().getActivePart() instanceof EditorView) {
            EditorView view = (EditorView)window.getActivePage().getActivePart();
            IWorkbenchPage page = window.getActivePage();
            IWorkbenchPart workbenchPart = page.getActivePart();
            IWorkbenchPartSite workbenchPartSite = workbenchPart.getSite();
            String secondaryId = ((IViewSite)workbenchPartSite).getSecondaryId();
            view.handleMissingSession(reqElement, page, secondaryId);
            if (xmlRequest != null && xmlRequest.getRoot().getNodeName().equals("GUIResponse")) {
                if (this.displayMode.equalsIgnoreCase("C")) {
                    CharFormatMode.resetRecordCount();
                    view.getCharMode().setCallMF(false);
                    view.getCharMode().isReset = true;
                    view.updateCharEditViewer(xmlRequest);
                    view.updateCharEditItemCount();
                }
                if (this.displayMode.equalsIgnoreCase("M")) {
                    view.getMultiRecordFormatMode().setUpdateCurrentDisplay(true);
                    view.updateMRFEditViewer(xmlRequest);
                }
                if (this.displayMode.equalsIgnoreCase("S")) {
                    view.updateSRFEditViewer(xmlRequest);
                }
                if (this.commandButton.getSelection() && view.isMoveCopyPending()) {
                    view.setMoveCopyPending(false);
                    view.clearMoveCopyPendingMessage();
                }
            }
        }
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        this.restOptions.clear();
        int x = 0;
        while (x < this.restOptionGroup.getChildren().length) {
            if (((Button)this.restOptionGroup.getChildren()[x]).getSelection()) {
                this.restOptions.add(((Button)this.restOptionGroup.getChildren()[x]).getText().replace("&", "").trim());
            }
            ++x;
        }
        this.setPageComplete(this.isPageComplete());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

