/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.utils.DateTimeUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class TimeStampValidator
implements IInputValidator,
ICellEditorValidator {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final Logger logger = Logger.getLogger(TimeStampValidator.class);
    private Pattern pattern;
    private String errMsg;
    private ColumnModel columnModel;
    private DataType dataType;
    private boolean scaleExists;
    private String nanoSecondsPattern = "";
    public static final String TIMESTAMP_PATTERN = "YYYY-MM-DD-hh.mm.ss";
    public static final String TIMESTAMPTZ_PATTERN = "[[ ]\ufffdth[:tm]]";
    private String NANO_SECONDS_REGEX = "([.]([0-9]{1,n}))?";
    private static final String TIMEZONE_REGEX = "(( )?[+-]([0-9]{1,2})(:([0-9]{2}))?)?";
    public static final String ISO_TIME_FORMAT_REGEX = "([0-9]{1,2})[.]([0-9]{2})[.]([0-9]{2})";
    public static final String TIMESTMP_FORMAT_REGEX = "([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})[-]([0-9]{1,2})[.]([0-9]{2})[.]([0-9]{2})";
    public static final String TIMESTMPTZ_FORMAT_REGEX = "([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})[-]([0-9]{1,2})[.]([0-9]{2})[.]([0-9]{2})( )?[+-]([0-9]{1,2}):([0-9]{2})";
    public static final Pattern TIMESTMP_FORMAT_PATTERN_INSTANCE = Pattern.compile("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})[-]([0-9]{1,2})[.]([0-9]{2})[.]([0-9]{2})");
    public static final Pattern TIMESTMPTZ_FORMAT_PATTERN_INSTANCE = Pattern.compile("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})[-]([0-9]{1,2})[.]([0-9]{2})[.]([0-9]{2})( )?[+-]([0-9]{1,2}):([0-9]{2})");

    public TimeStampValidator(ColumnModel columnModel, DataType dataType, String format) {
        this.columnModel = columnModel;
        this.dataType = dataType;
        this.scaleExists = columnModel.getScale() != 0;
        this.nanoSecondsPattern = this.getNanoSecondsPattern();
        this.errMsg = DWBundle.bind((String)DWBundle.ERR_INVALID_TIMESTMP_FORMAT, (Object)this.getTimeStampFormat());
        this.pattern = Pattern.compile(this.getRegex());
    }

    private String getTimeStampFormat() {
        String pattern = TIMESTAMP_PATTERN;
        if (this.scaleExists) {
            pattern = String.valueOf(pattern) + "[" + "." + this.nanoSecondsPattern + "]";
        }
        return this.dataType == DataType.TIMESTMP ? pattern : String.valueOf(pattern) + TIMESTAMPTZ_PATTERN;
    }

    private String getRegex() {
        String nanoSecondsRegex = "";
        if (this.scaleExists) {
            nanoSecondsRegex = this.NANO_SECONDS_REGEX.replace("n", String.valueOf(this.columnModel.getScale()));
        }
        if (this.dataType == DataType.TIMESTZ) {
            return TIMESTMP_FORMAT_REGEX + nanoSecondsRegex + TIMEZONE_REGEX;
        }
        return TIMESTMP_FORMAT_REGEX + nanoSecondsRegex;
    }

    public String isValid(String value) {
        if (!value.isEmpty()) {
            return this.isValidTimeStampFormat(value);
        }
        return null;
    }

    public String isValid(Object value) {
        return value != null ? this.isValid(value.toString().trim()) : null;
    }

    private String isValidTimeStampFormat(String s) {
        try {
            Matcher matcher = this.pattern.matcher(s);
            if (!matcher.matches()) {
                return this.errMsg;
            }
            return this.validateRanges(matcher);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String validateRanges(Matcher matcher) {
        try {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(2));
            int day = Integer.parseInt(matcher.group(3));
            String errMsg = DateTimeUtil.validateRangesForDate(year, month, day);
            int hours = Integer.parseInt(matcher.group(4));
            int minutes = Integer.parseInt(matcher.group(5));
            int seconds = Integer.parseInt(matcher.group(6));
            long fractionalseconds = 0L;
            int th = 0;
            int tm = 0;
            if (errMsg == null) {
                errMsg = DateTimeUtil.validateRangesForTime(false, hours, minutes, seconds);
            }
            if (errMsg == null) {
                String nanoseconds = this.scaleExists ? matcher.group(7) : null;
                String string = nanoseconds = nanoseconds == null ? null : nanoseconds.substring(1);
                if (nanoseconds != null) {
                    fractionalseconds = Long.parseLong(nanoseconds);
                    if (hours == 24 && fractionalseconds > 0L) {
                        errMsg = DWBundle.ERR_INVALID_TIMESTAMP_NANOSECONDS;
                    }
                }
                if (errMsg == null && this.dataType == DataType.TIMESTZ) {
                    if (!this.scaleExists) {
                        if (matcher.group(9) != null) {
                            th = Integer.parseInt(matcher.group(9));
                            tm = matcher.group(10) == null ? 0 : Integer.parseInt(matcher.group(10).substring(1));
                            errMsg = this.validateTimeZone(th, tm);
                        }
                    } else if (matcher.group(11) != null) {
                        th = Integer.parseInt(matcher.group(11));
                        tm = matcher.group(12) == null ? 0 : Integer.parseInt(matcher.group(12).substring(1));
                        errMsg = this.validateTimeZone(th, tm);
                    }
                }
            }
            if (errMsg == null && year == 9999 && month == 12 && (day == 31 || day == 30 && (hours != 0 || minutes != 0 || seconds != 0 || fractionalseconds != 0L))) {
                if (this.dataType == DataType.TIMESTMP) {
                    return DWBundle.ERR_MAXDATE_TIMESTAMP;
                }
                return DWBundle.ERR_MAXDATE_TIMESTZ;
            }
            return errMsg;
        }
        catch (Exception e) {
            logger.error((Object)("error occured while validating ranges for timestamp : " + matcher.group()), (Throwable)e);
            return DWBundle.ERR_INVALID_TIMESTAMP;
        }
    }

    private String validateTimeZone(int th, int tm) {
        if (th < 0 || th > 24) {
            return DWBundle.bind((String)DWBundle.ERR_INVALID_TZHOUR, (Object)0, (Object)24);
        }
        if (th == 24 && tm != 0) {
            return DWBundle.ERR_INVALID_TIMESTMPTZ_MINS;
        }
        if (tm < 0 || tm > 59) {
            return DWBundle.bind((String)DWBundle.ERR_INVALID_MINUTE, (Object)"00", (Object)59);
        }
        return null;
    }

    private String getNanoSecondsPattern() {
        String n = "nnnnnnnnnnnn";
        n = this.scaleExists ? n.substring(0, this.columnModel.getScale().shortValue()) : "";
        return n;
    }
}

