/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.model.ColumnModel;
import java.math.BigDecimal;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class NumericValidator
implements IInputValidator,
ICellEditorValidator {
    private DataType dataType;
    private String minValue;
    private String maxValue;
    private ColumnModel columnModel;
    private final Double DB2_FLOAT_MIN_VALUE = -7.2E75;
    private final Double DB2_FLOAT_MAX_VALUE = 7.2E75;
    private final Double DB2_FLOAT_LARGEST_NEGATIVE_VALUE = -5.4E-79;
    private final Double DB2_FLOAT_SMALLEST_POSITIVE_VALUE = 5.4E-79;
    private String db2FloatLargestNegativeValue = String.valueOf(this.DB2_FLOAT_LARGEST_NEGATIVE_VALUE);
    private String db2FloatSmallestPositiveValue = String.valueOf(this.DB2_FLOAT_SMALLEST_POSITIVE_VALUE);
    private BigDecimal DB2_DECIMAL_MIN_VALUE;
    private BigDecimal DB2_DECIMAL_MAX_VALUE;

    public NumericValidator(ColumnModel columnModel, DataType dataType) {
        this.columnModel = columnModel;
        this.dataType = dataType;
        this.setMinAndMaxValues();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String isValid(String value) {
        if (this.dataType == null) return null;
        String s = value == null ? null : value.trim();
        try {
            if (this.columnModel.isAutoGeneratedColumn() && "default".equals(s)) {
                return null;
            }
            if (s == null || s.isEmpty()) {
                if (this.columnModel.isNullable()) return null;
                String string = DWBundle.ERR_MSG_NOTNULL;
                return string;
            }
            switch (this.dataType) {
                case INTEGER: 
                case INT: {
                    Integer.valueOf(s);
                    return null;
                }
                case SMALLINT: {
                    Short.valueOf(s);
                    return null;
                }
                case BIGINT: {
                    Long.valueOf(s);
                    return null;
                }
                case DECIMAL: {
                    BigDecimal val = new BigDecimal(s);
                    s = val.toString();
                    if (val.compareTo(this.DB2_DECIMAL_MIN_VALUE) == -1 || this.DB2_DECIMAL_MAX_VALUE.compareTo(val) == -1) {
                        return DWBundle.bind((String)DWBundle.ERR_MSG_INVALID_DATA_FOR_NUMERIC, (Object[])new Object[]{this.minValue, this.maxValue});
                    }
                    if (!this.validatePrecision(s)) {
                        return "Invalid Precision";
                    }
                    if (this.validateScale(s)) return null;
                    return DWBundle.bind((String)DWBundle.ERR_MSG_INVALID_SCALE, (Object)this.columnModel.getScale());
                }
                case FLOAT: 
                case REAL: {
                    if (this.isFloatInRange(Double.valueOf(s))) return null;
                    return DWBundle.bind((String)DWBundle.ERR_MSG_INVALID_DATA_FOR_FLOAT, (Object[])new Object[]{this.minValue, this.db2FloatLargestNegativeValue, this.db2FloatSmallestPositiveValue, this.maxValue});
                }
            }
            return null;
        }
        catch (Exception e) {
            if (!this.dataType.equals((Object)DataType.FLOAT) && !this.dataType.equals((Object)DataType.REAL)) {
                return DWBundle.bind((String)DWBundle.ERR_MSG_INVALID_DATA_FOR_NUMERIC, (Object[])new Object[]{this.minValue, this.maxValue});
            }
            return DWBundle.bind((String)DWBundle.ERR_MSG_INVALID_DATA_FOR_FLOAT, (Object[])new Object[]{this.minValue, this.db2FloatLargestNegativeValue, this.db2FloatSmallestPositiveValue, this.maxValue});
        }
    }

    private BigDecimal generateBoundaryValueForDecimal(int precision, int scale) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < precision - scale) {
            builder.append(9);
            ++i;
        }
        if (scale > 0) {
            builder.append(".");
            i = 0;
            while (i < scale) {
                builder.append(9);
                ++i;
            }
        }
        return new BigDecimal(builder.toString());
    }

    private boolean isFloatInRange(Double d) {
        return this.DB2_FLOAT_MIN_VALUE <= d && d <= this.DB2_FLOAT_LARGEST_NEGATIVE_VALUE || this.DB2_FLOAT_SMALLEST_POSITIVE_VALUE <= d && d <= this.DB2_FLOAT_MAX_VALUE;
    }

    private void setMinAndMaxValues() {
        switch (this.dataType) {
            case INTEGER: 
            case INT: {
                this.setMinValue(String.valueOf(Integer.MIN_VALUE));
                this.setMaxValue(String.valueOf(Integer.MAX_VALUE));
                break;
            }
            case SMALLINT: {
                this.setMinValue(String.valueOf(Short.MIN_VALUE));
                this.setMaxValue(String.valueOf(Short.MAX_VALUE));
                break;
            }
            case BIGINT: {
                this.setMinValue(String.valueOf(Long.MIN_VALUE));
                this.setMaxValue(String.valueOf(Long.MAX_VALUE));
                break;
            }
            case DECIMAL: {
                this.DB2_DECIMAL_MAX_VALUE = this.generateBoundaryValueForDecimal(this.columnModel.getPrecision(), this.columnModel.getScale().shortValue());
                this.DB2_DECIMAL_MIN_VALUE = this.DB2_DECIMAL_MAX_VALUE.negate();
                this.setMinValue(String.valueOf(this.DB2_DECIMAL_MIN_VALUE));
                this.setMaxValue(String.valueOf(this.DB2_DECIMAL_MAX_VALUE));
                break;
            }
            case FLOAT: 
            case REAL: {
                this.setMinValue(this.DB2_FLOAT_MIN_VALUE.toString());
                this.setMaxValue(this.DB2_FLOAT_MAX_VALUE.toString());
                break;
            }
        }
    }

    private void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    private void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    private boolean validateScale(String s) {
        int index;
        if (s != null && !s.trim().isEmpty() && (index = s.indexOf(46)) != -1 && !s.substring(index + 1).equals("0")) {
            return s.substring(index + 1).length() <= this.columnModel.getScale();
        }
        return true;
    }

    private boolean validatePrecision(String s) {
        if (s != null && !s.trim().isEmpty()) {
            boolean isNegativeValue = s.charAt(0) == '-';
            int indexOfDot = s.indexOf(46);
            if (indexOfDot != -1) {
                s = s.substring(isNegativeValue ? 1 : 0, indexOfDot);
            }
            if (indexOfDot == -1) {
                s = s.substring(isNegativeValue ? 1 : 0);
            }
            if (this.columnModel.getPrecision().intValue() == this.columnModel.getScale().shortValue()) {
                return Integer.parseInt(s) == 0;
            }
            return s.length() <= this.columnModel.getLength() - this.columnModel.getScale();
        }
        return true;
    }

    public String isValid(Object value) {
        return value != null ? this.isValid(value.toString()) : null;
    }
}

