/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.widgets.DataWindow;
import com.ca.db2.editor.ui.widgets.DataWindowManager;
import com.ca.db2.editor.views.DWView;
import org.apache.log4j.Logger;

public class DWAddRowsAction
extends BaseAction {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final Logger logger = Logger.getLogger(DWAddRowsAction.class);
    private DataWindowManager manager;
    private String commandId = "com.ca.db2.editor.ui.actions.DWAddRowsAction";

    public DWAddRowsAction(DataWindowManager manager) {
        super(DWBundle.LABEL_ADDROW, 1);
        this.manager = manager;
        this.setId(DWView.ACTION.ADD_ROWS.toString());
        this.setImageDescriptor(Images.ADD_ROW);
        this.registerKeyBinding(this.commandId, 65613);
    }

    @Override
    public void execute() {
        try {
            if (this.getDataWindow().canRowsBeAdded(true)) {
                this.getDataWindow().addRows();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Problem while adding new rows:", (Throwable)e);
        }
    }

    @Override
    public void updateUI() {
        this.setEnabled(this.checkPreConditions());
    }

    @Override
    protected boolean checkPreConditions() {
        boolean enable = this.getDataWindow().isEditMode() && this.getDataWindow().isEditable();
        return enable;
    }

    private DataWindow getDataWindow() {
        return this.manager.getSelectedDataWindow();
    }
}

