/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import Xnet.XnetRowsetColumn;
import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.model.ColumnModel;

public class DataTypeUtils {
    static final String cacopyright = "Copyright \ufffd 2016 CA";

    public static boolean isChar(String colType) {
        return "CHAR".equals(colType.trim());
    }

    public static boolean isVarChar(String colType) {
        return "VARCHAR".equals(colType.trim());
    }

    public static boolean isFloat(String colType) {
        return "FLOAT".equals(colType.trim());
    }

    public static boolean isSmallInt(String colType) {
        return "SMALLINT".equals(colType.trim());
    }

    public static boolean isBigInt(String colType) {
        return "BIGINT".equals(colType.trim());
    }

    public static boolean isLongInt(short dataType) {
        return dataType == XnetRowsetColumn.LONG_INTEGER || dataType == XnetRowsetColumn.LONG_INTEGER + XnetRowsetColumn.NULLS;
    }

    public static boolean isDecimal(short dataType) {
        return dataType == XnetRowsetColumn.DECIMAL || dataType == XnetRowsetColumn.DECIMAL + XnetRowsetColumn.NULLS;
    }

    public static boolean isDecimal(String colType) {
        return "DECIMAL".equals(colType.trim());
    }

    public static boolean isDate(short dataType) {
        return dataType == XnetRowsetColumn.DATE || dataType == XnetRowsetColumn.DATE + XnetRowsetColumn.NULLS;
    }

    public static boolean isDate(String colType) {
        return "DATE".equals(colType.trim());
    }

    public static boolean isTimestamp(short dataType) {
        return dataType == XnetRowsetColumn.TIMESTAMP || dataType == XnetRowsetColumn.TIMESTAMP + XnetRowsetColumn.NULLS;
    }

    public static boolean isTimestamp(String colType) {
        return "TIMESTAMP".equals(colType.trim()) || "TIMESTMP".equals(colType.trim());
    }

    public static boolean isTimeSTZ(String colType) {
        return "TIMESTAMP WITH TIME ZONE".equals(colType.trim()) || "TIMESTZ".equals(colType.trim());
    }

    public static boolean isTime(short dataType) {
        return dataType == XnetRowsetColumn.TIME || dataType == XnetRowsetColumn.TIME + XnetRowsetColumn.NULLS;
    }

    public static boolean isTime(String colType) {
        return "TIME".equals(colType.trim());
    }

    public static boolean isNumericDataType(String colType) {
        return DataTypeUtils.isInteger(colType) || DataTypeUtils.isSmallInt(colType) || DataTypeUtils.isBigInt(colType) || DataTypeUtils.isFloat(colType) || DataTypeUtils.isDecimal(colType);
    }

    public static boolean isVarchar254(short dataType) {
        return XnetRowsetColumn.isVarchar254((short)dataType);
    }

    public static boolean isVarchar255(short dataType) {
        return XnetRowsetColumn.isVarchar255((short)dataType);
    }

    public static boolean isNumericDataType(DataType dataType) {
        if (dataType == null) {
            return false;
        }
        switch (dataType) {
            case SMALLINT: 
            case INTEGER: 
            case INT: 
            case BIGINT: 
            case DECIMAL: 
            case DEC: 
            case NUMERIC: 
            case FLOAT: 
            case REAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDateTimeDataType(DataType dataType) {
        if (dataType == null) {
            return false;
        }
        switch (dataType) {
            case DATE: 
            case TIME: 
            case TIMESTMP: 
            case TIMESTZ: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCharacterStringDataType(DataType dataType) {
        if (dataType == null) {
            return false;
        }
        switch (dataType) {
            case CHARACTER: 
            case CHAR: 
            case VARCHAR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFloatingPointDataType(DataType dataType) {
        if (dataType == null) {
            return false;
        }
        switch (dataType) {
            case DECIMAL: 
            case DEC: 
            case NUMERIC: 
            case FLOAT: 
            case REAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSinglePrecisionFP(DataType dataType) {
        if (dataType == null) {
            return false;
        }
        switch (dataType) {
            case FLOAT: 
            case REAL: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDoublePrecisionFP(DataType dataType) {
        if (dataType == null) {
            return false;
        }
        switch (dataType) {
            case FLOAT: 
            case DOUBLE: 
            case DOUBLEPRECISION: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTimeSTZ(ColumnModel model) {
        return model.getColType().trim().equals(DataType.TIMESTZ.name());
    }

    public static boolean isNumeric(String colType) {
        return DataTypeUtils.isInteger(colType.trim());
    }

    public static boolean isInteger(String colType) {
        return "INTEGER".equals(colType.trim());
    }
}

