/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.utils.AbstractCellEditor;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.utils.DateValidator;
import com.ca.db2.editor.ui.utils.TimeStampValidator;
import com.ca.db2.editor.ui.utils.TimeValidator;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;

public class DateCellEditor
extends AbstractCellEditor {
    private ICellEditorValidator validator;
    private DataType dataType;

    public DateCellEditor(Composite parent, ObjectIdentity identity, ColumnModel model) {
        super(parent, identity, model);
        this.dataType = DataType.value(model.getColType().trim());
        String format = this.dataType == DataType.DATE ? CommonUtils.getDateFormat(identity.getSsid()) : CommonUtils.getTimeFormat(identity.getSsid());
        this.validator = this.getICellEditorValidator(this.dataType, model, format);
    }

    @Override
    public boolean onKeyPressValidation(KeyEvent keyEvent) {
        char ch = keyEvent.character;
        if (this.dataType == DataType.TIME) {
            return Character.isDigit(ch) || ch == ':' || ch == '.' || ch == ' ' || this.noonChars(ch);
        }
        if (this.dataType == DataType.TIMESTMP) {
            return Character.isDigit(ch) || ch == '-' || ch == '.' || ch == ' ';
        }
        if (this.dataType == DataType.TIMESTZ) {
            return Character.isDigit(ch) || ch == '-' || ch == '.' || ch == ' ' || ch == '+' || ch == ':';
        }
        return Character.isDigit(ch) || ch == '-' || ch == '/' || ch == '.';
    }

    private boolean noonChars(char ch) {
        return ch == 'A' || ch == 'a' || ch == 'p' || ch == 'P' || ch == 'm' || ch == 'M';
    }

    @Override
    public String validate(Object value) {
        return this.validator.isValid(value);
    }

    @Override
    public Object formatValue(Object value) {
        return value;
    }

    private ICellEditorValidator getICellEditorValidator(DataType dataType, ColumnModel model, String format) {
        if (dataType == DataType.TIME) {
            return new TimeValidator(model, dataType, format);
        }
        if (dataType == DataType.TIMESTMP || dataType == DataType.TIMESTZ) {
            return new TimeStampValidator(model, dataType, format);
        }
        return new DateValidator(model, dataType, format);
    }
}

