/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.ui.model.GroupNode;
import com.ca.db2.editor.ui.model.ITreeNode;
import com.ca.db2.editor.ui.model.LparNode;
import com.ca.db2.editor.ui.model.SubsystemNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class DSESorter
extends ViewerSorter {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    public static int SORT_CATEGORY_TABLE = 1;
    public static int SORT_CATEGORY_VIEW = 2;
    public static int SORT_CATEGORY_SYNONYM = 3;
    public static int SORT_CATEGORY_ALIAS = 4;
    private SortOrder sortOrder = SortOrder.NONE;
    private int sortingCategory = SortBy.NONE.valueOf();

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof LparNode || e2 instanceof SubsystemNode || e1 instanceof GroupNode) {
            return 0;
        }
        if (this.sortingCategory == SortBy.NONE.valueOf()) {
            return 0;
        }
        if (this.isSortByType() && !this.isSortByName()) {
            return ((ITreeNode)e1).getSortingCategory() - ((ITreeNode)e2).getSortingCategory();
        }
        switch (this.sortOrder) {
            case NONE: {
                return 0;
            }
            case ASC: {
                return ((ITreeNode)e1).getName().compareTo(((ITreeNode)e2).getName());
            }
            case DESC: {
                return ((ITreeNode)e2).getName().compareTo(((ITreeNode)e1).getName());
            }
        }
        return 0;
    }

    public int category(Object element) {
        if (this.isSortByType()) {
            return ((ITreeNode)element).getSortingCategory();
        }
        return 0;
    }

    private boolean isSortByType() {
        return (this.sortingCategory & SortBy.TYPE.valueOf()) == SortBy.TYPE.valueOf();
    }

    private boolean isSortByName() {
        return (this.sortingCategory & SortBy.NAME.valueOf()) == SortBy.NAME.valueOf();
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void addSortBy(SortBy sortBy) {
        this.sortingCategory |= sortBy.valueOf();
    }

    public void removeSortBy(SortBy sortBy) {
        this.sortingCategory &= ~sortBy.valueOf();
    }

    public static enum SortBy {
        NONE(4),
        NAME(16),
        TYPE(32);

        private final int value;

        private SortBy(int value) {
            this.value = value;
        }

        public static SortBy valueOf(String string) {
            return Enum.valueOf(SortBy.class, string);
        }
    }

    public static enum SortOrder {
        NONE,
        ASC,
        DESC;

    }
}

