/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.common.FMDB2Exception;
import com.ca.db2.editor.service.DataSourceHandlerFactory;
import com.ca.db2.editor.service.IDataSourceHandler;
import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.CMBundle;
import com.ca.db2.editor.ui.i18n.DataWindowBundle;
import com.ca.db2.editor.ui.i18n.MsgDialogBundle;
import com.ca.db2.editor.ui.model.ChangeEntry;
import com.ca.db2.editor.ui.model.ChangeEntrySet;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.model.RowModel;
import com.ca.db2.editor.ui.utils.CMUtils;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.utils.SQLGenerator;
import com.ca.db2.editor.ui.widgets.DataWindow;
import com.ca.db2.editor.ui.widgets.DataWindowManager;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import com.ca.db2.editor.views.DWView;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.BusyIndicator;

public class DWDeleteRowAction
extends BaseAction {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final Logger logger = Logger.getLogger(DWDeleteRowAction.class);
    private String commandId = "com.ca.db2.editor.ui.actions.DWDeleteRowAction";
    private IDataSourceHandler dataSourceHandler = DataSourceHandlerFactory.getDataSourceHandler();
    private DataWindowManager manager;

    public DWDeleteRowAction(DataWindowManager manager) {
        super(DataWindowBundle.REMOVE);
        this.manager = manager;
        this.setId(DWView.ACTION.DELETE.toString());
        this.setImageDescriptor(Images.DESC_REMOVE);
        this.setDisabledImageDescriptor(Images.DESC_REMOVE_DISABLE);
        this.setToolTipText(DataWindowBundle.REMOVE_TOOLTIP);
        this.registerKeyBinding(this.commandId, 65611);
    }

    @Override
    public void execute() {
        if (MsgDialog.showConfirmDialog(null, DataWindowBundle.REMOVE_CONFIRM_TITLE, DataWindowBundle.REMOVE_CONFIRM_MSG)) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    DWDeleteRowAction.this.deleteRows();
                }
            });
        }
    }

    @Override
    public void updateUI() {
        this.setEnabled(this.checkPreConditions());
    }

    private boolean isNewRow(ObjectIdentity identity, Integer rowKey) {
        ChangeEntrySet entrySet = CMUtils.getChangeEntrySet(identity, rowKey);
        return entrySet == null ? false : entrySet.getChangeType() == ChangeEntrySet.ChangeType.INSERT;
    }

    private void deleteRows() {
        try {
            RowModel[] selectedRows = this.getDataWindow().getResultSetGrid().getSelectedRows();
            Integer[] deletedRowKeys = new Integer[selectedRows.length];
            int i = 0;
            while (i < selectedRows.length) {
                int rowKey = selectedRows[i].getRowKey();
                List<ChangeEntry> entries = CMUtils.getChangeEntries(this.getDataWindow().getIdentity(), rowKey);
                List<ColumnModel> cm = this.getDataWindow().getResultSetGrid().getTableModel().getColumnModels();
                ColumnModel[] columns = cm.toArray(new ColumnModel[cm.size()]);
                String sql = SQLGenerator.generateDeleteQuery(this.getDataWindow().getIdentity(), columns, this.getDataWindow().getValues(rowKey), entries);
                this.dataSourceHandler.delete(this.getDataWindow().getIdentity(), sql);
                this.getDataWindow().getResultSetGrid().removeRow(selectedRows[i]);
                deletedRowKeys[i] = rowKey;
                ++i;
            }
            CMUtils.removeEntries(this.getDataWindow().getIdentity(), deletedRowKeys);
            this.getDataWindow().getResultSetGrid().reOrganizeRowKeys(deletedRowKeys[0]);
            this.getDataWindow().getResultSetGrid().refreshUI();
            CMUtils.refreshChangeManager();
            logger.info((Object)("Deleted row successfully from " + this.getDataWindow().getIdentity()));
        }
        catch (FMDB2Exception e) {
            MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, e.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)"Problem while deleting row:", (Throwable)e);
            MsgDialog.showErrorDialog(null, CMBundle.COMMIT_FAILED_TITLE, CMBundle.COMMIT_FAILED_MSG);
        }
    }

    @Override
    protected boolean checkPreConditions() {
        boolean enable = this.getDataWindow().isEditMode() && this.getDataWindow().isEditable();
        enable = enable && this.getDataWindow().getResultSetGrid().getRightMouseClickedColumn() == null;
        boolean bl = enable = enable && this.getDataWindow().getResultSetGrid().getSelectedRows() != null;
        if (enable) {
            RowModel[] models;
            RowModel[] rowModelArray = models = this.getDataWindow().getResultSetGrid().getSelectedRows();
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                RowModel rm = rowModelArray[n2];
                if (this.isNewRow(this.getDataWindow().getIdentity(), rm.getRowKey()) || rm.isAddableRow()) {
                    enable = false;
                    break;
                }
                ++n2;
            }
        }
        return enable;
    }

    private DataWindow getDataWindow() {
        return this.manager.getSelectedDataWindow();
    }
}

