/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.widgets;

import com.ca.db2.editor.ui.i18n.ShuttleWidgetBundle;
import com.ca.db2.editor.ui.widgets.IShuttleValidator;
import com.ca.db2.editor.ui.widgets.ListLabelProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ShuttleWidget
extends Composite {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final Logger logger = Logger.getLogger(ShuttleWidget.class);
    private Composite parent;
    private List selectedList;
    private List availableList;
    private ListViewer selectedListViewer;
    private ListViewer availableListViewer;
    private Button moveToLeft;
    private Button moveToRight;
    private Button moveAllToLeft;
    private Button moveAllToRight;
    private Button moveUp;
    private Button moveDown;
    private boolean isSelectedFirst = false;
    private boolean isShowLabels = false;
    private boolean isShowAsGroup = false;
    private String shuttleGroupLabel = ShuttleWidgetBundle.SHUTTLE_GROUP_LABEL;
    private String selectedGroupLabel = ShuttleWidgetBundle.SELECTED_GROUP_LABEL;
    private String availableGroupLabel = ShuttleWidgetBundle.AVAILABLE_GROUP_LABEL;
    private int listWidth = 200;
    private int listHeight = 200;
    private Class clazz = null;
    private Method method = null;
    private String propertyName = "name";
    private IShuttleValidator validator;

    public ShuttleWidget(Composite parent, int style) {
        super(parent, style);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.wrap = false;
        this.setLayout((Layout)rowLayout);
        this.setVisible(true);
    }

    public void build() throws Exception {
        if (this.selectedList == null || this.availableList == null || this.selectedList.isEmpty() && this.availableList.isEmpty()) {
            throw new Exception(ShuttleWidgetBundle.ERROR_INVALID_INPUT);
        }
        this.getReflectionData(this.propertyName);
        this.parent = this;
        if (this.isShowAsGroup) {
            this.parent = new Group((Composite)this, 0);
            RowLayout rowLayout = new RowLayout(256);
            rowLayout.wrap = false;
            this.setLayout((Layout)rowLayout);
            ((Group)this.parent).setText(this.shuttleGroupLabel);
            this.parent.setLayout((Layout)rowLayout);
        }
        if (this.isSelectedFirst) {
            this.buildSelectedGroup();
            this.buildButtonGroup();
            this.buildAvailableGroup();
        } else {
            this.buildAvailableGroup();
            this.buildButtonGroup();
            this.buildSelectedGroup();
        }
        this.manageButtonStates();
    }

    private void getReflectionData(String propertyName) {
        Object obj;
        Object e = obj = this.selectedList.isEmpty() ? this.availableList.get(0) : this.selectedList.get(0);
        if (obj instanceof String) {
            return;
        }
        this.clazz = obj.getClass();
        String methodName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            this.method = this.clazz.getMethod(methodName, null);
            this.method.setAccessible(true);
        }
        catch (Exception e2) {
            logger.error((Object)"Problem while generating Reflection Data", (Throwable)e2);
        }
    }

    private void buildSelectedGroup() {
        Group selectedColGroup = new Group(this.parent, 0);
        selectedColGroup.setLayoutData((Object)new RowData(this.listWidth, this.listHeight));
        selectedColGroup.setText(this.selectedGroupLabel);
        selectedColGroup.setLayout((Layout)new FillLayout(256));
        this.selectedListViewer = new ListViewer((Composite)selectedColGroup, 2818);
        this.selectedListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.selectedListViewer.setInput((Object)this.selectedList);
        this.selectedListViewer.setLabelProvider((IBaseLabelProvider)new ListLabelProvider(this.method));
        this.selectedListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ShuttleWidget.this.manageButtonStates();
            }
        });
        this.selectedListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ShuttleWidget.this.addToAvailableViewer(false);
            }
        });
        this.selectedListViewer.getList().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) != 0 && e.keyCode == 97) {
                    ShuttleWidget.this.selectedListViewer.setSelection((ISelection)new StructuredSelection(ShuttleWidget.this.selectedList));
                }
            }
        });
    }

    private void buildAvailableGroup() {
        Group availableColGroup = new Group(this.parent, 0);
        availableColGroup.setText(this.availableGroupLabel);
        availableColGroup.setLayout((Layout)new FillLayout(256));
        availableColGroup.setLayoutData((Object)new RowData(this.listWidth, this.listHeight));
        this.availableListViewer = new ListViewer((Composite)availableColGroup, 2818);
        this.availableListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.availableListViewer.setInput((Object)this.availableList);
        this.availableListViewer.setLabelProvider((IBaseLabelProvider)new ListLabelProvider(this.method));
        this.availableListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ShuttleWidget.this.manageButtonStates();
            }
        });
        this.availableListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ShuttleWidget.this.addToSelectedViewer(false);
            }
        });
        this.availableListViewer.getList().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) != 0 && e.keyCode == 97) {
                    ShuttleWidget.this.availableListViewer.setSelection((ISelection)new StructuredSelection(ShuttleWidget.this.availableList));
                }
            }
        });
    }

    private void buildButtonGroup() {
        Group btnGroup = new Group(this.parent, 0);
        GridLayout btnGroupLayout = new GridLayout(1, true);
        btnGroupLayout.makeColumnsEqualWidth = true;
        btnGroup.setLayout((Layout)btnGroupLayout);
        this.moveToRight = new Button((Composite)btnGroup, 0);
        this.moveToRight.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.moveToRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ShuttleWidget.this.isSelectedFirst) {
                    ShuttleWidget.this.addToAvailableViewer(false);
                } else {
                    ShuttleWidget.this.addToSelectedViewer(false);
                }
            }
        });
        this.moveAllToRight = new Button((Composite)btnGroup, 0);
        this.moveAllToRight.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.moveAllToRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ShuttleWidget.this.isSelectedFirst) {
                    ShuttleWidget.this.addToAvailableViewer(true);
                } else {
                    ShuttleWidget.this.addToSelectedViewer(true);
                }
            }
        });
        this.moveToLeft = new Button((Composite)btnGroup, 0);
        this.moveToLeft.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.moveToLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ShuttleWidget.this.isSelectedFirst) {
                    ShuttleWidget.this.addToSelectedViewer(false);
                } else {
                    ShuttleWidget.this.addToAvailableViewer(false);
                }
            }
        });
        this.moveAllToLeft = new Button((Composite)btnGroup, 0);
        this.moveAllToLeft.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.moveAllToLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ShuttleWidget.this.isSelectedFirst) {
                    ShuttleWidget.this.addToSelectedViewer(true);
                } else {
                    ShuttleWidget.this.addToAvailableViewer(true);
                }
            }
        });
        this.moveUp = new Button((Composite)btnGroup, 0);
        this.moveUp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.moveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                org.eclipse.swt.widgets.List selected = ShuttleWidget.this.selectedListViewer.getList();
                int selectedIndex = selected.getSelectionIndex();
                if (selectedIndex < 1) {
                    return;
                }
                Object selectedObj = ShuttleWidget.this.selectedList.get(selectedIndex);
                Object prevObj = ShuttleWidget.this.selectedList.get(selectedIndex - 1);
                ShuttleWidget.this.selectedList.set(selectedIndex - 1, selectedObj);
                ShuttleWidget.this.selectedList.set(selectedIndex, prevObj);
                ShuttleWidget.this.selectedListViewer.refresh();
                ShuttleWidget.this.selectedListViewer.setSelection((ISelection)new StructuredSelection(selectedObj), true);
                ShuttleWidget.this.manageButtonStates();
            }
        });
        this.moveDown = new Button((Composite)btnGroup, 0);
        this.moveDown.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.moveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                org.eclipse.swt.widgets.List selected = ShuttleWidget.this.selectedListViewer.getList();
                int selectedIndex = selected.getSelectionIndex();
                if (selectedIndex == -1 || selectedIndex == ShuttleWidget.this.selectedList.size() - 1) {
                    return;
                }
                Object selectedObj = ShuttleWidget.this.selectedList.get(selectedIndex);
                Object nextObj = ShuttleWidget.this.selectedList.get(selectedIndex + 1);
                ShuttleWidget.this.selectedList.set(selectedIndex, nextObj);
                ShuttleWidget.this.selectedList.set(selectedIndex + 1, selectedObj);
                ShuttleWidget.this.selectedListViewer.refresh();
                ShuttleWidget.this.selectedListViewer.setSelection((ISelection)new StructuredSelection(selectedObj), true);
                ShuttleWidget.this.manageButtonStates();
            }
        });
        this.setButtonLabels();
    }

    private void addToSelectedViewer(boolean isSelectAll) {
        ArrayList moveList = new ArrayList();
        if (isSelectAll) {
            moveList.addAll(this.availableList);
            this.availableList.clear();
        } else {
            IStructuredSelection selection = (IStructuredSelection)this.availableListViewer.getSelection();
            Iterator itr = selection.iterator();
            while (itr.hasNext()) {
                moveList.add(itr.next());
            }
            this.availableList.removeAll(moveList);
        }
        if (moveList == null || moveList.isEmpty()) {
            return;
        }
        this.selectedList.addAll(moveList);
        this.availableListViewer.refresh();
        this.selectedListViewer.refresh();
        this.selectedListViewer.setSelection((ISelection)new StructuredSelection(moveList), true);
    }

    private void addToAvailableViewer(boolean isSelectAll) {
        ArrayList moveList = new ArrayList();
        if (isSelectAll) {
            moveList.addAll(this.selectedList);
            if (this.validator != null && !this.validator.isValid(moveList)) {
                return;
            }
            this.selectedList.clear();
            this.selectedListViewer.setSelection((ISelection)new StructuredSelection(this.selectedList));
        } else {
            IStructuredSelection selection = (IStructuredSelection)this.selectedListViewer.getSelection();
            Iterator itr = selection.iterator();
            while (itr.hasNext()) {
                moveList.add(itr.next());
            }
            if (this.validator != null && !this.validator.isValid(moveList)) {
                return;
            }
            this.selectedList.removeAll(moveList);
        }
        if (moveList == null || moveList.isEmpty()) {
            return;
        }
        this.availableList.addAll(moveList);
        this.availableListViewer.refresh();
        this.selectedListViewer.refresh();
        this.availableListViewer.setSelection((ISelection)new StructuredSelection(moveList), true);
    }

    private void setButtonLabels() {
        if (this.isShowLabels) {
            if (this.isSelectedFirst) {
                this.moveToRight.setText(ShuttleWidgetBundle.REMOVE_TO_RIGHT_LABEL);
                this.moveAllToRight.setText(ShuttleWidgetBundle.REMOVE_ALL_TO_RIGHT_LABEL);
                this.moveToLeft.setText(ShuttleWidgetBundle.ADD_TO_LEFT_LABEL);
                this.moveAllToLeft.setText(ShuttleWidgetBundle.ADD_ALL_TO_LEFT_LABEL);
            } else {
                this.moveToRight.setText(ShuttleWidgetBundle.ADD_TO_RIGHT_LABEL);
                this.moveAllToRight.setText(ShuttleWidgetBundle.ADD_ALL_TO_RIGHT_LABEL);
                this.moveToLeft.setText(ShuttleWidgetBundle.REMOVE_TO_LEFT_LABEL);
                this.moveAllToLeft.setText(ShuttleWidgetBundle.REMOVE_ALL_TO_LEFT_LABEL);
            }
            this.moveUp.setText(ShuttleWidgetBundle.MOVE_UP_LABEL);
            this.moveDown.setText(ShuttleWidgetBundle.MOVE_DOWN_LABEL);
        } else {
            this.moveToRight.setText(ShuttleWidgetBundle.MOVE_RIGHT_ARROW);
            this.moveToLeft.setText(ShuttleWidgetBundle.MOVE_LEFT_ARROW);
            this.moveAllToRight.setText(ShuttleWidgetBundle.MOVE_ALL_RIGHT_ARROW);
            this.moveAllToLeft.setText(ShuttleWidgetBundle.MOVE_ALL_LEFT_ARROW);
            this.moveUp.setText(ShuttleWidgetBundle.MOVE_UP_ARROW);
            this.moveDown.setText(ShuttleWidgetBundle.MOVE_DOWN_ARROW);
        }
    }

    private void manageButtonStates() {
        IStructuredSelection selectedViewerSelection = (IStructuredSelection)this.selectedListViewer.getSelection();
        boolean isEnableUp = false;
        boolean isEnableDown = false;
        boolean isEnableAdd = false;
        boolean isEnableRemove = false;
        boolean isEnableAddAll = false;
        boolean isEnableRemoveAll = false;
        org.eclipse.swt.widgets.List selectedListWidget = this.selectedListViewer.getList();
        if (!selectedViewerSelection.isEmpty()) {
            if (selectedViewerSelection.size() == 1) {
                int selectedIndex = selectedListWidget.getSelectionIndex();
                if (selectedIndex > 0) {
                    isEnableUp = true;
                }
                if (selectedIndex < selectedListWidget.getItemCount() - 1) {
                    isEnableDown = true;
                }
            }
            isEnableRemove = true;
        }
        this.moveUp.setEnabled(isEnableUp);
        this.moveDown.setEnabled(isEnableDown);
        if (!this.availableList.isEmpty()) {
            IStructuredSelection availableSelection = (IStructuredSelection)this.availableListViewer.getSelection();
            isEnableAdd = !availableSelection.isEmpty();
        }
        isEnableRemoveAll = !this.selectedList.isEmpty();
        boolean bl = isEnableAddAll = !this.availableList.isEmpty();
        if (this.isSelectedFirst) {
            this.moveToRight.setEnabled(isEnableRemove);
            this.moveAllToRight.setEnabled(isEnableRemoveAll);
            this.moveToLeft.setEnabled(isEnableAdd);
            this.moveAllToLeft.setEnabled(isEnableAddAll);
        } else {
            this.moveToLeft.setEnabled(isEnableRemove);
            this.moveAllToLeft.setEnabled(isEnableRemoveAll);
            this.moveToRight.setEnabled(isEnableAdd);
            this.moveAllToRight.setEnabled(isEnableAddAll);
        }
    }

    protected void checkSubclass() {
    }

    public void dispose() {
        this.selectedList = null;
        this.availableList = null;
        this.selectedListViewer = null;
        this.availableListViewer = null;
        this.moveToLeft.dispose();
        this.moveToRight.dispose();
        this.moveAllToLeft.dispose();
        this.moveAllToRight.dispose();
        this.moveUp.dispose();
        this.moveDown.dispose();
        this.clazz = null;
        this.method = null;
        this.propertyName = null;
        super.dispose();
    }

    public ListViewer getSelectedListViewer() {
        return this.selectedListViewer;
    }

    public ListViewer getAvailableListViewer() {
        return this.availableListViewer;
    }

    public List getSelectedItems() {
        return (List)this.selectedListViewer.getInput();
    }

    public List getDeselectedItems() {
        return (List)this.availableListViewer.getInput();
    }

    public void setSelectedFirst(boolean isSelectedFirst) {
        this.isSelectedFirst = isSelectedFirst;
    }

    public void setShowLabels(boolean isShowLabels) {
        this.isShowLabels = isShowLabels;
    }

    public void setSelectedList(List selectedList) {
        this.selectedList = selectedList;
    }

    public void setAvailableList(List availableList) {
        this.availableList = availableList;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setListWidth(int listWidth) {
        this.listWidth = listWidth;
    }

    public void setListHeight(int listHeight) {
        this.listHeight = listHeight;
    }

    public void setShowAsGroup(boolean isShowAsGroup) {
        this.isShowAsGroup = isShowAsGroup;
    }

    public void setShuttleGroupLabel(String shuttleGroupLabel) {
        this.shuttleGroupLabel = shuttleGroupLabel;
    }

    public void setSelectedGroupLabel(String selectedGroupLabel) {
        this.selectedGroupLabel = selectedGroupLabel;
    }

    public void setAvailableGroupLabel(String availableGroupLabel) {
        this.availableGroupLabel = availableGroupLabel;
    }

    public void setValitor(IShuttleValidator validator) {
        this.validator = validator;
    }
}

