/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.widgets;

import com.ca.db2.editor.common.FMDB2Exception;
import com.ca.db2.editor.service.DataSourceHandlerFactory;
import com.ca.db2.editor.service.IDataSourceHandler;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PropertiesManager {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static Logger logger = Logger.getLogger(PropertiesManager.class);
    private IDataSourceHandler dataSourceHandler = DataSourceHandlerFactory.getDataSourceHandler();
    Shell mainShell;
    Shell propertiesShell;
    Table propertiesList;
    Rectangle tableBounds;
    CTabFolder tabPanel;
    String[] columnNames = new String[]{"NAME", "TBNAME", "TBCREATOR", "COLNO", "COLTYPE", "LENGTH", "SCALE", "NULLS", "COLCARD", "HIGH2KEY", "LOW2KEY", "UPDATES", "IBREQD", "REMARKS", "DEFAULT", "KEYSEQ", "FOREIGNKEY", "FLDPROC", "LABEL", "STATSTIME", "DEFAULTVALUE", "COLCARDF", "COLSTATUS", "LENGTH2", "DATATYPEID", "SOURCETYPEID", "TYPESCHEMA", "TYPENAME", "CREATEDTS", "STATS_FORMAT", "PARTKEY_COLSEQ", "PARTKEY_ORDERING", "ALTERDTS", "CCSID", "HIDDEN", "RELCREATED", "HASHKEY_COLSEQ", "COLTROL_ID", "XML_TYPEMOD_ID", "PERIOD", "GENERATED_ATTRIBUTE"};

    public PropertiesManager(Shell mShell, Rectangle bounds) {
        this.mainShell = mShell;
        this.tableBounds = bounds;
        this.initFields();
        this.setValues();
        this.propertiesShell.setBounds(this.tableBounds);
        this.propertiesShell.pack();
        this.propertiesShell.open();
    }

    public PropertiesManager(Composite panel) {
        this.tabPanel = new CTabFolder(panel, 2880);
        this.tabPanel.setLayout((Layout)new GridLayout());
        this.tabPanel.setUnselectedCloseVisible(false);
    }

    private void initFields() {
        GridLayout layout = new GridLayout(1, false);
        this.propertiesShell = new Shell(this.mainShell, 80);
        this.propertiesShell.setLayout((Layout)layout);
        this.propertiesList = new Table((Composite)this.propertiesShell, 68352);
        this.propertiesList.setHeaderVisible(true);
        this.propertiesList.setLinesVisible(true);
    }

    private void setValues() {
        TableColumn col1 = new TableColumn(this.propertiesList, 2048);
        col1.setText("Field Name");
        col1.pack();
        TableColumn col2 = new TableColumn(this.propertiesList, 2048);
        col2.setText("Value");
        col2.setWidth(100);
        int i = 0;
        while (i < this.columnNames.length) {
            TableItem item = new TableItem(this.propertiesList, 2048);
            item.setText(0, this.columnNames[i]);
            item.setText(1, "dummy_" + this.columnNames[i]);
            ++i;
        }
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.heightHint = this.propertiesList.getItemHeight() * 10 + this.propertiesList.getHeaderHeight();
        data.widthHint = this.propertiesList.getColumns()[0].getWidth() * 2;
        this.propertiesList.setLayoutData((Object)data);
    }

    public void showPropertiesTab(ObjectIdentity identity, String columnName) throws FMDB2Exception {
        try {
            CTabItem tabItem = this.getTabItem(identity, columnName);
            if (tabItem == null) {
                Map<String, Object> properties = columnName == null ? this.dataSourceHandler.getProperties(identity) : this.dataSourceHandler.getColumnProperties(identity, columnName);
                Composite propertiesPanel = this.createPropertiesPanel();
                tabItem = this.createPropertiesTabItem(propertiesPanel, identity, columnName);
                Table propertiesTable = this.createPropertiesTable(propertiesPanel);
                for (Map.Entry<String, Object> e : properties.entrySet()) {
                    TableItem tableItem = new TableItem(propertiesTable, 0);
                    tableItem.setText(0, e.getKey());
                    tableItem.setText(1, e.getValue() == null ? null : e.getValue().toString());
                }
            }
            this.tabPanel.setSelection(tabItem);
        }
        catch (FMDB2Exception e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Problem while displaying properties:", (Throwable)e);
            throw new FMDB2Exception(e);
        }
    }

    private CTabItem getTabItem(ObjectIdentity identity, String columnName) {
        CTabItem[] cTabItemArray = this.tabPanel.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tabItem = cTabItemArray[n2];
            if (tabItem.getData().equals(columnName == null ? identity.getPath() : String.valueOf(columnName) + "-" + identity.getPath())) {
                return tabItem;
            }
            ++n2;
        }
        return null;
    }

    private Table createPropertiesTable(Composite propertiesPanel) {
        Table propertiesTable = new Table(propertiesPanel, 68354);
        propertiesTable.setHeaderVisible(true);
        propertiesTable.setLinesVisible(true);
        TableColumn nameColumn = new TableColumn(propertiesTable, 2048);
        nameColumn.setText("Property");
        nameColumn.setWidth(150);
        TableColumn valueColumn = new TableColumn(propertiesTable, 2048);
        valueColumn.setText("Value");
        valueColumn.setWidth(200);
        GridData gData = new GridData(272);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        gData.heightHint = propertiesTable.getHeaderHeight() + propertiesTable.getItemHeight() * 10;
        gData.widthHint = propertiesTable.getColumns()[0].getWidth() * 2;
        propertiesTable.setLayoutData((Object)gData);
        return propertiesTable;
    }

    private Composite createPropertiesPanel() {
        Composite propertiesPanel = new Composite((Composite)this.tabPanel, 0);
        propertiesPanel.setLayout((Layout)new GridLayout());
        propertiesPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        return propertiesPanel;
    }

    private CTabItem createPropertiesTabItem(Composite propertiesPanel, ObjectIdentity identity, String columnName) {
        CTabItem tabItem = new CTabItem(this.tabPanel, 2112);
        tabItem.setControl((Control)propertiesPanel);
        if (columnName == null) {
            tabItem.setText(identity.getSimpleName());
            tabItem.setToolTipText(identity.getPath());
            tabItem.setData((Object)identity.getPath());
        } else {
            tabItem.setText(String.valueOf(columnName) + "-" + identity.getSimpleName());
            tabItem.setToolTipText(String.valueOf(columnName) + "-" + identity.getPath());
            tabItem.setData((Object)(String.valueOf(columnName) + "-" + identity.getPath()));
        }
        return tabItem;
    }

    public void setFocus() {
        this.tabPanel.setFocus();
        if (this.tabPanel.getItemCount() > 0) {
            CTabItem cTabItem = this.tabPanel.getItem(0);
        }
    }
}

