/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.widgets;

import com.ca.db2.editor.ui.i18n.CommonBundle;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class NumberField<T extends Number> {
    private Text text;
    private T maxValue;
    private T minValue;
    String originalValue = null;

    public NumberField(Composite parent, int style) {
        this.text = new Text(parent, style);
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                NumberField.this.onKeyRelease(e);
            }

            public void keyPressed(KeyEvent e) {
                NumberField.this.onKeyPress(e);
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NumberField.this.validateRange();
            }
        });
    }

    public NumberField(Composite parent, int style, boolean allowNegative) {
        this(parent, style);
    }

    protected void onKeyPress(KeyEvent e) {
        this.originalValue = this.text.getText();
        if (!(this.specialKeys(e) || this.arrowKeys(e) || Character.isDigit(e.character))) {
            e.doit = false;
        }
    }

    private void validateRange() {
        if (this.text.getText().trim().isEmpty()) {
            return;
        }
        if (this.minValue != null && this.minValue instanceof Integer && Integer.parseInt(this.text.getText()) < (Integer)this.minValue) {
            MsgDialog.showErrorDialog(null, CommonBundle.INVALID_VALUE, String.valueOf(CommonBundle.VALUE_CANT_BE_LESS_THAN) + this.minValue);
            this.text.setText(this.originalValue);
        }
        if (this.maxValue != null && this.maxValue instanceof Integer && Integer.parseInt(this.text.getText()) > (Integer)this.maxValue) {
            MsgDialog.showErrorDialog(null, CommonBundle.INVALID_VALUE, String.valueOf(CommonBundle.VALUE_CANT_BE_GREATER_THAN) + this.maxValue);
            this.text.setText(this.originalValue);
        }
    }

    protected void onKeyRelease(KeyEvent e) {
    }

    protected boolean specialKeys(KeyEvent e) {
        return this.specialKeysByKeyChar(e) || this.specialKeysByKeyCode(e);
    }

    protected boolean specialKeysByKeyChar(KeyEvent e) {
        switch (e.character) {
            case '\b': 
            case '\t': 
            case '\n': 
            case '\r': 
            case '\u001b': 
            case '\u007f': {
                return true;
            }
        }
        return false;
    }

    protected boolean specialKeysByKeyCode(KeyEvent e) {
        switch (e.keyCode) {
            case 65536: 
            case 131072: 
            case 262144: 
            case 0x1000005: 
            case 0x1000006: 
            case 0x1000007: 
            case 0x1000008: 
            case 0x1000009: {
                return true;
            }
        }
        return false;
    }

    protected boolean arrowKeys(KeyEvent e) {
        switch (e.keyCode) {
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: {
                return true;
            }
        }
        return false;
    }

    public Text getWidget() {
        return this.text;
    }

    public void setMaxValue(T maxValue) {
        this.maxValue = maxValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(T minValue) {
        this.minValue = minValue;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public void setTextLimit(int limit) {
        this.text.setTextLimit(limit);
    }
}

