/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor;

import com.ca.db2.editor.ui.i18n.CommonBundle;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

class HostNamesConfigPanel
extends Composite {
    private List hostNames;
    private Button removeButton;
    private Button addButton;

    public HostNamesConfigPanel(Composite parent, int style, String title) {
        super(parent, 2048);
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(4, 4, true, true, 0, 0));
        this.createUI(title);
    }

    private void createUI(final String title) {
        final Text host = new Text((Composite)this, 2048);
        host.setLayoutData((Object)new GridData(4, 4, true, false));
        host.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HostNamesConfigPanel.this.addButton.setEnabled(!host.getText().trim().isEmpty());
            }
        });
        this.addButton = new Button((Composite)this, 0);
        this.addButton.setEnabled(false);
        this.addButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.addButton.setText(CommonBundle.ADD);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                String hostName = host.getText().trim();
                String[] stringArray = HostNamesConfigPanel.this.hostNames.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s.equals(hostName)) {
                        MsgDialog.showErrorDialog(null, title, CommonBundle.ERR_HOST_NAME_ALREADY_EXISTS);
                        return;
                    }
                    ++n2;
                }
                HostNamesConfigPanel.this.hostNames.add(hostName);
                host.setText("");
            }
        });
        this.hostNames = new List((Composite)this, 2562);
        GridData hostNamesListGridData = new GridData(4, 0x1000000, true, false, 1, 1);
        hostNamesListGridData.heightHint = 50;
        this.hostNames.setLayoutData((Object)hostNamesListGridData);
        this.hostNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                HostNamesConfigPanel.this.removeButton.setEnabled(HostNamesConfigPanel.this.hostNames.getSelectionCount() != 0);
            }
        });
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)new GridData(4, 2, false, false));
        this.removeButton.setText(CommonBundle.REMOVE);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                HostNamesConfigPanel.this.hostNames.remove(HostNamesConfigPanel.this.hostNames.getSelectionIndices());
                if (HostNamesConfigPanel.this.hostNames.getItemCount() == 0) {
                    HostNamesConfigPanel.this.removeButton.setEnabled(false);
                } else {
                    HostNamesConfigPanel.this.hostNames.select(0);
                }
            }
        });
    }

    public String[] getHostNames() {
        return this.hostNames.getItems();
    }

    public void setHostNames(String[] items) {
        this.hostNames.setItems(items);
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public Button getAddButton() {
        return this.addButton;
    }
}

