/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.model.RowModel;
import com.ca.db2.editor.ui.model.TableModel;
import com.ca.db2.editor.ui.utils.ColumnEditingSupport;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.utils.DWColumnSorter;
import com.ca.db2.editor.ui.utils.DWLabelProvider;
import com.ca.db2.editor.ui.utils.DWRowFilter;
import com.ca.db2.editor.ui.utils.DWTableViewerFocusCellManager;
import com.ca.db2.editor.ui.utils.DataTypeUtils;
import com.ca.db2.editor.ui.utils.DateTimeUtil;
import com.ca.db2.editor.ui.utils.ExtendedTableViewer;
import com.ca.db2.editor.ui.widgets.DataWindow;
import com.ca.db2.editor.ui.widgets.ExploreEditDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class Grid {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final Logger logger = Logger.getLogger(Grid.class);
    private ObjectIdentity identity;
    private ExtendedTableViewer viewer;
    private String rightMouseClickedColumn;
    private DWRowFilter filter;
    private DataWindow dataWindow;
    private TableModel tm;
    private boolean paginating;
    private DWTableViewerFocusCellManager cellManager;
    private FocusCellOwnerDrawHighlighter focusCellHighlighter;
    private Map<Integer, Integer> indiciesMap = new TreeMap<Integer, Integer>();
    private Map<String, ColumnModel> autoGeneratedIdentityColumns = new HashMap<String, ColumnModel>();

    public Grid(DataWindow dataWindow, ObjectIdentity identity, TableModel tm) {
        this.dataWindow = dataWindow;
        this.setIdentity(identity);
        this.tm = tm;
        this.setViewer(new ExtendedTableViewer(dataWindow, 68354));
        this.defineLayout();
        this.buildColumns();
        this.buildViewer();
        this.addListeners();
    }

    private void buildViewer() {
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DWLabelProvider((Viewer)this.viewer, this.getColumnIndexOfAddRowLabel()));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (this.tm.getRowModels() == null) {
            this.tm.setRowModels(new ArrayList<RowModel>());
        }
        this.viewer.setInput(this.tm.getRowModels());
        this.filter = new DWRowFilter(this.tm.getColumnModels());
        this.viewer.addFilter(this.filter);
        this.focusCellHighlighter = new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer);
        this.cellManager = new DWTableViewerFocusCellManager(this.viewer, (FocusCellHighlighter)this.focusCellHighlighter);
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)this.getCellManager(), (ColumnViewerEditorActivationStrategy)this.getActivationStrategy(), (int)58);
    }

    private ColumnViewerEditorActivationStrategy getActivationStrategy() {
        return new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || Grid.this.onKeyPress(event) || event.eventType == 2 && ((MouseEvent)event.sourceEvent).button == 1 || event.eventType == 4;
            }
        };
    }

    private boolean onKeyPress(ColumnViewerEditorActivationEvent event) {
        if (event.eventType == 1) {
            boolean isCtrlEnter;
            boolean bl = isCtrlEnter = event.stateMask == 262144 && event.keyCode == 13;
            if (isCtrlEnter) {
                ViewerCell cell = this.cellManager.getFocusCell();
                this.showExplodeEdit(cell);
                return false;
            }
            return event.keyCode == 13 || event.keyCode == 0x100000B || event.keyCode == 0x1000050;
        }
        return false;
    }

    public TableViewerFocusCellManager getCellManager() {
        return this.cellManager;
    }

    public void setIdentity(ObjectIdentity identity) {
        this.identity = identity;
    }

    public ObjectIdentity getIdentity() {
        return this.identity;
    }

    public void setViewer(ExtendedTableViewer viewer) {
        this.viewer = viewer;
    }

    public ExtendedTableViewer getViewer() {
        return this.viewer;
    }

    public void setRightMouseClickedColumn(String rightMouseClickedColumn) {
        this.rightMouseClickedColumn = rightMouseClickedColumn;
    }

    public String getRightMouseClickedColumn() {
        return this.rightMouseClickedColumn;
    }

    private void addListeners() {
        Listener paginationListener = new Listener(){

            public void handleEvent(Event e) {
                ScrollBar bar = (ScrollBar)e.widget;
                if (e.detail == 1 && bar.getMaximum() == bar.getThumb() + bar.getSelection()) {
                    Grid.this.paginate();
                }
            }
        };
        this.viewer.getTable().addListener(35, new Listener(){

            public void handleEvent(Event e) {
                Grid.this.handlesMenuDetectEvent(e);
            }
        });
        this.viewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Grid.this.handleMouseDoubleClickEvent(e);
            }

            public void mouseDown(MouseEvent e) {
                Grid.this.handleMouseDown(e);
            }
        });
        this.viewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000006: {
                        if (!Grid.this.isAtLastRow()) break;
                        Grid.this.paginate();
                        break;
                    }
                    case 13: {
                        if (!Grid.this.isAtLastRow()) break;
                        if (!Grid.this.dataWindow.isEditMode() || !Grid.this.dataWindow.canRowsBeAdded(false)) {
                            return;
                        }
                        Grid.this.dataWindow.addNewRows(1);
                        logger.info((Object)DWBundle.bind((String)DWBundle.MSG_ROWS_ADDED_TO_DW, (Object[])new Object[]{1, Grid.this.dataWindow.getIdentity()}));
                        break;
                    }
                }
            }
        });
        this.viewer.getTable().getVerticalBar().addListener(13, paginationListener);
    }

    private void paginate() {
        if (!this.paginating) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    Grid.this.paginating = true;
                    Grid.this.dataWindow.paginate();
                    Grid.this.paginating = false;
                }
            });
        }
    }

    private boolean isAtLastRow() {
        int index = this.viewer.getTable().getSelectionIndex();
        return index + 1 == this.viewer.getTable().getItemCount();
    }

    private void handlesMenuDetectEvent(Event e) {
        boolean header;
        Point pt = Display.getCurrent().map(null, (Control)this.viewer.getTable(), new Point(e.x, e.y));
        Rectangle clientArea = this.viewer.getTable().getClientArea();
        boolean bl = header = clientArea.y <= pt.y && pt.y < clientArea.y + this.viewer.getTable().getHeaderHeight();
        if (header) {
            TableColumn column = this.findColumn(this.viewer.getTable(), pt);
            this.setRightMouseClickedColumn(column == null ? null : column.getToolTipText());
        } else {
            this.setRightMouseClickedColumn(null);
        }
    }

    public void reveal(Object element) {
        this.viewer.reveal(element);
    }

    private void handleMouseDown(MouseEvent e) {
        ViewerCell cell = this.viewer.getCell(new Point(e.x, e.y));
        if (e.button == 1 && cell != null && cell.getElement() != null && ((RowModel)cell.getElement()).isAddableRow()) {
            this.dataWindow.addNewRows(1);
            logger.info((Object)DWBundle.bind((String)DWBundle.MSG_ROWS_ADDED_TO_DW, (Object[])new Object[]{1, this.dataWindow.getIdentity()}));
        }
    }

    private void handleMouseDoubleClickEvent(MouseEvent e) {
        this.showExplodeEdit(this.viewer.getCell(new Point(e.x, e.y)));
    }

    private void showExplodeEdit(ViewerCell cell) {
        if (cell != null) {
            int columnIndex = cell.getColumnIndex();
            ColumnModel columnModel = this.tm.getColumnModels().get(cell.getColumnIndex());
            ExploreEditDialog dialog = new ExploreEditDialog(this.identity, columnModel, cell.getText(), this.isColumnEditable(columnModel));
            if (dialog.open() == 0 && !dialog.getValue().equals(cell.getText())) {
                String colType = columnModel.getColType();
                String newValue = dialog.getValue();
                if (DataTypeUtils.isNumeric(colType) || DataTypeUtils.isDate(colType) || DataTypeUtils.isTime(colType) || DataTypeUtils.isTimestamp(colType) || DataTypeUtils.isTimeSTZ(columnModel)) {
                    newValue = newValue != null && newValue.trim().isEmpty() ? null : newValue;
                }
                this.updateCellValue((RowModel)cell.getElement(), columnModel, columnIndex, newValue);
            }
        }
    }

    private boolean isColumnEditable(ColumnModel cm) {
        if (!cm.isUpdatable()) {
            return false;
        }
        String _default = cm.getDefault().trim();
        return this.dataWindow.isEditMode() && !_default.equals("A") && !_default.equals("E") && !_default.equals("I");
    }

    public void updateCellValue(RowModel rowModel, ColumnModel columnModel, int columnIndex, Object newValue) {
        this.getDataWindow().addColChangeEvent(rowModel, columnModel, columnIndex, newValue);
        rowModel.getData()[columnIndex] = newValue;
        this.viewer.update(rowModel, null);
    }

    private final TableColumn findColumn(Table t, Point pt) {
        ScrollBar hb = t.getHorizontalBar();
        int offs = hb != null ? hb.getSelection() : 0;
        Rectangle area = t.getClientArea();
        int xp = pt.x + offs;
        int x0 = area.x + offs;
        if (xp >= x0) {
            int[] idx = t.getColumnOrder();
            int x = 0;
            int i = 0;
            while (i < idx.length) {
                TableColumn col = t.getColumn(idx[i]);
                int xNext = x + col.getWidth();
                if (xp >= x && xp < xNext) {
                    return col;
                }
                x = xNext;
                ++i;
            }
        }
        return null;
    }

    private void buildColumns() {
        this.indiciesMap.clear();
        int index = 0;
        while (index < this.tm.getColumnModels().size()) {
            ColumnModel model = this.tm.getColumnModels().get(index);
            this.indiciesMap.put(model.getIndex(), index);
            TableViewerColumn column = new TableViewerColumn((TableViewer)this.viewer, 2048);
            column.getColumn().setText(model.getDisplayName());
            column.getColumn().setMoveable(true);
            column.getColumn().setResizable(true);
            column.getColumn().setWidth(model.isVisible() ? 150 : 0);
            column.getColumn().setToolTipText(model.getName());
            new DWColumnSorter(this.identity, this.viewer, column.getColumn(), index, model);
            column.setEditingSupport((EditingSupport)new ColumnEditingSupport(this, model, index));
            if (model.isAutoGeneratedColumn()) {
                this.autoGeneratedIdentityColumns.put(model.getName(), model);
            }
            ++index;
        }
        int[] indiciesPrimitiveArray = new int[this.indiciesMap.values().size()];
        int i = 0;
        for (Integer value : this.indiciesMap.values()) {
            indiciesPrimitiveArray[i++] = value;
        }
        this.viewer.getTable().setColumnOrder(indiciesPrimitiveArray);
    }

    private void defineLayout() {
        GridData gridData = new GridData(272);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 10;
        this.viewer.getTable().setLayoutData((Object)gridData);
    }

    public void addRows(List<RowModel> rowModels) {
        this.removeAddableRow(true);
        this.tm.getRowModels().addAll(rowModels);
        this.appendAddableRow(true);
    }

    public void addRow(RowModel rowModel) {
        this.removeAddableRow(false);
        this.tm.getRowModels().add(rowModel);
        this.appendAddableRow(false);
    }

    public void refreshUI() {
        this.viewer.refresh();
    }

    public DWRowFilter getFilter() {
        return this.filter;
    }

    public RowModel[] getSelectedRows() {
        Object[] items = this.getSelectedItems();
        if (items.length > 0) {
            RowModel[] rows = new RowModel[items.length];
            int index = 0;
            while (index < items.length) {
                rows[index] = (RowModel)items[index];
                ++index;
            }
            return rows;
        }
        return null;
    }

    private Object[] getSelectedItems() {
        return ((StructuredSelection)this.viewer.getSelection()).toArray();
    }

    public void removeRow(RowModel model) {
        this.tm.getRowModels().remove(model);
        this.viewer.remove(model);
    }

    public RowModel getRow(Integer rowKey) {
        if (this.dataWindow.isFilterApplied()) {
            return this.getRowFromOriginalData(rowKey);
        }
        RowModel row = this.getRowFromSortedData(rowKey);
        return row != null ? row : this.getRowFromOriginalData(rowKey);
    }

    private RowModel getRowFromOriginalData(Integer rowKey) {
        for (RowModel row : this.tm.getRowModels()) {
            if (!row.getRowKey().equals(rowKey)) continue;
            return row;
        }
        return null;
    }

    private RowModel getRowFromSortedData(Integer rowKey) {
        Object[] sortedRows;
        Object[] objectArray = sortedRows = this.viewer.getSortedElements();
        int n = sortedRows.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            RowModel row = (RowModel)o;
            if (row.getRowKey().equals(rowKey)) {
                return row;
            }
            ++n2;
        }
        return null;
    }

    public void reOrganizeRowKeys(int deletedRowKey) {
        int index = deletedRowKey - 1;
        while (index < this.tm.getRowModels().size()) {
            RowModel row = this.tm.getRowModels().get(index);
            row.setRowKey(index + 1);
            ++index;
        }
    }

    private Object populateColumnDefaultValue(ColumnModel colModel, String dateFormat, String timeFormat) {
        String colType = colModel.getColType();
        if (colModel.isAutoGeneratedColumn()) {
            return "default";
        }
        if (DataTypeUtils.isNumeric(colType)) {
            if (this.hasDefaultValue(colModel)) {
                return colModel.getDefaultValue();
            }
            if (this.defaultValueGenerationIsRequired(colModel)) {
                return "0";
            }
        } else if (DataTypeUtils.isChar(colType)) {
            if (this.hasDefaultValue(colModel)) {
                return colModel.getDefaultValue();
            }
            if (this.defaultValueGenerationIsRequired(colModel)) {
                return "";
            }
        } else if (DataTypeUtils.isVarChar(colType)) {
            if (this.hasDefaultValue(colModel)) {
                return colModel.getDefaultValue();
            }
            if (this.defaultValueGenerationIsRequired(colModel)) {
                return "";
            }
        } else if (DataTypeUtils.isSmallInt(colType)) {
            if (this.hasDefaultValue(colModel)) {
                return colModel.getDefaultValue();
            }
            if (this.defaultValueGenerationIsRequired(colModel)) {
                return "0";
            }
        } else if (DataTypeUtils.isBigInt(colType)) {
            if (this.hasDefaultValue(colModel)) {
                return colModel.getDefaultValue();
            }
            if (this.defaultValueGenerationIsRequired(colModel)) {
                return "0";
            }
        } else if (DataTypeUtils.isDecimal(colType)) {
            if (this.hasDefaultValue(colModel)) {
                return colModel.getDefaultValue();
            }
            if (this.defaultValueGenerationIsRequired(colModel)) {
                return "0.0";
            }
        } else if (DataTypeUtils.isFloat(colType)) {
            if (this.hasDefaultValue(colModel)) {
                return colModel.getDefaultValue();
            }
            if (this.defaultValueGenerationIsRequired(colModel)) {
                return "0.0";
            }
        } else if (DataTypeUtils.isDate(colType)) {
            if (this.hasDefaultValue(colModel)) {
                return colModel.getDefaultValue();
            }
            if (this.defaultValueGenerationIsRequired(colModel)) {
                return DateTimeUtil.getSystemDate(dateFormat);
            }
        } else if (DataTypeUtils.isTimestamp(colType)) {
            if (this.hasDefaultValue(colModel)) {
                return colModel.getDefaultValue();
            }
            if (this.defaultValueGenerationIsRequired(colModel)) {
                return DateTimeUtil.getSystemTimestamp(dateFormat, colModel.getScale());
            }
        } else if (DataTypeUtils.isTimeSTZ(colType)) {
            if (this.hasDefaultValue(colModel)) {
                return colModel.getDefaultValue();
            }
            if (this.defaultValueGenerationIsRequired(colModel)) {
                return DateTimeUtil.getSystemTimestampTZ(dateFormat, colModel.getScale());
            }
        } else if (DataTypeUtils.isTime(colType)) {
            if (this.hasDefaultValue(colModel)) {
                return colModel.getDefaultValue();
            }
            if (this.defaultValueGenerationIsRequired(colModel)) {
                return DateTimeUtil.getSystemTime(timeFormat);
            }
        } else {
            logger.error((Object)("Column Type not populated with default value:" + colModel.getColType()));
        }
        return null;
    }

    private boolean hasDefaultValue(ColumnModel colModel) {
        return !"".equals(colModel.getDefaultValue());
    }

    private boolean defaultValueGenerationIsRequired(ColumnModel colModel) {
        return !colModel.isNullable() || "B".equals(colModel.getDefault());
    }

    public List<RowModel> addNewRows(int numberOfRows) {
        ArrayList<RowModel> rowModels = new ArrayList<RowModel>(numberOfRows);
        int i = 0;
        while (i < numberOfRows) {
            rowModels.add(this.addNewRow());
            ++i;
        }
        return rowModels;
    }

    public int getLastGeneratedRowKey() {
        int numOfRows = this.tm.getRowModels().size();
        if (numOfRows == 0) {
            return 0;
        }
        int n = numOfRows = this.isEditable() ? numOfRows - 1 : numOfRows;
        if (numOfRows == 0) {
            return 0;
        }
        return this.tm.getRowModels().get(numOfRows - 1).getRowKey();
    }

    private RowModel addNewRow() {
        ArrayList<Object> objects = new ArrayList<Object>();
        String dateFormat = CommonUtils.getDateFormat(this.identity.getSsid());
        String timeFormat = CommonUtils.getTimeFormat(this.identity.getSsid());
        for (ColumnModel cm : this.tm.getColumnModels()) {
            Object colDefaultValue = this.populateColumnDefaultValue(cm, dateFormat, timeFormat);
            objects.add(colDefaultValue);
        }
        RowModel rowModel = new RowModel(this.getLastGeneratedRowKey() + 1, objects.toArray());
        this.addRow(rowModel);
        this.viewer.add(rowModel);
        this.viewer.refresh();
        return rowModel;
    }

    public void highlightRow(int rowkey) {
        ViewerRow viewerRow;
        int rowIndex = this.viewer.getVisualRowIndex(rowkey);
        if (rowIndex != -1 && (viewerRow = this.viewer.getViewerRow(rowIndex)) != null) {
            this.cellManager.focusCell(null);
            this.viewer.getTable().setSelection(rowIndex);
            this.viewer.getTable().setFocus();
        }
    }

    public void updateAutoGeneratedKeysFromDB(ObjectIdentity identity, int rowKey, Map<String, Integer> generatedKeys) {
        RowModel rowModel = this.getRow(rowKey);
        for (Map.Entry<String, Integer> entry : generatedKeys.entrySet()) {
            String columnName = entry.getKey();
            Integer updatedValue = entry.getValue();
            ColumnModel model = this.autoGeneratedIdentityColumns.get(columnName);
            rowModel.getData()[model.getIndex().intValue()] = updatedValue;
            this.viewer.update(rowModel, null);
        }
    }

    public DataWindow getDataWindow() {
        return this.dataWindow;
    }

    public boolean isEditable() {
        return this.dataWindow.isEditable() && this.dataWindow.isEditMode();
    }

    public RowModel copyRow(RowModel rowModel) {
        RowModel copyInstance = new RowModel(this.tm.getRowModels().size(), (Object[])rowModel.getData().clone());
        this.addRow(copyInstance);
        this.viewer.add(copyInstance);
        this.viewer.refresh();
        return copyInstance;
    }

    public void postValueChanged() {
        this.dataWindow.setDirty(true);
    }

    public TableModel getTableModel() {
        return this.tm;
    }

    public void appendAddableRow(boolean isUpdateViewer) {
        if (!this.dataWindow.isEditMode() || !this.dataWindow.canRowsBeAdded(false)) {
            return;
        }
        int totalRows = this.tm.getRowModels().size();
        if (totalRows > 0 && this.tm.getRowModels().get(totalRows - 1).isAddableRow()) {
            return;
        }
        Object[] data = new Object[this.tm.getColumnModels().size()];
        int i = 0;
        while (i < data.length) {
            data[i] = "";
            ++i;
        }
        data[this.getColumnIndexOfAddRowLabel()] = DWBundle.ADD_ROW_TEXT;
        RowModel addableRow = new RowModel(totalRows + 1, data);
        addableRow.setAddableRow(true);
        this.tm.getRowModels().add(addableRow);
        if (isUpdateViewer) {
            this.viewer.add(addableRow);
        }
    }

    public void removeAddableRow(boolean isUpdateViewer) {
        int lastElementIndex = this.tm.getRowModels().size() - 1;
        RowModel rowModel = null;
        if (lastElementIndex != -1 && this.tm.getRowModels().get(lastElementIndex).isAddableRow()) {
            rowModel = this.tm.getRowModels().remove(lastElementIndex);
            if (isUpdateViewer && rowModel != null) {
                this.viewer.remove(rowModel);
            }
        }
    }

    private int getColumnIndexOfAddRowLabel() {
        return this.indiciesMap.get(0);
    }

    public boolean hasAutoGeneratedIdentityColumn() {
        return !this.autoGeneratedIdentityColumns.isEmpty();
    }
}

