/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.common.Context;
import com.ca.db2.editor.service.SessionSourceProvider;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.utils.DBObjectType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.services.ISourceProviderService;

public class CommonUtils {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final Logger logger = Logger.getLogger(CommonUtils.class);

    public static Integer[] convertTo(int[] elements) {
        Integer[] wrapperElements = new Integer[elements.length];
        int i = 0;
        while (i < elements.length) {
            wrapperElements[i] = elements[i];
            ++i;
        }
        return wrapperElements;
    }

    public static boolean isAlias(ObjectIdentity identity) {
        return identity.getObjectType() == DBObjectType.ALIAS;
    }

    public static boolean isView(ObjectIdentity identity) {
        return identity.getObjectType() == DBObjectType.VIEW;
    }

    public static boolean isSynonym(ObjectIdentity identity) {
        return identity.getObjectType() == DBObjectType.SYNONYM;
    }

    public static String escapeSpecialCharacters(String data) {
        data = data.replaceAll("'", "''");
        return data;
    }

    public static String formatReceivedData(String data) {
        String openBracket = "\uffef\uffbe\uff9b";
        String closeBracket = "\uffef\uffbe\uff9c";
        data = data.replaceAll(Pattern.quote(openBracket), "[");
        data = data.replaceAll(Pattern.quote(closeBracket), "]");
        return data;
    }

    public static HashMap<Integer, List<Object>> processData(HashMap<Integer, List<Object>> data) {
        if (data != null) {
            for (Map.Entry<Integer, List<Object>> thisData : data.entrySet()) {
                List<Object> rowValue = thisData.getValue();
                if (rowValue == null) continue;
                int y = 0;
                while (y < rowValue.size()) {
                    if (rowValue.get(y) != null) {
                        try {
                            if (rowValue.get(y) instanceof String) {
                                rowValue.set(y, CommonUtils.formatReceivedData((String)rowValue.get(y)));
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)"Problem while processing data returned:", (Throwable)e);
                        }
                    }
                    ++y;
                }
                thisData.setValue(rowValue);
            }
        }
        return data;
    }

    public static String formatExecutionTime(long millis) {
        long hours = TimeUnit.MILLISECONDS.toHours(millis);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        millis -= TimeUnit.SECONDS.toMillis(seconds);
        StringBuilder sb = new StringBuilder(64);
        sb.append("[ ");
        sb.append(hours < 10L ? "0" + hours : Long.valueOf(hours));
        sb.append(" hrs : ");
        sb.append(minutes < 10L ? "0" + minutes : Long.valueOf(minutes));
        sb.append(" min : ");
        sb.append(seconds < 10L ? "0" + seconds : Long.valueOf(seconds));
        sb.append(" sec : ");
        sb.append(millis > 100L ? Long.valueOf(millis) : (millis < 10L ? "00" + millis : "0" + millis));
        sb.append(" ms ]");
        return sb.toString();
    }

    public static void printExecutionTime(String msg, long millis) {
        logger.debug((Object)(String.valueOf(msg) + " " + CommonUtils.formatExecutionTime(millis)));
    }

    public static String getDirectorId(String username, String directorId) {
        if (username != null && !username.isEmpty()) {
            if (username.length() <= 8) {
                StringBuffer buffer = new StringBuffer(username);
                int index = username.length();
                while (index < 8) {
                    buffer.append(":");
                    ++index;
                }
                username = buffer.toString();
            } else if (username.length() > 8) {
                username = username.substring(0, 7);
            }
        }
        return String.valueOf(username) + directorId;
    }

    public static String getObjectName(ObjectIdentity identity) {
        return CommonUtils.isAlias(identity) || CommonUtils.isSynonym(identity) ? identity.getTbname() : identity.getObjectName();
    }

    public static String getCreator(ObjectIdentity identity) {
        return CommonUtils.isAlias(identity) || CommonUtils.isSynonym(identity) ? identity.getTbcreator() : identity.getCreator();
    }

    public static boolean isCatalogObject(ObjectIdentity identity) {
        return identity.getCreator().equals("SYSIBM");
    }

    public static String getDateFormat(String ssid) {
        Map<String, Object> properties = Context.getDECPPropertiesCache().get(ssid);
        Object dateFormat = properties.get("DECP_DATE                     ");
        return dateFormat != null ? dateFormat.toString().trim() : "ISO";
    }

    public static String getTimeFormat(String ssid) {
        Map<String, Object> properties = Context.getDECPPropertiesCache().get(ssid);
        Object timeFormat = properties.get("DECP_TIME                     ");
        return timeFormat != null ? timeFormat.toString().trim() : "ISO";
    }

    public static String parseErrorCode(String str) {
        String errorCode = "";
        int beginIndex = str.indexOf("SQLCODE:");
        int endIndex = str.indexOf(">", beginIndex);
        if (beginIndex != -1) {
            errorCode = str.substring(beginIndex + 9, endIndex).trim();
        }
        return errorCode;
    }

    public static String getFriendlyErrorMessage(String errorMessage) {
        String message = "";
        try {
            String sqlCode = CommonUtils.parseErrorCode(errorMessage);
            if ("-803".equals(sqlCode)) {
                message = "Enter a different Layout name.";
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Problem while getting Friendly error message", (Throwable)e);
        }
        return message;
    }

    public static IViewPart getView(String viewId) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart part = page.findView(viewId);
        if (part == null) {
            try {
                return page.showView(viewId);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return part;
    }

    public static void showView(String viewId) {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart part = page.findView(viewId);
            if (part != null) {
                IWorkbenchPartReference partReference = page.getReference((IWorkbenchPart)part);
                page.setPartState(partReference, 2);
                page.bringToTop((IWorkbenchPart)part);
            } else {
                IViewPart iViewPart = page.showView(viewId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static void hideView(String viewId) {
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = workbenchPage.findView(viewId);
        if (viewPart != null) {
            workbenchPage.hideView(viewPart);
        }
    }

    public static int getPaginatioCount() {
        try {
            return (Integer)Context.get(Context.Keys.PAGINATION_COUNT);
        }
        catch (Exception e) {
            return 50;
        }
    }

    public static boolean isLoggedIn() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISourceProviderService service = (ISourceProviderService)window.getService(ISourceProviderService.class);
        SessionSourceProvider sessionSourceProvider = (SessionSourceProvider)service.getSourceProvider("com.ca.db2.editor.service.sessionState");
        return sessionSourceProvider.isLoggedIn();
    }

    public static String removeNulls(String name) {
        String returnValue = "";
        int firstOccurence = name.indexOf(0);
        int nextOccurence = 0;
        int i = firstOccurence;
        while (i < name.length()) {
            if (i < 0) break;
            if (name.charAt(i) != '\u0000') {
                nextOccurence = i - 1;
                break;
            }
            ++i;
        }
        returnValue = firstOccurence == -1 || nextOccurence != 0 && nextOccurence != name.length() - 1 ? name : name.substring(0, firstOccurence);
        return returnValue;
    }

    public static void clearConsole() {
        ConsolePlugin consolePlugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = consolePlugin.getConsoleManager();
        IConsole[] consoles = consoleManager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            if ("".equals(consoles[i].getName())) {
                ((MessageConsole)consoles[i]).clearConsole();
            }
            ++i;
        }
    }
}

