/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.utils.AbstractCellEditor;
import com.ca.db2.editor.ui.utils.CharacterStringCellEditor;
import com.ca.db2.editor.ui.utils.DateCellEditor;
import com.ca.db2.editor.ui.utils.NumericCellEditor;
import org.eclipse.swt.widgets.Composite;

public class CellEditorFactory {
    public static AbstractCellEditor getCellEditor(Composite parent, ObjectIdentity identity, ColumnModel columnModel) {
        DataType dataType = DataType.value(columnModel.getColType().trim());
        if (dataType == null) {
            return new CharacterStringCellEditor(parent, identity, columnModel);
        }
        switch (dataType) {
            case SMALLINT: 
            case INTEGER: 
            case INT: 
            case BIGINT: 
            case DECIMAL: 
            case DEC: 
            case NUMERIC: 
            case FLOAT: {
                return new NumericCellEditor(parent, identity, columnModel);
            }
            case DATE: 
            case TIME: 
            case TIMESTMP: 
            case TIMESTZ: {
                return new DateCellEditor(parent, identity, columnModel);
            }
        }
        return new CharacterStringCellEditor(parent, identity, columnModel);
    }
}

