/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.model;

import com.ca.db2.editor.ui.utils.DBObjectType;
import java.io.Serializable;

public final class ObjectIdentity
implements Serializable {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final long serialVersionUID = 6716536930591425588L;
    private String lpar;
    private String ssid;
    private String creator;
    private String objectName;
    private String path;
    private String simpleName;
    private String fqn;
    private String tbcreator;
    private String tbname;
    private int hash;
    private DBObjectType objectType;

    public ObjectIdentity(String lpar, String ssid, String creator, String objectName, DBObjectType objectType, String tbcreator, String tbname) {
        this.lpar = lpar;
        this.ssid = ssid;
        this.creator = creator;
        this.objectName = objectName;
        this.objectType = objectType;
        this.tbcreator = tbcreator;
        this.tbname = tbname;
        this.simpleName = String.valueOf(creator) + "." + objectName;
        this.fqn = String.valueOf(lpar.trim()) + "." + ssid.trim() + "." + creator + "." + objectName;
        this.path = String.valueOf(lpar.trim()) + "\\" + ssid.trim() + "\\" + creator + "\\" + objectName;
    }

    public String getLpar() {
        return this.lpar;
    }

    public String getSsid() {
        return this.ssid;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int prime = 31;
            this.hash = 1;
            this.hash = 31 * this.hash + (this.creator == null ? 0 : this.creator.hashCode());
            this.hash = 31 * this.hash + (this.lpar == null ? 0 : this.lpar.hashCode());
            this.hash = 31 * this.hash + (this.objectName == null ? 0 : this.objectName.hashCode());
            this.hash = 31 * this.hash + (this.ssid == null ? 0 : this.ssid.hashCode());
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectIdentity other = (ObjectIdentity)obj;
        if (this.creator == null ? other.creator != null : !this.creator.equals(other.creator)) {
            return false;
        }
        if (this.lpar == null ? other.lpar != null : !this.lpar.equals(other.lpar)) {
            return false;
        }
        if (this.objectName == null ? other.objectName != null : !this.objectName.equals(other.objectName)) {
            return false;
        }
        return !(this.ssid == null ? other.ssid != null : !this.ssid.equals(other.ssid));
    }

    public String getPath() {
        return this.path;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String toString() {
        return this.getFQN();
    }

    public DBObjectType getObjectType() {
        return this.objectType;
    }

    public String getTbcreator() {
        return this.tbcreator;
    }

    public String getTbname() {
        return this.tbname;
    }

    public String getFQN() {
        return this.fqn;
    }

    public void setTbcreator(String tbcreator) {
        this.tbcreator = tbcreator;
    }

    public void setTbname(String tbname) {
        this.tbname = tbname;
    }
}

