/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.model;

import com.ca.db2.editor.ui.i18n.DSEBundle;
import com.ca.db2.editor.ui.model.BaseModel;
import com.ca.db2.editor.ui.model.ITreeNode;
import com.ca.db2.editor.ui.model.SubsystemNode;
import com.ca.db2.editor.ui.utils.DBObjectType;
import com.ca.db2.editor.ui.utils.Images;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class LparNode
extends BaseModel
implements ITreeNode {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final long serialVersionUID = -1336936132859289864L;
    private final Image LPAR = Images.LPAR.createImage();
    private final List<SubsystemNode> subsystems = new ArrayList<SubsystemNode>(50);

    private LparNode() {
    }

    public LparNode(String name) {
        this();
        this.setName(name);
        this.setTooltip(DSEBundle.bind((String)DSEBundle.TOOLTIP_LPAR, (Object)this.getName()));
    }

    public String toString() {
        return "LPAR : " + this.getName();
    }

    @Override
    public boolean hasChildren() {
        return !this.subsystems.isEmpty();
    }

    @Override
    public Image getImage() {
        return this.LPAR;
    }

    @Override
    public DBObjectType getObjectType() {
        return DBObjectType.LPAR;
    }

    @Override
    public int getSortingCategory() {
        return 0;
    }

    @Override
    public boolean isLeafNode() {
        return false;
    }

    @Override
    public boolean removeChild(ITreeNode node) {
        return this.subsystems.remove(node);
    }

    @Override
    public ITreeNode getParent() {
        return null;
    }

    @Override
    public void removeChildren() {
        this.subsystems.clear();
    }

    public List<SubsystemNode> getChildren() {
        return this.subsystems;
    }

    @Override
    public <U extends ITreeNode> void addChild(U node) {
        this.subsystems.add((SubsystemNode)node);
    }

    @Override
    public void addChildren(List<? extends ITreeNode> nodes) {
        for (ITreeNode iTreeNode : nodes) {
            this.addChild(iTreeNode);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.subsystems == null ? 0 : this.subsystems.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LparNode other = (LparNode)obj;
        return !(this.subsystems == null ? other.subsystems != null : !this.subsystems.equals(other.subsystems));
    }

    @Override
    public String getPath() {
        return this.getName();
    }
}

