/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.model;

import com.ca.db2.editor.ui.model.BaseModel;
import com.ca.db2.editor.ui.model.CreatorNode;
import com.ca.db2.editor.ui.model.DBObject;
import com.ca.db2.editor.ui.model.ITreeNode;
import com.ca.db2.editor.ui.utils.DBObjectType;
import com.ca.db2.editor.ui.utils.Images;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class GroupNode<T extends DBObject>
extends BaseModel
implements ITreeNode {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final long serialVersionUID = -320349453874945297L;
    private CreatorNode creator;
    private final List<T> dbObjects = new ArrayList<T>(100);
    private DBObjectType type;
    private static final Image FOLDER = Images.FOLDER.createImage();

    private GroupNode() {
    }

    public GroupNode(String name, CreatorNode creator, DBObjectType type) {
        this();
        this.setName(name);
        this.setCreator(creator);
        this.type = type;
    }

    public List<T> getDBObjects() {
        return this.dbObjects;
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public DBObjectType getObjectType() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return !this.dbObjects.isEmpty();
    }

    @Override
    public Image getImage() {
        return FOLDER;
    }

    @Override
    public int getSortingCategory() {
        return 0;
    }

    @Override
    public boolean isLeafNode() {
        return false;
    }

    @Override
    public boolean removeChild(ITreeNode node) {
        if (this.dbObjects.size() == 1) {
            return this.getParent().removeChild(this);
        }
        return this.dbObjects.remove(node);
    }

    @Override
    public ITreeNode getParent() {
        return this.creator;
    }

    public void setCreator(CreatorNode creator) {
        this.creator = creator;
    }

    public CreatorNode getCreator() {
        return this.creator;
    }

    public DBObjectType getType() {
        return this.type;
    }

    @Override
    public void removeChildren() {
        this.dbObjects.clear();
    }

    @Override
    public List<? extends ITreeNode> getChildren() {
        return this.dbObjects;
    }

    public void addChild(ITreeNode node) {
        if (!this.dbObjects.contains(node)) {
            ((DBObject)((Object)node)).setGroupNode(this);
            this.dbObjects.add((DBObject)((Object)node));
        }
    }

    @Override
    public void addChildren(List<? extends ITreeNode> nodes) {
        for (ITreeNode iTreeNode : nodes) {
            this.addChild(iTreeNode);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getName() == null ? 0 : this.getPath().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupNode other = (GroupNode)obj;
        if (this.getName() != other.getName()) {
            return false;
        }
        return this.getPath().equals(other.getParent().getPath());
    }

    @Override
    public String getPath() {
        return String.valueOf(this.getParent().getPath()) + "." + this.getName();
    }
}

