/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.model;

import com.ca.db2.editor.ui.i18n.CMBundle;
import com.ca.db2.editor.ui.model.BaseModel;
import com.ca.db2.editor.ui.model.ChangeEntry;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.model.RowModel;
import java.util.ArrayList;
import java.util.List;

public class ChangeEntrySet
extends BaseModel
implements Comparable<ChangeEntrySet> {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final long serialVersionUID = -3127817919587302895L;
    private RowModel rowModel;
    private List<ChangeEntry> entries;
    private ObjectIdentity identity;
    private Status status = Status.PENDING;
    private ChangeType changeType = ChangeType.UPDATE;

    private ChangeEntrySet() {
        this.entries = new ArrayList<ChangeEntry>();
    }

    public ChangeEntrySet(ObjectIdentity identity, RowModel rowModel) {
        this();
        this.identity = identity;
        this.rowModel = rowModel;
    }

    @Override
    public String getName() {
        return String.valueOf(CMBundle.ROWKEY) + this.rowModel.getRowKey();
    }

    public ChangeEntrySet(ObjectIdentity identity, RowModel rowModel, ChangeType changeType) {
        this(identity, rowModel);
        this.changeType = changeType;
    }

    public Integer getRowKey() {
        return this.rowModel.getRowKey();
    }

    public List<ChangeEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<ChangeEntry> entries) {
        this.entries = entries;
    }

    public ObjectIdentity getIdentity() {
        return this.identity;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identity == null ? 0 : this.identity.hashCode());
        result = 31 * result + this.rowModel.getRowKey();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeEntrySet other = (ChangeEntrySet)obj;
        if (this.identity == null ? other.identity != null : !this.identity.equals(other.identity)) {
            return false;
        }
        return this.rowModel.getRowKey().equals(other.rowModel.getRowKey());
    }

    public String toString() {
        return "RowKey : " + this.rowModel.getRowKey();
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    @Override
    public int compareTo(ChangeEntrySet o) {
        return this.rowModel.getRowKey().compareTo(o.rowModel.getRowKey());
    }

    public static enum ChangeType {
        INSERT(CMBundle.INSERT),
        UPDATE(CMBundle.UPDATE);

        private final String description;

        private ChangeType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum Status {
        PENDING(CMBundle.PENDING),
        FAILED(CMBundle.FAILED);

        private final String description;

        private Status(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

