/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.common.Context;
import com.ca.db2.editor.service.SessionSourceProvider;
import com.ca.db2.editor.ui.i18n.CommonBundle;
import com.ca.db2.editor.ui.utils.LoginLogoutUtils;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.ISourceProviderService;

public class LogoutHandler
extends AbstractHandler
implements IElementUpdater {
    static final String cacopyright = "Copyright \ufffd 2016 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean logout = MsgDialog.showConfirmDialog(null, CommonBundle.LOGOUT_TITLE, CommonBundle.LOGOUT_MSG);
        if (logout) {
            logout = LoginLogoutUtils.onLogout();
            Context.getInstance().clear();
            if (logout) {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
                ISourceProviderService service = (ISourceProviderService)window.getService(ISourceProviderService.class);
                SessionSourceProvider sessionSourceProvider = (SessionSourceProvider)service.getSourceProvider("com.ca.db2.editor.service.sessionState");
                sessionSourceProvider.setLoggedIn(false);
            }
        }
        return logout;
    }

    public void updateElement(UIElement element, Map parameters) {
    }

    private void openLoginDialog(IWorkbenchWindow window) {
        try {
            IHandlerService handlerService = (IHandlerService)window.getService(IHandlerService.class);
            handlerService.executeCommand("com.ca.db2.editor.loginCommand", null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (NotDefinedException e) {
            e.printStackTrace();
        }
        catch (NotEnabledException e) {
            e.printStackTrace();
        }
        catch (NotHandledException e) {
            e.printStackTrace();
        }
    }
}

