/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.common.Context;
import com.ca.db2.editor.common.FMDB2Exception;
import com.ca.db2.editor.service.DataSourceHandlerFactory;
import com.ca.db2.editor.service.IDataSourceHandler;
import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.i18n.MsgDialogBundle;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.LayoutFilterObject;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.model.RowModel;
import com.ca.db2.editor.ui.model.TableModel;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.widgets.DWLayoutFilterDialog;
import com.ca.db2.editor.ui.widgets.DataWindow;
import com.ca.db2.editor.ui.widgets.DataWindowManager;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import com.ca.db2.editor.views.DWView;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.BusyIndicator;

public class DWModifyFilterAction
extends BaseAction {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final Logger logger = Logger.getLogger(DWModifyFilterAction.class);
    private String commandId = "com.ca.db2.editor.ui.actions.DWModifyFilterAction";
    private IDataSourceHandler dataSourceHandler = DataSourceHandlerFactory.getDataSourceHandler();
    private DataWindowManager dwManager;

    public DWModifyFilterAction(DataWindowManager manager) {
        super(DWBundle.LABEL_MODIFY_FILTER, 1);
        this.setId(DWView.ACTION.MODIFY_FILTER.toString());
        this.setToolTipText(DWBundle.LABEL_MODIFY_FILTER);
        this.setImageDescriptor(Images.DW_MODIFY_FILTER);
        this.dwManager = manager;
        this.registerKeyBinding(this.commandId, 65620);
    }

    @Override
    protected void execute() {
        try {
            final DataWindow dataWindow = this.dwManager.getSelectedDataWindow();
            final ObjectIdentity identity = dataWindow.getIdentity();
            final LayoutFilterObject filterObj = (LayoutFilterObject)dataWindow.getData("FILTER");
            List<ColumnModel> columns = filterObj.getAllColumns();
            final DWLayoutFilterDialog dialog = new DWLayoutFilterDialog(null, identity, columns);
            dialog.setFilterObj(filterObj);
            dialog.create();
            if (dialog.open() == 0) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String sql = dialog.getSql();
                        Context.getInstance().setSQLID(identity.getFQN(), dialog.getSQLID());
                        Context.getInstance().setActiveSQLID(dialog.getSQLID());
                        dataWindow.setData("QUERY", sql);
                        try {
                            List<ColumnModel> columnModels = dataWindow.getResultSetGrid().getTableModel().getColumnModels();
                            List<RowModel> rowModels = DWModifyFilterAction.this.dataSourceHandler.getRuntimeData(identity, columnModels, sql);
                            TableModel tableModel = new TableModel(filterObj.getAllColumns(), rowModels);
                            DWModifyFilterAction.this.dwManager.updateDataWindow(dataWindow, tableModel);
                        }
                        catch (FMDB2Exception e) {
                            logger.error((Object)"Error while displaying Data Window with filtered data:", (Throwable)e);
                            MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, e.getMessage());
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while displaying Data Window with filtered data:", (Throwable)e);
        }
    }

    @Override
    public void updateUI() {
        this.setEnabled(true);
        this.setChecked(false);
    }

    @Override
    protected boolean checkPreConditions() {
        return this.dwManager.getSelectedDataWindow().canBeClosedOrRefreshed();
    }
}

